#ifndef FXINFO_H
#define FXINFO_H

#include	"sqlite3.h"

#include	"FxBookmark.h"
#include	"Bookmark.h"

#include	"IbookmarkTree.h"


class FxInfo
{
private:
	sqlite3 *db;	// DBANZXp

	// eID(moz_anno_attributes)
	sqlite_int64 toolbarId;	// p[\ic[o[tH_ID
	sqlite_int64 descriptionId;	// ID
	sqlite_int64 characterSetId;	// R[hID
	sqlite_int64 readOnlyId;		// ǂݎpID
	sqlite_int64 feedUriId;		// tB[hID
	sqlite_int64 siteUriId;		// TCgID
	sqlite_int64 expirationId;	// expirationID
	sqlite_int64 generatorId;	// }CNT}WFl[^ID
	sqlite_int64 staticTitleId;	// ÓI^CgID(}CNT})
	sqlite_int64 summaryExpirationId;	// }CNT}expiration
	sqlite_int64 organizerQueryId;	// ҏWʂ̃NG
	sqlite_int64 organizerFolderId;	// ҏWʂ̃tH_
	sqlite_int64 inSideBarId;		// TCho[Ƀ[hID
	sqlite_int64 maxAnnotationId;	// ł傫ID
	sqlite_int64 smartBookmarkId;	// X}[gubN}[NID
	sqlite_int64 excludeFromBackup;	// excludeFromBackup
	sqlite_int64 syncParentId;	// sync/parent
	sqlite_int64 mobileRootId;	// mobile/bookmarksRoot

	// [gtH_Q̏(moz_bookmarks_roots)
	sqlite_int64 topRoot;		// gbvxtH_ID
	sqlite_int64 menuRoot;		// ubN}[Nj[ID
	sqlite_int64 toolbarRoot;	// c[o[ID
	sqlite_int64 tagsRoot;		// ^OID
	sqlite_int64 unfiledRoot;	// unfiledID
	sqlite_int64 mobileRoot;	// oC̃ubN}[NID
	int roots;			// [gtH_̐
	bool hasGUID;		// GUIDĂ邩
	bool m_hasSyncStatus;	// syncStatus,syncChangeCountĂ邩

	int getAnnotateAttribute(void);
	int getRoots(void);
	int getRoots2(void);
	int getRootsV48(void);

	sqlite_int64 insertAnnotationAttribute(const char *attribute);
	int getBookmarkTableInfo(void);

public:
	FxInfo(sqlite3 *readDb);
	~FxInfo(void);

	int readInformations(void);

	//
	// 擾getterQ
	//

	// eID(moz_anno_attributes)

	sqlite_int64 getToolbarId(void)
	{
		sqlite_int64 newId;
		if (toolbarId == -1) {
			newId = insertAnnotationAttribute("bookmarks/toolbarFolder");
			toolbarId = newId;
		}
		return toolbarId;
	}

	sqlite_int64 getDescriptionId(void)
	{
		sqlite_int64 newId;
		if (descriptionId == -1) {
			newId = insertAnnotationAttribute("bookmarkProperties/description");
			descriptionId = newId;
		}
		return descriptionId;
	}

	sqlite_int64 getInSideBarId(void)
	{
		sqlite_int64 newId;
		if (inSideBarId == -1) {
			newId = insertAnnotationAttribute("bookmarkProperties/loadInSidebar");
			inSideBarId = newId;
		}
		return inSideBarId;
	}

	sqlite_int64 getCharacterSetId(void)
	{
		sqlite_int64 newId;
		if (characterSetId == -1) {
			newId = insertAnnotationAttribute("URIProperties/characterSet");
			characterSetId = newId;
		}
		return characterSetId;
	}

	sqlite_int64 getReadOnlyId(void)
	{
		sqlite_int64 newId;
		if (readOnlyId == -1) {
			newId = insertAnnotationAttribute("placesInternal/READ_ONLY");
			readOnlyId = newId;
		}
		return readOnlyId;
	}

	sqlite_int64 getFeedUriId(void)
	{
		sqlite_int64 newId;
		if (feedUriId == -1) {
			newId = insertAnnotationAttribute("livemark/feedURI");
			feedUriId = newId;
		}
		return feedUriId;
	}

	sqlite_int64 getSiteUriId(void)
	{
		sqlite_int64 newId;
		if (siteUriId == -1) {
			newId = insertAnnotationAttribute("livemark/siteURI");
			siteUriId = newId;
		}
		return siteUriId;
	}

	sqlite_int64 getExpirationId(void)
	{
		sqlite_int64 newId;
		if (expirationId == -1) {
			newId = insertAnnotationAttribute("livemark/expiration");
			expirationId = newId;
		}
		return expirationId;
	}

	sqlite_int64 getGeneratorId(void)
	{
		sqlite_int64 newId;
		if (generatorId == -1) {
			newId = insertAnnotationAttribute("microsummary/generatorURI");
			generatorId = newId;
		}
		return generatorId;
	}

	sqlite_int64 getStaticTitleId(void)
	{
		sqlite_int64 newId;
		if (staticTitleId == -1) {
			newId = insertAnnotationAttribute("bookmarks/staticTitle");
			staticTitleId = newId;
		}
		return staticTitleId;
	}

	sqlite_int64 getSummaryExpirationId(void)
	{
		sqlite_int64 newId;
		if (summaryExpirationId == -1) {
			newId = insertAnnotationAttribute("microsummary/expiration");
			summaryExpirationId = newId;
		}
		return summaryExpirationId;
	}

	sqlite_int64 getOrganizerQueryId(void)
	{
		sqlite_int64 newId;
		if (organizerQueryId == -1) {
			newId = insertAnnotationAttribute("PlacesOrganizer/OrganizerQuery");
			organizerQueryId = newId;
		}
		return organizerQueryId;
	}

	sqlite_int64 getOrganizerFolderId(void)
	{
		sqlite_int64 newId;
		if (organizerFolderId == -1) {
			newId = insertAnnotationAttribute("PlacesOrganizer/OrganizerFolder");
			organizerFolderId = newId;
		}
		return organizerFolderId;
	}

	sqlite_int64 getSmartBookmarkId(void)
	{
		sqlite_int64 newId;
		if (smartBookmarkId == -1) {
			newId = insertAnnotationAttribute("Places/SmartBookmark");
			smartBookmarkId = newId;
		}
		return smartBookmarkId;
	}

	/**
	 * sync/parentID擾B
	 *
	 * @return sync/parentID
	 */
	sqlite_int64 getSyncParentId(void)
	{
		sqlite_int64 newId;
		if (syncParentId == -1) {
			newId = insertAnnotationAttribute("sync/parent");
			syncParentId = newId;
		}
		return syncParentId;
	}

	/**
	 * mobile/bookmarksRootID擾B
	 *
	 * @return mobile/bookmarksRootID
	 */
	sqlite_int64 getMobileRootId(void)
	{
		sqlite_int64 newId;
		if (mobileRootId == -1) {
			newId = insertAnnotationAttribute("mobile/bookmarksRoot");
			mobileRootId = newId;
		}
		return mobileRootId;
	}

	// [gtH_Q̏(moz_bookmarks_roots)

	sqlite_int64 getTopFolder(void)
	{
		return topRoot;		// gbvxtH_ID
	}

	sqlite_int64 getMenuFolder(void)
	{
		return menuRoot;		// ubN}[Nj[ID
	}

	sqlite_int64 getToolbarFolder(void)
	{
		return toolbarRoot;	// c[o[ID
	}

	sqlite_int64 getTagsFolder(void)
	{
		return tagsRoot;		// ^OID
	}

	sqlite_int64 getUnfiledFolder(void)
	{
		return unfiledRoot;	// unfiledID
	}

	/**
	 * oC̃ubN}[NtH_ID
	 *
	 * @return oC̃ubN}[NtH_ID
	 */
	sqlite_int64 getMobileFolder(void)
	{
		return mobileRoot;	// oC̃ubN}[NID
	}

	sqlite_int64 getExcludeFromBackup()
	{
		return excludeFromBackup;
	}

	int getRootFolders(void)
	{
		return roots;
	}

	bool getHasGUID(void)
	{
		return hasGUID;
	}

	/**
	 * syncStatusĂ邩
	 *
	 * @return true:Ă false:ĂȂ
	 */
	bool hasSyncStatus(void)
	{
		return m_hasSyncStatus;
	}
};

#endif
