// Wwb_
#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>
#include	<assert.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"

// vbgtH[wb_
#include	"FxInfo.h"

/**
 * Firefox 3̃ubN}[NɊւǂݍŊi[NXB<br>
 * ǂݍݎݎgp̂ŃubN}[NƂăNXB
 *
 *
 */

/**
 * RXgN^
 *
 * @param readDb ǂݍރf[^x[Xւ̃|C^
 */
FxInfo::FxInfo(sqlite3 *readDb)
{
	db = readDb;

	roots = 0;

	// eID(moz_anno_attributes)
	toolbarId = -1;	// p[\ic[o[tH_ID
	descriptionId = -1;	// ID
	characterSetId = -1;	// R[hID
	readOnlyId = -1;		// ǂݎpID
	feedUriId = -1;		// tB[hID
	siteUriId = -1;		// TCgID
	expirationId = -1;	// expirationID
	generatorId = -1;	// }CNT}WFl[^ID
	staticTitleId = -1;	// ÓI^CgID(}CNT})
	summaryExpirationId = -1;	// }CNT}expiration
	organizerQueryId = -1;	// ҏWʂ̃NG
	organizerFolderId = -1;	// ҏWʂ̃tH_
	inSideBarId = -1;		// TCho[Ƀ[hID
	maxAnnotationId = -1;	// ł傫ID
	excludeFromBackup = -1;	// obNAbv珜O?ID
	syncParentId = -1;	// sync/parent
	mobileRootId = -1;	// mobile/bookmarksRoot

	hasGUID = false;	// guid񂪑݂邩ǂ
	m_hasSyncStatus = false;	// syncStatusĂ邩ǂ

	mobileRoot = -1;	// oC̃ubN}[NID
}

/**
 * fXgN^
 */
FxInfo::~FxInfo(void)
{
}

/**
 * ǂݍށB
 *
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int FxInfo::readInformations(void)
{
	int result;	// ǂݍ݌

	// GUID̗Lǂݍ
	result = getBookmarkTableInfo();
	if (result) {
		return 1;
	}

	// ǂݍ
	result = getAnnotateAttribute();
	if (result) {
		return 1;
	}

	// ẽ[gtH_ʒuǂݍ
	result = getRoots();
	if (result) {
		return 1;
	}

	// oC̃ubN}[NtH_ʒuǂݍ
	if (mobileRoot == -1) {
		result = getRoots2();
		if (result) {
			return 1;
		}
	}

	return 0;
}

/**
 * ubN}[N̎擾
 *
 * @return 0: 1:s
 */
int FxInfo::getAnnotateAttribute(void)
{
	const char *sql = 
		"select id,name "
		"from moz_anno_attributes; ";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char buf[256];

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		// 0n܂B
		sqlite_int64 id = -1;
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			// fprintf(stdout,"%d:INTEGER:%d\n",0,sqlite3_column_int64(statement,0));
		}
		if (sqlite3_column_type(statement,1) == SQLITE_TEXT){
			fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,1));
		}
		if (maxAnnotationId < id) {
			maxAnnotationId = id;
		}
		if (id != -1) {
			strcpy(buf,(const char *)sqlite3_column_text(statement,1));
			if (!strcmp(buf,"bookmarks/toolbarFolder")){
				toolbarId = id;
			}
			if (!strcmp(buf,"bookmarkProperties/description")){
				descriptionId = id;
			}
			if (!strcmp(buf,"bookmarkProperties/loadInSidebar")){
				inSideBarId = id;	// ҏWʂ̃NG
			}
			if (!strcmp(buf,"URIProperties/characterSet")){
				characterSetId = id;
			}
			if (!strcmp(buf,"placesInternal/READ_ONLY")){
				readOnlyId = id;
			}
			if (!strcmp(buf,"livemark/feedURI")){
				feedUriId = id;
			}
			if (!strcmp(buf,"livemark/siteURI")){
				siteUriId = id;
			}
			if (!strcmp(buf,"livemark/expiration")){
				expirationId = id;
			}
			if (!strcmp(buf,"microsummary/generatorURI")){
				generatorId = id;	// }CNT}WFl[^ID
			}
			if (!strcmp(buf,"bookmarks/staticTitle")){
				staticTitleId = id;	// ÓI^CgID(}CNT})
			}
			if (!strcmp(buf,"microsummary/expiration")){
				summaryExpirationId = id;	// }CNT}expiration
			}
			if (!strcmp(buf,"PlacesOrganizer/OrganizerQuery")){
				organizerQueryId = id;	// ҏWʂ̃NG
			}
			if (!strcmp(buf,"PlacesOrganizer/OrganizerFolder")){
				organizerFolderId = id;	// ҏWʂ̃NG
			}
			if (!strcmp(buf,"Places/SmartBookmark")){
				smartBookmarkId = id;
			}
			if (!strcmp(buf,"places/excludeFromBackup")){
				excludeFromBackup = id;
			}
			if (!strcmp(buf,"sync/parent")){
				syncParentId = id;
			}
			if (!strcmp(buf,"mobile/bookmarksRoot")){
				mobileRootId = id;
			}

		}
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed");
	}

	return 0;
}


/**
 * [gtH_̏擾B
 *
 * @return 0:擾 -1:擾s
 */
int FxInfo::getRoots(void)
{
	const char *sql = 
		"select root_name,folder_id "
		"from moz_bookmarks_roots; ";

	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char buf[256];

	// e[gtH_ID
	roots = 0;			// [gtH_̐
	topRoot = -1;		// gbvxtH_ID
	menuRoot = -1;		// ubN}[Nj[ID
	toolbarRoot = -1;	// c[o[ID
	tagsRoot = -1;		// ^OID
	unfiledRoot = -1;	// unfiledID

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");

		// Firefox 48ȍ~łmoz_bookmarks_rootse[uȂ̂ŁAʂ̕@
		// e[gtH_擾B
		rc = getRootsV48();
		if (rc) {
			fprintf(stderr, "Root folders get failed.\n");
			return -1;
		} else {
			return 0;
		}
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		// 0n܂B
		sqlite_int64 id = -1;

		// 
		if (sqlite3_column_type(statement,0) == SQLITE_TEXT){
			fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,0));
		}
		// tH_ID(moz_bookmarks)
		if (sqlite3_column_type(statement,1) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,1);
			// fprintf(stdout,"%d:INTEGER:%d\n",0,sqlite3_column_int64(statement,1));
		}
		strcpy(buf,(const char *)sqlite3_column_text(statement,0));
		if (!strcmp(buf,"places")) {
			// gbvxtH_
			topRoot = id;		// gbvxtH_ID
		}

		if (!strcmp(buf,"menu")) {
			// j[o[tH_
			menuRoot = id;		// ubN}[Nj[ID
		}

		if (!strcmp(buf,"toolbar")) {
			// c[o[tH_
			toolbarRoot = id;	// c[o[ID
		}

		if (!strcmp(buf,"tags")) {
			// ^OtH_
			tagsRoot = id;		// ^OID
		}

		if (!strcmp(buf,"unfiled")) {
			// unfiledtH_
			unfiledRoot = id;	// unfiledID
		}

		roots++;
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed");
	}

	return 0;
}

/**
 * [gtH_̏擾B(oC̃ubN}[N̂)
 *
 * @return 0:擾 -1:擾s
 */
int FxInfo::getRoots2(void)
{
	const char *sql = 
		"select id,title "
		"from moz_bookmarks where parent=1; ";

	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char buf[256];
	buf[255] = '\0';

	// e[gtH_ID

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		// 0n܂B
		sqlite_int64 id = -1;

		// tH_ID(moz_bookmarks)
		if (sqlite3_column_type(statement,0) == SQLITE_INTEGER){
			id = sqlite3_column_int64(statement,0);
			// fprintf(stdout,"%d:INTEGER:%d\n",0,sqlite3_column_int64(statement,1));
		}
		// O
		if (sqlite3_column_type(statement,1) == SQLITE_TEXT){
			fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,1));
		}
		strncpy(buf,(const char *)sqlite3_column_text(statement,1), 255);
		// gbvxtH_"mobile"oC̃ubN}[NȂ̂ŁA
		// 𔻒肷B
		if (!strcmp(buf, "mobile")) {
			mobileRoot = id;
			break;
		}

		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed");
	}

	return 0;
}

/**
 * [gtH_̏擾B(Firefox 48ȍ~p)
 *
 * @return 0:擾 -1:擾s
 */
int FxInfo::getRootsV48(void)
{
	const char *sql =
		"select guid,id "
		"from moz_bookmarks "
		"where parent<2";

	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char buf[256];

	// e[gtH_ID
	roots = 0;			// [gtH_̐
	topRoot = -1;		// gbvxtH_ID
	menuRoot = -1;		// ubN}[Nj[ID
	toolbarRoot = -1;	// c[o[ID
	tagsRoot = -1;		// ^OID
	unfiledRoot = -1;	// unfiledID

	rc = sqlite3_prepare_v2(db, sql, -1, &statement, &p);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "SQL error\n");
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while (rc == SQLITE_ROW) {
		// 0n܂B
		sqlite_int64 id = -1;

		// GUID
		if (sqlite3_column_type(statement, 0) == SQLITE_TEXT) {
			fprintf(stdout, "%d:TEXT:%s\n", 1, sqlite3_column_text(statement, 0));
		} else {
			// oC̃ubN}[N炩̗RNULLɂȂ肤̂
			// SQLITE_TEXTȊȌꍇ͔΂悤ɂB
			rc = sqlite3_step(statement);
			continue;
		}
		// tH_ID(moz_bookmarks)
		if (sqlite3_column_type(statement, 1) == SQLITE_INTEGER) {
			id = sqlite3_column_int64(statement, 1);
		} else {
			rc = sqlite3_step(statement);
			continue;
		}
		strcpy(buf, (const char *)sqlite3_column_text(statement, 0));

		// Kvȏ擾̂Ŏ̍sɐi߂ĂB
		rc = sqlite3_step(statement);

		// tH_̎ނ𔻒肷B
		if (!strcmp(buf, "root________")) {
			// gbvxtH_
			topRoot = id;		// gbvxtH_ID
		} else if (!strcmp(buf, "menu________")) {
			// j[o[tH_
			menuRoot = id;		// ubN}[Nj[ID
		} else if (!strcmp(buf, "toolbar_____")) {
			// c[o[tH_
			toolbarRoot = id;	// c[o[ID
		} else if (!strcmp(buf, "tags________")) {
			// ^OtH_
			tagsRoot = id;		// ^OID
		} else if (!strcmp(buf, "unfiled_____")) {
			// unfiledtH_
			unfiledRoot = id;	// unfiledID
		} else if (!strcmp(buf, "mobile______")) {
			// oC̃ubN}[NtH_
			mobileRoot = id;	// oC̃ubN}[NID(V)
		} else {
			// {vOňȂ[gtH_΂B
			continue;
		}

		// {vOŔF郋[gtH_
		roots++;
	}

	rc = sqlite3_finalize(statement);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "finalize failed");
	}

	return 0;
}

/**
 * moz_anno_attributesɑǉB
 *
 * @param attribute ǉ鑮
 * @return -1:ǉs >-1:Vid
 */
sqlite_int64 FxInfo::insertAnnotationAttribute(const char *attribute)
{
	sqlite_int64 newId;
	newId = maxAnnotationId + 1;

	const char *sql = "insert into moz_anno_attributes (id,name)"
				" values (?,?);";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	assert(rc == SQLITE_OK);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error in insertAnnotationAttribute\n");
	}

	sqlite3_reset(statement);
	// bind_??1n܂B
	// ID
	rc = sqlite3_bind_int64(statement, 1, newId);
	assert(rc == SQLITE_OK);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	rc = sqlite3_bind_text(statement, 2, attribute , -1, SQLITE_STATIC);
	assert(rc == SQLITE_OK);
	if ( rc != SQLITE_OK ){
		sqlite3_finalize(statement);
		return -1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	assert(rc == SQLITE_DONE);
	if ( rc != SQLITE_DONE ){
		fprintf(stderr,"SQLITE_DONE ȊÕbZ[W\n");
		return -1;
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed\n");
	}

	maxAnnotationId++;
	return newId;
}

/**
 * ubN}[N̎擾
 *
 * @return 0: 1:s
 */
int FxInfo::getBookmarkTableInfo(void)
{
	const char *sql = 
		"PRAGMA table_info(moz_bookmarks); ";
	const char *p;	// ǂݍ܂ȂƂŵă|C^
	sqlite3_stmt *statement;
	int rc;
	char buf[256];

	rc = sqlite3_prepare_v2(db, sql , -1 ,&statement, &p);
	if ( rc != SQLITE_OK ){
		fprintf(stderr, "SQL error\n");
		return 1;
	}

	// ŎsB
	rc = sqlite3_step(statement);
	while(rc == SQLITE_ROW) {
		// 0n܂B
		sqlite_int64 id = -1;
		if (sqlite3_column_type(statement,1) == SQLITE_TEXT){
			fprintf(stdout,"%d:TEXT:%s\n",1,sqlite3_column_text(statement,1));
		}
		strcpy(buf,(const char *)sqlite3_column_text(statement,1));
		if (!strcmp(buf,"guid")){
			hasGUID = true;
		}
		if (!strcmp(buf, "syncStatus")) {
			m_hasSyncStatus = true;
		}
		rc = sqlite3_step(statement);
	}

	rc = sqlite3_finalize(statement);
	if ( rc != SQLITE_OK ){
		fprintf(stderr,"finalize failed");
	}

	return 0;
}

