#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"encutil.h"
#include	"encutil2.h"
#include	"Bookmark.h"

#include	"FxBookmark.h"

#ifdef _DEBUG
#define debugprintf //printf
#else
#define debugprintf
#endif

// int FxBookmark::m_sortMode = 1;	// \[g
int FxBookmark::m_outputType[2] = {0,0};			// 0:Netscape 4/1:Netscape 6,7/Mozilla/2:Mozilla 1.4
int FxBookmark::m_mozVersion[2] = {0,0};			// 0:Netscape 4/1:Netscape 6,7/Mozilla/2:Mozilla 1.4
bool FxBookmark::m_UTF8[2] = {false,false};
int FxBookmark::m_spaces = 4;
FILE *FxBookmark::cs_fpo = NULL;

/*------------------------------*/
/* Firefox dependent attributes */
/*------------------------------*/

/**
 * ftHgRXgN^<br>
 * ftHglݒ肷B
 */
FxBookmark::FxBookmark(void)
{
	_init();
}

/**
 * ̃ubN}[N񂩂ubN}[NRs[RXgN^
 *
 * @param src ʌBookmarkNX̃CX^Xւ̎Q
 */
FxBookmark::FxBookmark(const FxBookmark &src)
{
	_init();

	_copy(src);

	if (src.getGUID() != NULL) {
		setGUID(src.getGUID());
	}
}

/**
 * fXgN^
 */
FxBookmark::~FxBookmark()
{
	reset();
}


/**
 * eԂɃZbgB
 */
void FxBookmark::reset(void)
{
	if (m_id != NULL){
		delete []m_id;
		m_id = NULL;
	}
	if (m_charset != NULL){
		delete []m_charset;
		m_charset = NULL;
	}
	m_check = 0;			// ŏIXVmF
	if (m_Firefoxicon != NULL){
		delete []m_Firefoxicon;
		m_Firefoxicon = NULL;
	}
	if (m_FeedUrl != NULL){
		delete []m_FeedUrl;
		m_FeedUrl = NULL;
	}
	if (m_feed_expiration != NULL) {
		delete []m_feed_expiration;
		m_feed_expiration = NULL;
	}
	if (m_schedule != NULL){
		delete []m_schedule;
		m_schedule = NULL;
	}
	m_group = 0;			// tH_O[vǂ
	m_LinkbarFolder = 0;	// tH_Personal Toolbar Folderǂ
	m_webPanel = false;
	m_NewSearchFolder = false;	// New Internet Search FolderH
	m_NewBookmarkFolder = false;	// New Bookmark FolderH
	m_readOnly = false;		// read only(Firefox 3)
	m_SmartBookmark = false;	// Smart bookmark(Firefox 3)
	m_syncStatus = 0;
	m_syncChangeCounter = 1;

	if (m_HRName != NULL){
		delete []m_HRName;
		m_HRName = NULL;
	}

	if (m_micsum_gen_uri != NULL){
		delete []m_micsum_gen_uri;
		m_micsum_gen_uri = NULL;	// Micro summary generate URL(Firefox 2)
	}
	if (m_micsum_expiration != NULL){
		delete []m_micsum_expiration;
		m_micsum_expiration = NULL;	// Micro summary expiration(Firefox 2)
	}
	if (m_generatedTitle != NULL){
		delete []m_generatedTitle;
		m_generatedTitle = NULL;	// Generated title(Firefox 2)
	}

	m_OrganizerFolder = false;
	m_OrganizerQuery = false;

	if (m_ProperName != NULL) {
		delete []m_ProperName;
		m_ProperName = NULL;
	}
	m_excludeFromBackup = -1;

	if (m_SyncParent != NULL) {
		m_SyncParent = NULL;
	}

	if (m_MobileRoot != NULL) {
		m_MobileRoot = NULL;
	}

	if (m_GUID != NULL) {
		delete []m_GUID;
		m_GUID = NULL;
	}
}

/**
 *	CX^X̓eɏlB<br>
 *	RXgN^p
 *
 */
void FxBookmark::_init()
{
	m_id = NULL;			// fBNgID
	m_charset = NULL;		// R[h
	m_check = 0;			// ŏIXVmF
	m_Firefoxicon = NULL;	// ACR(Firefox)
	m_feed_expiration = NULL;	// 
	m_FeedUrl = NULL;		// RSS feed URL
	m_schedule = NULL;		// XVmFXPW[
	m_group = 0;			// tH_O[vǂ
	m_LinkbarFolder = 0;	// c[o[tH_ǂ
	m_HRName = NULL;	// ؂̌o
	m_webPanel = false;
	m_NewSearchFolder = false;	// New Internet Search FolderH
	m_NewBookmarkFolder = false;	// New Bookmark FolderH
	m_micsum_gen_uri = NULL;	// Micro summary generate URL(Firefox 2)
	m_micsum_expiration = NULL;	// Micro summary expiration(Firefox 2)
	m_generatedTitle = NULL;	// Generated title(Firefox 2)
	m_readOnly = false;		// read only(Firefox 3)
	m_OrganizerFolder = false;
	m_OrganizerQuery = false;
	m_ProperName = NULL;	// eubN}[NɌŗL̖O
	m_SmartBookmark = false;
	m_excludeFromBackup = -1;
	m_SyncParent = NULL;
	m_MobileRoot = NULL;
	m_GUID = NULL;
	m_syncStatus = 0;
	m_syncChangeCounter = 1;

}

/**
 * ubN}[NŗL̓eȊÕubN}[NRs[
 *
 * @param src ʌBookmarkNX̃CX^Xւ̎Q
 */
void FxBookmark::_copy(const FxBookmark &src)
{
	if (src.getID() != NULL)
		setID(src.getID());

	if (src.getCharset() != NULL)
		setCharset(src.getCharset());

	setCheck(src.getCheck());

	if (src.getFirefoxIcon() != NULL)
		setFirefoxIcon(src.getFirefoxIcon());

	if (src.getFeedUrl() != NULL)
		setFeedUrl(src.getFeedUrl());

	if (src.getFeed_expiration() != NULL)
		setFeed_expiration(src.getFeed_expiration());

	if (src.getSchedule() != NULL)
		setSchedule(src.getSchedule());

	setGroup(src.getGroup());
	setLinkbarFolder(src.getLinkbarFolder());
	setWebPanel(src.getWebPanel());
	setNewSearchFolder(src.getNewSearchFolder());
	setNewBookmarkFolder(src.getNewBookmarkFolder());
	setReadOnly(src.getReadOnly());

	if (src.getHRName() != NULL)
		setHRName(src.getHRName());

	if (src.getProperName() != NULL)
		setProperName(src.getProperName());

	if (src.getMicsum_gen_uri() != NULL)
		setMicsum_gen_uri(src.getMicsum_gen_uri());

	if (src.getMicsum_expiration() != NULL)
		setMicsum_expiration(src.getMicsum_expiration());

	if (src.getGeneratedTitle() != NULL)
		setGeneratedTitle(src.getGeneratedTitle());

	setOrganizerFolder(src.getOrganizerFolder());
	setOrganizerQuery(src.getOrganizerQuery());
	setSmartBookmark(src.getSmartBookmark());
	setExcludeFromBackup(src.getExcludeFromBackup());

	if (src.getSyncParent() != NULL) {
		setSyncParent(src.getSyncParent());
	}
	if (src.getMobileRoot() != NULL) {
		setMobileRoot(src.getMobileRoot());
	}

}


/**
 * ubN}[NŗL̓eȊÕubN}[NRs[
 *
 * @param src ʌBookmarkNX̃CX^Xւ̎Q
 */
void FxBookmark::copy(const FxBookmark &src)
{
	_copy(src);
}

/**
 * ubN}[NRs[=Zq
 *
 * @param src ʌBookmarkNX̃CX^Xւ̎Q
 * @return gւ̎Q
 */
FxBookmark & FxBookmark::operator = (const FxBookmark &src)
{
	reset();

	copy(src);

	if (src.getGUID() != NULL) {
		setGUID(src.getGUID());
	}
	setSyncStatus(getSyncStatus());
	setSyncChangeCount(getSyncChangeCount());

	return *this;
}

/**
 * ubN}[N̎ʏRs[
 *
 * @param src ʌBookmarkNX̃CX^Xւ̃|C^
 * @return 0Œ
 */
int FxBookmark::copyBookmarkIdentifier(FxBookmark *src)
{
	if (src->getGUID() != NULL) {
		setGUID(src->getGUID());
	}
	setSyncStatus(getSyncStatus());
	setSyncChangeCount(getSyncChangeCount());

	return 0;
}

/**
* ubN}[NRs[(ubN}[Nʗp)
*
* @param src ʌBookmarkNX̃CX^Xւ̃|C^
* @return 0Œ
*/
void FxBookmark::copyWithoutId(FxBookmark *src)
{
	copy(*src);
}

char *FxBookmark::setID(const char *item)
{
	char *p;
	int len;
	
	if (m_id != NULL){
		delete []m_id;
		m_id = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_id = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setCharset(const char *item)
{
	char *p;
	int len;
	
	if (m_charset != NULL){
		delete []m_charset;
		m_charset = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_charset = p;
	}catch(...){
		return NULL;
	}
	return p;
}

time_t FxBookmark::setCheck(const char *item)
{
	char *p;

	m_check = (time_t)strtoul(item,&p,10);

	return m_check;

}

char *FxBookmark::setSchedule(const char *item)
{
	char *p;
	int len;
	
	if (m_schedule != NULL){
		delete []m_schedule;
		m_schedule = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_schedule = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setHRName(const char *item)
{
	char *p;
	int len;
	
	if (m_HRName != NULL){
		delete []m_HRName;
		m_HRName = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_HRName = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setProperName(const char *item)
{
	char *p;
	int len;
	
	if (m_ProperName != NULL){
		delete []m_ProperName;
		m_ProperName = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;

	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_ProperName = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setFirefoxIcon(const char *item)
{
	char *p;
	int len;
	
	if (m_Firefoxicon != NULL){
		delete []m_Firefoxicon;
		m_Firefoxicon = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_Firefoxicon = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setFeedUrl(const char *item)
{
	char *p;
	int len;
	
	if (m_FeedUrl != NULL){
		delete []m_FeedUrl;
		m_FeedUrl = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_FeedUrl = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setMicsum_gen_uri(const char *item)
{
	char *p;
	int len;
	
	if (m_micsum_gen_uri != NULL){
		delete []m_micsum_gen_uri;
		m_micsum_gen_uri = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_micsum_gen_uri = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setMicsum_expiration(const char *item)
{
	char *p;
	int len;
	
	if (m_micsum_expiration != NULL){
		delete []m_micsum_expiration;
		m_micsum_expiration = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_micsum_expiration = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setGeneratedTitle(const char *item)
{
	char *p;
	int len;
	
	if (m_generatedTitle != NULL){
		delete []m_generatedTitle;
		m_generatedTitle = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_generatedTitle = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setFeed_expiration(const char *item)
{
	char *p;
	int len;
	
	if (m_feed_expiration != NULL){
		delete []m_feed_expiration;
		m_feed_expiration = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_feed_expiration = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * sync/parent̒lݒ肷B
 *
 * @param item ݒ肷l
 * @return ݒ肵l
 */
char *FxBookmark::setSyncParent(const char *item)
{
	char *p;
	int len;
	
	if (m_SyncParent != NULL){
		delete []m_SyncParent;
		m_SyncParent = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_SyncParent = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * mobile/bookmarksRoot̒lݒ肷B
 *
 * @param item ݒ肷l
 * @return ݒ肵l
 */
char *FxBookmark::setMobileRoot(const char *item)
{
	char *p;
	int len;
	
	if (m_MobileRoot != NULL){
		delete []m_MobileRoot;
		m_MobileRoot = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_MobileRoot = p;
	}catch(...){
		return NULL;
	}
	return p;
}

char *FxBookmark::setGUID(const char *item)
{
	char *p;
	int len;
	
	if (m_GUID != NULL){
		delete []m_GUID;
		m_GUID = NULL;
	}
	
	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_GUID = p;
	}catch(...){
		return NULL;
	}
	return p;
}

