#ifndef EDGE2READER_H
#define EDGE2READER_H

#include	<vector>

#include	"BScommon.h"
#include	"Bookmark.h"
#include	"Logger.h"

#include	"IBookmarkTree.h"
#include	"BookmarkTree.h"
#include	"TJson.h"

#undef EXTERN
#ifdef ISEDGE2READER
#define EXTERN
#else
#define EXTERN extern
#endif

class Edge2Reader {

	enum ItemType {
		FOLDER,
		BOOKMARK
	};

private:
	char noIEfavorites;	// 1:IÊCɓRo[gȂB 0:
	IbookmarkTree *writer;	// ݗpIuWFNg
	int isSilentMode;	// 1:t@CI[vsbZ[WȂ 0:
	TJsonValue *topValue;	// ǂݍ񂾃f[^

	// ꎞobt@
	char *scFile;
	char item[BUFLEN],*pItem;	// H3̒gۑ
	int cItem;				// item̕JEgp
	Bookmark bookmark;
	int f_item;
	int m_bookmarkNo;	// ǂݍłubN}[N̔ԍ

	char *urlBuf;	// URLϊpobt@
	int urlBufLen;
	char *valueBuf;	// lobt@
	char *work;		// ꎞpobt@
	char *valuePtr;	// lobt@̃|C^
	int valueCount;	// lobt@̕JE^
	bool ignoreToolbar;	// c[o[𖳎邩ǂ

	int level;			// Kwx
	Logger *logger;

	int flushItem(Edge2Reader::ItemType type);
	int setName(char *item);

	int readFile(const char *bmFile,const char *fvDir);
	int reallocUrlBuf(int size);

	// ǂݍJSOÑIuWFNgf
	int parseStart(void);
	int parseToplevel(TJsonValue *roots);
	int parseBar(TJsonValue *topObject);
	int parseFolder(TJsonValue *folderArray);
	int parseItem(TJsonValue *topObject);
	char *decodeAndRealloc(char *p);

public:
	char setIEfavoritesImport(char mode){	noIEfavorites = mode;return mode;}
	void setBookmarkWriter(IbookmarkTree *obj)
	{
		writer = obj;
	}
	Edge2Reader();
	~Edge2Reader();
	int readBookmark(const char *bmFile,const char *fvDir);
	void setSilentMode(int mode){	isSilentMode = mode;}
	int getBookmarkNo(void) { return m_bookmarkNo; }
	void setBookmarkNo(int no){	m_bookmarkNo = no;}
	void setIgnoreToolbar(bool flag) {
		ignoreToolbar = flag;
	}
	void setLogger(Logger *loggerObj) {
		logger = loggerObj;
	}

};

#undef EXTERN

#endif	// EDGE2READER_H
