#ifndef EDGE2BOOKMARK_H
#define EDGE2BOOKMARK_H

// Wwb_
#include	<stdio.h>
#include	"bslib.h"

#define STARS_DESCRIPTION "stars.description"
#define STARS_NOTE "stars.note"
#define STARS_VERSION "stars.version"
#define STARS_ID "stars.id"
#define STARS_IS_SYNCED "stars.isSynced"

class Edge2Bookmark {
private:
	char *m_id;	// ID
	char *m_metaInfo;	// meta_info
	char *m_starsVersion;
	char *m_starsId;
	char *m_starsIsSynced;
	char *m_guid;			// GUID
	bool m_ShowIcon;
	char *m_source;			// source

	void _init(void);
	void _reset(void);

protected:
	void _copy(const Edge2Bookmark &src);
	void copy(const Edge2Bookmark &src);

public:
	/* EʁEj */
	Edge2Bookmark(void);
	Edge2Bookmark(const Edge2Bookmark &src);
	virtual ~Edge2Bookmark();

	Edge2Bookmark & operator = (const Edge2Bookmark &src);
	void copyWithoutId(Edge2Bookmark *src);
	int copyBookmarkIdentifier(Edge2Bookmark *src);

	void reset(void);

	char *getID(void) const { return m_id; };
	char *setID(const char *item);

	char *getMetaInfo(void) const { return m_metaInfo; };
	char *setMetaInfo(const char *item);

	char *getStarsVersion(void) const { return m_starsVersion; };
	char *setStarsVersion(const char *item)
	{
		return reAllocate(m_starsVersion, item);
	}

	char *getStarsId(void) const { return m_starsId; };
	char *setStarsId(const char *item)
	{
		return reAllocate(m_starsId, item);
	}

	char *getStarsIsSynced(void) const { return m_starsIsSynced; };
	char *setStarsIsSynced(const char *item)
	{
		return reAllocate(m_starsIsSynced, item);
	}

	char *getGuid(void) const { return m_guid; };
	char *setGuid(const char *item);

	bool getShowIcon(void) const { return m_ShowIcon; };
	bool setShowIcon(const bool value)
	{
		m_ShowIcon = value;
		return value;
	}

	char *getSource(void) const { return m_source; };
	char *setSource(const char *item);
};

#endif	// EDGE2BOOKMARK_H
