#include	<stdlib.h>
#include	<new>
#include	<memory>

#include	<stdio.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"encutil2.h"
#include	"Bookmark.h"
#include	"Edge2Bookmark.h"

#ifdef _DEBUG
#define debugprintf //printf
#else
#define debugprintf
#endif

/**
 * RXgN^
 */
Edge2Bookmark::Edge2Bookmark()
{
	_init();
}

/**
 * Rs[RXgN^
 *
 * @param src Rs[̃IuWFNg
 */
Edge2Bookmark::Edge2Bookmark(const Edge2Bookmark &src)
{
	_init();
	_copy(src);
}

/**
 * fXgN^
 */
Edge2Bookmark::~Edge2Bookmark()
{
	_reset();
}

/**
 *	CX^X̓eɏlB<br>
 *	RXgN^p
 *
 */
void Edge2Bookmark::_init(void)
{
	m_id = NULL;
	m_metaInfo = NULL;
	m_starsVersion = NULL;
	m_starsId = NULL;
	m_starsIsSynced = NULL;
	m_guid = NULL;
	m_ShowIcon = false;
	m_source = NULL;
}

/**
 * CX^X̓eĐݒ肷B(Jt)
 */
void Edge2Bookmark::_reset(void)
{
	if (m_source != NULL) {
		delete[]m_source;
		m_source = NULL;
	}

	m_ShowIcon = false;

	if (m_guid != NULL) {
		delete[]m_guid;
		m_guid = NULL;
	}

	if (m_id != NULL) {
		delete[]m_id;
		m_id = NULL;
	}
	if (m_metaInfo != NULL) {
		delete []m_metaInfo;
		m_metaInfo = NULL;
	}
	if (m_starsVersion != NULL) {
		delete[]m_starsVersion;
	}
	if (m_starsId != NULL) {
		delete[]m_starsId;
	}
	if (m_starsIsSynced != NULL) {
		delete[]m_starsIsSynced;
	}
	_init();
}

/**
 * CX^X̃Rs[
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
void Edge2Bookmark::_copy(const Edge2Bookmark &src)
{
	setMetaInfo(src.getMetaInfo());
	setStarsVersion(src.getStarsVersion());
	setShowIcon(src.getShowIcon());
	if (src.getSource() != NULL) {
		setSource(src.getSource());
	}
}

/**
 * CX^XŜ̓eB
 */
void Edge2Bookmark::reset(void)
{
	_reset();
}

/**
 * CX^X̃Rs[
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
void Edge2Bookmark::copy(const Edge2Bookmark &src)
{
	_copy(src);
}

/**
 * =ZqɂCX^X̃Rs[
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 * @return g̎Q
 */
Edge2Bookmark & Edge2Bookmark::operator = (const Edge2Bookmark &src)
{
	reset();
	copy(src);
	setID(src.getID());
	setStarsId(src.getStarsId());
	setStarsIsSynced(src.getStarsIsSynced());
	setGuid(src.getGuid());
	setShowIcon(src.getShowIcon());
	setSource(src.getSource());

	return *this;
}

/**
 * ubN}[NRs[(ubN}[Nʗp)
 *
 * @param src ʌBookmarkNX̃CX^Xւ̃|C^
 * @return 0Œ
 */
void Edge2Bookmark::copyWithoutId(Edge2Bookmark *src)
{
	_copy(*src);
}

/**
* ubN}[N̎ʏRs[
*
* @param src ʌBookmarkNX̃CX^Xւ̃|C^
* @return 0Œ
*/
int Edge2Bookmark::copyBookmarkIdentifier(Edge2Bookmark *src)
{
	if (src->getID() != NULL) {
		setID(src->getID());
	}
	if (src->getGuid() != NULL) {
		setGuid(src->getGuid());
	}
	if (src->getStarsId() != NULL) {
		setStarsId(src->getStarsId());
	}
	if (src->getStarsIsSynced() != NULL) {
		setStarsIsSynced(src->getStarsIsSynced());
	}

	return 0;
}


/**
 * IDݒ肷B
 *
 * @param item ݒ肷ID
 * @return ݒ肵IDւ̃|C^
 */
char *Edge2Bookmark::setID(const char *item)
{
	char *p;
	int len;
	
	if (m_id != NULL){
		delete []m_id;
		m_id = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_id = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * meta_infoݒ肷B
 *
 * @param item ݒ肷meta_info
 * @return ݒ肵meta_infoւ̃|C^
 */
char *Edge2Bookmark::setMetaInfo(const char *item)
{
	char *p;
	int len;
	
	if (m_metaInfo != NULL){
		delete []m_metaInfo;
		m_metaInfo = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_metaInfo = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * GUIDݒ肷B
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
char *Edge2Bookmark::setGuid(const char *item)
{
	char *p;
	int len;

	if (m_guid != NULL) {
		delete[]m_guid;
		m_guid = NULL;
	}

	if (item == NULL) {
		return NULL;
	}

	len = strlen(item) + 1;

	try {
		p = new char[len];
		if (p == NULL) {
			return NULL;
		}
		strcpy(p, item);
		m_guid = p;
	}
	catch (...) {
		return NULL;
	}
	return p;
}

/**
 * GUIDݒ肷B
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
char *Edge2Bookmark::setSource(const char *item)
{
	char *p;
	int len;

	if (m_source != NULL) {
		delete[]m_source;
		m_source = NULL;
	}

	if (item == NULL) {
		return NULL;
	}

	len = strlen(item) + 1;

	try {
		p = new char[len];
		if (p == NULL) {
			return NULL;
		}
		strcpy(p, item);
		m_source = p;
	}
	catch (...) {
		return NULL;
	}
	return p;
}
