/*
	IÊCɓǂݍŃ̃XgɊi[B
	fBNg͍ċAIɍsB
*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<io.h>
#include	<errno.h>
#include	<time.h>
#include	<vector>
#include	<algorithm>
#include	<functional>

#include	"NTfunction.h"
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"BSStringHolder.h"
#include	"TJson.h"

#define EDGEREADER_CPP
#include	"EdgeReader.h"

static const char *g_message[2][2] = {
	{
		"fBNg %s ̌Ɏs܂B\n",
		"G[܂B\n"
	},{
		"Directory %s search failed.\n",
		"Internal error.\n"
	}
};

EdgeReader::EdgeReader()
{
	level = 0;

	instance = JET_instanceNil;
	sesid = JET_sesidNil;
	dbid = JET_dbidNil;
	tableid = JET_tableidNil;
	ignoreLink = false;
}

/**
 * tH_̓e͂B
 *
 * @param parent etH_GUID
 * @return 0:I 1:ُI
 */
int EdgeReader::parseFolder(char *parent)
{
	int itemsCount;

	// t@C̃tH_̂Cɓ̃tH_ɍv̂B
	itemsCount = items.size();

	for (int i = 0; i < itemsCount; i++) {
		// ɈtH_͔΂B
		if (items[i]->treated) {
			continue;
		}

		bool found = false;

		// etH_v̂B
		if (!memcmp(items[i]->parentId, parent, 16)) {
			found = true;
		}
		if (!found) {
			// tH_̂̂ł͂Ȃ̂Ŕ
			continue;
		}

		items[i]->treated = true;
		bookmark.reset();

		// 
		bool isFolderValue;
		if (items[i]->isFolder) {
			isFolderValue = true;
			bookmark.setItemType(Bookmark::folder);
		} else {
			isFolderValue = false;
			bookmark.setItemType(Bookmark::bookmark);
		}

		// O
		wchar_t *name = items[i]->title;
		// Cɓo[ǂ̔
		if ((level == 0) && isFolderValue && !(wcscmp(L"_Favorites_Bar_", name))) {
			// Cɓo[̏ꍇ
			// IEp̐ݒ(Unicode)
			const wchar_t *nameW = L"Cɓo[";
			bookmark.setIeNameW(nameW);
			// UTF-8̖{̖̐ݒ
			char *nameChar = wctoUTF8Internal(nameW);
			bookmark.setName(nameChar);
			// IEp̐ݒ(}`oCg)
			nameChar = wctombInternal(nameW);
			bookmark.setIeName(nameChar);
		} else {
			// Cɓo[ȊȌꍇ
			// IEp̐ݒ(Unicode)
			bookmark.setIeNameW(name);
			// UTF-8̖{̖̐ݒ
			char *nameChar = wctoUTF8Internal(name);
			bookmark.setName(nameChar);
			// IEp̐ݒ(}`oCg)
			nameChar = wctombInternal(name);
			bookmark.setIeName(nameChar);
		}

		// ʏ
		bookmark.setModified(items[i]->updated);

		// ŗL
		if (isFolderValue) {
			// tH_̏ꍇ
			writer->storeItem(&bookmark);
			// TutH_ċAIɌB
			level++;	// Kw̒iXVB
			parseFolder(items[i]->itemId);
			writer->upFolder();
			level--;	// Kw̒iXVB
		} else {
			bookmark.setURL(items[i]->url);
			writer->storeItem(&bookmark);
		}
	}

	return 0;
}

/**
 * tH_̓e͂B
 *
 * @param parent etH_GUID
 * @return 0:I 1:ُI
 */
int EdgeReader::parseRoot(void)
{
	int itemsCount;

	std::sort(items.begin(), items.end());

	// t@C̃tH_̂Cɓ̃tH_ɍv̂B
	itemsCount = items.size();

	for (int i = 0; i < itemsCount; i++) {
		if (items[i]->treated) {
			continue;
		}

		IdHolder parent(items[i]->parentId);

		// etH_̃ubN}[N̏ꍇ̓[gtH_ł͂Ȃ̂őΏۊOƂB
		if (folderIdList.find(parent) != folderIdList.end()) {
			// [gtH_̂̂ł͂Ȃ̂Ŕ
			continue;
		}

		items[i]->treated = true;
		bookmark.reset();

		// 
		bool isFolderValue;
		if (items[i]->isFolder) {
			isFolderValue = true;
			bookmark.setItemType(Bookmark::folder);
		} else {
			isFolderValue = false;
			bookmark.setItemType(Bookmark::bookmark);
		}

		// O
		wchar_t *name = items[i]->title;
		bool isFavoritesBar = false;
		// Cɓo[ǂ̔
		if ((level == 0) && isFolderValue && !(wcscmp(L"_Favorites_Bar_", name))) {
			// Cɓo[̏ꍇ
			// IEp̐ݒ(Unicode)
			const wchar_t *nameW = L"Cɓo[";
			bookmark.setIeNameW(nameW);
			// UTF-8̖{̖̐ݒ
			char *nameChar = wctoUTF8Internal(nameW);
			bookmark.setName(nameChar);
			// IEp̐ݒ(}`oCg)
			nameChar = wctombInternal(nameW);
			bookmark.setIeName(nameChar);
			isFavoritesBar = true;
		} else {
			// Cɓo[ȊȌꍇ
			// IEp̐ݒ(Unicode)
			bookmark.setIeNameW(name);
			// UTF-8̖{̖̐ݒ
			char *nameChar = wctoUTF8Internal(name);
			bookmark.setName(nameChar);
			// IEp̐ݒ(}`oCg)
			nameChar = wctombInternal(name);
			bookmark.setIeName(nameChar);
		}

		// ʏ
		bookmark.setModified(items[i]->updated);

		// ŗL
		if (isFolderValue) {
			// tH_̏ꍇ
			if (!ignoreLink || !isFavoritesBar) {
				// Cɓo[𖳎ȂꍇƂCɓo[łȂꍇA
				// z߂B
				writer->storeItem(&bookmark);

				// TutH_ċAIɌB
				level++;	// Kw̒iXVB
				parseFolder(items[i]->itemId);
				writer->upFolder();
				level--;	// Kw̒iXVB
			}
		} else {
			bookmark.setURL(items[i]->url);
			writer->storeItem(&bookmark);
		}
	}

	return 0;
}


/**
 * Cɓ擾B
 *
 * @throw G[R[h
 * @return <br>
 *		-1:G[<br>
 *		0:łȂt@C/fBNg<br>
 *		1:ׂẴt@C/fBNg<br>
 */
int EdgeReader::getFavorites(void)
{
	err = JetMove(sesid, tableid, 0, JET_MoveFirst);
	if (err < JET_errSuccess) {
		throw err;
	}
	while (err == JET_errSuccess) {

		struct BookmarkData *record = (struct BookmarkData *)calloc(1, sizeof(struct BookmarkData));

		char buffer[8192];
		FILETIME fileTime;
		__int64 llTime;

		err = JetRetrieveColumn(sesid, tableid, isdeleted.columnid, buffer, sizeof(buffer), NULL, 0, NULL);
		if (err < JET_errSuccess) {
			throw err;
		}
		if ((err != JET_wrnColumnNull) && (buffer[0] == -1)) {
			err = JetMove(sesid, tableid, JET_MoveNext, 0);
			continue;
		}

		err = JetRetrieveColumn(sesid, tableid, isfolder.columnid, buffer, sizeof(buffer), NULL, 0, NULL);
		if (err < JET_errSuccess) {
			throw err;
		}
		if ((err != JET_wrnColumnNull) && (buffer[0] == -1)) {
			record->isFolder = true;
		} else {
			record->isFolder = false;
		}

		err = JetRetrieveColumn(sesid, tableid, itemid.columnid, buffer, sizeof(buffer), NULL, 0, NULL);
		if (err < JET_errSuccess) {
			throw err;
		}
		memcpy(record->itemId, buffer, 16);

		err = JetRetrieveColumn(sesid, tableid, parentid.columnid, buffer, sizeof(buffer), NULL, 0, NULL);
		if (err < JET_errSuccess) {
			throw err;
		}
		memcpy(record->parentId, buffer, 16);

		err = JetRetrieveColumn(sesid, tableid, dateupdated.columnid, &llTime, sizeof(__int64), NULL, 0, NULL);
		if (err < JET_errSuccess) {
			throw err;
		}
		if (err != JET_wrnColumnNull) {
			fileTime.dwHighDateTime = (llTime >> 32) & 0xffffffff;
			fileTime.dwLowDateTime = llTime & 0xffffffff;

			// nɕϊB
			SYSTEMTIME systemTime;
			FileTimeToSystemTime(&fileTime, &systemTime);
			SYSTEMTIME localTime;
			SystemTimeToTzSpecificLocalTime(NULL, &systemTime, &localTime);

			// ŁAtime_tɕϊB
			time_t unixTime;
			struct tm timeDetail;

			timeDetail.tm_year = localTime.wYear - 1900;
			timeDetail.tm_mon = localTime.wMonth - 1;
			timeDetail.tm_mday = localTime.wDay;
			timeDetail.tm_wday = localTime.wDayOfWeek;
			timeDetail.tm_yday = 0;
			timeDetail.tm_hour = localTime.wHour;
			timeDetail.tm_min = localTime.wMinute;
			timeDetail.tm_sec = localTime.wSecond;
			timeDetail.tm_isdst = 0;

			unixTime = mktime(&timeDetail);
			record->updated = unixTime;
		} else {
			record->updated = 0;
		}

		memset(buffer, 0, 4096);
		err = JetRetrieveColumn(sesid, tableid, title.columnid, buffer, sizeof(buffer), NULL, 0, NULL);
		if (err < JET_errSuccess) {
			throw err;
		}
		if (err != JET_wrnColumnNull) {
			wcscpy(record->title, (wchar_t *)buffer);
		} else {
			wcscpy(record->title, L"");
		}

		if (!record->isFolder) {
			// URL̓tH_łȂꍇ̂ݎ擾B
			memset(buffer, 0, 8192);
			err = JetRetrieveColumn(sesid, tableid, url.columnid, buffer, sizeof(buffer), NULL, 0, NULL);
			if (err < JET_errSuccess) {
				throw err;
			}
			if (err != JET_wrnColumnNull) {
				char *p = wctombInternal((wchar_t *)buffer);
				strcpy(record->url, p);
			} else {
				strcpy(record->url, "");
			}
		} else {
			// tH_IDXgɓo^B
			IdHolder id(record->itemId);
			folderIdList.insert(id);
		}
		record->treated = false;
		items.push_back(record);

		err = JetMove(sesid, tableid, JET_MoveNext, 0);
	}


	return 0;
}

/**
 * e[ȕ擾B
 */
void EdgeReader::getTableInfo(void)
{
	// e[uI[vB
	err = JetOpenTable(sesid, dbid, "Favorites", 0, 0, JET_bitTableReadOnly, &tableid);
	if (err < JET_errSuccess) {
		throw err;
	}

	// ȅ擾B
	err = JetGetTableColumnInfo(sesid, tableid, "IsDeleted", &isdeleted, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
	err = JetGetTableColumnInfo(sesid, tableid, "ItemId", &itemid, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
	err = JetGetTableColumnInfo(sesid, tableid, "ParentId", &parentid, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
	err = JetGetTableColumnInfo(sesid, tableid, "Title", &title, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
	err = JetGetTableColumnInfo(sesid, tableid, "URL", &url, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
	err = JetGetTableColumnInfo(sesid, tableid, "IsFolder", &isfolder, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
	err = JetGetTableColumnInfo(sesid, tableid, "OrderNumber", &ordernumber, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
	err = JetGetTableColumnInfo(sesid, tableid, "DateUpdated", &dateupdated, sizeof(JET_COLUMNDEF), JET_ColInfo);
	if (err < JET_errSuccess) {
		throw err;
	}
}

/**
 * fBNgJn
 *
 * @param dir_nameW TfBNg(\tȂ)
 * @return <br>
 *		-1:G[<br>
 *		0:łȂt@C/fBNg<br>
 *		1:ׂẴt@C/fBNg<br>
 */
int EdgeReader::search_dir(const char *dir_nameW)
{
	int result = 1;	// s

	unsigned long pagesize;
	char logDir[MAX_PATH];
	char systemDir[MAX_PATH];
	char *p;

	logger->debug("Favorite data file");
	logger->debug(dir_nameW);

	strcpy(logDir, dir_nameW);
	p = strrchr(logDir, '\\');
	if (p != NULL) {
		*(p + 1) = '\0';
	} else {
		strcpy(logDir, ".\\");
	}
	strcpy(systemDir, logDir);	// *.CHK쐬fBNgi̓obNXbV)
	strcat(logDir, "LogFiles");	// gUNVO쐬fBNg

	logger->debug("Transaction log directory");
	logger->debug(logDir);

	CreateDirectory(logDir, NULL);

	logger->debug(logDir);

	try {
		err = JetGetDatabaseFileInfo(dir_nameW, &pagesize, sizeof(unsigned long), JET_DbInfoPageSize);
		if (err < JET_errSuccess) {
			throw err;
		}
		JetSetSystemParameter(&instance, JET_sesidNil, JET_paramDatabasePageSize, pagesize, NULL);

		// ESENT̃CX^X쐬B
		logger->trace("ESE create Instance.");
		err = JetCreateInstance(&instance, "instance");
		if (err < JET_errSuccess) {
			throw err;
		}
		// ȉA3ڂEdgê̂ɍ킹
		// gUNVÕvtBbNX
		JetSetSystemParameter(&instance, JET_sesidNil, JET_paramBaseName, 0, "edb");
		// gUNVOt@C̃TCY(512 * 1024 = 524,288)
		JetSetSystemParameter(&instance, JET_sesidNil, JET_paramLogFileSize, 512, NULL);
		// gUNVÖʒu
		JetSetSystemParameter(&instance, JET_sesidNil, JET_paramLogFilePath, 0, logDir);
		// `FbN|Cg̃fBNgEdgê̂gB
		JetSetSystemParameter(&instance, JET_sesidNil, JET_paramSystemPath, 0, systemDir);
		JetSetSystemParameter(&instance, JET_sesidNil, JET_paramCircularLog, 1, NULL);

		logger->trace("ESE Initialize.");
		err = JetInit(&instance);
		if (err < JET_errSuccess) {
			throw err;
		}

		logger->trace("ESE Begin session.");
		JetBeginSession(instance, &sesid, 0, 0);

		logger->trace("ESE attach database.");
		err = JetAttachDatabase(sesid, dir_nameW, 0);
		if (err < JET_errSuccess) {
			throw err;
		}

		logger->trace("ESE open database.");
		err = JetOpenDatabase(sesid, dir_nameW, 0, &dbid, 0);
		if (err < JET_errSuccess) {
			throw err;
		}

		// e[ȕ擾B
		logger->trace("ESE table info reading.");
		getTableInfo();

		// e[u炨Cɓ擾B
		logger->trace("ESE get favorites.");
		getFavorites();

		// Cɓ͂B
		logger->trace("Favorites parse start.");
		parseRoot();

		logger->trace("Favorites read end.");
	}
	catch (JET_ERR &errorCode) {
		result = -1;
		char message[128];
		sprintf(message, "Error! Error code:%ld", errorCode);
		logger->debug(message);
	}

	// Cɓf[^̃N[Abv
	int itemsCount;

	itemsCount = items.size();

	for (int i = 0; i < itemsCount; i++) {
		free(items[i]);
	}

	// Terminate ESENT. This performs a clean shutdown.
	if (tableid != JET_tableidNil) {
		JetCloseTable(sesid, tableid);
	}
	if (dbid != JET_dbidNil) {
		JetCloseDatabase(sesid, dbid, JET_bitNil);
	}
	if (sesid != JET_sesidNil) {
		JetEndSession(sesid, JET_bitNil);
	}
	if (instance != JET_instanceNil) {
		JetTerm(instance);
	}

	return result;
}
