
#undef JET_VERSION

// Windows XPœ삷͈͓APIgpB
#define JET_VERSION 0x0501

#include <stdio.h>
#include <string.h>
#include "EdgeDBCleaner.h"

//
#define Call(func) { \
       err = (func); \
       if(err < JET_errSuccess) { \
       throw err; \
       } \
}

/**
 * RXgN^
 */
EdgeDBCleaner::EdgeDBCleaner()
{
	instance = JET_instanceNil;
	sesid = JET_sesidNil;
	dbid = JET_dbidNil;
	tableid = JET_tableidNil;
}

/**
 * 폜JnB
 *
 * @param dbPath EdgêCɓDB̃pX
 * @return 0:폜 -1:폜s
 */
int EdgeDBCleaner::startCleaning(const char *dbPath)
{
	int result = 0;
	JET_ERR err;
	JET_INSTANCE instance = JET_instanceNil;
	JET_SESID sesid = JET_sesidNil;
	JET_DBID dbid = JET_dbidNil;
	JET_TABLEID tableid = JET_tableidNil;

	// ESENTB
	unsigned long pagesize;
	const char *target = dbPath;
	char logDir[MAX_PATH];
	char systemDir[MAX_PATH];
	char *p;

	logger->debug("Favorite data file");
	logger->debug(dbPath);

	strcpy(logDir, dbPath);
	p = strrchr(logDir, '\\');
	if (p != NULL) {
		*(p + 1) = '\0';
	} else {
		strcpy(logDir, ".\\");
	}
	strcpy(systemDir, logDir);	// *.CHK쐬fBNgi̓obNXbV)
	strcat(logDir, "LogFiles");	// gUNVO쐬fBNg

	logger->debug("Transaction log directory");
	logger->debug(logDir);

	CreateDirectory(logDir, NULL);

	logger->debug(logDir);

	try {
		Call(JetGetDatabaseFileInfo(target, &pagesize, sizeof(unsigned long), JET_DbInfoPageSize));

		Call(JetSetSystemParameter(&instance, JET_sesidNil, JET_paramDatabasePageSize, pagesize, NULL));
		logger->trace("ESE DB page size set.");

		Call(JetCreateInstance(&instance, "instance"));
		logger->trace("ESE DB instance created.");

		Call(JetSetSystemParameter(&instance, JET_sesidNil, JET_paramBaseName, 0, "edb"));
		logger->trace("ESE DB JET_paramBaseName set.");

		Call(JetSetSystemParameter(&instance, JET_sesidNil, JET_paramLogFileSize, 512, NULL));
		logger->trace("ESE DB JET_paramLogFileSize set.");

		// gUNVÕfBNgEdgê̂gB
		Call(JetSetSystemParameter(&instance, JET_sesidNil, JET_paramLogFilePath, 0, logDir));
		logger->trace("ESE DB JET_paramLogFilePath set.");

		// `FbN|Cg̃fBNgEdgê̂gB
		Call(JetSetSystemParameter(&instance, JET_sesidNil, JET_paramSystemPath, 0, systemDir));
		logger->trace("ESE DB JET_paramSystemPath set.");

		Call(JetSetSystemParameter(&instance, JET_sesidNil, JET_paramCircularLog, 1, NULL));
		logger->trace("ESE DB JET_paramCircularLog set.");

		Call(JetInit(&instance));
		logger->trace("ESE DB Initialized.");

		Call(JetBeginSession(instance, &sesid, 0, 0));
		logger->trace("ESE DB Session Begin.");

		// To open an existing database use the JetAttachDatabase and
		// JetOpenDatabase APIs.

		Call(JetAttachDatabase(sesid, target, 0));
		logger->trace("ESE DB Attached.");

		Call(JetOpenDatabase(sesid, target, 0, &dbid, 0));
		logger->trace("ESE DB Opened.");

		// Open the table.
		Call(JetOpenTable(sesid, dbid, "Favorites", 0, 0, JET_bitTableUpdatable, &tableid));
		logger->trace("ESE Table Opened.");

		Call(JetGetTableColumnInfo(sesid, tableid, "Title", &titleDef, sizeof(JET_COLUMNDEF), JET_ColInfo));


		// ׂẴR[h폜B
		JetMove(sesid, tableid, JET_MoveLast, 0);
		while (1) {
#if 0
			// R[h𓾂
			JET_OBJECTINFO info;
			memset(&info, 0, sizeof(info));
			info.cbStruct = sizeof(info);
			err = JetGetObjectInfo(
				sesid,
				dbid,
				JET_objtypTable,
				NULL,
				"Favorites",
				&info,
				sizeof(info),
				JET_ObjInfo);
			if (info.cRecord < 2) {
				//break;
			}
#endif

			Call(JetBeginTransaction(sesid));

			bool isFavBar = false;
			wchar_t titleBuf[4096];
			memset(titleBuf, 0, 4096 * sizeof(wchar_t));
			Call(JetRetrieveColumn(sesid, tableid, titleDef.columnid, titleBuf, sizeof(titleBuf), NULL, 0, NULL));
			if (wcscmp(L"_Favorites_Bar_", titleBuf)) {
				// _Favorites_Bar_͎cĂȂƃ[gtH_̐em邷ׂȂȂ̂Ŏc
				err = JetDelete(sesid, tableid);
				if (err != JET_errSuccess) {
					logger->debug("Record delete error.");
					throw err;
				}
			} else {
				isFavBar = true;
			}

			Call(JetCommitTransaction(sesid, JET_bitCommitLazyFlush));

			JET_RECPOS pos;

			// ŏ̃R[hłȂꍇA1OɈړB
			err = JetGetRecordPosition(sesid, tableid, &pos, sizeof(pos));
			if (err != JET_errSuccess) {
				logger->debug("Record move error.");
				throw err;
			}
			if (pos.centriesLT > 0) {
				err = JetMove(sesid, tableid, JET_MovePrevious, 0);
			} else {
				if (isFavBar) {
					// Cɓo[ȂȂ甲B
					break;
				}
			}

		}
	} catch (JET_ERR &errorCode) {
		result = -1;
		char message[128];
		sprintf(message, "Error! Error code:%ld", errorCode);
		logger->debug(message);
	}

	// ESENŤnsB
	logger->trace("ESE clean up start.");

	if (tableid != JET_tableidNil) {
		JetCloseTable(sesid, tableid);
		tableid = JET_tableidNil;
	}
	if (dbid != JET_dbidNil) {
		JetCloseDatabase(sesid, dbid, JET_bitNil);
		dbid = JET_dbidNil;
	}
	if (sesid != JET_sesidNil) {
		JetEndSession(sesid, JET_bitNil);
		sesid = JET_sesidNil;
	}
	if (instance != JET_instanceNil) {
		JetTerm(instance);
		instance = JET_instanceNil;
	}
	logger->trace("ESE clean up end.");

	return result;
}

int main(int argc, char * argv[])
{
	EdgeDBCleaner *cleaner = new EdgeDBCleaner();
	
	int result = cleaner->startCleaning(argv[1]);
	
	delete cleaner;
}
