#ifndef EDGECLEANER_H
#define EDGECLEANER_H

#include	"IEdgeItemHandler.h"
#include	"BookmarkTree.h"

/**
 * IÊCɓ폜
 *
 */
class EdgeCleaner : public IEdgeItemHandler {
private:
	bool m_noIElink;
	char *m_linkDir;
	BookmarkTree *m_bookmarkTree;
	bool inTreeFlag;
	
	int removeNT(const wchar_t *dirName,WIN32_FIND_DATAW *f_info);
	int remove(const char *dirName,WIN32_FIND_DATA *f_info);
public:
	EdgeCleaner::EdgeCleaner(void);

	int doAction(const char *dirName,WIN32_FIND_DATA *f_info,
				 const wchar_t *dirNameW,WIN32_FIND_DATAW *f_infoW);

	void setNoIeLink(bool noIeLink){
		m_noIElink = noIeLink;
	}
	void setIElinkDir(char *dir){
		m_linkDir = dir;
	}
	void setBookmarkTree(BookmarkTree *bookmarkTree) {
		m_bookmarkTree = bookmarkTree;
		inTreeFlag = true;
	}
};

#endif
