#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"
#include	"Bookmark.h"
#include	"url.h"

#include	"ChromeWriter.h"

/**
 * RXgN^
 */
ChromeWriter::ChromeWriter(void)
{
	m_target = 0;
	m_level = 0;
	placesPut = true;
	m_ignore = false;
	itemsCount.push_back(0);
	putIEToolbar = true;
	isFirstRoot = true;
	inFolder = true;

	urlBuf = NULL;
	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;
}

/**
 * fXgN^
 */
ChromeWriter::~ChromeWriter()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}
}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int ChromeWriter::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		return -1;
	}
	return size;
}

/**
 * Xy[Xo͂B
 *
 * @param fp o͐̃t@C|C^
 * @param tabs ^u̐
 */
void ChromeWriter::spput(FILE *fp,int tabs)
{
	int i;
	
	for (i = 0;i < (tabs * 3);i++){
		fputc(' ',fp);
	}
}

/**
 * tH_AubN}[ÑJ}؂o͂ƃJ}Kvǂ̃JEgsB
 *
 */
void ChromeWriter::putItemPause(void)
{
	if ((inFolder) || (m_level < 2)) {
		// tH_ɃtH_ꍇ͊etH_̏Ԃ
		// J}łB
		if (itemsCount[m_level] > 0) {
			fprintf(cs_fpo,", ");
		}
		itemsCount[m_level] += 1;
	} else {
		if (m_level < 2) {
			// 1iڂ܂ł͊etH_̏Ԃ
			// J}łB
			if (itemsCount[m_level] > 0) {
				fprintf(cs_fpo,", ");
			}
			itemsCount[m_level] += 1;
		} else {
			// tH_̒2iڂ̏ԂɃJ}łB
			if (itemsCount[2] > 0) {
				fprintf(cs_fpo,", ");
			}
			itemsCount[2] += 1;
		}
	}
}

/**
 * meta_info̓eo͂B
 *
 * @param item ubN}[N̏
 * @param chromeInfo ChromẽubN}[NŗL
 * @param level o͂Kw
 * @param isFolder tH_ǂH
 */
void ChromeWriter::putMetaInfo(Bookmark *item, ChromeBookmark *chromeInfo, int level, bool isFolder)
{
	bool outMetaInfoValue = false;

	if (item->getDescription() != NULL) {
		outMetaInfoValue = true;
		spput(cs_fpo, level + m_level);
		fprintf(cs_fpo, "\"meta_info\": {\n");

		spput(cs_fpo, level + 1 + m_level);
		if (isFolder) {
			fprintf(cs_fpo, "\"stars.description\": \"");
		} else {
			fprintf(cs_fpo, "\"stars.note\": \"");
		}
		wchar_t *wp = UTF8towcFileNameInternal(item->getDescription());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo, "\"");
	}

	if (chromeInfo->getStarsVersion() != NULL) {
		if (outMetaInfoValue) {
			fprintf(cs_fpo, ",\n");
		} else {
			outMetaInfoValue = true;
			spput(cs_fpo, level + m_level);
			fprintf(cs_fpo, "\"meta_info\": {\n");
		}
		spput(cs_fpo, level + 1 + m_level);
		fprintf(cs_fpo, "\"stars.version\": \"");
		fprintf(cs_fpo, chromeInfo->getStarsVersion());
		fprintf(cs_fpo, "\"");
	}

	if (chromeInfo->getStarsId() != NULL) {
		if (outMetaInfoValue) {
			fprintf(cs_fpo, ",\n");
		} else {
			outMetaInfoValue = true;
			spput(cs_fpo, level + m_level);
			fprintf(cs_fpo, "\"meta_info\": {\n");
		}
		spput(cs_fpo, level + 1 + m_level);
		fprintf(cs_fpo, "\"stars.id\": \"");
		fprintf(cs_fpo, chromeInfo->getStarsId());
		fprintf(cs_fpo, "\"");
	}

	if (chromeInfo->getStarsIsSynced() != NULL) {
		if (outMetaInfoValue) {
			fprintf(cs_fpo, ",\n");
		} else {
			outMetaInfoValue = true;
			spput(cs_fpo, level + m_level);
			fprintf(cs_fpo, "\"meta_info\": {\n");
		}
		spput(cs_fpo, level + 1 + m_level);
		fprintf(cs_fpo, "\"stars.isSynced\": \"");
		fprintf(cs_fpo, chromeInfo->getStarsIsSynced());
		fprintf(cs_fpo, "\"");
	}

	// meta_infoȈo
	if (outMetaInfoValue) {
		fprintf(cs_fpo, "\n");
		spput(cs_fpo, level + m_level);
		fprintf(cs_fpo, "},\n");
	}

}

/**
 * tH_̏o͂B
 *
 * @param item o͑Ώۂ̃tH_
 */
void ChromeWriter::putFolder(Bookmark *item)
{
	switch(item->getFolderType()) {
		case Bookmark::toolBar:
			m_ignore = false;
			if (!isFirstRoot) {
				fprintf(cs_fpo,",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo,2);
			fprintf(cs_fpo,"\"bookmark_bar\": {\n");
			spput(cs_fpo,3);
			fprintf(cs_fpo,"\"children\": [ ");

			if (m_ignore) {
				putFolderEndInfo(item);
			}

			break;
		case Bookmark::menuBar:
			m_ignore = false;
			if (!isFirstRoot) {
				fprintf(cs_fpo,",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo,2);
			// Chrome
			fprintf(cs_fpo,"\"other\": {\n");
			spput(cs_fpo,3);
			fprintf(cs_fpo,"\"children\": [ ");

			if (m_ignore) {
				putFolderEndInfo(item);
			}
			break;
		case Bookmark::mobile:
			if (!isFirstRoot) {
				fprintf(cs_fpo,",\n");
			}
			isFirstRoot = false;
			spput(cs_fpo,2);
			fprintf(cs_fpo,"\"synced\": {\n");
			spput(cs_fpo,3);
			fprintf(cs_fpo,"\"children\": [ ");

			break;
		default:
			if (m_level == 0) {
				// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂B
				m_ignore = true;
				m_ignoreSince = 0;
			} else {
				if ((putIEToolbar == false) && (item->isIEToolbar())) {
					m_ignore = true;
					m_ignoreSince = m_level;
				}
				if (!m_ignore) {
					// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂A
					// Kŵ݃JEgB
					if ((inFolder) || (m_level < 2)) {
						// tH_̍ŏ̗vfȊȌꍇ1O̗vf̋؂Ƃ,łB
						putItemPause();

						fprintf(cs_fpo,"{\n");
						spput(cs_fpo,3 + m_level);
						fprintf(cs_fpo,"\"children\": [");
					}
				}
			}
			break;
	}
	m_level++;

	// ̊Kw̗vfB
	if (m_level >= itemsCount.size()) {
		itemsCount.push_back(0);
	} else {
		itemsCount[m_level] = 0;
	}
}

/**
 * tH_ĨtH_̏o͂B
 *
 * @param item o͑Ώۂ̃tH_
 */
void ChromeWriter::putFolderEndInfo(Bookmark *item)
{
	fprintf(cs_fpo,"],\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_added\": \"");
	putChromeDateTime(cs_fpo,item->getAdddate());
	fprintf(cs_fpo,"\",\n");

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"date_modified\": \"");
	putChromeDateTime(cs_fpo,item->getModified());
	fprintf(cs_fpo,"\",\n");

	ChromeBookmark *chromeInfo = item->getChromeBookmark(m_target);
	if (chromeInfo->getID() != NULL) {
		spput(cs_fpo,3 + m_level);
		fprintf(cs_fpo,"\"id\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(chromeInfo->getID());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	}
	if (chromeInfo->getMetaInfo() != NULL) {
		spput(cs_fpo,3 + m_level);
		fprintf(cs_fpo,"\"meta_info\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(chromeInfo->getMetaInfo());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	} else {
		// Chrome 43肩meta_info
		putMetaInfo(item, chromeInfo, 3, true);
	}

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"name\": \"");
	if (item->getFolderType() == Bookmark::mobile) {
		putJSONString(cs_fpo, L"oC̃ubN}[N");
	} else {
		if (item->getIeNameW() != NULL){
			putJSONString(cs_fpo,item->getIeNameW());
		}
	}
	fprintf(cs_fpo,"\",\n");
	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"\"type\": \"folder\"\n");
	spput(cs_fpo,2 + m_level);
	fprintf(cs_fpo,"}");
}

/**
 * tH_Io͂B
 *
 * @param item o͂tH_
 */
void ChromeWriter::putFolderEnd(Bookmark *item,bool isLast)
{
	m_level--;

	// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂A
	// Kŵ݃JEgB
	if (!m_ignore) {
		if ((inFolder) || (m_level < 2)) {
			putFolderEndInfo(item);
		}
	}
	if (m_level == m_ignoreSince) {
		m_ignore = false;
	}
}

/**
 * URL̏o͂B
 *
 * @param item URLo͂ubN}[N
 */
void ChromeWriter::putURL(Bookmark *item)
{
	if (item->getURL() != NULL){
		char *p;
		wchar_t *wp;
		int escapeLen;

		p = item->getURL();
		if (strncmp("javascript:", p,11) == 0) {
			// ubN}[Nbg̏ꍇURLGR[h
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		} else if (strncmp("file:", p, 5) == 0) {
			// file:̏ꍇURLGR[hB
			escapeLen = strlen(p) * 3;
			if ((escapeLen + 1) > urlBufLen) {
				reallocUrlBuf(escapeLen);
			}
			encodeURL(urlBuf, p);
			p = urlBuf;
		}

		wp = UTF8towcFileNameInternal(p);

		putJSONString(cs_fpo,wp);
	}
}

/**
 * ubN}[N̏o͂B
 */
void ChromeWriter::putBookmark(Bookmark *item,bool isLast)
{
	if (!placesPut) {
		// Firefox 3̃X}[gubN}[NtH_炱𖳎B
		if (item->isPlaceURI()) {
			return;
		}
	}

	// ChromeɂZp[^͂Ȃ̂ŉɏݐƂB
	if (item->getSeparator()) {
		return;
	}
	if (m_ignore) {
		// ubN}[No[Ȇ̃ubN}[NȊȌꍇ͔΂B
		return;
	}
	if (m_level == 0) {
		// ŏ̊Kw(ubN}[No[Ȇ̃ubN}[NƂ)
		// ɂ̓ubN}[N͓Ȃ̂Ŕ΂B
		return;
	}

	// tH_̍ŏ̗vfȊȌꍇ1O̗vf̋؂Ƃ,łB
	putItemPause();

	fprintf(cs_fpo,"{\n");
	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"date_added\": \"");
	putChromeDateTime(cs_fpo,item->getAdddate());
	fprintf(cs_fpo,"\",\n");
	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"date_modified\": \"");
	putChromeDateTime(cs_fpo,item->getModified());
	fprintf(cs_fpo,"\",\n");

	ChromeBookmark *chromeInfo = item->getChromeBookmark(m_target);

	if (chromeInfo->getID() != NULL) {
		spput(cs_fpo,4 + m_level);
		fprintf(cs_fpo,"\"id\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(chromeInfo->getID());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	}
	if (chromeInfo->getMetaInfo() != NULL) {
		spput(cs_fpo,4 + m_level);
		fprintf(cs_fpo,"\"meta_info\": \"");
		wchar_t *wp = UTF8towcFileNameInternal(chromeInfo->getMetaInfo());
		putJSONString(cs_fpo, wp);
		fprintf(cs_fpo,"\",\n");
	} else {
		// Chrome 43肩meta_info
		putMetaInfo(item, chromeInfo, 4, false);
	}

	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"name\": \"");
	if (item->getIeNameW() != NULL){
		putJSONString(cs_fpo,item->getIeNameW());
	}
	fprintf(cs_fpo,"\",\n");

	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"type\": \"url\",\n");

	spput(cs_fpo,4 + m_level);
	fprintf(cs_fpo,"\"url\": \"");
	putURL(item);
	fprintf(cs_fpo,"\"\n");

	spput(cs_fpo,3 + m_level);
	fprintf(cs_fpo,"}");

}

/**
 * ubN}[Ñwb_o͂B
 */
void ChromeWriter::putHeader(void)
{
	fprintf(cs_fpo,"{\n");	// Top level object
	fprintf(cs_fpo,"   \"roots\": {\n");
}

/**
 * ubN}[Ñtb^o͂B
 */
void ChromeWriter::putFooter(void)
{
	fprintf(cs_fpo,"\n");
	fprintf(cs_fpo,"   },\n");
	fprintf(cs_fpo,"   \"version\": 1\n");
	fprintf(cs_fpo,"}\n");	// Top level object
}

/**
 * &HTML̕QƂɕϊȂ當o͂B
 *
 * @param fp t@C|C^
 * @param name o͂镶
 */
void ChromeWriter::putname2(FILE *fp,char *name)
{
//	debugprintf("putname2\n");
	while(*name){
		switch(*name){
			case '&':
				fprintf(fp,"&amp;");
			break;
			case '<':
				fprintf(fp,"&lt;");
			break;
			case '>':
				fprintf(fp,"&gt;");
			break;
			case '\"':
				fprintf(fp,"&quot;");
			break;
			default:
				fputc(*name,fp);
			break;
		}
		name++;
	}
}

/**
 * ėpo̓[` SJIS -> UTF8ϊt
 *
 * @param fp t@C|C^
 * @param name o͂镶
 */
void ChromeWriter::putname(FILE *fp,wchar_t *name)
{

	wchar_t *unicode;
	unsigned char *utf8;
	int utf8Count;
	
//	debugprintf("putname\n");
	if (name == NULL)
		return;
	
	unicode = name;

	// Unicode -> UTF8
	utf8Count = countUTF16LEtoUTF8str(unicode);
	utf8 = (unsigned char *)calloc(utf8Count + 1,sizeof(unsigned char));
	if (utf8 == NULL){
		return;
	}
	toUTF8(utf8,unicode);

	putname2(fp,(char *)utf8);

	free(utf8);

}

