#define ISCHROMEREADER

#include	<stdlib.h>
#include	<fstream>
#include	<iostream>
#include	<stdio.h>
#include	<string.h>
#include	<wchar.h>
#include	<direct.h>
#include	<locale.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<winreg.h>
#include	<io.h>
#include	<time.h>

// BookSyncʃwb_
#include	"BSCommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"url.h"
#include	"TJson.h"

// vbgtH[wb_
#include	"ChromeReader.h"
#include	"IbookmarkTree.h"
#include	"..\core\messages.h"

#ifdef __BORLANDC__
#define	_stricmp stricmp
#endif

// int g_verbose = 0;

/**
 *	RXgN^
 */
ChromeReader::ChromeReader()
{
	noIEfavorites = 0;	// C|[gIÊCɓ΂Ȃ
	isSilentMode = 1;
	topValue = NULL;
	level = 0;
	ignoreToolbar = false;

	urlBuf = NULL;
	writer = NULL;

	try {
		urlBuf = new char[BUFLEN];
	} catch (...) {
	}
	urlBufLen = BUFLEN;

	try {
		valueBuf = new char[BUFLEN];
		if (valueBuf == NULL) {
			delete []urlBuf;
		}
		valuePtr = valueBuf;
	} catch (...) {
		if (valueBuf == NULL) {
			delete []urlBuf;
		}
	}

	// ꎞobt@mۂB
	work = NULL;
	try{
		work = new char[BUFLEN];
		if (work == NULL){
			delete []urlBuf;
			delete []valueBuf;
			return;
		}
	}catch(...){
		delete []urlBuf;
		delete []valueBuf;
		return;
	}

}

ChromeReader::~ChromeReader()
{
	if (urlBuf != NULL) {
		delete []urlBuf;
	}

	if (valueBuf != NULL) {
		delete []valueBuf;
	}

	if (work != NULL) {
		delete []work;
	}

}

/**
 * URLϊpobt@̍Ċm
 *
 * @param size mۂTCY
 * @return -1:mێs > -1 : mۂTCY
 */
int ChromeReader::reallocUrlBuf(int size)
{
	delete []urlBuf;
	try {
		urlBuf = NULL;
		urlBuf = new char[size];
		if (urlBuf == NULL) {
			logger->debug("No enough memory");
			return -1;
		}
		urlBufLen = size;
	} catch (...) {
		logger->debug("No enough memory");
		return -1;
	}
	return size;
}


/**
 * bookmarkoB
 *
 * @param type ACe̎
 * @return 0  1 G[
 */
int ChromeReader::flushItem(ChromeReader::ItemType type)
{
	int result = 0;

	switch (type){
		case ChromeReader::BOOKMARK:	// Bookmark
			result = writer->storeItem(&bookmark);
		break;
		case ChromeReader::FOLDER:	// Folder
			result = writer->storeItem(&bookmark);
		break;
	}

	return result;
}

/**
 * ubN}[NEtH_ݒ肷B
 *
 * @param item ubN}[NEtH_
 */
int ChromeReader::setName(char *item)
{
	if (item == NULL) {
		logger->debug("Bookmark/Folder name is NULL.");
		return 1;
	}

	// ubN}[N
	bookmark.setName(item);

	// O̐ݒ(}`oCg)
	char *p;
	p = UTF8tombFileNameInternal(item);

	// if (g_verbose) {
	//	std::cout << work << "\n" << std::flush;
	//}
	bookmark.setIeName(p);

	// O̐ݒ(Unicode)
	wchar_t *wp;
	wp = UTF8towcFileNameInternal(item);

	bookmark.setIeNameW(wp);

	return 0;
}

/*****************************
  ubN}[Nt@C͕
*****************************/

/* evfʂ̉߃W[ */


/**
 * ACẻ
 *
 * @param roots [gxIuWFNg("roots")
 * @return 0:́Eϊ 1:͎s
 */
int ChromeReader::parseItem(TJsonValue *item)
{
	int result = 0;
	bookmark.reset();
	bookmark.getChromeBookmark(m_bookmarkNo)->reset();

	// IuWFNg̒g킷typeɊmFB
	TJsonValue *type = item->getObjectValue("type");
	if (type == NULL) {
		// type݂Ȃꍇ͕stH[}bgG[
		logger->debug("type not found");
		return 1;
	} else {
		if (type->getType() != TJsonValue::VALUE) {
			// typelłȂꍇ͕stH[}bgG[
			logger->debug("type is not value");
			return 1;
		} else if (type->getValue() == NULL) {
			// typeɒlĂȂꍇstH[}bgG[
			logger->debug("Value is not in value");
			return 1;
		}
	}

	TJsonValue *name = item->getObjectValue("name");
	if (name != NULL) {
		if (name->getType() == TJsonValue::VALUE) {
			// name̒l
			setName(name->getValue());
		}
	}

	TJsonValue *date_added = item->getObjectValue("date_added");
	if (date_added != NULL) {
		if (date_added->getType() == TJsonValue::VALUE) {
			// date_added̒l
			if (date_added->getValue() != NULL) {
				logger->debug("date_added");
				logger->debug(date_added->getValue());
				bookmark.setAdddate(chTimeToTimet(date_added->getValue()));
			}
		}
	}

	TJsonValue *date_modified = item->getObjectValue("date_modified");
	if (date_modified != NULL) {
		if (date_modified->getType() == TJsonValue::VALUE) {
			// date_modified̒l
			if (date_modified->getValue() != NULL) {
				logger->debug("date_modified");
				logger->debug(date_modified->getValue());
				bookmark.setModified(chTimeToTimet(date_modified->getValue()));
			}
		}
	}

	TJsonValue *id = item->getObjectValue("id");
	if (id != NULL) {
		if (id->getType() == TJsonValue::VALUE) {
			// id̒l
			if (id->getValue() != NULL) {
				logger->debug("id");
				logger->debug(id->getValue());
				bookmark.getChromeBookmark(m_bookmarkNo)->setID(id->getValue());
			}
		}
	}

	TJsonValue *metaInfo = item->getObjectValue("meta_info");
	if (metaInfo != NULL) {
		if (metaInfo->getType() == TJsonValue::VALUE) {
			// meta_info̒l
			if (metaInfo->getValue() != NULL) {
				logger->debug("meta_info");
				logger->debug(metaInfo->getValue());
				bookmark.getChromeBookmark(m_bookmarkNo)->setMetaInfo(metaInfo->getValue());
			}
		} else if (metaInfo->getType() == TJsonValue::OBJECT) {
			// stars.description tH_̃RgB
			TJsonValue *description = metaInfo->getObjectValue(STARS_DESCRIPTION);
			if (description != NULL) {
				if (description->getValue() != NULL) {
					logger->debug(STARS_NOTE);
					logger->debug(description->getValue());
					bookmark.setDescription(description->getValue());
				}
			}
			// stars.note ̓ubN}[NɕtȊÖႢ͂̂H
			// ubN}[NƃtH_̈ႢŃRgʗvfɂēˁH
			TJsonValue *note = metaInfo->getObjectValue(STARS_NOTE);
			if (note != NULL) {
				if (note->getValue() != NULL) {
					logger->debug(STARS_NOTE);
					logger->debug(note->getValue());
					if (bookmark.getDescription() == NULL) {
						bookmark.setDescription(note->getValue());
					}
				}
			}
			TJsonValue *starVersion = metaInfo->getObjectValue(STARS_VERSION);
			if (starVersion != NULL) {
				if (starVersion->getValue() != NULL) {
					logger->debug(STARS_VERSION);
					logger->debug(starVersion->getValue());
					bookmark.getChromeBookmark(m_bookmarkNo)->setStarsVersion(starVersion->getValue());
				}
			}
			TJsonValue *starId = metaInfo->getObjectValue(STARS_ID);
			if (starId != NULL) {
				if (starId->getValue() != NULL) {
					logger->debug(STARS_VERSION);
					logger->debug(starId->getValue());
					bookmark.getChromeBookmark(m_bookmarkNo)->setStarsId(starId->getValue());
				}
			}
			TJsonValue *starsIsSynced = metaInfo->getObjectValue(STARS_IS_SYNCED);
			if (starsIsSynced != NULL) {
				if (starsIsSynced->getValue() != NULL) {
					logger->debug(STARS_VERSION);
					logger->debug(starsIsSynced->getValue());
					bookmark.getChromeBookmark(m_bookmarkNo)->setStarsIsSynced(starsIsSynced->getValue());
				}
			}
		}
	}


	// type̒lŃubN}[NƃtH_𔻕ʂAŗL̏ǂݍށB
	char *typeValue = type->getValue();
	if (!strcmp(typeValue,"url")) {
		TJsonValue *url = item->getObjectValue("url");
		if (url != NULL) {
			if (url->getType() == TJsonValue::VALUE) {
				// url̒l
				if (url->getValue() != NULL) {
					char *p = url->getValue();
					if (strncmp("javascript:", p,11) == 0) {
						// JavaScript(ubN}[Nbg)URLGR[hĂ̂
						// Ŏg߃fR[h
						p = decodeAndRealloc(p);
						if (p == NULL) {
							logger->debug("javascript: URL decode error");
							return 1;
						}
					} else if (strncmp("file:", p, 5) == 0) {
						// file([Jt@C)URLGR[hĂ̂
						// Ŏg߃fR[h
						p = decodeAndRealloc(p);
						if (p == NULL) {
							logger->debug("file: URL decode error");
							return 1;
						}
					}
					bookmark.setURL(p);
				}
			}
		}
		// ubN}[NoB
		bookmark.setItemType(Bookmark::bookmark);
		flushItem(ChromeReader::BOOKMARK);
		bookmark.reset();
	} else if (!strcmp(typeValue,"folder")) {
		// type:folderƑgƂȂchildrenz(tH_)̑݃`FbNsB
		TJsonValue *children = item->getObjectValue("children");
		if (children == NULL) {
			// childrenIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Folder's children not found");
			return 1;
		}else{
			if (children->getType() != TJsonValue::ARRAY) {
				// childrenzłȂꍇ͕stH[}bgG[
				logger->debug("Folder's children is not array");
				return 1;
			} else {
				// tH_oB
				bookmark.setItemType(Bookmark::folder);
				bookmark.setFolderType(Bookmark::normalFolder);

				flushItem(ChromeReader::FOLDER);
				bookmark.reset();

				// childrenIuWFNg̉͂ɓ
				result = parseFolder(children);
			}
		}
	} else {
		// tH_AubN}[NȊÔ͍Ƃ둶݂Ȃ̂ŃG[
		logger->debug("Unknown item type");
		return 1;
	}
	return result;
}

/**
 * URLGR[h̃fR[hƍĊmۂsB
 *
 * @param p fR[hsURL
 * @return NULL:fR[h NULL:fR[hs
 */
char *ChromeReader::decodeAndRealloc(char *p)
{
	int count = decodeURL(NULL, p);
	if ((count + 1) > urlBufLen) {
		int result = reallocUrlBuf(count + 2);
		if (result == -1) {
			return NULL;
		}
	}
	decodeURL(urlBuf, p);
	return urlBuf;
}

/**
 * tH_̉
 *
 * @param folderArray tH_̔z
 * @return 0:́Eϊ 1:͎s
 */
int ChromeReader::parseFolder(TJsonValue *folderArray)
{
	int result = 0;
	unsigned int count = folderArray->getArrayCount();

	level++;
	for (unsigned int i = 0;i < count;i++) {
		// 
		TJsonValue *item = folderArray->getArrayValue(i);
		if (item == NULL) {
			// itemIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Folder's item not found");
			return 1;
		}else{
			if (item->getType() != TJsonValue::OBJECT) {
				// itemIuWFNgłȂꍇ͕stH[}bgG[
				logger->debug("Folder's item is not object");
				return 1;
			} else {
				// itemIuWFNg̉͂ɓ
				result = parseItem(item);
			}
		}
	}
	// KwЂƂオB
	writer->upFolder();
	level--;
	return result;	
}

/**
 * ubN}[No[Ȃ̃ubN}[Ñgbv̉
 *
 * @param topObject ubN}[No[Ȇ̃ubN}[ÑIuWFNg
 * @return 0:́Eϊ 1:͎s
 */
int ChromeReader::parseBar(TJsonValue *topObject)
{
	int result = 0;	// ͌

	// ԍŏ̔z(tH_)̑݃`FbNsB
	TJsonValue *children = topObject->getObjectValue("children");
	if (children == NULL) {
		// childrenIuWFNg݂Ȃꍇ͕stH[}bgG[
		logger->debug("Bookmark bar folder's item not found");
		return 1;
	}else{
		if (children->getType() != TJsonValue::ARRAY) {
			// childrenIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("Bookmark bar folder is not array");
			return 1;
		} else {
			// childrenIuWFNg̉͂ɓ
			result = parseFolder(children);
		}
	}
	return result;
}


/**
 * ubN}[No[Ȃ̃ubN}[N
 *
 * @param roots [gxIuWFNg("roots")
 * @return 0:́Eϊ 1:͎s
 */
int ChromeReader::parseToplevel(TJsonValue *roots)
{
	int result = 0;	// ͌

	if (ignoreToolbar == false) {
		// bookmark_bar(ubN}[No[)
		TJsonValue *bookmark_bar = roots->getObjectValue("bookmark_bar");
		if (bookmark_bar == NULL) {
			// bookmark_barIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("Bookmark bar not found");
			return 1;
		}else{
			if (bookmark_bar->getType() != TJsonValue::OBJECT) {
				// bookmark_barIuWFNgłȂꍇ͕stH[}bgG[
				logger->debug("Bookmark bar is not boject");
				return 1;
			} else {
				bookmark.reset();
				level = 0;

				bookmark.setItemType(Bookmark::folder);

				bookmark.setFolderType(Bookmark::toolBar);
				char *p;
				p = wctoUTF8Internal(L"ubN}[N o[");
				if (p != NULL) {
					bookmark.setName(p);
				}
				bookmark.setIeName("ubN}[N o[");
				bookmark.setIeNameW(L"ubN}[N o[");

				flushItem(ChromeReader::FOLDER);
				// bookmark_barIuWFNg̉͂ɓ
				result = parseBar(bookmark_bar);
			}
		}
		if (result) {
			// ͎s炻̎_Ŕ
			return result;
		}
	}

	// other(̑̃ubN}[Nj[)
	TJsonValue *other = roots->getObjectValue("other");
	if (other == NULL) {
		// otherIuWFNg݂Ȃꍇ͕stH[}bgG[
		logger->debug("Other bookmark not found");
		return 1;
	}else{
		if (other->getType() != TJsonValue::OBJECT) {
			// otherIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("Other bookmark is not object");
			return 1;
		} else {
			bookmark.reset();
			level = 0;

			bookmark.setItemType(Bookmark::folder);

			bookmark.setFolderType(Bookmark::menuBar);
			char *p;
			p = wctoUTF8Internal(L"̑̃ubN}[N");
			if (p != NULL) {
				bookmark.setName(p);
			}
			bookmark.setIeName("̑̃ubN}[N");
			bookmark.setIeNameW(L"̑̃ubN}[N");
			flushItem(ChromeReader::FOLDER);
				
			// otherIuWFNg̉͂ɓ
			result = parseBar(other);
		}
	}

	// oC̃ubN}[N
	TJsonValue *synced = roots->getObjectValue("synced");
	if (synced != NULL) {
		if (synced->getType() != TJsonValue::OBJECT) {
			// syncedIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("synced bookmark is not object");
			return 1;
		} else {
			bookmark.reset();
			level = 0;

			bookmark.setItemType(Bookmark::folder);
			bookmark.setFolderType(Bookmark::mobile);
			char *p;
			p = wctoUTF8Internal(L"oC̃ubN}[N");
			if (p != NULL) {
				bookmark.setName(p);
			}
			bookmark.setIeName("oC̃ubN}[N");
			bookmark.setIeNameW(L"oC̃ubN}[N");
			flushItem(ChromeReader::FOLDER);
				
			// syncedIuWFNg̉͂ɓ
			result = parseBar(synced);
		}
	}

	return result;
}

/**
 * ubN}[N͊Jn
 *
 * @return 0:́Eϊ 1:͎s
 */
int ChromeReader::parseStart(void)
{
	int result = 0;	// ͌

	if (topValue->getType() != TJsonValue::OBJECT) {
		// gbvIuWFNg̓IuWFNgłKvB
		logger->debug("Top level object is not object");
		return 1;
	} else {
#if 0
		// ubN}[Ño[W`FbNȂ̂A
		// 2009/03/01iKł͂܂PȂ̂ŏ璷Ȃ̂ŏsȂB
		TJsonValue *ver = topValue->getObjectValue("version");
		if (ver == NULL) {
			// versionȂꍇ͕sȃtH[}bgȂ̂ŃG[
			return 1;
		}else{
			if (ver->getType() != TJsonValue::VALUE) {
				// lłȂꍇ͕sȃtH[}bgȂ̂ŃG[
				return 1;
			} else {
				char *value = ver->getValue();
				if (value == NULL) {
					// version̒lǂ߂ĂȂ̂ŃG[
					return 1;
				} else {
					// version̒lɂďςKvꍇ
					// Ńo[W`FbN
				}
			}
		}
#endif

		TJsonValue *roots = topValue->getObjectValue("roots");
		if (roots == NULL) {
			// rootsIuWFNg݂Ȃꍇ͕stH[}bgG[
			logger->debug("roots object not found");
			return 1;
		}else{
			if (roots->getType() != TJsonValue::OBJECT) {
				// rootsIuWFNgłȂꍇ͕stH[}bgG[
			logger->debug("roots object is not object");
				return 1;
			} else {
				// rootsIuWFNg̉͂ɓ
				result = parseToplevel(roots);
			}
		}

	}
	return result;
}

/**
 * ubN}[Nǂݍݕ
 *
 * @param bmFile ubN}[Nt@C
 * @param fvDir uCɓvfBNg
 *
 * @return 0:ǂݍ݁ERo[g 1:ǂݍ݁ERo[gs
 */
int ChromeReader::readFile(const char *bmFile,const char *fvDir)
{
	int ret = 0;	// s
	TJson *reader = NULL;
	try {
		reader = new TJson();
		if (reader == NULL) {
			return 1;
		}
	} catch(...) {
		return 1;
	}
	ret = reader->readFile(bmFile);
	if (ret) {
		// sƂƂƔ
		logger->debug("JSON read error");
		delete reader;
		return 1;
	}
	topValue = reader->getTopValue();
	// ǂݍJSON̉͂JnB
	ret = parseStart();

	delete reader;

	return ret;
}

/**
 * ͂JnBmۂB
 *
 * @param bmFile ubN}[Nt@C
 * @param fvDir gp
 * @return 0: 0:s
 */
int ChromeReader::readBookmark(const char *bmFile,const char *fvDir)
{
	int ret;

	ret = readFile(bmFile,fvDir);

	return ret;
}

