#ifndef CHROMEBOOKMARK_H
#define CHROMEBOOKMARK_H

// Wwb_
#include	<stdio.h>
#include	"bslib.h"

#define STARS_DESCRIPTION "stars.description"
#define STARS_NOTE "stars.note"
#define STARS_VERSION "stars.version"
#define STARS_ID "stars.id"
#define STARS_IS_SYNCED "stars.isSynced"

class ChromeBookmark {
private:
	char *m_id;	// ID
	char *m_metaInfo;	// meta_info
	char *m_starsVersion;
	char *m_starsId;
	char *m_starsIsSynced;

	void _init(void);
	void _reset(void);

protected:
	void _copy(const ChromeBookmark &src);
	void copy(const ChromeBookmark &src);

public:
	/* EʁEj */
	ChromeBookmark(void);
	ChromeBookmark(const ChromeBookmark &src);
	virtual ~ChromeBookmark();

	ChromeBookmark & operator = (const ChromeBookmark &src);
	void copyWithoutId(ChromeBookmark *src);
	int copyBookmarkIdentifier(ChromeBookmark *src);

	void reset(void);

	char *getID(void) const { return m_id; };
	char *setID(const char *item);

	char *getMetaInfo(void) const { return m_metaInfo; };
	char *setMetaInfo(const char *item);

	char *getStarsVersion(void) const { return m_starsVersion; };
	char *setStarsVersion(const char *item)
	{
		return reAllocate(m_starsVersion, item);
	}

	char *getStarsId(void) const { return m_starsId; };
	char *setStarsId(const char *item)
	{
		return reAllocate(m_starsId, item);
	}

	char *getStarsIsSynced(void) const { return m_starsIsSynced; };
	char *setStarsIsSynced(const char *item)
	{
		return reAllocate(m_starsIsSynced, item);
	}

};

#endif	// CHROMEBOOKMARK_H
