#include	<stdlib.h>
#include	<new>
#include	<memory>

#include	<stdio.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"encutil2.h"
#include	"Bookmark.h"
#include	"ChromeBookmark.h"

#ifdef _DEBUG
#define debugprintf //printf
#else
#define debugprintf
#endif

/**
 * RXgN^
 */
ChromeBookmark::ChromeBookmark()
{
	_init();
}

/**
 * Rs[RXgN^
 *
 * @param src Rs[̃IuWFNg
 */
ChromeBookmark::ChromeBookmark(const ChromeBookmark &src)
{
	_init();
	_copy(src);
}

/**
 * fXgN^
 */
ChromeBookmark::~ChromeBookmark()
{
	_reset();
}

/**
 *	CX^X̓eɏlB<br>
 *	RXgN^p
 *
 */
void ChromeBookmark::_init(void)
{
	m_id = NULL;
	m_metaInfo = NULL;
	m_starsVersion = NULL;
	m_starsId = NULL;
	m_starsIsSynced = NULL;
}

/**
 * CX^X̓eĐݒ肷B(Jt)
 */
void ChromeBookmark::_reset(void)
{
	if (m_id != NULL) {
		delete[]m_id;
		m_id = NULL;
	}
	if (m_metaInfo != NULL) {
		delete []m_metaInfo;
		m_metaInfo = NULL;
	}
	if (m_starsVersion != NULL) {
		delete[]m_starsVersion;
	}
	if (m_starsId != NULL) {
		delete[]m_starsId;
	}
	if (m_starsIsSynced != NULL) {
		delete[]m_starsIsSynced;
	}
	_init();
}

/**
 * CX^X̃Rs[
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
void ChromeBookmark::_copy(const ChromeBookmark &src)
{
	setMetaInfo(src.getMetaInfo());
	setStarsVersion(src.getStarsVersion());
}

/**
 * CX^XŜ̓eB
 */
void ChromeBookmark::reset(void)
{
	_reset();
}

/**
 * CX^X̃Rs[
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 */
void ChromeBookmark::copy(const ChromeBookmark &src)
{
	_copy(src);
}

/**
 * =ZqɂCX^X̃Rs[
 *
 * @param src ʌBookmarkNX̃CX^X̎Q
 * @return g̎Q
 */
ChromeBookmark & ChromeBookmark::operator = (const ChromeBookmark &src)
{
	reset();
	copy(src);
	setID(src.getID());
	setStarsId(src.getStarsId());
	setStarsIsSynced(src.getStarsIsSynced());

	return *this;
}

/**
 * ubN}[NRs[(ubN}[Nʗp)
 *
 * @param src ʌBookmarkNX̃CX^Xւ̃|C^
 * @return 0Œ
 */
void ChromeBookmark::copyWithoutId(ChromeBookmark *src)
{
	_copy(*src);
}

/**
* ubN}[N̎ʏRs[
*
* @param src ʌBookmarkNX̃CX^Xւ̃|C^
* @return 0Œ
*/
int ChromeBookmark::copyBookmarkIdentifier(ChromeBookmark *src)
{
	if (src->getID() != NULL) {
		setID(src->getID());
	}
	if (src->getStarsId() != NULL) {
		setStarsId(src->getStarsId());
	}
	if (src->getStarsIsSynced() != NULL) {
		setStarsIsSynced(src->getStarsIsSynced());
	}

	return 0;
}


/**
 * IDݒ肷B
 *
 * @param item ݒ肷ID
 * @return ݒ肵IDւ̃|C^
 */
char *ChromeBookmark::setID(const char *item)
{
	char *p;
	int len;
	
	if (m_id != NULL){
		delete []m_id;
		m_id = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_id = p;
	}catch(...){
		return NULL;
	}
	return p;
}

/**
 * meta_infoݒ肷B
 *
 * @param item ݒ肷meta_info
 * @return ݒ肵meta_infoւ̃|C^
 */
char *ChromeBookmark::setMetaInfo(const char *item)
{
	char *p;
	int len;
	
	if (m_metaInfo != NULL){
		delete []m_metaInfo;
		m_metaInfo = NULL;
	}

	if (item == NULL){
		return NULL;
	}

	len = strlen(item) + 1;
	
	try{
		p = new char[len];
		if (p == NULL){
			return NULL;
		}
		strcpy(p,item);
		m_metaInfo = p;
	}catch(...){
		return NULL;
	}
	return p;
}

