#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<mbstring.h>

#include	"BScommon.h"
#include	"bslib.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NTfunction.h"

#include	"AttributeWriter.h"

/**
 * OperãubN}[NŗL̏̂Â̂ϊB
 *
 * @param target ΏۂƂȂubN}[N
 */
void AttributeWriter::convertOperaAttribute(Bookmark *target)
{
	MozillaBookmark *mozTo;
	OperaBookmark *opeFrom,*opeTo;
	FxBookmark *fxTo;

	opeFrom = target->getOperaBookmark(browserNo);
	opeTo = target->getOperaBookmark(1 - browserNo);
	*opeTo = *opeFrom;

	// -> Mozilla
	for (int i = 0;i < 2;i++) {
		mozTo = target->getMozillaBookmark(i);
		mozTo->setWebPanel(opeFrom->getInPanel());
	}

	// -> Firefox 3
	for (int i = 0;i < 2;i++) {
		fxTo = target->getFxBookmark(i);
		fxTo->setWebPanel(opeFrom->getInPanel());
	}
}

/**
 * MozillãubN}[NŗL̏̂Â̂ϊB
 *
 * @param target ΏۂƂȂubN}[N
 */
void AttributeWriter::convertMozillaAttribute(Bookmark *target)
{
	MozillaBookmark *mozFrom,*mozTo;
	OperaBookmark *opeTo;
	FxBookmark *fxTo;

	mozFrom = target->getMozillaBookmark(browserNo);
	mozTo = target->getMozillaBookmark(1 - browserNo);
	*mozTo = *mozFrom;

	// -> Opera
	for (int i = 0;i < 2;i++) {
		opeTo = target->getOperaBookmark(i);
		opeTo->setInPanel(mozFrom->getWebPanel());
		if (mozFrom->getWebPanel()) {
			// pl̈ʒȕ
			opeTo->setPanelPos(-1);
		}
	}

	// -> Firefox 3
	for (int i = 0;i < 2;i++) {
		fxTo = target->getFxBookmark(i);
		fxTo->setWebPanel(mozFrom->getWebPanel());
		fxTo->setCharset(mozFrom->getCharset());
		// fxTo->setCheck(mozFrom->getCheck());

		// Live Bookmark
		fxTo->setFeedUrl(mozFrom->getFeedUrl());

		// Micro Summary
		fxTo->setGeneratedTitle(mozFrom->getGeneratedTitle());
		fxTo->setMicsum_expiration(mozFrom->getMicsum_expiration());
		fxTo->setMicsum_gen_uri(mozFrom->getMicsum_gen_uri());
	}
}

/**
 * Firefox 3̃ubN}[NŗL̏̂Â̂ϊB
 *
 * @param target ΏۂƂȂubN}[N
 */
void AttributeWriter::convertFxAttribute(Bookmark *target)
{
	MozillaBookmark *mozTo;
	OperaBookmark *opeTo;
	FxBookmark *fxFrom,*fxTo;

	fxFrom = target->getFxBookmark(browserNo);
	fxTo = target->getFxBookmark(1 - browserNo);
	*fxTo = *fxFrom;

	// -> Opera
	for (int i = 0;i < 2;i++) {
		opeTo = target->getOperaBookmark(i);
		opeTo->setInPanel(fxFrom->getWebPanel());
		if (fxFrom->getWebPanel()) {
			// pl̈ʒȕ
			opeTo->setPanelPos(-1);
		}
	}

	// -> Mozilla
	for (int i = 0;i < 2;i++) {
		mozTo = target->getMozillaBookmark(i);
		mozTo->setWebPanel(fxFrom->getWebPanel());
		mozTo->setCharset(fxFrom->getCharset());
		// fxTo->setCheck(mozFrom->getCheck());

		// Live Bookmark
		mozTo->setFeedUrl(fxFrom->getFeedUrl());

		// Micro Summary
		mozTo->setGeneratedTitle(fxFrom->getGeneratedTitle());
		mozTo->setMicsum_expiration(fxFrom->getMicsum_expiration());
		mozTo->setMicsum_gen_uri(fxFrom->getMicsum_gen_uri());
	}
}

/**
 * uEUŗL̏̂Â̂ϊB
 *
 * @param target ΏۂƂȂubN}[N
 */
void AttributeWriter::convertBrowserAttribute(Bookmark *target)
{
	switch (browserType){
		case 0:	// IE
			break;
		case 1:	// Mozilla
			convertMozillaAttribute(target);
			break;
		case 2:	// Opera
			convertOperaAttribute(target);
			break;
		case 3:	// Firefox 3
			convertFxAttribute(target);
			break;
	}
}


void AttributeWriter::putHeader(void)
{
}

void AttributeWriter::putFolder(Bookmark *item)
{
	convertBrowserAttribute(item);
}

void AttributeWriter::putFolderEnd(Bookmark *item,bool isLast)
{
}

void AttributeWriter::putBookmark(Bookmark *item,bool isLast)
{
	convertBrowserAttribute(item);
}

void AttributeWriter::putFooter(void)
{
}

