#ifndef	UTIL_H
#define UTIL_H

#include <Windows.h>
#include "BookSyncApp.h"

#include "FxForm.h"
#include "OperaForm.h"
#include "IEForm.h"
#ifdef WITH_EDGE
#include "EdgeForm.h"
#endif	// WITH_EDGE
#include "SfForm.h"
#include "ChForm.h"
#include "MozForm.h"
#include "XbForm.h"
#ifdef WITH_OP15
#include "Op15Form.h"
#endif	// WITH_OP15
#include "Op19Form.h"
#include "ViForm.h"
#include "Edge2Form.h"

#include "Configuration.h"
#include "tstring.h"

// MozillañEChENX
#define MOZCLASS _T("MozillaWindowClass")
#define SEAMONKEYCLASS _T("MozillaUIWindowClass")

// ChromeñEChENX
#define CHROMECLASS _T("Chrome_XPFrame")
#define CHROMEVISTACLASS _T("Chrome_VistaFrame")
#define CHROME2CLASS _T("Chrome_WidgetWin_0")
#define CHROME59CLASS _T("Chrome_WidgetWin_1")

// euEU̎st@C
#define MOZILLA_FILENAME _T("mozilla")
#define FIREFOX_FILENAME _T("firefox")
#define NETSCAPE9_FILENAME _T("navigator")
#define NETSCAPE8_FILENAME _T("netscape")
#define NETSCAPE7_FILENAME _T("Netscp")
#define NETSCAPE6_FILENAME _T("netscp6")
#define PHOENIX_FILENAME _T("phoenix")
#define MOZILLAFIREBIRD_FILENAME _T("MozillaFirebird")
#define SEAMONKEY_FILENAME _T("seamonkey")
#define WATERFOX_FILENAME _T("waterfox")

#define CHROME_FILENAME _T("chrome")
#define CHROMIUM_FILENAME _T("chromium")
#define IRON_FILENAME _T("iron")
#define DRAGON_FILENAME _T("dragon")
#define VIVALDI_FILENAME _T("vivaldi")
#define EDGE2_FILENAME _T("msedge")

#define OPERA_FILENAME _T("opera")

#define IE7_LINK_NAME "Links"		// IE7̃No[tH_(p)
#define IE7_LINK_NAME_W L"Links"		// IE7̃No[tH_(p)
#define IE7_LINK_NAME_JP "N"	// IE7̃No[tH_({)
#define IE7_LINK_NAME_JP_W L"N"	// IE7̃No[tH_({)

BOOL CALLBACK checkMozillaWindow(HWND hwnd,LPARAM lparam);
BOOL CALLBACK checkChromeWindow(HWND hwnd,LPARAM lparam);
BOOL CALLBACK checkOperaWindow(HWND hwnd,LPARAM lparam);
BOOL CALLBACK checkVivaldiWindow(HWND hwnd, LPARAM lparam);
BOOL CALLBACK checkEdge2Window(HWND hwnd, LPARAM lparam);

void setupAutoComplete();
void cleanupAutoComplete();
void setAutoComplete(HWND hWnd);


void mozFormToConfig(Configuration *config,CMozForm *mozForm);
void operaFormToConfig(Configuration *config,COperaForm *operaForm);
void ieFormToConfig(Configuration *config,CIEForm *ieForm);
#ifdef WITH_EDGE
void edgeFormToConfig(Configuration *config, CEdgeForm *edgeForm);
#endif	// WITH_EDGE
void fxFormToConfig(Configuration *config, CFxForm *fxForm);
void sfFormToConfig(Configuration *config,CSfForm *sfForm);
void chFormToConfig(Configuration *config,CChForm *chForm);
void xbFormToConfig(Configuration *config,CXbForm *xbForm);
#ifdef WITH_OP15
void op15FormToConfig(Configuration *config,COp15Form *op15Form);
#endif	// WITH_OP15
void op19FormToConfig(Configuration *config,COp19Form *op19Form);
void viFormToConfig(Configuration *config, CViForm *viForm);
void edge2FormToConfig(Configuration *config, CEdge2Form *edge2Form);

tstring setBasePath(tstring bookmark);
bool isExistingFile(const TCHAR *filename);
void adjustCenter(RECT parentRect, HWND parentHWnd, HWND myHWnd);

extern int MozillaFoundFlag;
extern int ChromeFoundFlag;
extern int OperaFoundFlag;
extern int VivaldiFoundFlag;
extern int Edge2FoundFlag;


#endif	// UTIL_H
