#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "stdafx.h"

#include <tlhelp32.h>
#include <shlobj.h>
#include <tchar.h>

#include "Resource.h"
#include "util.h"

int MozillaFoundFlag;
int ChromeFoundFlag;
int OperaFoundFlag;
int VivaldiFoundFlag;
int Edge2FoundFlag;

// vZXIDvZX̃t@C擾B
BOOL getProcessFilename(DWORD pid,TCHAR *fullPath)
{
	// OS̎(9x/NT)ɂďς邽OS̃o[W擾B
	OSVERSIONINFO  osver ;

	osver.dwOSVersionInfoSize = sizeof( osver ) ;
	if( !GetVersionEx( &osver ) ){
		return FALSE;
	}

	if( osver.dwPlatformId == VER_PLATFORM_WIN32_NT ){
		// Windows NT ̏ꍇ:
		HMODULE hInstLib = LoadLibrary(_T("psapi.dll"));

		BOOL (WINAPI *lpEnumProcessModules)(HANDLE,HMODULE *,DWORD,LPDWORD);
		DWORD (WINAPI *lpGetModuleFileNameEx)(HANDLE,HMODULE,LPTSTR,DWORD);

		lpEnumProcessModules = (BOOL (WINAPI *)(HANDLE,HMODULE *,DWORD,LPDWORD))
			GetProcAddress( hInstLib,"EnumProcessModules");
		lpGetModuleFileNameEx = (DWORD (WINAPI *)(HANDLE,HMODULE,LPTSTR,DWORD))
			GetProcAddress( hInstLib,"GetModuleFileNameExA");

		// vZXI[vB
		HANDLE hProcess = OpenProcess(PROCESS_ALL_ACCESS,TRUE,pid);
		if (hProcess == NULL){
			FreeLibrary(hInstLib);
			return FALSE;
		}

		// vZX̃W[nh擾B
		HMODULE hModule;
		DWORD requireSize;
		BOOL result = lpEnumProcessModules(hProcess,&hModule,1 * sizeof(HMODULE),&requireSize);
		if (!result){
			CloseHandle(hProcess);
			FreeLibrary(hInstLib);
			return FALSE;
		}

		// vZXƃW[̃nhtpX擾B
		int pathLen = lpGetModuleFileNameEx(hProcess,hModule,fullPath,_MAX_PATH);
		if (pathLen == 0) {
			CloseHandle(hProcess);
			FreeLibrary(hInstLib);
			return FALSE;
		}

		// nȟnsB
		CloseHandle(hProcess);
		FreeLibrary(hInstLib);


	}else{
		// Windows 95/98/Mep̃vZX擾
		HMODULE hInstLib = LoadLibrary(_T("kernel32.dll"));

		HANDLE (WINAPI *pCreateToolhelp32Snapshot)(DWORD,DWORD);
		BOOL (WINAPI *lpfProcess32First)(HANDLE,LPPROCESSENTRY32);
		BOOL (WINAPI *lpfProcess32Next)(HANDLE,LPPROCESSENTRY32);

		pCreateToolhelp32Snapshot = (HANDLE(WINAPI *)(DWORD,DWORD))
			GetProcAddress( hInstLib,
			"CreateToolhelp32Snapshot" ) ;
		lpfProcess32First=
			(BOOL(WINAPI *)(HANDLE,LPPROCESSENTRY32))
			GetProcAddress( hInstLib, "Process32First" ) ;
		lpfProcess32Next=
			(BOOL(WINAPI *)(HANDLE,LPPROCESSENTRY32))
			GetProcAddress( hInstLib, "Process32Next" ) ;

		// vZX̃XibvVbg擾B
		HANDLE hSnapShot = pCreateToolhelp32Snapshot(
			TH32CS_SNAPPROCESS | TH32CS_SNAPMODULE, pid ) ;
		if( hSnapShot == INVALID_HANDLE_VALUE )	{
			FreeLibrary( hInstLib ) ;
			return FALSE;
		}

		// ŏ̃vZX̏擾܂B
		PROCESSENTRY32 procentry;
		procentry.dwSize = sizeof(PROCESSENTRY32) ;
		BOOL bFlag = lpfProcess32First( hSnapShot, &procentry ) ;

		if( bFlag == FALSE ){
			CloseHandle(hSnapShot);
			FreeLibrary( hInstLib ) ;
			return FALSE;
		}

		// EChE쐬vZX̃vZXIDo܂ŃvZX擾B
		while(procentry.th32ProcessID != pid){
			bFlag = lpfProcess32Next( hSnapShot, &procentry ) ;

			if( bFlag == FALSE ){
				CloseHandle(hSnapShot);
				FreeLibrary( hInstLib ) ;
				break;
			}
		}

		// vZXRs[B
		_tcscpy(fullPath,procentry.szExeFile);

		// nȟn
		CloseHandle(hSnapShot);
		FreeLibrary( hInstLib ) ;

	}
	return TRUE;

}

/**
 * eEChEMozillanuEÛ̂`FbNsR[obN
 *
 * @param hwnd EChEnh
 * @param lparam \
 * @return TRUE:񋓂𑱂 FALSE:񋓂I
 */
BOOL CALLBACK checkMozillaWindow(HWND hwnd,LPARAM lparam)
{
	int result;
	TCHAR winClass[1024];
	// tpX擾B
	TCHAR fileName[_MAX_FNAME];
	TCHAR fullPath[_MAX_PATH];

	result = GetClassName(hwnd,winClass,1024);
	if (result == 0){
		return TRUE;
	}

	// Mozilla̗ނ̃EChENXǂ肷B
	if (_tcscmp(winClass,MOZCLASS)){
		if (_tcscmp(winClass,SEAMONKEYCLASS)){
			return TRUE;
		}
	}

	//-----------------------
	// t@C擾
	//-----------------------

	// EChEnhvZXID擾B
	DWORD pid;
	GetWindowThreadProcessId(hwnd,&pid);

	// vZX𐶐t@C̃t@C擾B
	BOOL gotPath = getProcessFilename(pid,fullPath);
	if (!gotPath) {
		return TRUE;
	}
	
	// t@C𕪊ăt@ĈݎgBgqexeB
	_tsplitpath(fullPath,NULL,NULL,fileName,NULL);

	//-------------------------------------------------------
	// st@CuEÛ̂ǂ`FbNB
	// ɂAubN}[NȂXULgpvO
	// (Mozilla Thunderbird)Ƃ̌FhB
	//-------------------------------------------------------

	// Mozillaǂ`FbNB
	if (!_tcsicmp(fileName,MOZILLA_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// SeaMonkeyǂ`FbNB
	if (!_tcsicmp(fileName,SEAMONKEY_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Mozilla Firefoxǂ`FbNB
	if (!_tcsicmp(fileName,FIREFOX_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Waterfoxǂ`FbNB
	if (!_tcsicmp(fileName, WATERFOX_FILENAME)) {
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Netscape Navigator 9.xǂ`FbNB
	if (!_tcsicmp(fileName,NETSCAPE9_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Netscape 8.xǂ`FbNB
	if (!_tcsicmp(fileName,NETSCAPE8_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Netscape 7.xǂ`FbNB
	if (!_tcsicmp(fileName,NETSCAPE7_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Netscape 6.xǂ`FbNB
	if (!_tcsicmp(fileName,NETSCAPE6_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Phoenixǂ`FbNB(̃`FbNKvǂ͍ł͋^)
	if (!_tcsicmp(fileName,PHOENIX_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	// Mozilla Firebirdǂ`FbNB(̃`FbNKvǂ͍ł͋^)
	if (!_tcsicmp(fileName,MOZILLAFIREBIRD_FILENAME)){
		MozillaFoundFlag = 1;
		return TRUE;
	}

	return TRUE;
}

/**
 * eEChEChromeƂ̔hǂ`FbNsR[obN
 *
 * @param hwnd EChEnh
 * @param lparam \
 * @return TRUE:񋓂𑱂 FALSE:񋓂I
 */
BOOL CALLBACK checkChromeWindow(HWND hwnd,LPARAM lparam)
{
	int result;
	TCHAR winClass[1024];
	// tpX擾B
	TCHAR fileName[_MAX_FNAME];
	TCHAR fullPath[_MAX_PATH];

	result = GetClassName(hwnd,winClass,1024);
	if (result == 0){
		return TRUE;
	}

	// Chrome̗ނ̃EChENXǂ肷B
	bool isChrome = false;
	if (!_tcscmp(winClass, CHROMECLASS)) {
		isChrome = true;
	} else if (!_tcscmp(winClass, CHROMEVISTACLASS)) {
		isChrome = true;
	} else if (!_tcscmp(winClass,CHROME2CLASS)){
		isChrome = true;
	} else if (!_tcscmp(winClass, CHROME59CLASS)) {
		isChrome = true;
	}
	if (!isChrome) {
		return TRUE;
	}

	//-----------------------
	// t@C擾
	//-----------------------

	// EChEnhvZXID擾B
	DWORD pid;
	GetWindowThreadProcessId(hwnd,&pid);

	// vZX𐶐t@C̃t@C擾B
	BOOL gotPath = getProcessFilename(pid, fullPath);
	if (!gotPath) {
		return TRUE;
	}

	// t@C𕪊ăt@ĈݎgBgqexeB
	_tsplitpath(fullPath,NULL,NULL,fileName,NULL);

	//--------------------------------------------------------------
	// st@CuEÛ̂ǂ`FbNB
	// ɂAubN}[NȂBlinkGWgpvO
	// Ƃ̌FhB
	//--------------------------------------------------------------

	// Chrome/ǂ`FbNB
	if (!_tcsicmp(fileName, CHROME_FILENAME)){
		ChromeFoundFlag = 1;
		return TRUE;
	}

	// Chromiumǂ`FbNB
	if (!_tcsicmp(fileName, CHROMIUM_FILENAME)){
		ChromeFoundFlag = 1;
		return TRUE;
	}

	// Ironǂ`FbNB
	if (!_tcsicmp(fileName, IRON_FILENAME)){
		ChromeFoundFlag = 1;
		return TRUE;
	}

	// COMODO Dragonǂ`FbNB
	if (!_tcsicmp(fileName, DRAGON_FILENAME)){
		ChromeFoundFlag = 1;
		return TRUE;
	}

	return TRUE;
}

/**
 * eEChEOpera 15ȍ~̂̂`FbNsR[obN
 *
 * @param hwnd EChEnh
 * @param lparam \
 * @return TRUE:񋓂𑱂 FALSE:񋓂I
 */
BOOL CALLBACK checkOperaWindow(HWND hwnd,LPARAM lparam)
{
	int result;
	TCHAR winClass[1024];
	// tpX擾B
	TCHAR fileName[_MAX_FNAME];
	TCHAR fullPath[_MAX_PATH];

	result = GetClassName(hwnd,winClass,1024);
	if (result == 0){
		return TRUE;
	}

	// Chrome̗ނ̃EChENXǂ肷B
	if (_tcscmp(winClass,CHROMECLASS)){
		if (_tcscmp(winClass,CHROMEVISTACLASS)){
			if (_tcscmp(winClass,CHROME2CLASS)){
				return TRUE;
			}
		}
	}

	//-----------------------
	// t@C擾
	//-----------------------

	// EChEnhvZXID擾B
	DWORD pid;
	GetWindowThreadProcessId(hwnd,&pid);

	// vZX𐶐t@C̃t@C擾B
	getProcessFilename(pid,fullPath);
	
	// t@C𕪊ăt@ĈݎgBgqexeB
	_tsplitpath(fullPath,NULL,NULL,fileName,NULL);

	//--------------------------------------------------------------
	// st@COperâ̂ǂ`FbNB
	// ɂAChromeƔhvOƂ̌FhB
	//--------------------------------------------------------------

	// Operaǂ`FbNB
	if (!_tcsicmp(fileName, OPERA_FILENAME)){
		OperaFoundFlag = 1;
		return TRUE;
	}

	return TRUE;
}

/**
* eEChEVivaldî̂`FbNsR[obN
*
* @param hwnd EChEnh
* @param lparam \
* @return TRUE:񋓂𑱂 FALSE:񋓂I
*/
BOOL CALLBACK checkVivaldiWindow(HWND hwnd, LPARAM lparam)
{
	int result;
	TCHAR winClass[1024];
	// tpX擾B
	TCHAR fileName[_MAX_FNAME];
	TCHAR fullPath[_MAX_PATH];

	result = GetClassName(hwnd, winClass, 1024);
	if (result == 0) {
		return TRUE;
	}

	// Chrome̗ނ̃EChENXǂ肷B
	if (_tcscmp(winClass, CHROMECLASS)) {
		if (_tcscmp(winClass, CHROMEVISTACLASS)) {
			if (_tcscmp(winClass, CHROME2CLASS)) {
				return TRUE;
			}
		}
	}

	//-----------------------
	// t@C擾
	//-----------------------

	// EChEnhvZXID擾B
	DWORD pid;
	GetWindowThreadProcessId(hwnd, &pid);

	// vZX𐶐t@C̃t@C擾B
	getProcessFilename(pid, fullPath);

	// t@C𕪊ăt@ĈݎgBgqexeB
	_tsplitpath(fullPath, NULL, NULL, fileName, NULL);

	//--------------------------------------------------------------
	// st@CVivaldî̂ǂ`FbNB
	// ɂAChromeƔhvOƂ̌FhB
	//--------------------------------------------------------------

	// Vivaldiǂ`FbNB
	if (!_tcsicmp(fileName, VIVALDI_FILENAME)) {
		VivaldiFoundFlag = 1;
		return TRUE;
	}


	return TRUE;
}

/**
* eEChEVivaldî̂`FbNsR[obN
*
* @param hwnd EChEnh
* @param lparam \
* @return TRUE:񋓂𑱂 FALSE:񋓂I
*/
BOOL CALLBACK checkEdge2Window(HWND hwnd, LPARAM lparam)
{
	int result;
	TCHAR winClass[1024];
	// tpX擾B
	TCHAR fileName[_MAX_FNAME];
	TCHAR fullPath[_MAX_PATH];

	result = GetClassName(hwnd, winClass, 1024);
	if (result == 0) {
		return TRUE;
	}

	// Chrome̗ނ̃EChENXǂ肷B
	if (_tcscmp(winClass, CHROMECLASS)) {
		if (_tcscmp(winClass, CHROMEVISTACLASS)) {
			if (_tcscmp(winClass, CHROME2CLASS)) {
				return TRUE;
			}
		}
	}

	//-----------------------
	// t@C擾
	//-----------------------

	// EChEnhvZXID擾B
	DWORD pid;
	GetWindowThreadProcessId(hwnd, &pid);

	// vZX𐶐t@C̃t@C擾B
	getProcessFilename(pid, fullPath);

	// t@C𕪊ăt@ĈݎgBgqexeB
	_tsplitpath(fullPath, NULL, NULL, fileName, NULL);

	//--------------------------------------------------------------
	// st@CEdgê̂ǂ`FbNB
	// ɂAChromeƔhvOƂ̌FhB
	//--------------------------------------------------------------

	// Edgeǂ`FbNB
	if (!_tcsicmp(fileName, EDGE2_FILENAME)) {
		Edge2FoundFlag = 1;
		return TRUE;
	}


	return TRUE;
}

typedef HRESULT (WINAPI *SHAUTOCOMPLETE)
	(HWND hwndEdit, DWORD dwFlags);
static SHAUTOCOMPLETE SHAutoCompleteAPI;
static HANDLE hSHlwapi;

/**
 *  I[gRv[g̏sB
 *
 */
void setupAutoComplete()
{
	// SHLWAPI.DLLSHAutoComplete֐AKpĂB
	hSHlwapi = LoadLibrary(_T("SHLWAPI.DLL"));
	if (hSHlwapi != NULL)
	{
		SHAutoCompleteAPI = 
			(SHAUTOCOMPLETE)GetProcAddress((HINSTANCE)hSHlwapi, "SHAutoComplete");
	}
}

/**
 * I[gRv[gݒpɃ[hDLĽnsB
 *
 */
void cleanupAutoComplete()
{
	if (hSHlwapi != NULL){
		FreeLibrary((HINSTANCE)hSHlwapi);
	}
}

/**
 * eLXg{bNXɃI[gRv[g̐ݒsB
 *
 * @param hWnd eLXg{bNX̃EChEnh
 */
void setAutoComplete(HWND hWnd)
{
	if (SHAutoCompleteAPI){
		SHAutoCompleteAPI(hWnd, 0x00000000);  // hEdit͓KpeLXg{bNX̃nh
	}
}

/**
 * ϊݒIuWFNgMozilla֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param mozForm Mozilla֘A̐ݒtH[
 */
void mozFormToConfig(Configuration *config,CMozForm *mozForm)
{
	// MozillãubN}[N̏ꏊ
	config->setMozPath(0,setBasePath(mozForm->m_MozBM1).c_str());
	config->setMozPath(1,setBasePath(mozForm->m_MozBM2).c_str());

	// s邩ǂ
	config->setMozConvert(0,mozForm->m_chkMoz1 ? true : false);
	config->setMozConvert(1,mozForm->m_chkMoz2 ? true : false);

	config->setConvertFrom(BOOKMARK_MOZILLA_1,mozForm->m_chkMoz1 ? true : false);
	config->setConvertFrom(BOOKMARK_MOZILLA_2,mozForm->m_chkMoz2 ? true : false);
	config->setConvertTo(BOOKMARK_MOZILLA_1,mozForm->m_chkMoz1 ? true : false);
	config->setConvertTo(BOOKMARK_MOZILLA_2,mozForm->m_chkMoz2 ? true : false);

	// IÊCɓ薳
	config->setMozIgnoreIe(0,mozForm->m_chkIEfav1 ? true : false);
	config->setMozIgnoreIe(1,mozForm->m_chkIEfav2 ? true : false);

	// Netscape 4̃tH[}bgŏo͂邩ǂ
	config->setMozNs4Format(0,mozForm->m_chkNS4Format1 ? true : false);
	config->setMozNs4Format(1,mozForm->m_chkNS4Format2 ? true : false);

}

/**
 * ϊݒIuWFNgOpera֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param operaForm Opera֘A̐ݒtH[
 */
void operaFormToConfig(Configuration *config,COperaForm *operaForm)
{
	// OperãubN}[N̏ꏊ
	config->setOperaPath(0,setBasePath(operaForm->m_OperaBM1).c_str());
	config->setOperaPath(1,setBasePath(operaForm->m_OperaBM2).c_str());

	// s邩ǂ
	config->setOperaConvert(0,operaForm->m_chkOpera1 ? true : false);
	config->setOperaConvert(1,operaForm->m_chkOpera2 ? true : false);

	config->setConvertFrom(BOOKMARK_OPERA_1,operaForm->m_chkOpera1 ? true : false);
	config->setConvertFrom(BOOKMARK_OPERA_2,operaForm->m_chkOpera2 ? true : false);
	config->setConvertTo(BOOKMARK_OPERA_1,operaForm->m_chkOpera1 ? true : false);
	config->setConvertTo(BOOKMARK_OPERA_2,operaForm->m_chkOpera2 ? true : false);

	// Opera 7p̃ubN}[No͂邩H
	config->setOpera7Format(0,operaForm->m_chkOpera7_1 ? true : false);
	config->setOpera7Format(1,operaForm->m_chkOpera7_2 ? true : false);

	// ݔ
	config->setOperaIgnoreTrush(0,operaForm->m_Opera7Trash1 ? true : false);
	config->setOperaIgnoreTrush(1,operaForm->m_Opera7Trash2 ? true : false);

	// Windows MobilełOperaǂ
	config->setOperaWinMobile(0,operaForm->m_WinMobile1 ? true : false);
	config->setOperaWinMobile(1,operaForm->m_WinMobile2 ? true : false);

	// oĈCɓƓ邩ǂ
	config->setOperaSyncMobile(0,operaForm->m_SyncMobileFavorites1 ? true : false);
	config->setOperaSyncMobile(1,operaForm->m_SyncMobileFavorites2 ? true : false);
}

/**
 * ϊݒIuWFNgIE֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param ieForm IE֘A̐ݒtH[
 */
void ieFormToConfig(Configuration *config,CIEForm *ieForm)
{
	// IÊCɓ̏ꏊ
	config->setIePath(setBasePath(ieForm->m_IEBM).c_str());

	// s邩ǂ
	config->setIeConvert(ieForm->m_chkIE1 ? true : false);

	config->setConvertFrom(BOOKMARK_IE,ieForm->m_chkIE1 ? true : false);
	config->setConvertTo(BOOKMARK_IE,ieForm->m_chkIE1 ? true : false);

	// IÊCɓ薳
	config->setIeIgnoreLinkFolder(ieForm->m_chkIElink ? true : false);

	// NtH_̓
	config->setIeSyncronizeLinkFolder(ieForm->m_chkIElinkSync ? true : false);

	// ϊOɏ
	config->setIeEraseFavorite(ieForm->m_IEdel ? true : false);

	// NtH_Firefox 3ubN}[Nc[o[Ƃ̓
	config->setIeSyncronizeFxLinkFolder(ieForm->m_chkLinkFx3Sync ? true : false);

	// NtH_Firefox 3j[o[ɏo͂Ȃ
	config->setIeNoLinkToMenu(ieForm->m_chkNoLinkToMenu ? true : false);
}

#ifdef WITH_EDGE
/**
 * ϊݒIuWFNgEdge֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param edgeForm Edge֘A̐ݒtH[
 */
void edgeFormToConfig(Configuration *config, CEdgeForm *edgeForm)
{
	// EdgêCɓ̏ꏊ
	config->setEdgePath(setBasePath(edgeForm->m_EdgeBM).c_str());

	// s邩ǂ
	config->setEdgeConvert(edgeForm->m_chkEdge1 ? true : false);

	config->setConvertFrom(BOOKMARK_EDGE, edgeForm->m_chkEdge1 ? true : false);
	config->setConvertTo(BOOKMARK_EDGE, false);

	// EdgêCɓ薳
	config->setEdgeIgnoreLinkFolder(edgeForm->m_chkEdgelink ? true : false);

	// NtH_̓
	config->setEdgeSyncronizeLinkFolder(edgeForm->m_chkEdgelinkSync ? true : false);

	// NtH_Firefox 3ubN}[Nc[o[Ƃ̓
	config->setEdgeSyncronizeFxLinkFolder(edgeForm->m_chkLinkFx3Sync ? true : false);

	// NtH_Firefox 3j[o[ɏo͂Ȃ
	config->setEdgeNoLinkToMenu(edgeForm->m_chkNoLinkToMenu ? true : false);
}
#endif	// WITH_EDGE

/**
 * ϊݒIuWFNgFirefox֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param fxForm Firefox֘A̐ݒtH[
 */
void fxFormToConfig(Configuration *config,CFxForm *fxForm)
{
	// Firefox 3̃ubN}[N̏ꏊ
	config->setFxPath(0,setBasePath(fxForm->m_FxBM1).c_str());
	config->setFxPath(1,setBasePath(fxForm->m_FxBM2).c_str());

	// s邩ǂ
	config->setFxConvert(0,fxForm->m_chkFx1 ? true : false);
	config->setFxConvert(1,fxForm->m_chkFx2 ? true : false);

	config->setConvertFrom(BOOKMARK_FIREFOX_1,fxForm->m_chkFx1 ? true : false);
	config->setConvertFrom(BOOKMARK_FIREFOX_2,fxForm->m_chkFx2 ? true : false);
	config->setConvertTo(BOOKMARK_FIREFOX_1,fxForm->m_chkFx1 ? true : false);
	config->setConvertTo(BOOKMARK_FIREFOX_2,fxForm->m_chkFx2 ? true : false);

	config->setFxIgnoreToolbar(0,fxForm->m_chkIgnoreToolbar1 ? true : false);
	config->setFxIgnoreToolbar(1,fxForm->m_chkIgnoreToolbar2 ? true : false);

	config->setFxDoOptimize(0,fxForm->m_chkOptimize1 ? true : false);
	config->setFxDoOptimize(1,fxForm->m_chkOptimize2 ? true : false);

	// IÊCɓ薳
	config->setFxIgnoreIe(0,false);
	config->setFxIgnoreIe(1,false);

	// X}[gubN}[No͂邩ǂ?
	config->setPlacesPut(fxForm->m_placesPut ? true : false);

}

/**
 * ϊݒIuWFNgSafari֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param sfForm Safari֘A̐ݒtH[
 */
void sfFormToConfig(Configuration *config,CSfForm *sfForm)
{
	// SafarĩubN}[N̏ꏊ
	config->setSfPath(0,setBasePath(sfForm->m_SfBM1).c_str());
	config->setSfPath(1,setBasePath(sfForm->m_SfBM2).c_str());

	// s邩ǂ
	config->setSfConvert(0,sfForm->m_chkSf1 ? true : false);
	config->setSfConvert(1,sfForm->m_chkSf2 ? true : false);

	config->setConvertFrom(BOOKMARK_SAFARI_1,sfForm->m_chkSf1 ? true : false);
	config->setConvertFrom(BOOKMARK_SAFARI_2,sfForm->m_chkSf2 ? true : false);
	config->setConvertTo(BOOKMARK_SAFARI_1,sfForm->m_chkSf1 ? true : false);
	config->setConvertTo(BOOKMARK_SAFARI_2,sfForm->m_chkSf2 ? true : false);

	config->setSfIgnoreToolbar(0,sfForm->m_chkIgnoreToolbar1 ? true : false);
	config->setSfIgnoreToolbar(1,sfForm->m_chkIgnoreToolbar2 ? true : false);

}

/**
 * ϊݒIuWFNgChrome֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param chForm Chrome֘A̐ݒtH[
 */
void chFormToConfig(Configuration *config,CChForm *chForm)
{
	// ChromẽubN}[N̏ꏊ
	config->setChPath(0,setBasePath(chForm->m_ChBM1).c_str());
	config->setChPath(1,setBasePath(chForm->m_ChBM2).c_str());

	config->setConvertFrom(BOOKMARK_CHROME_1,chForm->m_chkCh1 ? true : false);
	config->setConvertFrom(BOOKMARK_CHROME_2,chForm->m_chkCh2 ? true : false);
	config->setConvertTo(BOOKMARK_CHROME_1,chForm->m_chkCh1 ? true : false);
	config->setConvertTo(BOOKMARK_CHROME_2,chForm->m_chkCh2 ? true : false);

	config->setChIgnoreToolbar(0,chForm->m_chkIgnoreToolbar1 ? true : false);
	config->setChIgnoreToolbar(1,chForm->m_chkIgnoreToolbar2 ? true : false);
}

/**
 * ϊݒIuWFNgXBEL֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param xbForm XBEL֘A̐ݒtH[
 */
void xbFormToConfig(Configuration *config,CXbForm *xbForm)
{
	// XBELt@C̏ꏊ
	config->setXbPath(0,setBasePath(xbForm->m_XbBM1).c_str());
	config->setXbPath(1,setBasePath(xbForm->m_XbBM2).c_str());

	// s邩ǂ
	config->setConvertFrom(BOOKMARK_XBEL_1,xbForm->m_chkXb1 ? true : false);
	config->setConvertFrom(BOOKMARK_XBEL_2,xbForm->m_chkXb2 ? true : false);
	config->setConvertTo(BOOKMARK_XBEL_1,xbForm->m_chkXb1 ? true : false);
	config->setConvertTo(BOOKMARK_XBEL_2,xbForm->m_chkXb2 ? true : false);

	// CAEg
	config->setXbLayout(0,xbForm->m_LayoutXb1);
	config->setXbLayout(1,xbForm->m_LayoutXb2);

	// ubN}[No[𖳎邩ǂH
	config->setXbIgnoreToolbar(0,xbForm->m_chkIgnoreToolbar1 ? true : false);
	config->setXbIgnoreToolbar(1,xbForm->m_chkIgnoreToolbar2 ? true : false);
}

#ifdef WITH_OP15
/**
 * ϊݒIuWFNgOpera15֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param op15Form Opera15֘A̐ݒtH[
 */
void op15FormToConfig(Configuration *config,COp15Form *op15Form)
{
	// Opera 15̃Xs[h_C̏ꏊ
	config->setOp15Path(0,setBasePath(op15Form->m_Op15BM1).c_str());
	config->setOp15Path(1,setBasePath(op15Form->m_Op15BM2).c_str());

	// s邩ǂ
	config->setOp15Convert(0,op15Form->m_chkOp15_1 ? true : false);
	config->setOp15Convert(1,op15Form->m_chkOp15_2 ? true : false);

	config->setConvertFrom(BOOKMARK_OPERA15_1,op15Form->m_chkOp15_1 ? true : false);
	config->setConvertFrom(BOOKMARK_OPERA15_2,op15Form->m_chkOp15_2 ? true : false);
	config->setConvertTo(BOOKMARK_OPERA15_1,op15Form->m_chkOp15_1 ? true : false);
	config->setConvertTo(BOOKMARK_OPERA15_2,op15Form->m_chkOp15_2 ? true : false);

	config->setOp15InFolder(0,op15Form->m_chkInFolder1 ? true : false);
	config->setOp15InFolder(1,op15Form->m_chkInFolder2 ? true : false);

	config->setOp15Optimize(0,op15Form->m_chkOptimize1 ? true : false);
	config->setOp15Optimize(1,op15Form->m_chkOptimize2 ? true : false);

}
#endif	// WITH_OP15

/**
 * ϊݒIuWFNgOpera19֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param op19Form Opera19֘A̐ݒtH[
 */
void op19FormToConfig(Configuration *config,COp19Form *op19Form)
{
	// Opera 19̃ubN}[No[̏ꏊ
	config->setOp19Path(0,setBasePath(op19Form->m_Op19BM1).c_str());
	config->setOp19Path(1,setBasePath(op19Form->m_Op19BM2).c_str());

	// s邩ǂ
	config->setOp19Convert(0,op19Form->m_chkOp19_1 ? true : false);
	config->setOp19Convert(1,op19Form->m_chkOp19_2 ? true : false);

	config->setConvertFrom(BOOKMARK_OPERA25_1,op19Form->m_chkOp19_1 ? true : false);
	config->setConvertFrom(BOOKMARK_OPERA25_2,op19Form->m_chkOp19_2 ? true : false);
	config->setConvertTo(BOOKMARK_OPERA25_1,op19Form->m_chkOp19_1 ? true : false);
	config->setConvertTo(BOOKMARK_OPERA25_2,op19Form->m_chkOp19_2 ? true : false);

	config->setOp19InFolder(0,op19Form->m_chkInFolder1 ? true : false);
	config->setOp19InFolder(1,op19Form->m_chkInFolder2 ? true : false);

	config->setOp19IgnoreTrush(0, op19Form->m_Opera19Trash1 ? true : false);
	config->setOp19IgnoreTrush(1, op19Form->m_Opera19Trash2 ? true : false);

	config->setOp19IgnoreToolbar(0, op19Form->m_chkIgnoreToolbar1 ? true : false);
	config->setOp19IgnoreToolbar(1, op19Form->m_chkIgnoreToolbar2 ? true : false);

	config->setOp19IgnoreUnsorted(0, op19Form->m_chkNoUnsorted1 ? true : false);
	config->setOp19IgnoreUnsorted(1, op19Form->m_chkNoUnsorted2 ? true : false);

	// Opera 29ȍ~̃Xs[h_C𑼂ŏo͂邩H
	config->setOp29SpeedDialPut(op19Form->m_chkOp29SpeedDial ? true : false);
}

/**
 * ϊݒIuWFNgVivaldi֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param viForm Vivaldi֘A̐ݒtH[
 */
void viFormToConfig(Configuration *config, CViForm *viForm)
{
	// VivaldĩubN}[No[̏ꏊ
	config->setViPath(0, setBasePath(viForm->m_ViBM1).c_str());
	config->setViPath(1, setBasePath(viForm->m_ViBM2).c_str());

	// s邩ǂ
	config->setViConvert(0, viForm->m_chkVi_1 ? true : false);
	config->setViConvert(1, viForm->m_chkVi_2 ? true : false);

	config->setConvertFrom(BOOKMARK_VIVALDI_1, viForm->m_chkVi_1 ? true : false);
	config->setConvertFrom(BOOKMARK_VIVALDI_2, viForm->m_chkVi_2 ? true : false);
	config->setConvertTo(BOOKMARK_VIVALDI_1, viForm->m_chkVi_1 ? true : false);
	config->setConvertTo(BOOKMARK_VIVALDI_2, viForm->m_chkVi_2 ? true : false);

	config->setViIgnoreTrush(0, viForm->m_ViTrash1 ? true : false);
	config->setViIgnoreTrush(1, viForm->m_ViTrash2 ? true : false);

}

/**
 * ϊݒIuWFNgEdge(Chromium)֘A̐ݒ]B
 *
 * @param config ϊݒIuWFNg
 * @param edge2Form Edge֘A̐ݒtH[
 */
void edge2FormToConfig(Configuration *config, CEdge2Form *edge2Form)
{
	// ChromẽubN}[N̏ꏊ
	config->setEdge2Path(0, setBasePath(edge2Form->m_Edge2BM1).c_str());
	config->setEdge2Path(1, setBasePath(edge2Form->m_Edge2BM2).c_str());

	config->setConvertFrom(BOOKMARK_EDGE2_1, edge2Form->m_chkEdge2_1 ? true : false);
	config->setConvertFrom(BOOKMARK_EDGE2_2, edge2Form->m_chkEdge2_2 ? true : false);
	config->setConvertTo(BOOKMARK_EDGE2_1, edge2Form->m_chkEdge2_1 ? true : false);
	config->setConvertTo(BOOKMARK_EDGE2_2, edge2Form->m_chkEdge2_2 ? true : false);

	config->setEdge2IgnoreToolbar(0, edge2Form->m_chkIgnoreToolbar1 ? true : false);
	config->setEdge2IgnoreToolbar(1, edge2Form->m_chkIgnoreToolbar2 ? true : false);
}

/**
 * ΃pX̉
 *
 * @param bookmark ubN}[Nt@C̃pX
 * @return ΃pX̏ꍇ͎st@C̃tH_B
 */
tstring setBasePath(tstring bookmark)
{
	TCHAR buf[2];
	TCHAR currentDirectory[MAX_PATH];

	if (bookmark.length() == 0){
		return _T("");
	}
	// lbg[NpX
	if ((bookmark[0] == '\\') && (bookmark[1] == '\\')){
		return bookmark;
	}

	// ΃pX
	if (bookmark[0] == '\\'){
		GetCurrentDirectory(MAX_PATH, currentDirectory);
		buf[0] = currentDirectory[0];
		buf[1] = '\0';

		tstring temp = buf;
		temp += ":"; 
		temp += bookmark;
		return temp;
	}

	// ΃pX̏ꍇ
	if (bookmark[1] != ':'){
		tstring temp = basePath + bookmark;
		return temp;
	}
	return bookmark;
}

/**
 * w肵t@C݂邩ǂׂ
 *
 * @param filename `FbNt@C
 * @return true:t@C݂ false:t@C݂Ȃ
 */
bool isExistingFile(const TCHAR *filename)
{
	WIN32_FIND_DATA f;

	HANDLE hFind = FindFirstFile( filename , &f );
	if (hFind == INVALID_HANDLE_VALUE) {
		return false;
	}
	FindClose(hFind);
	return true;
}

/**
 * EChEeEChE̒ɔzuB
 *
 * @param parentRect SɓΏۂ̗̈
 * @param parentHWnd eEChEnh
 * @param myHWnd 񂹂vf̃EChEnh
 */
void adjustCenter(RECT parentRect, HWND parentHWnd, HWND myHWnd)
{
	int parentWidth, parentHeight;
	int myWidth, myHeight;
	int newTop, newLeft;
	RECT myRect;

	GetWindowRect(myHWnd, &myRect);

	parentWidth = parentRect.right - parentRect.left + 1;
	parentHeight = parentRect.bottom - parentRect.top + 1;

	myWidth = myRect.right - myRect.left + 1;
	myHeight = myRect.bottom - myRect.top + 1;

	if (myWidth >= parentWidth) {
		newLeft = parentRect.left + 1;
	} else {
		newLeft = parentRect.left + MulDiv((parentWidth - myWidth), 45, 100);
	}
	if (myHeight >= parentHeight) {
		newTop = parentRect.top + 1;
	} else {
		newTop = parentRect.top + MulDiv((parentHeight - myHeight), 45, 100);
	}
	SetWindowPos(myHWnd, parentHWnd, newLeft, newTop, myWidth, myHeight, SWP_SHOWWINDOW);

}
