#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>
#include "NCFileDialog.h"
#include "util.h"
#include "resource.h"
#include "XbForm.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CXbForm::CXbForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_XbBM1(_T(""))
	, m_XbBM2(_T(""))
	, m_chkXb1(FALSE)
	, m_chkXb2(FALSE)
	, m_LayoutXb1(0)
	, m_LayoutXb2(0)
	, m_chkIgnoreToolbar1(FALSE)
	, m_chkIgnoreToolbar2(FALSE)
{
	editXb1 = NULL;
	editXb2 = NULL;
	chkXb1 = NULL;
	chkXb2 = NULL;
	ignoreToolbarXb1 = NULL;
	ignoreToolbarXb2 = NULL;
	layoutXb1 = NULL;
	layoutXb2 = NULL;
	groupXb1 = NULL;
	groupXb2 = NULL;
	refXb1 = NULL;
	refXb2 = NULL;
	layoutTextXb1 = NULL;
	layoutTextXb2 = NULL;
}

CXbForm::~CXbForm()
{
	if (editXb1 != NULL) {
		delete editXb1;
	}
	if (editXb2 != NULL) {
		delete editXb2;
	}
	if (chkXb1 != NULL) {
		delete chkXb1;
	}
	if (chkXb2 != NULL) {
		delete chkXb2;
	}
	if (ignoreToolbarXb1 != NULL) {
		delete ignoreToolbarXb1;
	}
	if (ignoreToolbarXb2 != NULL) {
		delete ignoreToolbarXb2;
	}
	if (layoutXb1 != NULL) {
		delete layoutXb1;
	}
	if (layoutXb2 != NULL) {
		delete layoutXb2;
	}
	if (groupXb1 == NULL) {
		delete groupXb1;
	}

	if (groupXb2 == NULL) {
		delete groupXb2;
	}

	if (refXb1 == NULL) {
		delete refXb1;
	}

	if (refXb2 == NULL) {
		delete refXb2;
	}

	if (layoutTextXb1 == NULL) {
		delete layoutTextXb1;
	}

	if (layoutTextXb2 == NULL) {
		delete layoutTextXb2;
	}
}

void CXbForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITXB1, m_XbBM1);
	DDX_Text(toObj, IDC_EDITXB2, m_XbBM2);
	DDX_Check(toObj, IDC_CHECKXB1, m_chkXb1);
	DDX_Check(toObj, IDC_CHECKXB2, m_chkXb2);
	DDX_CBIndex(toObj, IDC_COMBO_LAYOUT_XB1, m_LayoutXb1);
	DDX_CBIndex(toObj, IDC_COMBO_LAYOUT_XB2, m_LayoutXb2);
	DDX_Check(toObj, IDC_CHECK_XB_TOOLBAR_IGNORE1, m_chkIgnoreToolbar1);
	DDX_Check(toObj, IDC_CHECK_XB_TOOLBAR_IGNORE2, m_chkIgnoreToolbar2);
}

INT_PTR CXbForm::OnInitDialog()
{
	editXb1 = GetDlgItem(IDC_EDITXB1);
	editXb2 = GetDlgItem(IDC_EDITXB2);
	chkXb1 = GetDlgItem(IDC_CHECKXB1);
	chkXb2 = GetDlgItem(IDC_CHECKXB2);
	ignoreToolbarXb1 = GetDlgItem(IDC_CHECK_XB_TOOLBAR_IGNORE1);
	ignoreToolbarXb2 = GetDlgItem(IDC_CHECK_XB_TOOLBAR_IGNORE2);
	layoutXb1 = new TwrCombobox(GetDlgItemRaw(IDC_COMBO_LAYOUT_XB1));
	layoutXb2 = new TwrCombobox(GetDlgItemRaw(IDC_COMBO_LAYOUT_XB2));
	groupXb1 = GetDlgItem(IDC_GroupXb1);
	groupXb2 = GetDlgItem(IDC_GroupXb2);
	refXb1 = GetDlgItem(IDC_REFXB1);
	refXb2 = GetDlgItem(IDC_REFXB2);
	layoutTextXb1 = GetDlgItem(IDC_LAYOUTTEXT_XB1);
	layoutTextXb2 = GetDlgItem(IDC_LAYOUTTEXT_XB2);

	layoutXb1->addItem(_T("c[o[{j[(QtWeb)"));
	layoutXb1->addItem(_T("j[̂"));
	layoutXb1->addItem(_T("oĈCɓɍ킹"));

	layoutXb2->addItem(_T("c[o[{j[(QtWeb)"));
	layoutXb2->addItem(_T("j[̂"));
	layoutXb2->addItem(_T("oĈCɓɍ킹"));

	// I[gRv[gݒ肷B
	setAutoComplete(editXb1->getHwnd());
	setAutoComplete(editXb2->getHwnd());

	UpdateData(false);

	groupXb1->setPoint(7, 6);
	groupXb1->setSize(524, 88);
	add(groupXb1);

	chkXb1->setPoint(23, 26);
	chkXb1->setSize(54, 19);
	add(chkXb1);

	layoutTextXb1->setPoint(74, 27);
	layoutTextXb1->setSize(52, 13);
	add(layoutTextXb1);

	layoutXb1->setPoint(126, 24);
	layoutXb1->setSize(211, 21);
	add(layoutXb1);

	ignoreToolbarXb1->setPoint(23, 46);
	ignoreToolbarXb1->setSize(216, 19);
	add(ignoreToolbarXb1);

	editXb1->setPoint(23, 68);
	editXb1->setSize(386, 19);
	add(editXb1);

	refXb1->setPoint(424, 60);
	refXb1->setSize(43, 24);
	add(refXb1);

	groupXb2->setPoint(7, 95);
	groupXb2->setSize(524, 88);
	add(groupXb2);

	chkXb2->setPoint(23, 111);
	chkXb2->setSize(54, 19);
	add(chkXb2);

	layoutTextXb2->setPoint(74, 113);
	layoutTextXb2->setSize(52, 13);
	add(layoutTextXb2);

	layoutXb2->setPoint(126, 110);
	layoutXb2->setSize(211, 21);
	add(layoutXb2);

	ignoreToolbarXb2->setPoint(23, 131);
	ignoreToolbarXb2->setSize(220, 19);
	add(ignoreToolbarXb2);

	editXb2->setPoint(23, 152);
	editXb2->setSize(386, 19);
	add(editXb2);

	refXb2->setPoint(424, 146);
	refXb2->setSize(43, 24);
	add(refXb2);

	SetXb1Enable();
	SetXb2Enable();	

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CXbForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR CXbForm::OnCommand(WPARAM wParam)
{
	if (HIWORD(wParam) == CBN_SELCHANGE) {
		switch (LOWORD(wParam)) {
			case IDC_COMBO_LAYOUT_XB1:
				OnCbnSelchangeComboLayoutXb1();

				return (INT_PTR)TRUE;

			case IDC_COMBO_LAYOUT_XB2:
				OnCbnSelchangeComboLayoutXb2();

				return (INT_PTR)TRUE;
		}
	} else {
		switch (LOWORD(wParam)) {
			case IDC_REFXB1:
				OnBnClickedRefxb1();

				return (INT_PTR)TRUE;

			case IDC_REFXB2:
				OnBnClickedRefxb2();

				return (INT_PTR)TRUE;

			case IDC_CHECKXB1:
				OnBnClickedCheckxb1();

				return (INT_PTR)TRUE;

			case IDC_CHECKXB2:
				OnBnClickedCheckxb2();

				return (INT_PTR)TRUE;
		}
	}

	return BaseDialog::OnCommand(wParam);
}

// CXbForm bZ[W nh

void CXbForm::OnBnClickedRefxb1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T(""),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("XBELt@C(*.xbel)\0*.xbel\0XBELt@C(*.xml)\0*.xml\0ׂẴt@C(*.*)\0*.*\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("XBELt@C̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_XbBM1 = path;
	m_chkXb1 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);
	SetXb1Enable();

	delete cDlg;
}

void CXbForm::OnBnClickedRefxb2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T(""),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("XBELt@C(*.xbel)\0*.xbel\0XBELt@C(*.xml)\0*.xml\0ׂẴt@C(*.*)\0*.*\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("XBELt@C̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_XbBM2 = path;
	m_chkXb2 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);
	SetXb2Enable();

	delete cDlg;
}

/**
 * XBEL1̎s̗Lɉă`FbN邩ǂw肷B
 */
void CXbForm::SetXb1Enable()
{
	UpdateData(true);

	if (m_LayoutXb1 == 0) {
		ignoreToolbarXb1->EnableWindow(TRUE);
	} else {
		ignoreToolbarXb1->EnableWindow(FALSE);
	}

	UpdateData(false);
}

/**
 * XBEL2̎s̗Lɉă`FbN邩ǂw肷B
 */
void CXbForm::SetXb2Enable()
{
	UpdateData(true);

	if (m_LayoutXb2 == 0) {
		ignoreToolbarXb2->EnableWindow(TRUE);
	} else {
		ignoreToolbarXb2->EnableWindow(FALSE);
	}

	UpdateData(false);
}


void CXbForm::OnBnClickedCheckxb1()
{
	UpdateData(true);
	SetXb1Enable();
}

void CXbForm::OnBnClickedCheckxb2()
{
	UpdateData(true);
	SetXb2Enable();
}

void CXbForm::OnCbnSelchangeComboLayoutXb1()
{
	UpdateData(true);
	SetXb1Enable();
}

void CXbForm::OnCbnSelchangeComboLayoutXb2()
{
	UpdateData(true);
	SetXb2Enable();
}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CXbForm::setSettingEnable(void)
{
	SetXb1Enable();
	SetXb2Enable();
}
