#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "encutil.h"
#include "encutil2.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "ViForm.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CViForm::CViForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_ViBM1(_T(""))
	, m_ViBM2(_T(""))
	, m_chkVi_1(FALSE)
	, m_chkVi_2(FALSE)
	, m_ViTrash1(TRUE)
	, m_ViTrash2(TRUE)
//	, m_LayoutVi1(1)
//	, m_LayoutVi2(1)
{
	editVi_1 = NULL;
	editVi_2 = NULL;
	chkVi_1 = NULL;
	chkVi_2 = NULL;
	inFolderVi_1 = NULL;
	inFolderVi_2 = NULL;
	chkViTrash_1 = NULL;
	chkViTrash_2 = NULL;
	//groupVi_1 = NULL;
	//groupVi_2 = NULL;
	refVi_1 = NULL;
	refVi_2 = NULL;
	findVi_1 = NULL;
	findVi_2 = NULL;
	//layoutVi1 = NULL;
	//layoutVi2 = NULL;
	//layoutTextVi1 = NULL;
	//layoutTextVi2 = NULL;
}

/**
 * fXgN^
 */
CViForm::~CViForm()
{
#if 0
	if (layoutTextVi1 == NULL) {
		delete layoutTextVi1;
	}

	if (layoutTextVi2 == NULL) {
		delete layoutTextVi2;
	}
	if (layoutVi1 != NULL) {
		delete layoutVi1;
	}
	if (layoutVi2 != NULL) {
		delete layoutVi2;
	}
#endif

	if (editVi_1 != NULL) {
		delete editVi_1;
	}
	if (editVi_2 != NULL) {
		delete editVi_2;
	}
	if (chkVi_1 != NULL) {
		delete chkVi_1;
	}
	if (chkVi_2 != NULL) {
		delete chkVi_2;
	}
	if (inFolderVi_1 != NULL) {
		delete inFolderVi_1;
	}
	if (inFolderVi_2 != NULL) {
		delete inFolderVi_2;
	}
	if (chkViTrash_1 != NULL) {
		delete chkViTrash_1;
	}
	if (chkViTrash_2 != NULL) {
		delete chkViTrash_2;
	}

	if (groupVi_1 == NULL) {
		delete groupVi_1;
	}

	if (groupVi_2 == NULL) {
		delete groupVi_2;
	}

	if (refVi_1 == NULL) {
		delete refVi_1;
	}

	if (refVi_2 == NULL) {
		delete refVi_2;
	}

	if (findVi_1 == NULL) {
		delete findVi_1;
	}

	if (findVi_2 == NULL) {
		delete findVi_2;
	}
}

/**
 * f[^XV
 *
 * @param toObj true:Rg[̏ԂIuWFNgɐݒ肷B false:IuWFNg̏ԂRg[ɐݒ肷B
 */
void CViForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITVI_1, m_ViBM1);
	DDX_Text(toObj, IDC_EDITVI_2, m_ViBM2);
	DDX_Check(toObj, IDC_CHECKVI_1, m_chkVi_1);
	DDX_Check(toObj, IDC_CHECKVI_2, m_chkVi_2);
	DDX_Check(toObj, IDC_NOVITRASH1, m_ViTrash1);
	DDX_Check(toObj, IDC_NOVITRASH2, m_ViTrash2);
	//DDX_CBIndex(toObj, IDC_COMBO_LAYOUT_VI1, m_LayoutVi1);
	//DDX_CBIndex(toObj, IDC_COMBO_LAYOUT_VI2, m_LayoutVi2);

}

/**
 * _CAȌ
 *
 * @return FALSE
 */
INT_PTR CViForm::OnInitDialog()
{
	editVi_1 = GetDlgItem(IDC_EDITVI_1);
	editVi_2 = GetDlgItem(IDC_EDITVI_2);
	chkVi_1 = GetDlgItem(IDC_CHECKVI_1);
	chkVi_2 = GetDlgItem(IDC_CHECKVI_2);
	chkViTrash_1 = GetDlgItem(IDC_NOVITRASH1);
	chkViTrash_2 = GetDlgItem(IDC_NOVITRASH2);
	groupVi_1 = GetDlgItem(IDC_GroupVI_1);
	groupVi_2 = GetDlgItem(IDC_GroupVI_2);
	refVi_1 = GetDlgItem(IDC_REFVI_1);
	refVi_2 = GetDlgItem(IDC_REFVI_2);
	findVi_1 = GetDlgItem(IDC_BUTTONSearchVI_1);
	findVi_2 = GetDlgItem(IDC_BUTTONSearchVI_2);
	//layoutVi1 = new TwrCombobox(GetDlgItemRaw(IDC_COMBO_LAYOUT_VI1));
	//layoutVi2 = new TwrCombobox(GetDlgItemRaw(IDC_COMBO_LAYOUT_VI2));
	//layoutTextVi1 = GetDlgItem(IDC_LAYOUTTEXT_VI1);
	//layoutTextVi2 = GetDlgItem(IDC_LAYOUTTEXT_VI2);

	//layoutVi1->addItem(_T("ubN}[No["));
	//layoutVi1->addItem(_T("ubN}[Nj["));

	//layoutVi2->addItem(_T("ubN}[No["));
	//layoutVi2->addItem(_T("ubN}[Nj["));

	// I[gRv[gݒ肷B
	setAutoComplete(editVi_1->getHwnd());
	setAutoComplete(editVi_2->getHwnd());

	UpdateData(false);

	groupVi_1->setPoint(7, 5);
	groupVi_1->setSize(524, 72);
	add(groupVi_1);

	chkVi_1->setPoint(23, 21);
	chkVi_1->setSize(54, 19);
	add(chkVi_1);

	//layoutTextVi1->setPoint(80, 24);
	//layoutTextVi1->setSize(52, 13);
	//add(layoutTextVi1);

	//layoutVi1->setPoint(132, 22);
	//layoutVi1->setSize(211, 21);
	//add(layoutVi1);

	chkViTrash_1->setPoint(80, 21);
	chkViTrash_1->setSize(115, 19);
	add(chkViTrash_1);

	editVi_1->setPoint(23, 46);
	editVi_1->setSize(386, 19);
	add(editVi_1);

	refVi_1->setPoint(424, 44);
	refVi_1->setSize(43, 24);
	add(refVi_1);

	findVi_1->setPoint(475, 44);
	findVi_1->setSize(43, 24);
	add(findVi_1);


	groupVi_2->setPoint(7, 79);
	groupVi_2->setSize(524, 72);
	add(groupVi_2);

	chkVi_2->setPoint(23, 95);
	chkVi_2->setSize(54, 19);
	add(chkVi_2);

	//layoutTextVi2->setPoint(80, 114);
	//layoutTextVi2->setSize(52, 13);
	//add(layoutTextVi2);

	//layoutVi2->setPoint(132, 111);
	//layoutVi2->setSize(211, 21);
	//add(layoutVi2);

	chkViTrash_2->setPoint(80, 95);
	chkViTrash_2->setSize(115, 19);
	add(chkViTrash_2);

	editVi_2->setPoint(23, 120);
	editVi_2->setSize(386, 19);
	add(editVi_2);

	refVi_2->setPoint(424, 118);
	refVi_2->setSize(43, 24);
	add(refVi_2);

	findVi_2->setPoint(475, 118);
	findVi_2->setSize(43, 24);
	add(findVi_2);


	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CViForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR CViForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFVI_1:
			OnBnClickedRefVi_1();

			return (INT_PTR)TRUE;

		case IDC_REFVI_2:
			OnBnClickedRefVi_2();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchVI_1:
			OnBnClickedButtonsearchVi_1();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchVI_2:
			OnBnClickedButtonsearchVi_2();

			return (INT_PTR)TRUE;
	}

	return BaseDialog::OnCommand(wParam);
}

/**
 * VivaldĩubN}[N1̎Qƃ{^ꂽƂ̏
 *
 */
void CViForm::OnBnClickedRefVi_1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Vivaldiȍ~̃ubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_ViBM1 = path;
	m_chkVi_1 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

/**
 * VivaldĩubN}[N2̎Qƃ{^ꂽƂ̏
 *
 */
void CViForm::OnBnClickedRefVi_2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("VivaldĩubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_ViBM2 = path;
	m_chkVi_2 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void CViForm::OnBnClickedButtonsearchVi_1()
{
	UpdateData(true);

	searchVi_1(hWnd);

	UpdateData(false);
}

void CViForm::OnBnClickedButtonsearchVi_2()
{
	UpdateData(true);

	searchVi_2(hWnd);

	UpdateData(false);
}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CViForm::setSettingEnable(void)
{
}

/**
 * VivaldĩubN}[N1̌
 *
 */
void CViForm::searchVi_1(HWND hWnd)
{
	// Version 2.4̃}`vtB[ő{
	tstring bookmark = GetBookmark2(hWnd, 1, m_ViBM2);
	if (bookmark != _T("")) {
		if (bookmark != _T(" ")) {
			m_ViBM1 = bookmark;
			m_chkVi_1 = TRUE;
		}
		return;
	} else {
		// Ȃꍇ͈ȑO̕@ő{B
		bookmark = GetBookmark(_T(VI_BOOKMARK_OLD_FULL));
		if (bookmark != _T("")) {
			if (bookmark != m_ViBM2) {
				if (confirm(hWnd, bookmark, 1, 0)) {
					m_ViBM1 = bookmark;
					m_chkVi_1 = TRUE;
					return;
				}
			}
		}
	}
}

/**
 * VivaldĩubN}[N2̌
 *
 */
void CViForm::searchVi_2(HWND hWnd)
{
	// Version 2.4̃}`vtB[ő{
	tstring bookmark = GetBookmark2(hWnd, 2, m_ViBM1);
	if (bookmark != _T("")) {
		if (bookmark != _T(" ")) {
			m_ViBM2 = bookmark;
			m_chkVi_2 = TRUE;
		}
		return;
	} else {
		// Ȃꍇ͈ȑO̕@ő{B
		bookmark = GetBookmark(_T(VI_BOOKMARK_OLD_FULL));
		if (bookmark != _T("")) {
			if (bookmark != m_ViBM1) {
				if (confirm(hWnd, bookmark, 2, 0)) {
					m_ViBM2 = bookmark;
					m_chkVi_2 = TRUE;
					return;
				}
			}
		}
	}
}

/**
 * VivaldĩubN}[Nt@C̈ʒu擾B
 *
 * @param path ubN}[Nt@C̃pX̒f(VivaldifBNg)
 * @return 󕶎łȂꍇ:ubN}[Nt@C̈ʒu 󕶎:ubN}[Nt@CȂ
 */
tstring CViForm::GetBookmark(const TCHAR *path)
{
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR profileDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	/* ܂AubN}[N̈ʒuTB */
	profiles[0] = _T('\0');
	memset(profiles, 0x00, _MAX_PATH * sizeof(TCHAR));
	memset(profileDir, 0x00, _MAX_PATH * sizeof(TCHAR));
	GetLocalAppDataDir(profileDir);

	if (profileDir[0] != '\0'){
		_tcscpy(profiles,profileDir);
		_tcscat(profiles, path);

		memset(&f,0x00,sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			// Ȃ甲B
			delete []profiles;
			return ret;
		}
		FindClose(h);
		ret = profiles;

	}

	delete []profiles;
	return ret;
}

/**
 * VivaldĩubN}[Nt@C̈ʒu擾B(邱Chromeƈꏏ)
 *
 * @param hWnd EChEnh
 * @param pos ݒ肷ubN}[N̈ʒu
 * @param exclude 珜OubN}[Nt@C̃tpX
 * @return ubN}[Nt@C̃pX
 */
tstring CViForm::GetBookmark2(HWND hWnd, int pos, tstring exclude)
{
	tstring profileBasePath;	// vt@CtH_̃pX
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR localAppDataDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try {
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL) {
			return ret;
		}
	}
	catch (...) {
		return ret;
	}

	profiles[0] = '\0';
	memset(profiles, 0x00, _MAX_PATH);
	memset(localAppDataDir, 0x00, _MAX_PATH * sizeof(TCHAR));
	GetLocalAppDataDir(localAppDataDir);

	if (localAppDataDir[0] != _T('\0')) {
		// vtB[̓t@CLocal StatěEǂݍ
		_tcscpy(profiles, localAppDataDir);
		// vt@CtH_̋N_
		_tcscat(profiles, _T(VI_CONFIG_BASE));
		profileBasePath = profiles;
		// AvP[Vݒt@C
		_tcscat(profiles, _T(VI_CONFIG_FILE));

		memset(&f, 0x00, sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles, &f);
		if (h == INVALID_HANDLE_VALUE) {
			// Ȃ甲B
			delete[]profiles;
			return ret;
		}
		FindClose(h);

		// 
		try {
			TJson *jsonObj = new TJson();
			if (jsonObj == NULL) {
				delete[]profiles;
				return ret;
			}
			tstring bookmarkFile = searchProfile(
				hWnd,
				jsonObj,
				profiles,
				pos,
				profileBasePath,
				exclude);
			delete jsonObj;
			if (bookmarkFile != _T("")) {
				ret = bookmarkFile;
			}
		}
		catch (...) {
			delete[]profiles;
			return ret;
		}
	}

	delete[]profiles;
	return ret;
}

/**
 * vtB[ƕRÂubN}[Nt@CB
 *
 * @param hWnd ₢킹_CAO̐eEChEnh
 * @param jsonObj JSONǂݎIuWFNg
 * @param profiles vtB[񂪏ꂽLocal StatẽtpX
 * @param pos ݒΏۂ̃ubN}[N(1/2)
 * @param base vtB[̂tH_̃pX
 * @param exclude 珜OubN}[Nt@C̃tpX
 * @return vtB[ɕRÂubN}[Nt@C̃tpX(IȂꍇ͋)
 */
tstring CViForm::searchProfile(
	HWND hWnd,
	TJson *jsonObj,
	TCHAR *profiles,
	int pos,
	tstring base,
	tstring exclude)
{
	tstring ret;
	ret = _T("");

	int readResult = jsonObj->readFile(profiles);
	if (readResult) {
		return ret;
	}
	TJsonValue *top = jsonObj->getTopValue();
	if (top == NULL) {
		return ret;
	}
	TJsonValue *profile = top->getObjectValue("profile");
	if (profile == NULL) {
		return ret;
	}
	TJsonValue *infoCache = profile->getObjectValue("info_cache");
	if (infoCache == NULL) {
		return ret;
	}
	int profileCount = infoCache->getObjectCount();
	if (profileCount == 0) {
		return ret;
	}
	for (int i = 0; i < profileCount; i++) {
		TJsonValue *profile = infoCache->getObjectValue(i);
		std::string folder = infoCache->getObjectKey(i);
		TJsonValue *name = profile->getObjectValue("name");
		if (name == NULL) {
			continue;
		}
		char *profileName = name->getValue();

		tstring message = _T("[U[");
#ifndef UNICODE
		char *mbProfileName = UTF8tombInternal(profileName);
		message += mbProfileName;

		tstring fullPath = base;
		fullPath += _T("\\");
		fullPath += folder;
		fullPath += _T("\\Bookmarks");

#else
		wchar_t *wcProfileName = UTF8tombInternal(profileName);
		message += wcProfileName;

		tstring fullPath = base;
		fullPath += _T("\\");
		fullPath += mbtowcInternal(folder);
		fullPath += _T("\\Bookmarks");
#endif
		message += _T("\nubN}[NVivaldĩubN}[N");
		if (pos == 1) {
			message += _T("1");
		} else {
			message += _T("2");
		}
		message += _T("ɐݒ肵܂H");

		if (fullPath != exclude) {
			// ̃ubN}[NƏdȂȂ̂₢킹sB
			int answer = MessageBox(
				hWnd,
				message.c_str(),
				_T("VivaldĩubN}[N"),
				MB_YESNO | MB_ICONQUESTION);
			if (answer == IDYES) {
#ifndef UNICODE
				ret = fullPath;
#else
				ret = mbtowcInternal(folder.c_str());;
#endif
				break;
			} else {
				ret = _T(" ");
				break;
			}
		}
	}
	return ret;
}

bool CViForm::confirm(HWND hWnd,tstring &bookmark,int pos, int type)
{
	tstring msg;

	msg = _T("Vivaldi");
	msg += _T("̃ubN}[N\n");
	msg += bookmark;
	msg += _T("\n");
	if (pos == 1){
		msg += _T("VivaldĩubN}[N1ɐݒ肵܂H");
	}else{
		msg += _T("VivaldĩubN}[N2ɐݒ肵܂H");
	}

	int answer;
	const TCHAR *title = _T("");
	title = _T("VivaldĩubN}[N");

	answer = ::MessageBox(
		hWnd,
		msg.c_str(),
		title,
		MB_YESNO | MB_ICONQUESTION);

	if (answer == IDNO){
		return false;
	} else {
		return true;
	}
}

