#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>
#include "bslib.h"
#include "NCFileDialog.h"
#include "util.h"
#include "resource.h"
#include "SfForm.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CSfForm::CSfForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_chkSf1(FALSE)
	, m_chkSf2(FALSE)
	, m_SfBM1(_T(""))
	, m_SfBM2(_T(""))
	, m_chkIgnoreToolbar1(FALSE)
	, m_chkIgnoreToolbar2(FALSE)
{
	editSf1 = NULL;
	editSf2 = NULL;
	chkSf1 = NULL;
	chkSf2 = NULL;
	ignoreToolbarSf1 = NULL;
	ignoreToolbarSf2 = NULL;
	groupSf1 = NULL;
	groupSf2 = NULL;
	refSf1 = NULL;
	refSf2 = NULL;
	findSf1 = NULL;
	findSf2 = NULL;
}

CSfForm::~CSfForm()
{
	if (editSf1 != NULL) {
		delete editSf1;
	}
	if (editSf2 != NULL) {
		delete editSf2;
	}
	if (chkSf1 != NULL) {
		delete chkSf1;
	}
	if (chkSf2 != NULL) {
		delete chkSf2;
	}
	if (ignoreToolbarSf1 != NULL) {
		delete ignoreToolbarSf1;
	}
	if (ignoreToolbarSf2 != NULL) {
		delete ignoreToolbarSf2;
	}
	if (groupSf1 == NULL) {
		delete groupSf1;
	}

	if (groupSf2 == NULL) {
		delete groupSf2;
	}

	if (refSf1 == NULL) {
		delete refSf1;
	}

	if (refSf2 == NULL) {
		delete refSf2;
	}

	if (findSf1 == NULL) {
		delete findSf1;
	}

	if (findSf2 == NULL) {
		delete findSf2;
	}
}

void CSfForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITSF1, m_SfBM1);
	DDX_Text(toObj, IDC_EDITSF2, m_SfBM2);
	DDX_Check(toObj, IDC_CHECKSF1, m_chkSf1);
	DDX_Check(toObj, IDC_CHECKSF2, m_chkSf2);
	DDX_Check(toObj, IDC_CHECK_SF_TOOLBAR_IGNORE1, m_chkIgnoreToolbar1);
	DDX_Check(toObj, IDC_CHECK_SF_TOOLBAR_IGNORE2, m_chkIgnoreToolbar2);
}

INT_PTR CSfForm::OnInitDialog()
{
	editSf1 = GetDlgItem(IDC_EDITSF1);
	editSf2 = GetDlgItem(IDC_EDITSF2);
	chkSf1 = GetDlgItem(IDC_CHECKSF1);
	chkSf2 = GetDlgItem(IDC_CHECKSF2);
	ignoreToolbarSf1 = GetDlgItem(IDC_CHECK_SF_TOOLBAR_IGNORE1);
	ignoreToolbarSf2 = GetDlgItem(IDC_CHECK_SF_TOOLBAR_IGNORE2);
	groupSf1 = GetDlgItem(IDC_GroupSf1);
	groupSf2 = GetDlgItem(IDC_GroupSf2);
	refSf1 = GetDlgItem(IDC_REFSF1);
	refSf2 = GetDlgItem(IDC_REFSF2);
	findSf1 = GetDlgItem(IDC_BUTTONSearchSf3_1);
	findSf2 = GetDlgItem(IDC_BUTTONSearchSf3_2);

	// I[gRv[gݒ肷B
	setAutoComplete(editSf1->getHwnd());
	setAutoComplete(editSf2->getHwnd());

	UpdateData(false);

	groupSf1->setPoint(7, 6);
	groupSf1->setSize(524, 58);
	add(groupSf1);

	chkSf1->setPoint(23, 19);
	chkSf1->setSize(54, 19);
	add(chkSf1);

	ignoreToolbarSf1->setPoint(81, 19);
	ignoreToolbarSf1->setSize(152, 19);
	add(ignoreToolbarSf1);

	editSf1->setPoint(23, 38);
	editSf1->setSize(386, 19);
	add(editSf1);

	refSf1->setPoint(424, 30);
	refSf1->setSize(43, 24);
	add(refSf1);

	findSf1->setPoint(474, 30);
	findSf1->setSize(43, 24);
	add(findSf1);

	groupSf2->setPoint(7, 68);
	groupSf2->setSize(524, 58);
	add(groupSf2);

	chkSf2->setPoint(23, 83);
	chkSf2->setSize(54, 19);
	add(chkSf2);

	ignoreToolbarSf2->setPoint(81, 83);
	ignoreToolbarSf2->setSize(152, 19);
	add(ignoreToolbarSf2);

	editSf2->setPoint(23, 102);
	editSf2->setSize(386, 19);
	add(editSf2);

	refSf2->setPoint(424, 95);
	refSf2->setSize(43, 24);
	add(refSf2);

	findSf2->setPoint(474, 95);
	findSf2->setSize(43, 24);
	add(findSf2);

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CSfForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR CSfForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFSF1:
			OnBnClickedRefsf1();

			return (INT_PTR)TRUE;

		case IDC_REFSF2:
			OnBnClickedRefsf2();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchSf3_1:
			OnBnClickedButtonsearchsf31();
			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchSf3_2:
			OnBnClickedButtonsearchsf32();
			return (INT_PTR)TRUE;
	}

	return BaseDialog::OnCommand(wParam);
}

void CSfForm::OnBnClickedRefsf1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks.plist"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.plist)\0*.plist\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("SafarĩubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_SfBM1 = path;
	m_chkSf1 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void CSfForm::OnBnClickedRefsf2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks.plist"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.plist)\0*.plist\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("SafarĩubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_SfBM2 = path;
	m_chkSf2 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void CSfForm::OnBnClickedButtonsearchsf31()
{
	UpdateData(TRUE);

	searchSf1(hWnd);

	UpdateData(FALSE);
}

void CSfForm::OnBnClickedButtonsearchsf32()
{
	UpdateData(TRUE);

	searchSf2(hWnd);

	UpdateData(FALSE);
}


bool CSfForm::confirm(HWND hWnd,tstring &bookmark,int pos)
{
	tstring msg;
	msg = _T("ubN}[Nt@C\n");
	msg += bookmark;
	msg += _T("\n");
	if (pos == 1){
		msg += _T("SafarĩubN}[N1ɐݒ肵܂H");
	}else{
		msg += _T("SafarĩubN}[N2ɐݒ肵܂H");
	}

	int answer;
	const TCHAR *title = _T("");
	title = _T("SafarĩubN}[N");

	answer = ::MessageBox(
		hWnd,
		msg.c_str(),
		title,
		MB_YESNO | MB_ICONQUESTION);

	if (answer == IDNO){
		return false;
	} else {
		return true;
	}
}

/**
 * SafarĩubN}[N1̌
 *
 */
void CSfForm::searchSf1(HWND hWnd)
{
	// Safari 1
	tstring bookmark = GetBookmark();
	if (bookmark != _T("")){
		if (bookmark != m_SfBM2) {
			if (confirm(hWnd,bookmark,1)) {
				m_SfBM1 = bookmark;
				m_chkSf1 = TRUE;
			}
		}
	}
}

/**
 * SafarĩubN}[N2̌
 *
 */
void CSfForm::searchSf2(HWND hWnd)
{
	// Safari 2
	tstring bookmark = GetBookmark();
	if (bookmark != _T("")){
		if (bookmark != m_SfBM1) {
			if (confirm(hWnd,bookmark,2)) {
				m_SfBM2 = bookmark;
				m_chkSf2 = TRUE;
			}
		}
	}

}

/**
 * SafarĩubN}[Nt@C̈ʒu擾B
 *
 */
tstring CSfForm::GetBookmark()
{
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR profileDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	/* ܂Aprofiles.iniTB */
	profiles[0] = _T('\0');
	memset(profiles, 0x00, _MAX_PATH * sizeof(TCHAR));
	memset(profileDir, 0x00, _MAX_PATH * sizeof(TCHAR));
	GetAppDataDir(profileDir);

	if (profileDir[0] != '\0'){
		_tcscpy(profiles,profileDir);
		_tcscat(profiles,_T("\\Apple Computer\\Safari\\Bookmarks.plist"));

		memset(&f,0x00,sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			// Ȃ甲B
			delete []profiles;
			return ret;
		}
		FindClose(h);
		ret = profiles;

	}

	delete []profiles;
	return ret;
}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CSfForm::setSettingEnable(void)
{
}
