#include "stdafx.h"
#include "shellapi.h"

#include "BookSyncApp.h"
#include "GuiDefine.h"
#include "PriorityDlg.h"
#include "util.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CPriorityDlg::CPriorityDlg(HWND parent, int resource) : BaseDialog(parent, resource)
{
	m_bookmarkList = NULL;
	for (int i = 0; i < ALL_BOOKMARKS; i++) {
		currentPriority[i] = i;
	}
	priority = NULL;

	upButton = NULL;
	downButton = NULL;
	okButton = NULL;
	cancelButton = NULL;
}

/**
 * fXgN^
 */
CPriorityDlg::~CPriorityDlg()
{
	if (font != NULL) {
		DeleteObject(font);
	}

	if (m_bookmarkList != NULL) {
		delete m_bookmarkList;
	}

	if (upButton == NULL) {
		delete upButton;
	}

	if (downButton == NULL) {
		delete downButton;
	}

	if (okButton == NULL) {
		delete okButton;
	}

	if (cancelButton == NULL) {
		delete cancelButton;
	}
}

/**
 * _CAO
 *
 * @return tH[JX̐ݒ肪(FALSE:)
 */
INT_PTR CPriorityDlg::OnInitDialog()
{
	m_bookmarkList = new TwrListbox(::GetDlgItem(hWnd, IDC_BOOKMARK_LIST));
	upButton = GetDlgItem(IDC_UP_PRI_BUTTON);
	downButton = GetDlgItem(IDC_DOWN_PRI_BUTTON);
	okButton = GetDlgItem(IDOK);
	cancelButton = GetDlgItem(IDCANCEL);

	int nextPos = 0;

	// ʂɍ܂ł̗Dx𔽉fB
	for (int i = 0; i < ALL_BOOKMARKS; i++) {

		// Ή̃ubN}[N͒ǉȂ
#ifndef WITH_EDGE
		if (priority[i] == BOOKMARK_EDGE) {
			continue;
		}
#endif

#ifndef WITH_WITH_OP15
		if ((priority[i] == BOOKMARK_OPERA15_1) || (priority[i] == BOOKMARK_OPERA15_2)) {
			continue;
		}
#endif

		currentPriority[nextPos] = priority[i];

		// O̔ԍ
		int nameNumber = currentPriority[nextPos];

		m_bookmarkList->addItem(bookmark_name[nameNumber]);
		nextPos++;
	}

	// Ή̃ubN}[N̗Dx͌
#ifndef WITH_EDGE
	currentPriority[nextPos] = BOOKMARK_EDGE;
	nextPos++;
#endif

#ifndef WITH_OP15
	currentPriority[nextPos] = BOOKMARK_OPERA15_1;
	nextPos++;
	currentPriority[nextPos] = BOOKMARK_OPERA15_2;
	nextPos++;
#endif

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	RECT r;

	// \ꂽEChËʒuIuWFNgɔfB
	GetWindowRect(hWnd, &r);
	setPoint(r.left, r.top);
	// EChȆ傫ݒ肷B
	setClientSize(365, 300);

	// eRg[̃NCAg̈̈ʒuƃTCY96dpi̎̈ʒuE傫Őݒ肵Ă
	m_bookmarkList->setPoint(12, 9);
	m_bookmarkList->setSize(299, 246);
	add(m_bookmarkList);

	upButton->setPoint(320, 91);
	upButton->setSize(27, 24);
	add(upButton);

	downButton->setPoint(320, 129);
	downButton->setSize(27, 24);
	add(downButton);

	okButton->setPoint(165, 263);
	okButton->setSize(89, 22);
	add(okButton);

	cancelButton->setPoint(259, 263);
	cancelButton->setSize(89, 22);
	add(cancelButton);

	SetFocus(m_bookmarkList->getHwnd());

	return (INT_PTR)FALSE;
}

/**
 * \ɌĂяo܂B
 */
void CPriorityDlg::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
	scaleChildren();

	// _CAOe̒ɔzuB
	RECT parentRect;

	GetWindowRect(getParent(), &parentRect);

	adjustCenter(parentRect, getParent(), this->hWnd);

}

/**
 * WM_COMMANDbZ[W̏
 *
 * @param wParam WPARAM
 */
INT_PTR CPriorityDlg::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_UP_PRI_BUTTON:
			OnBnClickedUpPriButton();

			return (INT_PTR)TRUE;
		case IDC_DOWN_PRI_BUTTON:
			OnBnClickedDownPriButton();

			return (INT_PTR)TRUE;
		case IDOK:
			OnBnClickedOk();

			break;
	}
	return BaseDialog::OnCommand(wParam);

}

/**
 * {^Ƃ̓
 */
void CPriorityDlg::OnBnClickedUpPriButton()
{
	int selected = m_bookmarkList->getSelectedIndex();
	if (selected == -1) {
		return;
	}

	if (selected == 0) {
		return;
	}
	// O̔ԍ
	int nameNumber = currentPriority[selected - 1];

	// Xg{bNX̖OI1ƌB
	m_bookmarkList->removeItem(selected - 1);
	m_bookmarkList->insertItem(selected,bookmark_name[nameNumber]);

	int tmp = currentPriority[selected - 1];
	currentPriority[selected - 1] = currentPriority[selected];
	currentPriority[selected] = tmp;
	m_bookmarkList->selectItem(selected - 1);
}

/**
 * {^Ƃ̓
 */
void CPriorityDlg::OnBnClickedDownPriButton()
{
	int selected = m_bookmarkList->getSelectedIndex();
	if (selected == -1) {
		return;
	}

	if (selected >= (SELECTABLE_BOOKMARKS - 1)) {
		// ԉ̏ꍇ͉Ȃ
		return;
	}
	// O̔ԍ
	int nameNumber = currentPriority[selected];

	// Xg{bNX̖OI1ƌB
	m_bookmarkList->removeItem(selected);
	m_bookmarkList->insertItem(selected + 1,bookmark_name[nameNumber]);

	int tmp = currentPriority[selected + 1];
	currentPriority[selected + 1] = currentPriority[selected];
	currentPriority[selected] = tmp;
	m_bookmarkList->selectItem(selected + 1);

}

/**
 * DPIωۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT CPriorityDlg::OnDpiChanged(void)
{
	// \p̃tHg蒼B
	if (font != NULL) {
		DeleteObject(font);
	}

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	return BaseDialog::OnDpiChanged();
}


#if 0
HWND priorityHwnd;
/**
 * 񋓂ꂽEChEnhɑ΂AtHgݒ肷B
 *
 * @param hwnd 񋓂ꂽEChEnh
 * @param lparam Ăьnꂽp[^(tHgnh)
 * @return TRUE 񋓂pB
 */
BOOL CALLBACK setPriorityFont(HWND hwnd, LPARAM lparam)
{
	//HFONT font = (HFONT)lparam;

	//SendMessage(hwnd, WM_SETFONT, (WPARAM)font, TRUE);

	// Capture control position
	char buf[256];
	RECT r;
	GetWindowRect(hwnd, &r);
	POINT p;
	p.x = r.left;
	p.y = r.top;
	ScreenToClient(priorityHwnd, &p);

	sprintf(buf, "->setPoint(%d, %d);\n->setSize(%d, %d);\nadd();\n",
		p.x, p.y, r.right - r.left + 1, r.bottom - r.top + 1);
	MessageBox(NULL, buf, "", MB_OK);
	// Capture control position end

	return TRUE;
}
#endif

/**
 * OK{^Ƃ̓
 */
void CPriorityDlg::OnBnClickedOk()
{
	// D揇ʂ𔽉fB
	if (priority != NULL) {
		for (int i = 0;i < ALL_BOOKMARKS;i++) {
			priority[i] = currentPriority[i];
		}
	}

#if 0
	//myHwnd = getHwnd();
	priorityHwnd = getHwnd();
	HWND w = getHwnd();
	EnumChildWindows(w, ::setPriorityFont, (LPARAM)font);
#endif
}
