#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "OperaForm.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
COperaForm::COperaForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_OperaBM1(_T(""))
	, m_OperaBM2(_T(""))
	, m_chkOpera1(FALSE)
	, m_chkOpera2(FALSE)
	, m_chkOpera7_1(TRUE)
	, m_chkOpera7_2(TRUE)
	, m_Opera7Trash1(FALSE)
	, m_Opera7Trash2(FALSE)
	, m_WinMobile1(FALSE)
	, m_WinMobile2(FALSE)
	, m_SyncMobileFavorites1(FALSE)
	, m_SyncMobileFavorites2(FALSE)
{
	editOpera1 = NULL;
	editOpera2 = NULL;
	chkOpera1 = NULL;
	chkOpera2 = NULL;
	ignoreTrash1 = NULL;
	ignoreTrash2 = NULL;
	mobileFormat1 = NULL;
	mobileFormat2 = NULL;
	syncMobile1 = NULL;
	syncMobile2 = NULL;
	groupOpera1 = NULL;
	groupOpera2 = NULL;
	refOpera1 = NULL;
	refOpera2 = NULL;
	findOpera1 = NULL;
	findOpera2 = NULL;
}

COperaForm::~COperaForm()
{
	if (editOpera1 != NULL) {
		delete editOpera1;
	}
	if (editOpera2 != NULL) {
		delete editOpera2;
	}
	if (chkOpera1 != NULL) {
		delete chkOpera1;
	}
	if (chkOpera2 != NULL) {
		delete chkOpera2;
	}
	if (ignoreTrash1 != NULL) {
		delete ignoreTrash1;
	}
	if (ignoreTrash2 != NULL) {
		delete ignoreTrash2;
	}
	if (mobileFormat1 != NULL) {
		delete mobileFormat1;
	}
	if (mobileFormat2 != NULL) {
		delete mobileFormat2;
	}
	if (syncMobile1 != NULL) {
		delete syncMobile1;
	}
	if (syncMobile2 != NULL) {
		delete syncMobile2;
	}
	if (groupOpera1 == NULL) {
		delete groupOpera1;
	}

	if (groupOpera2 == NULL) {
		delete groupOpera2;
	}

	if (refOpera1 == NULL) {
		delete refOpera1;
	}

	if (refOpera2 == NULL) {
		delete refOpera2;
	}

	if (findOpera1 == NULL) {
		delete findOpera1;
	}

	if (findOpera2 == NULL) {
		delete findOpera2;
	}
}

void COperaForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITOPERA1, m_OperaBM1);
	DDX_Text(toObj, IDC_EDITOPERA2, m_OperaBM2);
	DDX_Check(toObj, IDC_CHECKOPERA1, m_chkOpera1);
	DDX_Check(toObj, IDC_CHECKOPERA2, m_chkOpera2);
	DDX_Check(toObj, IDC_NOO7TRASH1, m_Opera7Trash1);
	DDX_Check(toObj, IDC_NOO7TRASH2, m_Opera7Trash2);
	DDX_Check(toObj, IDC_CHECKMOBILE1, m_WinMobile1);
	DDX_Check(toObj, IDC_CHECKMOBILE2, m_WinMobile2);
	DDX_Check(toObj, IDC_CHECKSYNCMOBILE1, m_SyncMobileFavorites1);
	DDX_Check(toObj, IDC_CHECKSYNCMOBILE2, m_SyncMobileFavorites2);
}

INT_PTR COperaForm::OnInitDialog()
{
	editOpera1 = GetDlgItem(IDC_EDITOPERA1);
	editOpera2 = GetDlgItem(IDC_EDITOPERA2);
	chkOpera1 = GetDlgItem(IDC_CHECKOPERA1);
	chkOpera2 = GetDlgItem(IDC_CHECKOPERA2);
	ignoreTrash1 = GetDlgItem(IDC_NOO7TRASH1);
	ignoreTrash2 = GetDlgItem(IDC_NOO7TRASH2);
	mobileFormat1 = GetDlgItem(IDC_CHECKMOBILE1);
	mobileFormat2 = GetDlgItem(IDC_CHECKMOBILE2);
	syncMobile1 = GetDlgItem(IDC_CHECKSYNCMOBILE1);
	syncMobile2 = GetDlgItem(IDC_CHECKSYNCMOBILE2);
	groupOpera1 = GetDlgItem(IDC_GroupOpera);
	groupOpera2 = GetDlgItem(IDC_GroupOpera2);
	refOpera1 = GetDlgItem(IDC_REFOPERA1);
	refOpera2 = GetDlgItem(IDC_REFOPERA2);
	findOpera1 = GetDlgItem(IDC_BUTTONSearchOp1);
	findOpera2 = GetDlgItem(IDC_BUTTONSearchOp2);

	// I[gRv[gݒ肷B
	setAutoComplete(editOpera1->getHwnd());
	setAutoComplete(editOpera2->getHwnd());

	UpdateData(false);

	groupOpera1->setPoint(7, 5);
	groupOpera1->setSize(523, 86);
	add(groupOpera1);

	chkOpera1->setPoint(23, 23);
	chkOpera1->setSize(54, 19);
	add(chkOpera1);

	ignoreTrash1->setPoint(84, 23);
	ignoreTrash1->setSize(115, 19);
	add(ignoreTrash1);

	mobileFormat1->setPoint(23, 44);
	mobileFormat1->setSize(192, 19);
	add(mobileFormat1);

	syncMobile1->setPoint(219, 44);
	syncMobile1->setSize(162, 19);
	add(syncMobile1);

	editOpera1->setPoint(23, 64);
	editOpera1->setSize(386, 19);
	add(editOpera1);

	refOpera1->setPoint(424, 57);
	refOpera1->setSize(43, 24);
	add(refOpera1);

	findOpera1->setPoint(474, 57);
	findOpera1->setSize(43, 24);
	add(findOpera1);

	groupOpera2->setPoint(7, 92);
	groupOpera2->setSize(523, 86);
	add(groupOpera2);

	chkOpera2->setPoint(23, 110);
	chkOpera2->setSize(54, 19);
	add(chkOpera2);

	ignoreTrash2->setPoint(84, 110);
	ignoreTrash2->setSize(115, 19);
	add(ignoreTrash2);

	mobileFormat2->setPoint(23, 131);
	mobileFormat2->setSize(192, 19);
	add(mobileFormat2);

	syncMobile2->setPoint(219, 131);
	syncMobile2->setSize(162, 19);
	add(syncMobile2);

	editOpera2->setPoint(23, 151);
	editOpera2->setSize(386, 19);
	add(editOpera2);

	refOpera2->setPoint(424, 144);
	refOpera2->setSize(43, 24);
	add(refOpera2);

	findOpera2->setPoint(474, 144);
	findOpera2->setSize(43, 24);
	add(findOpera2);

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void COperaForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR COperaForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFOPERA1:
			OnBnClickedRefopera1();

			return (INT_PTR)TRUE;

		case IDC_REFOPERA2:
			OnBnClickedRefopera2();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchOp1:
			OnBnClickedButtonsearchop1();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchOp2:
			OnBnClickedButtonsearchop2();

			return (INT_PTR)TRUE;
	}

	return BaseDialog::OnCommand(wParam);
}

void COperaForm::OnBnClickedRefopera1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("opera6.adr"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Opera 12 Bookmark file(*.adr)\0*.adr\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Opera 12ȑÕubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_OperaBM1 = path;
	m_chkOpera1 = TRUE;
	
	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void COperaForm::OnBnClickedRefopera2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("opera6.adr"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Opera 12 Bookmark file(*.adr)\0*.adr\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Opera 12ȑÕubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_OperaBM2 = path;
	m_chkOpera2 = TRUE;
	
	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void COperaForm::OnBnClickedButtonsearchop1()
{
	UpdateData(true);

	searchOpera(hWnd );

	UpdateData(false);
}

void COperaForm::OnBnClickedButtonsearchop2()
{
	UpdateData(true);

	searchOpera2(hWnd);

	UpdateData(false);
}

/**
 * OperãubN}[N1̌oɓB
 *
 * @param hWnd eEChẼEChEnh
 */
void COperaForm::searchOpera(HWND hWnd)
{
	// ݒ̏ꍇAOperãubN}[ŇoɓB
	tstring bookmark = CheckOperaBookmark(hWnd,0);

	if (bookmark != _T("")){
		// 炱ݒ肷B
		m_OperaBM1 = bookmark;
		m_chkOpera1 = TRUE;
	}
}

/**
 * OperãubN}[N2̌oɓB
 *
 * @param hWnd eEChẼEChEnh
 */
void COperaForm::searchOpera2(HWND hWnd)
{
	// ݒ̏ꍇAOperãubN}[ŇoɓB
	tstring bookmark = CheckOperaBookmark(hWnd,1);

	if (bookmark != _T("")){
		// 炱ݒ肷B
		m_OperaBM2 = bookmark;
		m_chkOpera2 = TRUE;
	}
}

/**
 * OperãubN}[NB 
 *
 * @param hWnd eEChẼnh
 * @return OperãubN}[Nt@C
 */
tstring COperaForm::CheckOperaBookmark(HWND hWnd,int no)
{
	int answer;
	tstring ret = _T("");
	TCHAR *buf;

	try{
		buf = new TCHAR[_MAX_PATH + 1024];
		if (buf == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	// Opera 10ȍ~VO[U[ŎgpƂ̃ubN}[NoB
	// Application DataɃf[^ĂA炪݂ꍇ͂D悷B
	// }`[U[OperaACXg[VO[U[ŃCXg[
	// VO[U[p̐ݒ肪D悳邽߁B
	ret = GetOpera10SingleBookmark();
	if (ret != _T("")){
		if ( ((no == 0) && (ret != m_OperaBM2)) || 
			 ((no == 1) && (ret != m_OperaBM1)) ){
			answer = setBookmarkQuestion(
				hWnd,
				_T("Opera 10`12(VO[U[)̃ubN}[N"),
				ret.c_str(),no);

			if (answer == IDYES){
				delete []buf;
				return ret;
			}
		}
	}

	// Opera 7`9.6VO[U[ŎgpƂ̃ubN}[NoB
	// Application DataɃf[^ĂA炪݂ꍇ͂D悷B
	// }`[U[OperaACXg[VO[U[ŃCXg[
	// VO[U[p̐ݒ肪D悳邽߁B
	ret = GetOpera7SingleBookmark();
	if (ret != _T("")){
		if ( ((no == 0) && (ret != m_OperaBM2)) || 
			 ((no == 1) && (ret != m_OperaBM1)) ){
			answer = setBookmarkQuestion(
				hWnd,
				_T("Opera 7`9(VO[U[)̃ubN}[N"),
				ret.c_str(),no);

			if (answer == IDYES){
				delete []buf;
				return ret;
			}
		}
	}

	// }`[U[̃ubN}[N
	HANDLE hFind;
	WIN32_FIND_DATA dat;
	TCHAR operaProfile[_MAX_PATH];

	GetAppDataDir(operaProfile);
	if (operaProfile[0] != _T('\0')){
		_tcscat(operaProfile,_T("\\Opera\\*"));
	}
	memset(&dat,0x00,sizeof(WIN32_FIND_DATA));

	// %AppData%\Operaz̊etH_B
	hFind = FindFirstFile(operaProfile,&dat);

	if (hFind != INVALID_HANDLE_VALUE){
		do {
			// 1̃fBNĝ͔΂B
			if (!_tcscmp(dat.cFileName,_T(".."))) {
				continue;
			}
			// fBNĝ͔΂B
			if (!_tcscmp(dat.cFileName,_T("."))) {
				continue;
			}
			if (!(dat.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
				continue;
			}
			// Opera 10̃ubN}[N邩ǂ𒲂ׂB
			ret = GetOpera10Bookmark(dat.cFileName);
			if (ret != _T("")){
				if ( ((no == 0) && (ret != m_OperaBM2)) || 
					 ((no == 1) && (ret != m_OperaBM1)) ){
					answer = setBookmarkQuestion(
						hWnd,
						_T("Opera 10`12(}`[U[)̃ubN}[N"),
						ret.c_str(),no);

					if (answer == IDYES){
						FindClose(hFind);
						delete []buf;
						return ret;
					}
				}
			} else {
				// Opera 10̃ubN}[NȂꍇOpera 7`9.6
				// ubN}[N𒲂ׂB
				ret = GetOperaXXBookmark(dat.cFileName);
				if (ret != _T("")){
					if ( ((no == 0) && (ret != m_OperaBM2)) || 
						((no == 1) && (ret != m_OperaBM1)) ){
						answer = setBookmarkQuestion(
							hWnd,
							_T("Opera 7`9(}`[U[)̃ubN}[N"),
							ret.c_str(),no);

						if (answer == IDYES){
							FindClose(hFind);
							delete []buf;
							return ret;
						}
					}
				}
			}
		}while(FindNextFile(hFind,&dat));
		FindClose(hFind);
	}else{
		// ubN}[N݂͑ȂB
		ret = _T("");
	}

	// Opera 7̃ubN}[NołȂꍇAOpera 6̃ubN}[NoB
	ret = GetOpera6Bookmark();
	if (ret != _T("")){
		if ( ((no == 0) && (ret != m_OperaBM2)) || 
			 ((no == 1) && (ret != m_OperaBM1)) ){
			answer = setBookmarkQuestion(
				hWnd,
				_T("Opera 6̃ubN}[N"),
				ret.c_str(),no);
			if (answer != IDYES){
				ret = _T("");
			}
		}else{
			ret = _T("");
		}
	}

	delete []buf;
	return ret;
}

int COperaForm::setBookmarkQuestion(HWND hWnd,const TCHAR *target,const TCHAR *path,int no)
{
	TCHAR *buf;

	try{
		buf = new TCHAR[_MAX_PATH + 1024];
		if (buf == NULL){
			return IDNO;
		}
	}catch(...){
		return IDNO;
	}

	_tcscpy(buf,target);
	_tcscat(buf,_T("\n"));
	_tcscat(buf,path);
	_tcscat(buf,_T("\nOperãubN}[N"));
	if (no == 0){
		_tcscat(buf,_T("1"));
	}else{
		_tcscat(buf,_T("2"));
	}
	_tcscat(buf,_T("ɐݒ肵܂H"));

	int answer = ::MessageBox(hWnd,buf,target,MB_YESNO | MB_ICONQUESTION);
	delete []buf;

	return answer;
}

// Opera 6̃ubN}[NoB
tstring COperaForm::GetOpera6Bookmark()
{
	TCHAR *OperaPath = NULL,*OperaBookmark = NULL,*p,*lastDelim = NULL;
	tstring ret = _T("");
	LONG regresult;
	DWORD len;
	HKEY key;

	try{
		OperaPath = new TCHAR[_MAX_PATH];
		if (OperaPath == NULL){
			return ret;
		}
		OperaBookmark = new TCHAR[_MAX_PATH];
		if (OperaBookmark == NULL){
			delete []OperaPath;
			return ret;
		}
	}catch(...){
		if (OperaPath != NULL)
			delete []OperaPath;
		if (OperaBookmark != NULL)
			delete []OperaBookmark;
		return ret;
	}

	regresult = ::RegOpenKeyEx(HKEY_CURRENT_USER,
		_T("Software\\Opera Software"),0,KEY_READ,&key);
	if (regresult != ERROR_SUCCESS){
		ret = _T("");
	}else{
		len = _MAX_PATH;
		_tcscpy(OperaPath,_T(""));
		//regresult = ::RegQueryValueEx(key,"Last Directory",NULL,NULL,(LPBYTE)OperaPath,&len);
		// Œۏ؂Ă̂͂ꂾB
		regresult = ::RegQueryValueEx(
			key,
			_T("Last CommandLine"),
			NULL,NULL,(LPBYTE)OperaPath,&len);
		if (regresult == ERROR_SUCCESS){
			//MessageBox(NULL,OperaPath,"test",MB_OK);

			// Ō̃fBNg؂肩؂B
			p = OperaPath;
			while(*p){
				if (isleadbyte(*p)){
					p++;
				}else{
					if (*p == _T('\\')){
						lastDelim = p;
					}
				}
				p++;
			}
			if (lastDelim != NULL){
				*lastDelim = _T('\0');
			}

			if (::_tcslen(OperaPath) > 0){
				::_tcscat(OperaPath,_T("\\Opera6.ini"));
				ret = getOperaBookmarkName(OperaPath);
			}
		}else{
			// Opera6̓CXg[ĂȂB
			ret = _T("");
		}
		::RegCloseKey(key);
	}
	//MessageBox(NULL,ret,"test",MB_OK);

	delete [] OperaPath;
	delete [] OperaBookmark;
	return ret;
}

/* Opera 7.5̃ubN}[Nt@C̈ʒuw肷B */
tstring COperaForm::GetOperaXXBookmark(TCHAR *version)
{
	tstring ret;
	tstring profileDefaultBookmark;
	TCHAR *OperaPath = NULL;
	ret = _T("");

	try{
		OperaPath = new TCHAR[_MAX_PATH];
		if (OperaPath == NULL){
			return ret;
		}
	}catch(...){
	}

	OperaPath[0] = _T('\0');
	//GetAppDataDir(OperaPath);
	if (OperaPath[0] != _T('\0')){
		// _tcscat(OperaPath,"\\Opera\\Opera");
		_tcscat(OperaPath,_T("\\Opera\\"));
		_tcscat(OperaPath,version);

		// Opera 9.x܂ł̃ftHg̃ubN}[NĂB
		profileDefaultBookmark = OperaPath;
		profileDefaultBookmark += _T("\\profile\\Opera6.adr");

		_tcscat(OperaPath,_T("\\profile\\Opera6.ini"));

		ret = getOperaBookmarkName(OperaPath);
		if (ret == _T("")) {
			if (isExistingFile(profileDefaultBookmark.c_str())) {
				ret = profileDefaultBookmark;
			}
		}

	}
	//MessageBox(NULL,OperaPath,"Test",MB_OK);

	delete []OperaPath;
	return ret;
}

/* Opera 10̃ubN}[Nt@C̈ʒuw肷B */
tstring COperaForm::GetOpera10Bookmark(TCHAR *version)
{
	tstring ret;
	tstring profileDefaultBookmark;
	tstring opera10Bookmark;
	TCHAR *OperaPath = NULL;
	ret = _T("");

	try{
		OperaPath = new TCHAR[_MAX_PATH];
		if (OperaPath == NULL){
			return ret;
		}
	}catch(...){
	}

	OperaPath[0] = _T('\0');
	GetAppDataDir(OperaPath);
	if (OperaPath[0] != _T('\0')){
		// _tcscat(OperaPath,"\\Opera\\Opera");
		_tcscat(OperaPath,_T("\\Opera\\"));
		_tcscat(OperaPath,version);

		// Opera 10̃ftHg̃ubN}[NĂB
		opera10Bookmark = OperaPath;
		opera10Bookmark += _T("\\bookmarks.adr");

		_tcscat(OperaPath,_T("\\operaprefs.ini"));

		ret = getOperaBookmarkName(OperaPath);
		if (ret == _T("")) {
			if (isExistingFile(opera10Bookmark.c_str())) {
				ret = opera10Bookmark;
			}
		}

	}
	//MessageBox(NULL,OperaPath,"Test",MB_OK);

	delete []OperaPath;
	return ret;
}

/**
 * Opera 7`9VO[U[Ŏgꍇ̃ubN}[ÑtpX擾B
 *
 * @return 擾ubN}[ÑtpX(݂Ȃ͋󕶎)
 */
tstring COperaForm::GetOperaBasePath(void)
{
	TCHAR *OperaPath = NULL,*OperaBookmark = NULL,*p,*lastDelim = NULL;
	tstring ret;
	LONG regresult;
	DWORD len;
	HKEY key;

	try{
		OperaPath = new TCHAR[_MAX_PATH];
		if (OperaPath == NULL){
			ret = _T("");
			return ret;
		}
		OperaBookmark = new TCHAR[_MAX_PATH];
		if (OperaBookmark == NULL){
			delete []OperaPath;
			ret = _T("");
			return ret;
		}
	}catch(...){
		if (OperaPath != NULL)
			delete []OperaPath;
		if (OperaBookmark != NULL)
			delete []OperaBookmark;
		ret = _T("");
		return ret;
	}

	regresult = ::RegOpenKeyEx(
		HKEY_CURRENT_USER,
		_T("Software\\Opera Software"),
		0,KEY_READ,&key);
	if (regresult != ERROR_SUCCESS){
		ret = _T("");
	}else{
		len = _MAX_PATH;
		_tcscpy(OperaPath,_T(""));
		//regresult = ::RegQueryValueEx(key,"Last Directory",NULL,NULL,(LPBYTE)OperaPath,&len);
		// Œۏ؂Ă̂͂ꂾB
		regresult = ::RegQueryValueEx(
			key,
			_T("Last CommandLine v2"),
			NULL,NULL,(LPBYTE)OperaPath,&len);
		if (regresult == ERROR_SUCCESS){
			//MessageBox(NULL,OperaPath,"test",MB_OK);

			// Ō̃fBNg؂肩؂B
			bool driveFlag = false;
			p = OperaPath;
			while(*p){
				if (isleadbyte(*p)){
					p++;
				}else{
					if (*p == _T('\\')){
						lastDelim = p;
					}
				}
				if (*p == _T(':')){
					if (driveFlag){
						// 2߂̃tpXɓ̂ŉ͂߂B
						break;
					}else{
						// ŏ̃tpX
						driveFlag = true;
					}
				}
				p++;
			}
			if (lastDelim != NULL){
				*lastDelim = _T('\0');
			}
			ret = OperaPath;
		}else{
			// Opera 7̃vt@C͂ȂB
			ret = _T("");
		}
		::RegCloseKey(key);
	}

	delete [] OperaPath;
	delete [] OperaBookmark;
	return ret;
}

/**
 * Opera 7`9VO[U[Ŏgꍇ̃ubN}[ÑtpX擾B
 *
 * @return 擾ubN}[ÑtpX(݂Ȃ͋󕶎)
 */
tstring COperaForm::GetOpera7SingleBookmark(void)
{
	tstring ret;
	tstring basePath;
	tstring iniPath;

	basePath = GetOperaBasePath();
	if (basePath == _T("")) {
		ret = _T("");
		return ret;
	}

	tstring opera9Bookmark = basePath;
	opera9Bookmark += _T("\\profile\\Opera6.adr");

	// Opera6.iniǂݍށB
	iniPath = basePath + _T("\\profile\\Opera6.ini");
	ret = getOperaBookmarkName(iniPath.c_str());

	if (ret == _T("")) {
		// Opera6.iniɃubN}[N̋LqȂꍇ
		// ftHg̃ubN}[N݂邩ǂׂB
		if (isExistingFile(opera9Bookmark.c_str())) {
			ret = opera9Bookmark;
		}
	}

	return ret;
}

/**
 * Opera 10VO[U[Ŏgꍇ̃ubN}[ÑtpX擾B
 *
 * @return 擾ubN}[ÑtpX(݂Ȃ͋󕶎)
 */
tstring COperaForm::GetOpera10SingleBookmark(void)
{
	tstring ret;
	tstring basePath;
	tstring iniPath;

	basePath = GetOperaBasePath();
	if (basePath == _T("")) {
		ret = _T("");
		return ret;
	}

	tstring opera10Bookmark = basePath;
	opera10Bookmark += _T("\\profile\\bookmarks.adr");

	// operaprefs.iniǂݍށB
	iniPath = basePath + _T("\\profile\\operaprefs.ini");
	ret = getOperaBookmarkName(iniPath.c_str());

	if (ret == _T("")) {
		// operaprefs.iniɃubN}[N̋LqȂꍇ
		// ftHg̃ubN}[N݂邩ǂׂB
		if (isExistingFile(opera10Bookmark.c_str())) {
			ret = opera10Bookmark;
		}
	}

	return ret;
}

/**
 * opera6.iniOperãubN}[Nt@C擾B
 * 
 * @param prefFile opera6.inĩtpX
 * @return 擾ubN}[Nt@C
 */
tstring COperaForm::getOperaBookmarkName(const TCHAR *prefFile)
{
	TCHAR *OperaBookmark = NULL;	// 擾ubN}[Nt@C̊i[obt@
	tstring ret;				// l߂߂CString
	ret = _T("");

	try{
		OperaBookmark = new TCHAR[_MAX_PATH];
		if (OperaBookmark == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	::GetPrivateProfileString(
		_T("User Prefs"),
		_T("Hot List File Ver2"),
		_T(""),
		OperaBookmark,
		_MAX_PATH,
		prefFile);

	// ubN}[N{ɑ݂邩ǂ`FbNB
	if (isExistingFile((LPCTSTR)OperaBookmark)) {
		// ubN}[N݂
		ret = OperaBookmark;
	}else{
		// ubN}[N݂͑Ȃ
		ret = _T("");
	}

	delete []OperaBookmark;

	return ret;
}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void COperaForm::setSettingEnable(void)
{
}
