#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "Op19Form.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
COp19Form::COp19Form(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_Op19BM1(_T(""))
	, m_Op19BM2(_T(""))
	, m_chkOp19_1(FALSE)
	, m_chkOp19_2(FALSE)
	, m_chkInFolder1(TRUE)
	, m_chkInFolder2(TRUE)
	, m_chkIgnoreToolbar1(FALSE)
	, m_chkIgnoreToolbar2(FALSE)
	, m_Opera19Trash1(TRUE)
	, m_Opera19Trash2(TRUE)
	, m_chkNoUnsorted1(FALSE)
	, m_chkNoUnsorted2(FALSE)
	, m_chkOp29SpeedDial(FALSE)
{
	editOp19_1 = NULL;
	editOp19_2 = NULL;
	chkOp19_1 = NULL;
	chkOp19_2 = NULL;
	ignoreToolbarOp19_1 = NULL;
	ignoreToolbarOp19_2 = NULL;
	inFolderOp19_1 = NULL;
	inFolderOp19_2 = NULL;
	chkOp19Trash_1 = NULL;
	chkOp19Trash_2 = NULL;
	ignoreUnsort_1 = NULL;
	ignoreUnsort_2 = NULL;
	chkOp29SpeedDial = NULL;
	groupOp19_1 = NULL;
	groupOp19_2 = NULL;
	refOp19_1 = NULL;
	refOp19_2 = NULL;
	findOp19_1 = NULL;
	findOp19_2 = NULL;
}

/**
 * fXgN^
 */
COp19Form::~COp19Form()
{
	if (editOp19_1 != NULL) {
		delete editOp19_1;
	}
	if (editOp19_2 != NULL) {
		delete editOp19_2;
	}
	if (chkOp19_1 != NULL) {
		delete chkOp19_1;
	}
	if (chkOp19_2 != NULL) {
		delete chkOp19_2;
	}
	if (ignoreToolbarOp19_1 != NULL) {
		delete ignoreToolbarOp19_1;
	}
	if (ignoreToolbarOp19_2 != NULL) {
		delete ignoreToolbarOp19_2;
	}
	if (inFolderOp19_1 != NULL) {
		delete inFolderOp19_1;
	}
	if (inFolderOp19_2 != NULL) {
		delete inFolderOp19_2;
	}
	if (chkOp19Trash_1 != NULL) {
		delete chkOp19Trash_1;
	}
	if (chkOp19Trash_2 != NULL) {
		delete chkOp19Trash_2;
	}
	if (chkOp29SpeedDial != NULL) {
		delete chkOp29SpeedDial;
	}

	if (ignoreUnsort_1 != NULL) {
		delete ignoreUnsort_1;
	}
	if (ignoreUnsort_2 != NULL) {
		delete ignoreUnsort_2;
	}

	if (groupOp19_1 == NULL) {
		delete groupOp19_1;
	}

	if (groupOp19_2 == NULL) {
		delete groupOp19_2;
	}

	if (refOp19_1 == NULL) {
		delete refOp19_1;
	}

	if (refOp19_2 == NULL) {
		delete refOp19_2;
	}

	if (findOp19_1 == NULL) {
		delete findOp19_1;
	}

	if (findOp19_2 == NULL) {
		delete findOp19_2;
	}
}

/**
 * f[^XV
 *
 * @param toObj true:Rg[̏ԂIuWFNgɐݒ肷B false:IuWFNg̏ԂRg[ɐݒ肷B
 */
void COp19Form::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITOP19_1, m_Op19BM1);
	DDX_Text(toObj, IDC_EDITOP19_2, m_Op19BM2);
	DDX_Check(toObj, IDC_CHECKOP19_1, m_chkOp19_1);
	DDX_Check(toObj, IDC_CHECKOP19_2, m_chkOp19_2);
	DDX_Check(toObj, IDC_CHECK_O19_TOOLBAR_IGNORE1, m_chkIgnoreToolbar1);
	DDX_Check(toObj, IDC_CHECK_O19_TOOLBAR_IGNORE2, m_chkIgnoreToolbar2);
	DDX_Check(toObj, IDC_NOO19TRASH1, m_Opera19Trash1);
	DDX_Check(toObj, IDC_NOO19TRASH2, m_Opera19Trash2);
	DDX_Check(toObj, IDC_NOO19UNSORT1, m_chkNoUnsorted1);
	DDX_Check(toObj, IDC_NOO19UNSORT2, m_chkNoUnsorted2);

	DDX_Check(toObj, IDC_CHECKOP29SPEEDDIAL, m_chkOp29SpeedDial);

}

/**
 * _CAȌ
 *
 * @return FALSE
 */
INT_PTR COp19Form::OnInitDialog()
{
	editOp19_1 = GetDlgItem(IDC_EDITOP19_1);
	editOp19_2 = GetDlgItem(IDC_EDITOP19_2);
	chkOp19_1 = GetDlgItem(IDC_CHECKOP19_1);
	chkOp19_2 = GetDlgItem(IDC_CHECKOP19_2);
	ignoreToolbarOp19_1 = GetDlgItem(IDC_CHECK_O19_TOOLBAR_IGNORE1);
	ignoreToolbarOp19_2 = GetDlgItem(IDC_CHECK_O19_TOOLBAR_IGNORE2);
	chkOp19Trash_1 = GetDlgItem(IDC_NOO19TRASH1);
	chkOp19Trash_2 = GetDlgItem(IDC_NOO19TRASH2);
	chkOp29SpeedDial = GetDlgItem(IDC_CHECKOP29SPEEDDIAL);
	groupOp19_1 = GetDlgItem(IDC_GroupOp19_1);
	groupOp19_2 = GetDlgItem(IDC_GroupOP19_2);
	refOp19_1 = GetDlgItem(IDC_REFOP19_1);
	refOp19_2 = GetDlgItem(IDC_REFOP19_2);
	findOp19_1 = GetDlgItem(IDC_BUTTONSearchOP19_1);
	findOp19_2 = GetDlgItem(IDC_BUTTONSearchOP19_2);
	ignoreUnsort_1 = GetDlgItem(IDC_NOO19UNSORT1);
	ignoreUnsort_2 = GetDlgItem(IDC_NOO19UNSORT2);

	// I[gRv[gݒ肷B
	setAutoComplete(editOp19_1->getHwnd());
	setAutoComplete(editOp19_2->getHwnd());

	UpdateData(false);

	groupOp19_1->setPoint(7, 5);
	groupOp19_1->setSize(524, 65);
	add(groupOp19_1);

	chkOp19_1->setPoint(23, 21);
	chkOp19_1->setSize(54, 19);
	add(chkOp19_1);

	ignoreToolbarOp19_1->setPoint(81, 21);
	ignoreToolbarOp19_1->setSize(152, 19);
	add(ignoreToolbarOp19_1);

	chkOp19Trash_1->setPoint(233, 21);
	chkOp19Trash_1->setSize(115, 19);
	add(chkOp19Trash_1);

	ignoreUnsort_1->setPoint(348, 21);
	ignoreUnsort_1->setSize(175, 19);
	add(ignoreUnsort_1);

	editOp19_1->setPoint(23, 44);
	editOp19_1->setSize(386, 19);
	add(editOp19_1);

	refOp19_1->setPoint(427, 42);
	refOp19_1->setSize(43, 24);
	add(refOp19_1);

	findOp19_1->setPoint(478, 42);
	findOp19_1->setSize(43, 24);
	add(findOp19_1);

	// ubN}[N2
	groupOp19_2->setPoint(7, 71);
	groupOp19_2->setSize(524, 65);
	add(groupOp19_2);

	chkOp19_2->setPoint(23, 88);
	chkOp19_2->setSize(54, 19);
	add(chkOp19_2);

	ignoreToolbarOp19_2->setPoint(81, 88);
	ignoreToolbarOp19_2->setSize(152, 19);
	add(ignoreToolbarOp19_2);

	chkOp19Trash_2->setPoint(233, 88);
	chkOp19Trash_2->setSize(115, 19);
	add(chkOp19Trash_2);

	ignoreUnsort_2->setPoint(348, 88);
	ignoreUnsort_2->setSize(175, 19);
	add(ignoreUnsort_2);

	editOp19_2->setPoint(23, 110);
	editOp19_2->setSize(386, 19);
	add(editOp19_2);

	refOp19_2->setPoint(427, 107);
	refOp19_2->setSize(43, 24);
	add(refOp19_2);

	findOp19_2->setPoint(478, 107);
	findOp19_2->setSize(43, 24);
	add(findOp19_2);

	chkOp29SpeedDial->setPoint(23, 141);
	chkOp29SpeedDial->setSize(341, 19);
	add(chkOp29SpeedDial);

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void COp19Form::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR COp19Form::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFOP19_1:
			OnBnClickedRefOp19_1();

			return (INT_PTR)TRUE;

		case IDC_REFOP19_2:
			OnBnClickedRefOp19_2();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchOP19_1:
			OnBnClickedButtonsearchOp19_1();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchOP19_2:
			OnBnClickedButtonsearchOp19_2();

			return (INT_PTR)TRUE;
	}

	return BaseDialog::OnCommand(wParam);
}

/**
 * Opera 19̃ubN}[N1̎Qƃ{^ꂽƂ̏
 *
 */
void COp19Form::OnBnClickedRefOp19_1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Opera 25ȍ~̃ubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_Op19BM1 = path;
	m_chkOp19_1 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

/**
 * Opera 19̃ubN}[N2̎Qƃ{^ꂽƂ̏
 *
 */
void COp19Form::OnBnClickedRefOp19_2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Opera 25ȍ~̃ubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_Op19BM2 = path;
	m_chkOp19_2 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void COp19Form::OnBnClickedButtonsearchOp19_1()
{
	UpdateData(true);

	searchOp19_1(hWnd);

	UpdateData(false);
}

void COp19Form::OnBnClickedButtonsearchOp19_2()
{
	UpdateData(true);

	searchOp19_2(hWnd);

	UpdateData(false);
}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void COp19Form::setSettingEnable(void)
{
}

/**
 * Opera 19ȍ~̃ubN}[N1̌
 *
 */
void COp19Form::searchOp19_1(HWND hWnd)
{
	tstring bookmark = GetBookmark(_T(OP19_STABLE_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op19BM2) {
			if (confirm(hWnd,bookmark,1, 0)) {
				m_Op19BM1 = bookmark;
				m_chkOp19_1 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(OP19_NEXT_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op19BM2) {
			if (confirm(hWnd, bookmark, 1, 1)) {
				m_Op19BM1 = bookmark;
				m_chkOp19_1 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(OP19_DEVELOPER_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op19BM2) {
			if (confirm(hWnd, bookmark, 1, 2)) {
				m_Op19BM1 = bookmark;
				m_chkOp19_1 = TRUE;
				return;
			}
		}
	}
}

/**
 * Opera 19ȍ~̃ubN}[N2̌
 *
 */
void COp19Form::searchOp19_2(HWND hWnd)
{
	tstring bookmark = GetBookmark(_T(OP19_STABLE_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op19BM1) {
			if (confirm(hWnd, bookmark, 2, 0)) {
				m_Op19BM2 = bookmark;
				m_chkOp19_2 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(OP19_NEXT_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op19BM1) {
			if (confirm(hWnd, bookmark, 2, 1)) {
				m_Op19BM2 = bookmark;
				m_chkOp19_2 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(OP19_DEVELOPER_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op19BM1) {
			if (confirm(hWnd, bookmark, 2, 2)) {
				m_Op19BM2 = bookmark;
				m_chkOp19_2 = TRUE;
				return;
			}
		}
	}

}

/**
 * Opera 19ȍ~̃ubN}[Nt@C̈ʒu擾B
 *
 */
tstring COp19Form::GetBookmark(const TCHAR *path)
{
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR profileDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	/* ܂Aprofiles.iniTB */
	profiles[0] = _T('\0');
	memset(profiles, 0x00, _MAX_PATH * sizeof(TCHAR));
	memset(profileDir, 0x00, _MAX_PATH * sizeof(TCHAR));
	GetAppDataDir(profileDir);

	if (profileDir[0] != '\0'){
		_tcscpy(profiles,profileDir);
		_tcscat(profiles, path);

		memset(&f,0x00,sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			// Ȃ甲B
			delete []profiles;
			return ret;
		}
		FindClose(h);
		ret = profiles;

	}

	delete []profiles;
	return ret;
}

bool COp19Form::confirm(HWND hWnd,tstring &bookmark,int pos, int type)
{
	tstring msg;

	switch (type) {
		case 0:
			msg = _T("Opera 25ȍ~()");
			break;
		case 1:
			msg = _T("Opera 25ȍ~(Opera Beta)");
			break;
		case 2:
			msg = _T("Opera 25ȍ~(Opera Developer)");
			break;
	}
	msg += _T("̃ubN}[N\n");
	msg += bookmark;
	msg += _T("\n");
	if (pos == 1){
		msg += _T("Opera 25ȍ~̃ubN}[N1ɐݒ肵܂H");
	}else{
		msg += _T("Opera 25ȍ~̃ubN}[N2ɐݒ肵܂H");
	}

	int answer;
	const TCHAR *title = _T("");
	title = _T("Opera 25ȍ~̃ubN}[N");

	answer = ::MessageBox(
		hWnd,
		msg.c_str(),
		title,
		MB_YESNO | MB_ICONQUESTION);

	if (answer == IDNO){
		return false;
	} else {
		return true;
	}
}

