#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "Op15Form.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
COp15Form::COp15Form(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_Op15BM1(_T(""))
	, m_Op15BM2(_T(""))
	, m_chkOp15_1(FALSE)
	, m_chkOp15_2(FALSE)
	, m_chkInFolder1(FALSE)
	, m_chkInFolder2(FALSE)
	, m_chkOptimize1(FALSE)
	, m_chkOptimize2(FALSE)
{
	editOp15_1 = NULL;
	editOp15_2 = NULL;
	chkOp15_1 = NULL;
	chkOp15_2 = NULL;
	inFolderOp15_1 = NULL;
	inFolderOp15_2 = NULL;
	optimizeOp15_1 = NULL;
	optimizeOp15_2 = NULL;
}

/**
 * fXgN^
 */
COp15Form::~COp15Form()
{
	if (editOp15_1 != NULL) {
		delete editOp15_1;
	}
	if (editOp15_2 != NULL) {
		delete editOp15_2;
	}
	if (chkOp15_1 != NULL) {
		delete chkOp15_1;
	}
	if (chkOp15_2 != NULL) {
		delete chkOp15_2;
	}
	if (inFolderOp15_1 != NULL) {
		delete inFolderOp15_1;
	}
	if (inFolderOp15_2 != NULL) {
		delete inFolderOp15_2;
	}
	if (optimizeOp15_1 != NULL) {
		delete optimizeOp15_1;
	}
	if (optimizeOp15_2 != NULL) {
		delete optimizeOp15_2;
	}

}


void COp15Form::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITOP15_1, m_Op15BM1);
	DDX_Text(toObj, IDC_EDITOP15_2, m_Op15BM2);
	DDX_Check(toObj, IDC_CHECKOP15_1, m_chkOp15_1);
	DDX_Check(toObj, IDC_CHECKOP15_2, m_chkOp15_2);
	DDX_Check(toObj, IDC_CHECK_OP15_IN_FOLDER_1, m_chkInFolder1);
	DDX_Check(toObj, IDC_CHECK_OP15_IN_FOLDER_2, m_chkInFolder2);
	DDX_Check(toObj, IDC_CHECK_OP15_OPTIMIZE1, m_chkOptimize1);
	DDX_Check(toObj, IDC_CHECK_OP15_OPTIMIZE2, m_chkOptimize2);
}

/**
 * _CAȌ
 *
 * @return FALSE
 */
INT_PTR COp15Form::OnInitDialog()
{
	editOp15_1 = GetDlgItem(IDC_EDITOP15_1);
	editOp15_2 = GetDlgItem(IDC_EDITOP15_2);
	chkOp15_1 = GetDlgItem(IDC_CHECKOP15_1);
	chkOp15_2 = GetDlgItem(IDC_CHECKOP15_2);
	inFolderOp15_1 = GetDlgItem(IDC_CHECK_OP15_IN_FOLDER_1);
	inFolderOp15_2 = GetDlgItem(IDC_CHECK_OP15_IN_FOLDER_2);
	optimizeOp15_1 = GetDlgItem(IDC_CHECK_OP15_OPTIMIZE1);
	optimizeOp15_2 = GetDlgItem(IDC_CHECK_OP15_OPTIMIZE2);

	// I[gRv[gݒ肷B
	setAutoComplete(editOp15_1->getHwnd());
	setAutoComplete(editOp15_2->getHwnd());

	UpdateData(false);

	return (INT_PTR)FALSE;
}

INT_PTR COp15Form::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFOP15_1:
			OnBnClickedRefOp15_1();

			return (INT_PTR)TRUE;

		case IDC_REFOP15_2:
			OnBnClickedRefOp15_2();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchOP15_1:
			OnBnClickedButtonsearchOp15_1();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchOP15_2:
			OnBnClickedButtonsearchOp15_2();

			return (INT_PTR)TRUE;
	}

	return BaseDialog::OnCommand(wParam);
}

/**
 * Opera 15̃ubN}[N1̎Qƃ{^ꂽƂ̏
 *
 */
void COp15Form::OnBnClickedRefOp15_1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("favorites.db"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.db)\0*.db\0ׂẴt@C(*.*)\0*.*\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Opera 15`28̃Xs[h_C̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_Op15BM1 = path;
	m_chkOp15_1 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

/**
 * Opera 15̃ubN}[N2̎Qƃ{^ꂽƂ̏
 *
 */
void COp15Form::OnBnClickedRefOp15_2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("favorites.db"),
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.db)\0*.db\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Opera 15`28̃Xs[h_C̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_Op15BM2 = path;
	m_chkOp15_2 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void COp15Form::OnBnClickedButtonsearchOp15_1()
{
	UpdateData(true);

	searchOp15_1(hWnd);

	UpdateData(false);
}

void COp15Form::OnBnClickedButtonsearchOp15_2()
{
	UpdateData(true);

	searchOp15_2(hWnd);

	UpdateData(false);
}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void COp15Form::setSettingEnable(void)
{
}

/**
 * Opera 15ȍ~̃ubN}[N1̌
 *
 */
void COp15Form::searchOp15_1(HWND hWnd)
{
	tstring bookmark = GetBookmark(_T(STABLE_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op15BM2) {
			if (confirm(hWnd,bookmark,1, 0)) {
				m_Op15BM1 = bookmark;
				m_chkOp15_1 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(NEXT_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op15BM2) {
			if (confirm(hWnd, bookmark, 1, 1)) {
				m_Op15BM1 = bookmark;
				m_chkOp15_1 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(DEVELOPER_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op15BM2) {
			if (confirm(hWnd, bookmark, 1, 2)) {
				m_Op15BM1 = bookmark;
				m_chkOp15_1 = TRUE;
				return;
			}
		}
	}
}

/**
 * Opera 15ȍ~̃ubN}[N2̌
 *
 */
void COp15Form::searchOp15_2(HWND hWnd)
{
	tstring bookmark = GetBookmark(_T(STABLE_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op15BM1) {
			if (confirm(hWnd, bookmark, 2, 0)) {
				m_Op15BM2 = bookmark;
				m_chkOp15_2 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(NEXT_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op15BM1) {
			if (confirm(hWnd, bookmark, 2, 1)) {
				m_Op15BM2 = bookmark;
				m_chkOp15_2 = TRUE;
				return;
			}
		}
	}

	bookmark = GetBookmark(_T(DEVELOPER_BOOKMARK));
	if (bookmark != _T("")){
		if (bookmark != m_Op15BM1) {
			if (confirm(hWnd, bookmark, 2, 2)) {
				m_Op15BM2 = bookmark;
				m_chkOp15_2 = TRUE;
				return;
			}
		}
	}

}

/**
 * Opera 15ȍ~̃ubN}[Nt@C̈ʒu擾B
 *
 */
tstring COp15Form::GetBookmark(TCHAR *path)
{
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR profileDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	/* ܂Aprofiles.iniTB */
	profiles[0] = _T('\0');
	memset(profiles, 0x00, _MAX_PATH * sizeof(TCHAR));
	memset(profileDir, 0x00, _MAX_PATH * sizeof(TCHAR));
	GetAppDataDir(profileDir);

	if (profileDir[0] != '\0'){
		_tcscpy(profiles,profileDir);
		_tcscat(profiles, path);

		memset(&f,0x00,sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			// Ȃ甲B
			delete []profiles;
			return ret;
		}
		FindClose(h);
		ret = profiles;

	}

	delete []profiles;
	return ret;
}

bool COp15Form::confirm(HWND hWnd,tstring &bookmark,int pos, int type)
{
	tstring msg;

	switch (type) {
		case 0:
			msg = _T("Opera 15`28()");
			break;
		case 1:
			msg = _T("Opera 15`28(Opera Beta)");
			break;
		case 2:
			msg = _T("Opera 15`28(Opera Developer)");
			break;
	}
	msg += _T("̃Xs[h_C\n");
	msg += bookmark;
	msg += _T("\n");
	if (pos == 1){
		msg += _T("Opera 15`28̃Xs[h_C1ɐݒ肵܂H");
	}else{
		msg += _T("Opera 15`28̃Xs[h_C2ɐݒ肵܂H");
	}

	int answer;
	TCHAR *title = _T("");
	title = _T("Opera 15`28̃Xs[h_C");

	answer = ::MessageBox(
		hWnd,
		msg.c_str(),
		title,
		MB_YESNO | MB_ICONQUESTION);

	if (answer == IDNO){
		return false;
	} else {
		return true;
	}
}

