#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "MozForm.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CMozForm::CMozForm(HWND parent, int resource) : ChildDialog(parent, resource)
{
	editMoz1 = NULL;
	editMoz2 = NULL;
	chkMoz1 = NULL;
	chkMoz2 = NULL;
	ignoreIE1 = NULL;
	ignoreIE2 = NULL;
	ns4Format1 = NULL;
	ns4Format2 = NULL;
	groupMoz1 = NULL;
	groupMoz2 = NULL;
	refMoz1 = NULL;
	refMoz2 = NULL;
	findMoz1 = NULL;
	findMoz2 = NULL;
}

CMozForm::~CMozForm()
{
	if (editMoz1 != NULL) {
		delete editMoz1;
	}
	if (editMoz2 != NULL) {
		delete editMoz2;
	}
	if (chkMoz1 != NULL) {
		delete chkMoz1;
	}
	if (chkMoz2 != NULL) {
		delete chkMoz2;
	}
	if (ignoreIE1 != NULL) {
		delete ignoreIE1;
	}
	if (ignoreIE2 != NULL) {
		delete ignoreIE2;
	}
	if (ns4Format1 != NULL) {
		delete ns4Format1;
	}
	if (ns4Format2 != NULL) {
		delete ns4Format2;
	}
	if (groupMoz1 == NULL) {
		delete groupMoz1;
	}

	if (groupMoz2 == NULL) {
		delete groupMoz2;
	}

	if (refMoz1 == NULL) {
		delete refMoz1;
	}

	if (refMoz2 == NULL) {
		delete refMoz2;
	}

	if (findMoz1 == NULL) {
		delete findMoz1;
	}

	if (findMoz2 == NULL) {
		delete findMoz2;
	}
}

void CMozForm::UpdateData(bool toObj)
{
	DDX_Check(toObj, IDC_CHECKMOZ1, m_chkMoz1);
	DDX_Check(toObj, IDC_CHECKMOZ2, m_chkMoz2);
	DDX_Check(toObj, IDC_IEFAV1, m_chkIEfav1);
	DDX_Check(toObj, IDC_IEFAV2, m_chkIEfav2);
	DDX_Check(toObj, IDC_NS4FORMAT1, m_chkNS4Format1);
	DDX_Check(toObj, IDC_NS4FORMAT2, m_chkNS4Format2);
	DDX_Text(toObj, IDC_EDITMOZ1, m_MozBM1);
	DDX_Text(toObj, IDC_EDITMOZ2, m_MozBM2);
}

INT_PTR CMozForm::OnInitDialog()
{
	editMoz1 = GetDlgItem(IDC_EDITMOZ1);
	editMoz2 = GetDlgItem(IDC_EDITMOZ2);
	chkMoz1 = GetDlgItem(IDC_CHECKMOZ1);
	chkMoz2 = GetDlgItem(IDC_CHECKMOZ2);
	ignoreIE1 = GetDlgItem(IDC_IEFAV1);
	ignoreIE2 = GetDlgItem(IDC_IEFAV2);
	ns4Format1 = GetDlgItem(IDC_NS4FORMAT1);
	ns4Format2 = GetDlgItem(IDC_NS4FORMAT2);
	groupMoz1 = GetDlgItem(IDC_GroupMoz1);
	groupMoz2 = GetDlgItem(IDC_GroupMoz2);
	refMoz1 = GetDlgItem(IDC_REFMOZ1);
	refMoz2 = GetDlgItem(IDC_REFMOZ2);
	findMoz1 = GetDlgItem(IDC_BUTTONSearchFx1);
	findMoz2 = GetDlgItem(IDC_BUTTONSearchFx2);

	// I[gRv[gݒ肷B
	setAutoComplete(editMoz1->getHwnd());
	setAutoComplete(editMoz2->getHwnd());

	UpdateData(false);

	groupMoz1->setPoint(7, 6);
	groupMoz1->setSize(524, 63);
	add(groupMoz1);

	chkMoz1->setPoint(23, 21);
	chkMoz1->setSize(54, 19);
	add(chkMoz1);

	ignoreIE1->setPoint(84, 21);
	ignoreIE1->setSize(162, 19);
	add(ignoreIE1);

	ns4Format1->setPoint(254, 21);
	ns4Format1->setSize(111, 19);
	add(ns4Format1);

	editMoz1->setPoint(23, 44);
	editMoz1->setSize(386, 19);
	add(editMoz1);

	refMoz1->setPoint(424, 39);
	refMoz1->setSize(43, 24);
	add(refMoz1);

	findMoz1->setPoint(474, 39);
	findMoz1->setSize(43, 24);
	add(findMoz1);

	groupMoz2->setPoint(7, 69);
	groupMoz2->setSize(524, 63);
	add(groupMoz2);

	chkMoz2->setPoint(23, 86);
	chkMoz2->setSize(54, 19);
	add(chkMoz2);

	ignoreIE2->setPoint(84, 86);
	ignoreIE2->setSize(162, 19);
	add(ignoreIE2);

	ns4Format2->setPoint(254, 86);
	ns4Format2->setSize(111, 19);
	add(ns4Format2);

	editMoz2->setPoint(23, 108);
	editMoz2->setSize(386, 19);
	add(editMoz2);

	refMoz2->setPoint(424, 102);
	refMoz2->setSize(43, 24);
	add(refMoz2);

	findMoz2->setPoint(474, 102);
	findMoz2->setSize(43, 24);
	add(findMoz2);

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CMozForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR CMozForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFMOZ1:
			OnBnClickedRefmoz1();

			return (INT_PTR)TRUE;

		case IDC_REFMOZ2:
			OnBnClickedRefmoz2();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchFx1:
			OnBnClickedButtonsearchfx1();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchFx2:
			OnBnClickedButtonsearchfx2();

			return (INT_PTR)TRUE;
	}


	return BaseDialog::OnCommand(wParam);
}

/**
 * Firefox 2/Mozilla/NetscapẽubN}[N1̎Qƃ{^ꂽƂ̏
 *
 */
void CMozForm::OnBnClickedRefmoz1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	cDlg = new NCFileDialog(TRUE,NULL,
		_T("bookmark*.htm*"),
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.htm;*.html)\0*.htm*\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Firefox 2/Netscape/MozillãubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_MozBM1 = path;
	m_chkMoz1 = TRUE;

	// IuWFNgeLXg{bNXɐݒ肷B
	UpdateData(false);

	delete cDlg;
}

/**
 * Firefox 2/Mozilla/NetscapẽubN}[N2̎Qƃ{^ꂽƂ̏
 *
 */
void CMozForm::OnBnClickedRefmoz2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	cDlg = new NCFileDialog(TRUE,NULL,_T("bookmark*.htm*"),
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.htm;*.html)\0*.htm*\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Firefox 2/Netscape/MozillãubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_MozBM2 = path;
	m_chkMoz2 = TRUE;

	// IuWFNgeLXg{bNXɐݒ肷B
	UpdateData(false);

	delete cDlg;
}

/**
 * Firefox 2/Mozilla/NetscapẽubN}[N1̌{^ꂽƂ̏
 *
 */
void CMozForm::OnBnClickedButtonsearchfx1()
{
	UpdateData(true);

	searchFx1(hWnd);

	UpdateData(false);
}

/**
 * Firefox 2/Mozilla/NetscapẽubN}[N2̌{^ꂽƂ̏
 *
 */
void CMozForm::OnBnClickedButtonsearchfx2()
{
	UpdateData(true);

	searchFx2(hWnd);

	UpdateData(false);
}

/**
 * Firefox 2/Netscape 8̃ubN}[N1̌
 *
 */
void CMozForm::searchFx1(HWND hWnd)
{
	// SeaMonkey 2
	tstring bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\SeaMonkey\\"),3,1);
	if (bookmark != _T("")){
		m_MozBM1 = bookmark;
		m_chkNS4Format1 = 0;
		m_chkMoz1 = TRUE;
		return;
	}

	// Mozilla Firefox 2
	bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\Firefox\\"),0,1);
	if (bookmark != _T("")){
		m_MozBM1 = bookmark;
		m_chkNS4Format1 = 0;
		m_chkMoz1 = TRUE;
		return;
	}

	// Netscape 8
	bookmark = GetMozFireBookmark( hWnd , _T("\\Netscape\\NSB\\"),1,1);
	if (bookmark != _T("")){
		m_MozBM1 = bookmark;
		m_chkNS4Format1 = 0;
		m_chkMoz1 = TRUE;
	}

	// Netscape Navigator 9
	bookmark = GetMozFireBookmark( hWnd , _T("\\Netscape\\Navigator\\"),2,1);
	if (bookmark != _T("")){
		m_MozBM1 = bookmark;
		m_chkNS4Format1 = 0;
		m_chkMoz1 = TRUE;
	}

}

/**
 * Firefox 2/Netscape 8̃ubN}[N2̌
 *
 */
void CMozForm::searchFx2(HWND hWnd)
{
	// SeaMonkey 2
	tstring bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\SeaMonkey\\"),3,2);
	if (bookmark != _T("")){
		m_MozBM2 = bookmark;
		m_chkNS4Format2 = 0;
		m_chkMoz2 = TRUE;
		return;
	}

	// Mozilla Firefox 2
	bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\Firefox\\"),0,2);
	if (bookmark != _T("")){
		m_MozBM2 = bookmark;
		m_chkNS4Format2 = 0;
		m_chkMoz2 = TRUE;
		return;
	}

	// Netscape 8
	bookmark = GetMozFireBookmark( hWnd , _T("\\Netscape\\NSB\\"),1,2);
	if (bookmark != _T("")){
		m_MozBM2 = bookmark;
		m_chkNS4Format2 = 0;
		m_chkMoz2 = TRUE;
	}

	// Netscape Navigator 9
	bookmark = GetMozFireBookmark( hWnd , _T("\\Netscape\\Navigator\\"),2,2);
	if (bookmark != _T("")){
		m_MozBM2 = bookmark;
		m_chkNS4Format2 = 0;
		m_chkMoz2 = TRUE;
	}
}


/* Mozilla Firefox̃ubN}[Nt@C̈ʒu擾B */
tstring CMozForm::GetMozFireBookmark(HWND hWnd,const TCHAR *appProfile,int type,int pos)
{
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR profileDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	/* ܂Aprofiles.iniTB */
	profiles[0] = _T('\0');
	memset(profiles,0x00,_MAX_PATH * sizeof(TCHAR));
	memset(profileDir,0x00,_MAX_PATH * sizeof(TCHAR));
	GetAppDataDir(profileDir);
	//MessageBox(NULL,profileDir,"Mozilla Firefox Wizard",MB_OK);
	if (profileDir[0] != _T('\0')){
		_tcscpy(profiles,profileDir);
		_tcscat(profiles,appProfile);
		_tcscat(profiles,_T("PROFILES.INI"));
		//MessageBox(NULL,profiles,"Mozilla Firefox Wizard",MB_OK);
		memset(&f,0x00,sizeof(WIN32_FIND_DATA));
		//strcpy(profiles,"C:\\Windows\\Application Data\\Mozilla\\Firefox\\PROFILES.INI");

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			//ret = OperaPath;
			// Ȃ甲B
			//MessageBox(NULL,profiles,"Mozilla Firefox Wizard - Not found",MB_OK);
			delete []profiles;
			return ret;
		}
		FindClose(h);

	}

	//MessageBox(NULL,profiles,"Mozilla Firefox Wizard - Found",MB_OK);
	DWORD result;

	TCHAR *MozFireProfiles = NULL;
	try{
		MozFireProfiles = new TCHAR[65536];
		if (MozFireProfiles == NULL){
			delete []profiles;
			return ret;
		}
	}catch(...){
		delete []profiles;
		return ret;
	}
	// vt@Cꗗ擾B
	result = ::GetPrivateProfileSectionNames(MozFireProfiles,32768,profiles);
	if (result == 0){
		delete []profiles;
		delete []MozFireProfiles;
		return ret;
	}
	//MessageBox(NULL,MozFireProfiles,"Mozilla Firefox Wizard - Profiles",MB_OK);

	TCHAR *p;	// Eovt@C̐擪
	p = MozFireProfiles;
	while(*p){
		// vt@C擾B
		ret = getMozFireProfile(hWnd,profileDir,appProfile,profiles,p,type,pos);
		if (ret != _T("")){
			// Iꂽ甲B
			break;
		}

		while(*p){
			// '\0'o܂Ői߂B
			p++;
		}
		p++;	// '\0'̎ցB'\0'̏ꍇAȏZNVȂƂƂŔB
	}

	delete []MozFireProfiles;
	delete []profiles;
	return ret;
}

/* Mozilla Firefox 2/Netscape 8̃vt@CubN}[N̈ʒu擾B */
tstring CMozForm::getMozFireProfile(
	HWND hWnd,
	const TCHAR *profileDir,
	const TCHAR *appProfile,
	const TCHAR *profiles,
	const TCHAR *section,
	int type,
	int pos)
{
	TCHAR *MozFirePath = NULL;
	tstring profileName;
	tstring ret = _T("");
	DWORD result;

	MozFirePath = new TCHAR[65536];
	if (MozFirePath == NULL){
		return ret;
	}

	// vt@C擾B
	result = ::GetPrivateProfileString(section,
		_T("Name"),
		_T(""),
		MozFirePath,_MAX_PATH,profiles);
	if (result == 0){
		delete []MozFirePath;
		return ret;
	}
	//utf8tomb(MozFirePath,65536);	// UTF-8ŏĂ̂ŕϊB
	profileName = MozFirePath;

	// pX擾B
	result = ::GetPrivateProfileString(
		section,
		_T("Path"),
		_T(""),
		MozFirePath,
		_MAX_PATH,
		profiles);
	if (result > 0){
		//utf8tomb(MozFirePath,65536);	// UTF-8ŏĂ̂ŕϊB
		// pX̃XbV\ɒB
		TCHAR *p;
		for (p = MozFirePath;*p;p++){
			if (*p == _T('/')){
				*p = _T('\\');
			}
		}

		result = ::GetPrivateProfileInt(section,_T("IsRelative"),-1,profiles);

		tstring bookmarkFile;
		tstring placesFile;
		tstring profilePath;
		if (result == 0){
			profilePath = MozFirePath;
		}else{
			profilePath = profileDir;
			profilePath += appProfile;
			profilePath += MozFirePath;
		}
		bookmarkFile = profilePath + _T("\\bookmarks.html");
		placesFile = profilePath + _T("\\places.sqlite");

		// bookmarks.html݂邩ǂmFB
		// (Firefox3ȍ~ł͌`ς邽߁B)
		if (isExistingFile(bookmarkFile.c_str())) {
			ret = bookmarkFile;
		} else {
			delete []MozFirePath;
			ret = _T("");
			return ret;
		}

		// Firefox 3̏ꍇAbookmarks.htmlplaces.sqlitê̗݂
		// places.sqlite݂ꍇFirefox 3̃vt@CƂ݂ȂāA
		// Ώۂ͂B
		// AASeaMonkey 2̏ꍇ̓ubN}[Nbookmarks.htmlɁA
		// places.sqliteɊi[̂Ń`FbN͂B
		if (type != 3) {
			if (isExistingFile(placesFile.c_str())) {
				delete []MozFirePath;
				ret = _T("");
				return ret;
			}
		}
	}

	delete []MozFirePath;

	// ubN}[N2̃eLXg{bNXɓȂ悤ɂB
	if (pos == 2){
		// 2ڂ̃ubN}[N̏ꍇ
		if (ret == m_MozBM1) {
			ret = _T("");
			return ret;
		}
	}else{
		// 1ڂ̃ubN}[N̏ꍇ
		if (ret == m_MozBM2) {
			ret = _T("");
			return ret;
		}
	}

	tstring msg;
	msg = _T("vt@C ");
	msg += profileName;
	if (pos == 1){
		msg += _T("̃ubN}[NFirefox 2/Netscape/MozillãubN}[N1ɐݒ肵܂H");
	}else{
		msg += _T("̃ubN}[NFirefox 2/Netscape/MozillãubN}[N2ɐݒ肵܂H");
	}

	int answer;
	const TCHAR *title = _T("");
	switch(type){
		case 0:
			title = _T("Mozilla Firefox̃ubN}[N");
			break;
		case 1:
			title = _T("Netscape 8̃ubN}[N");
			break;
		case 2:
			title = _T("Netscape Navigator 9.x̃ubN}[N");
			break;
		case 3:
			title = _T("SeaMonkeỹubN}[N");
			break;
	}
	answer = ::MessageBox(hWnd,msg.c_str(),title,MB_YESNO | MB_ICONQUESTION);
	if (answer == IDNO){
		ret = _T("");
		return ret;
	}

	return ret;

}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CMozForm::setSettingEnable(void)
{
}
