#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>
#include <shtypes.h>
#include <shlobj.h>
#include "NCFileDialog.h"
#include "util.h"
#include "resource.h"
#include "IEForm.h"
#include "IeUtil.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CIEForm::CIEForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_IEBM(_T(""))
	, m_IEdel(FALSE)
	, m_chkIElink(FALSE)
	, m_chkIElinkSync(FALSE)
	, m_chkIE1(false)
	, m_chkLinkFx3Sync(FALSE)
	, m_chkNoLinkToMenu(FALSE)
{
	editIE = NULL;
	chkIE = NULL;
	ignoreLink = NULL;
	delBeforeConvert = NULL;
	useLink = NULL;
	syncFx3 = NULL;
	noLinkToMenu = NULL;
	groupIE = NULL;
	refIE = NULL;
	findIE = NULL;
}

CIEForm::~CIEForm()
{
	if (editIE != NULL) {
		delete editIE;
	}
	if (chkIE != NULL) {
		delete chkIE;
	}
	if (ignoreLink != NULL) {
		delete ignoreLink;
	}
	if (delBeforeConvert != NULL) {
		delete delBeforeConvert;
	}
	if (useLink != NULL) {
		delete useLink;
	}
	if (syncFx3 != NULL) {
		delete syncFx3;
	}
	if (noLinkToMenu != NULL) {
		delete noLinkToMenu;
	}
	if (groupIE != NULL) {
		delete groupIE;
	}
	if (refIE != NULL) {
		delete refIE;
	}
	if (findIE != NULL) {
		delete findIE;
	}
}


void CIEForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITIEFAVORITE, m_IEBM);
	DDX_Check(toObj, IDC_CHKDEL, m_IEdel);
	DDX_Check(toObj, IDC_CHKLINK, m_chkIElink);
	DDX_Check(toObj, IDC_USELINK, m_chkIElinkSync);
	DDX_Check(toObj, IDC_CHECKIE1, m_chkIE1);
	DDX_Check(toObj, IDC_CHECKLINKSYNCFX3, m_chkLinkFx3Sync);
	DDX_Check(toObj, IDC_CHECKNOLINKTOMENU, m_chkNoLinkToMenu);
}

INT_PTR CIEForm::OnInitDialog()
{
	editIE = GetDlgItem(IDC_EDITIEFAVORITE);
	chkIE = GetDlgItem(IDC_CHECKIE1);
	ignoreLink = GetDlgItem(IDC_CHKLINK);
	delBeforeConvert = GetDlgItem(IDC_CHKDEL);
	useLink = GetDlgItem(IDC_USELINK);
	syncFx3 = GetDlgItem(IDC_CHECKLINKSYNCFX3);
	noLinkToMenu = GetDlgItem(IDC_CHECKNOLINKTOMENU);
	groupIE = GetDlgItem(IDC_GroupIE);
	refIE = GetDlgItem(IDC_BUT_IEFav);
	findIE = GetDlgItem(IDC_BUT_OrgIEFav);

	// I[gRv[gݒ肷B
	setAutoComplete(editIE->getHwnd());

	UpdateData(false);

	groupIE->setPoint(7, 6);
	groupIE->setSize(526, 138);
	add(groupIE);

	chkIE->setPoint(23, 21);
	chkIE->setSize(54, 19);
	add(chkIE);

	ignoreLink->setPoint(95, 21);
	ignoreLink->setSize(166, 19);
	add(ignoreLink);

	delBeforeConvert->setPoint(268, 21);
	delBeforeConvert->setSize(122, 19);
	add(delBeforeConvert);

	useLink->setPoint(23, 44);
	useLink->setSize(435, 19);
	add(useLink);

	syncFx3->setPoint(23, 66);
	syncFx3->setSize(498, 19);
	add(syncFx3);

	noLinkToMenu->setPoint(23, 89);
	noLinkToMenu->setSize(442, 19);
	add(noLinkToMenu);

	editIE->setPoint(23, 111);
	editIE->setSize(386, 19);
	add(editIE);

	refIE->setPoint(417, 111);
	refIE->setSize(31, 24);
	add(refIE);

	findIE->setPoint(452, 111);
	findIE->setSize(68, 24);
	add(findIE);


	SetIE1Enable();

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CIEForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR CIEForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_BUT_IEFav:
			OnBnClickedButIefav();

			return (INT_PTR)TRUE;
		case IDC_BUT_OrgIEFav:
			OnBnClickedButOrgiefav();

			return (INT_PTR)TRUE;

		case IDC_USELINK:
			OnBnClickedUselink();
			return (INT_PTR)TRUE;

		case IDC_CHKLINK:
			OnBnClickedChklink();
			return (INT_PTR)TRUE;

		case IDC_CHECKLINKSYNCFX3:
			OnBnClickedChecklinksyncfx3();
			return (INT_PTR)TRUE;
	}


	return BaseDialog::OnCommand(wParam);
}

/**
 * IÊCɓtH_(tpX)擾B
 *
 * @return "":擾s ""ȊO:擾
 *
 */
tstring CIEForm::getIeFavoriteFolder(void)
{
	char szDir[MAX_PATH+1];
	tstring ret;

	getIeFavoritesFolder(szDir);

	ret = szDir;

	return ret;

}

/**
 * IÊCɓfBNg̑IsB
 */
void CIEForm::IE_dirsel(HWND hWnd)
{
	BROWSEINFO info;
	ITEMIDLIST *lpid;
	TCHAR buf[MAX_PATH],dir[MAX_PATH];

    HRESULT hr;
    LPMALLOC pMalloc = NULL;//IMallocւ̃|C^

	UpdateData(true);
	memset(&info, 0, sizeof(BROWSEINFO));
	info.hwndOwner = hWnd;	//eEChEnh
	info.pszDisplayName = dir;	// ʂobt@
	info.lpszTitle = _T("^[QbgfBNg̑I");
	info.ulFlags = BIF_RETURNONLYFSDIRS ;
	info.pidlRoot = NULL;	// fBNg
	info.lpfn = NULL;	// CxgN̊֐
	info.lParam = (LPARAM)0;

	lpid = SHBrowseForFolder(&info);
	if (lpid == NULL) {
		return;
	} else {
        hr = SHGetMalloc(&pMalloc);
        if (hr == E_FAIL) {
            ::MessageBox(hWnd, _T("SHGetMalloc Error"), _T("Error"), MB_OK);
            return;
        }
        SHGetPathFromIDList(lpid, buf);

		// eLXg{bNXɔfB
		m_IEBM = buf;
		m_chkIE1 = TRUE;

		// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
		UpdateData(false);
		SetIE1Enable();

		pMalloc->Free(lpid);
		pMalloc->Release();
	}

}

/**
 * IE̎s̗Lɉă`FbN邩ǂw肷B
 */
void CIEForm::SetIE1Enable()
{
	if (m_chkLinkFx3Sync) {
		noLinkToMenu->EnableWindow(TRUE);
	} else {
		noLinkToMenu->EnableWindow(FALSE);
	}
}

/**
 * IÊCɓtH_߂{^NbNƂ̏
 *
 */
void CIEForm::OnBnClickedButOrgiefav()
{
	UpdateData(true);

	// IÊCɓtH_擾B
	tstring favoriteFolder = getIeFavoriteFolder();

	m_IEBM = favoriteFolder;
	m_chkIE1 = TRUE;

	UpdateData(false);
	SetIE1Enable();
}

/**
 * IÊCɓtH_I{^NbNƂ̏
 *
 */
void CIEForm::OnBnClickedButIefav()
{
	// IÊCɓtH_Iɓ
	IE_dirsel(hWnd);
}

/**
 * NtH_Firefox 2ƓNbNƂ̏
 *
 */
void CIEForm::OnBnClickedUselink()
{
	UpdateData(true);

	// NtH_𔽉fꍇ̓NtH_̖͍sȂB
	if (m_chkIElinkSync){
		if (m_chkIElink){
			m_chkIElink = FALSE;
			UpdateData(false);
		}
	}

}

/**
 * NtH_Firefox 3ƓNbNƂ̏
 *
 */
void CIEForm::OnBnClickedChecklinksyncfx3()
{
	UpdateData(true);

	// NtH_𓯊ꍇ̓NtH_̖͍sȂB
	if (m_chkLinkFx3Sync){
		if (m_chkIElink){
			m_chkIElink = FALSE;
			UpdateData(false);
		}
		noLinkToMenu->EnableWindow(TRUE);
	} else {
		m_chkNoLinkToMenu = FALSE;
		noLinkToMenu->EnableWindow(FALSE);
		UpdateData(false);
	}
}

/**
 * NtH_𖳎NbNƂ̏
 *
 */
void CIEForm::OnBnClickedChklink()
{
	UpdateData(true);

	// NtH_𖳎ꍇ̓NtH_̔f͍sȂB
	if (m_chkIElink){
		m_chkIElinkSync = FALSE;
		m_chkLinkFx3Sync = FALSE;
		m_chkNoLinkToMenu = FALSE;
		noLinkToMenu->EnableWindow(FALSE);
		UpdateData(false);
	} else {
		if (m_chkLinkFx3Sync) {
			noLinkToMenu->EnableWindow(TRUE);
		} else {
			noLinkToMenu->EnableWindow(FALSE);
		}
	}

}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CIEForm::setSettingEnable(void)
{
	SetIE1Enable();
}
