#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "FxForm.h"

const TCHAR *browserNames[4] = {
	_T("Mozilla Firefox̃ubN}[N"),
	_T("SeaMonkeỹubN}[N"),
	_T("Pale MooñubN}[N"),
	_T("Waterfox̃ubN}[N")
};

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CFxForm::CFxForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_FxBM1(_T(""))
	, m_FxBM2(_T(""))
	, m_chkFx1(FALSE)
	, m_chkFx2(FALSE)
	, m_chkIEfav1(FALSE)
	, m_chkIEfav2(FALSE)
	, m_placesPut(FALSE)
	, m_chkIgnoreToolbar1(FALSE)
	, m_chkIgnoreToolbar2(FALSE)
	, m_chkOptimize1(FALSE)
	, m_chkOptimize2(FALSE)
{
	editFx1 = NULL;
	editFx2 = NULL;
	chkFx1 = NULL;
	chkFx2 = NULL;
	ignoreToolbarFx1 = NULL;
	ignoreToolbarFx2 = NULL;
	ignorePlaces = NULL;
	optimizeFx1 = NULL;
	optimizeFx2 = NULL;
	groupFx1 = NULL;
	groupFx2 = NULL;
	refFx1 = NULL;
	refFx2 = NULL;
	findFx1 = NULL;
	findFx2 = NULL;
}

/**
 * fXgN^
 */
CFxForm::~CFxForm()
{
	if (editFx1 != NULL) {
		delete editFx1;
	}
	if (editFx2 != NULL) {
		delete editFx2;
	}
	if (chkFx1 != NULL) {
		delete chkFx1;
	}
	if (chkFx2 != NULL) {
		delete chkFx2;
	}
	if (ignoreToolbarFx1 != NULL) {
		delete ignoreToolbarFx1;
	}
	if (ignoreToolbarFx2 != NULL) {
		delete ignoreToolbarFx2;
	}
	if (ignorePlaces != NULL) {
		delete ignorePlaces;
	}
	if (optimizeFx1 != NULL) {
		delete optimizeFx1;
	}
	if (optimizeFx2 != NULL) {
		delete optimizeFx2;
	}
	if (groupFx1 == NULL) {
		delete groupFx1;
	}
	
	if (groupFx2 == NULL) {
		delete groupFx2;
	}
	
	if (refFx1 == NULL) { 
		delete refFx1;
	}
	
	if (refFx2 == NULL) {
		delete refFx2;
	}
	
	if (findFx1 == NULL ){
		delete findFx1; 
	}
	
	if (findFx2 == NULL) {
		delete findFx2;
	}

}


void CFxForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITFX1, m_FxBM1);
	DDX_Text(toObj, IDC_EDITFX2, m_FxBM2);
	DDX_Check(toObj, IDC_CHECKFX1, m_chkFx1);
	DDX_Check(toObj, IDC_CHECKFX2, m_chkFx2);
	DDX_Check(toObj, IDC_CHECKPLACES, m_placesPut);
	DDX_Check(toObj, IDC_CHECK_FX_TOOLBAR_IGNORE1, m_chkIgnoreToolbar1);
	DDX_Check(toObj, IDC_CHECK_FX_TOOLBAR_IGNORE2, m_chkIgnoreToolbar2);
	DDX_Check(toObj, IDC_CHECK_FX_OPTIMIZE1, m_chkOptimize1);
	DDX_Check(toObj, IDC_CHECK_FX_OPTIMIZE2, m_chkOptimize2);
}

INT_PTR CFxForm::OnInitDialog()
{
	// int x;
	// RECT r;
	// RECT parent;

	editFx1 = GetDlgItem(IDC_EDITFX1);
	// GetWindowRect(editFx1->getHwnd(), &r);
	// GetWindowRect(getHwnd(), &parent);
	// x = (r.left - parent.left) * 96 / 96;
	editFx2 = GetDlgItem(IDC_EDITFX2);
	chkFx1 = GetDlgItem(IDC_CHECKFX1);
	chkFx2 = GetDlgItem(IDC_CHECKFX2);
	ignoreToolbarFx1 = GetDlgItem(IDC_CHECK_FX_TOOLBAR_IGNORE1);
	ignoreToolbarFx2 = GetDlgItem(IDC_CHECK_FX_TOOLBAR_IGNORE2);
	ignorePlaces = GetDlgItem(IDC_CHECKPLACES);
	optimizeFx1 = GetDlgItem(IDC_CHECK_FX_OPTIMIZE1);
	optimizeFx2 = GetDlgItem(IDC_CHECK_FX_OPTIMIZE2);
	groupFx1 = GetDlgItem(IDC_GroupFx1);
	groupFx2 = GetDlgItem(IDC_GroupFx2);
	refFx1 = GetDlgItem(IDC_REFFX1);
	refFx2 = GetDlgItem(IDC_REFFX2);
	findFx1 = GetDlgItem(IDC_BUTTONSearchFx3_1);
	findFx2 = GetDlgItem(IDC_BUTTONSearchFx3_2);

	// I[gRv[gݒ肷B
	setAutoComplete(editFx1->getHwnd());
	setAutoComplete(editFx2->getHwnd());

	UpdateData(false);

	groupFx1->setPoint(7, 6);
	groupFx1->setSize(524, 58);
	add(groupFx1);

	chkFx1->setPoint(23, 19);
	chkFx1->setSize(54, 19);
	add(chkFx1);

	ignoreToolbarFx1->setPoint(81, 19);
	ignoreToolbarFx1->setSize(175, 19);
	add(ignoreToolbarFx1);

	optimizeFx1->setPoint(265, 19);
	optimizeFx1->setSize(70, 19);
	add(optimizeFx1);

	editFx1->setPoint(23, 39);
	editFx1->setSize(386, 19);
	add(editFx1);

	refFx1->setPoint(424, 30);
	refFx1->setSize(43, 24);
	add(refFx1);

	findFx1->setPoint(474, 30);
	findFx1->setSize(43, 24);
	add(findFx1);

	groupFx2->setPoint(7, 68);
	groupFx2->setSize(524, 58);
	add(groupFx2);

	chkFx2->setPoint(23, 83);
	chkFx2->setSize(54, 19);
	add(chkFx2);

	ignoreToolbarFx2->setPoint(81, 83);
	ignoreToolbarFx2->setSize(175, 19);
	add(ignoreToolbarFx2);

	optimizeFx2->setPoint(265, 83);
	optimizeFx2->setSize(70, 19);
	add(optimizeFx2);

	editFx2->setPoint(23, 103);
	editFx2->setSize(386, 19);
	add(editFx2);

	refFx2->setPoint(424, 95);
	refFx2->setSize(43, 24);
	add(refFx2);

	findFx2->setPoint(474, 95);
	findFx2->setSize(43, 24);
	add(findFx2);

	ignorePlaces->setPoint(23, 131);
	ignorePlaces->setSize(386, 19);
	add(ignorePlaces);

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CFxForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

INT_PTR CFxForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFFX1:
			OnBnClickedReffx1();

			return (INT_PTR)TRUE;

		case IDC_REFFX2:
			OnBnClickedReffx2();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchFx3_1:
			OnBnClickedButtonsearchfx31();

			return (INT_PTR)TRUE;

		case IDC_BUTTONSearchFx3_2:
			OnBnClickedButtonsearchfx32();

			return (INT_PTR)TRUE;
	}

	return BaseDialog::OnCommand(wParam);
}

/**
 * Firefox 3̃ubN}[N1̎Qƃ{^ꂽƂ̏
 *
 */
void CFxForm::OnBnClickedReffx1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("places.sqlite"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.sqlite)\0*.sqlite\0ׂẴt@C(*.*)\0*.*\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Firefox 3ȍ~̃ubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_FxBM1 = path;
	m_chkFx1 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

/**
 * Firefox 3̃ubN}[N2̎Qƃ{^ꂽƂ̏
 *
 */
void CFxForm::OnBnClickedReffx2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("places.sqlite"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.sqlite)\0*.sqlite\0ׂẴt@C(*.*)\0*.*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("Firefox 3ȍ~̃ubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_FxBM2 = path;
	m_chkFx2 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

void CFxForm::OnBnClickedButtonsearchfx31()
{
	UpdateData(true);

	searchFx1(hWnd);
	UpdateData(false);
}

void CFxForm::OnBnClickedButtonsearchfx32()
{
	UpdateData(true);

	searchFx2(hWnd);
	UpdateData(false);
}

/**
 * Firefox 3̃ubN}[N1̌
 *
 */
void CFxForm::searchFx1(HWND hWnd)
{
	// Mozilla Firefox 3ȍ~
	tstring bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\Firefox\\"),0,1);
	if (bookmark != _T("")){
		m_FxBM1 = bookmark;
		m_chkFx1 = TRUE;
		return;
	}

	// SeaMonkey 2.1 Alpha 3ȍ~
	bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\SeaMonkey\\"),1,1);
	if (bookmark != _T("")){
		m_FxBM1 = bookmark;
		m_chkFx1 = TRUE;
		return;
	}

	// Pale Moon
	bookmark = GetMozFireBookmark( hWnd , _T("\\Moonchild Productions\\Pale Moon\\"),2,1);
	if (bookmark != _T("")){
		m_FxBM1 = bookmark;
		m_chkFx1 = TRUE;
		return;
	}

	// Pale Moon
	bookmark = GetMozFireBookmark(hWnd, _T("\\Waterfox\\"), 3, 1);
	if (bookmark != _T("")) {
		m_FxBM1 = bookmark;
		m_chkFx1 = TRUE;
		return;
	}
}

/**
 * Firefox 3̃ubN}[N2̌
 *
 */
void CFxForm::searchFx2(HWND hWnd)
{
	// Mozilla Firefox 3ȍ~
	tstring bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\Firefox\\"),0,2);
	if (bookmark != _T("")){
		m_FxBM2 = bookmark;
		m_chkFx2 = TRUE;
		return;
	}

	// SeaMonkey 2.1 Alpha 3ȍ~
	bookmark = GetMozFireBookmark( hWnd , _T("\\Mozilla\\SeaMonkey\\"),1,2);
	if (bookmark != _T("")){
		m_FxBM2 = bookmark;
		m_chkFx2 = TRUE;
		return;
	}

	// Pale Moon
	bookmark = GetMozFireBookmark( hWnd , _T("\\Moonchild Productions\\Pale Moon\\"),3,2);
	if (bookmark != _T("")){
		m_FxBM2 = bookmark;
		m_chkFx2 = TRUE;
		return;
	}

	// Waterfox
	bookmark = GetMozFireBookmark(hWnd, _T("\\Waterfox\\"), 3, 2);
	if (bookmark != _T("")) {
		m_FxBM2 = bookmark;
		m_chkFx2 = TRUE;
		return;
	}
}


/**
 * Mozilla Firefox̃ubN}[Nt@C̈ʒu擾B
 */
tstring CFxForm::GetMozFireBookmark(HWND hWnd,const TCHAR *appProfile,int type,int pos)
{
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR profileDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	/* ܂Aprofiles.iniTB */
	profiles[0] = _T('\0');
	memset(profiles,0x00,_MAX_PATH * sizeof(TCHAR));
	memset(profileDir,0x00,_MAX_PATH * sizeof(TCHAR));
	GetAppDataDir(profileDir);
	//MessageBox(NULL,profileDir,"Mozilla Firefox Wizard",MB_OK);
	if (profileDir[0] != _T('\0')){
		_tcscpy(profiles,profileDir);
		_tcscat(profiles,appProfile);
		_tcscat(profiles,_T("PROFILES.INI"));
		//MessageBox(NULL,profiles,"Mozilla Firefox Wizard",MB_OK);
		memset(&f,0x00,sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			//ret = OperaPath;
			// Ȃ甲B
			//MessageBox(NULL,profiles,"Mozilla Firefox Wizard - Not found",MB_OK);
			delete []profiles;
			return ret;
		}
		FindClose(h);

	}

	//MessageBox(NULL,profiles,"Mozilla Firefox Wizard - Found",MB_OK);
	DWORD result;

	TCHAR *MozFireProfiles = NULL;
	try{
		MozFireProfiles = new TCHAR[65536];
		if (MozFireProfiles == NULL){
			delete []profiles;
			return ret;
		}
	}catch(...){
		delete []profiles;
		return ret;
	}
	// vt@Cꗗ擾B
	result = ::GetPrivateProfileSectionNames(MozFireProfiles,32768,profiles);
	if (result == 0){
		delete []profiles;
		delete []MozFireProfiles;
		return ret;
	}
	//MessageBox(NULL,MozFireProfiles,"Mozilla Firefox Wizard - Profiles",MB_OK);

	TCHAR *p;	// Eovt@C̐擪
	p = MozFireProfiles;
	while(*p){
		// vt@C擾B
		ret = getMozFireProfile(hWnd,profileDir,appProfile,profiles,p,type,pos);
		if (ret != _T("")){
			// Iꂽ甲B
			break;
		}

		while(*p){
			// '\0'o܂Ői߂B
			p++;
		}
		p++;	// '\0'̎ցB'\0'̏ꍇAȏZNVȂƂƂŔB
	}

	delete []MozFireProfiles;
	delete []profiles;
	return ret;
}

/**
 * Mozilla Firefox 2/Netscape 8̃vt@CubN}[N̈ʒu擾B
 */
tstring CFxForm::getMozFireProfile(
	HWND hWnd,
	const TCHAR *profileDir,
	const TCHAR *appProfile,
	const TCHAR *profiles,
	const TCHAR *section,
	int type,
	int pos)
{
	TCHAR *MozFirePath = NULL;
	tstring profileName;
	tstring ret = _T("");
	DWORD result;

	MozFirePath = new TCHAR[65536];
	if (MozFirePath == NULL){
		return ret;
	}

	// vt@C擾B
	result = ::GetPrivateProfileString(
		section,
		_T("Name"),
		_T(""),
		MozFirePath,
		_MAX_PATH,
		profiles);

	if (result == 0){
		delete []MozFirePath;
		return ret;
	}
	//utf8tomb(MozFirePath,65536);	// UTF-8ŏĂ̂ŕϊB
	profileName = MozFirePath;

	// pX擾B
	result = ::GetPrivateProfileString(section,_T("Path"),_T(""),MozFirePath,_MAX_PATH,profiles);
	if (result > 0){
		//utf8tomb(MozFirePath,65536);	// UTF-8ŏĂ̂ŕϊB
		// pX̃XbV\ɒB
		TCHAR *p;
		for (p = MozFirePath;*p;p++){
			if (*p == '/'){
				*p = '\\';
			}
		}

		result = ::GetPrivateProfileInt(section,_T("IsRelative"),-1,profiles);

		tstring bookmarkFile;
		if (result == 0){
			bookmarkFile = MozFirePath;
			bookmarkFile += _T("\\places.sqlite");
		}else{
			bookmarkFile = profileDir;
			bookmarkFile += appProfile;
			bookmarkFile += MozFirePath;
			bookmarkFile += _T("\\places.sqlite");
		}

		// places.sqlite݂邩ǂmFB
		WIN32_FIND_DATA f;
		HANDLE hFind = FindFirstFile( bookmarkFile.c_str() , &f );
		if (hFind == INVALID_HANDLE_VALUE) {
			delete []MozFirePath;
			ret = _T("");
			return ret;
		}
		FindClose(hFind);

		ret = bookmarkFile;
	}

	delete []MozFirePath;

	// ubN}[N2̃eLXg{bNXɓȂ悤ɂB
	if (pos == 2){
		// 2ڂ̃ubN}[N̏ꍇ
		if (ret == m_FxBM1) {
			ret = _T("");
			return ret;
		}
	}else{
		// 1ڂ̃ubN}[N̏ꍇ
		if (ret == m_FxBM2) {
			ret = _T("");
			return ret;
		}
	}

	tstring msg;
	msg = _T("vt@C ");
	msg += profileName;
	if (pos == 1){
		msg += _T("̃ubN}[NFirefox 3ȍ~̃ubN}[N1ɐݒ肵܂H");
	}else{
		msg += _T("̃ubN}[NFirefox 3ȍ~̃ubN}[N2ɐݒ肵܂H");
	}

	int answer;
	const TCHAR *title = _T("");
	title = browserNames[type];
	/*
	switch(type){
		case 0:
			title = _T("Mozilla Firefox̃ubN}[N");
			break;
		case 1:
			title = _T("SeaMonkeỹubN}[N");
			break;
		case 2:
			title = _T("Pale MooñubN}[N");
			break;
	}
	*/
	answer = ::MessageBox(hWnd,msg.c_str(),title,MB_YESNO | MB_ICONQUESTION);
	if (answer == IDNO){
		ret = _T("");
		return ret;
	}

	return ret;

}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CFxForm::setSettingEnable(void)
{
}
