#include "stdafx.h"
#include "shellapi.h"

#include "BookSyncApp.h"
#include "GuiDefine.h"
#include "EditSelect.h"
#include "util.h"

/**
 * R{{bNX\Ǝۂ̃ubN}[N̎ނ̑Ή
 */
static int menuNo[SELECTABLE_BOOKMARKS - 1] = {
	// Firefox 3ȍ~̃ubN}[N1
	BOOKMARK_FIREFOX_1,
	// Firefox 3ȍ~̃ubN}[N2
	BOOKMARK_FIREFOX_2,
	// IẼubN}[N
	BOOKMARK_IE,
#if 0
	// EdgẽubN}[N
	BOOKMARK_EDGE,
#endif	// WITH_EDGE
	// ChromẽubN}[N1
	BOOKMARK_CHROME_1,
	// ChromẽubN}[N2
	BOOKMARK_CHROME_2,
#ifdef WITH_OP15
	// Opera 15`28̃Xs[h_C
	BOOKMARK_OPERA15_1,
	// Opera 15`28̃Xs[h_C
	BOOKMARK_OPERA15_2,
#endif	// WITH_OP15
	// Opera 25ȍ~̃ubN}[N1
	BOOKMARK_OPERA25_1,
	// Opera 25ȍ~̃ubN}[N2
	BOOKMARK_OPERA25_2,
	// VivaldĩubN}[N1
	BOOKMARK_VIVALDI_1,
	// VivaldĩubN}[N1
	BOOKMARK_VIVALDI_2,
	// Edge(Chromium)̃ubN}[N1
	BOOKMARK_EDGE2_1,
	// Edge(Chromium)̃ubN}[N1
	BOOKMARK_EDGE2_2,
	// MozillãubN}[N1
	BOOKMARK_MOZILLA_1,
	// MozillãubN}[N2
	BOOKMARK_MOZILLA_2,
	// XBEL`ubN}[N1
	BOOKMARK_XBEL_1,
	// XBEL`ubN}[N2
	BOOKMARK_XBEL_2,
	// Opera 12ȑÕubN}[N1
	BOOKMARK_OPERA_1,
	// Opera 12ȑÕubN}[N2
	BOOKMARK_OPERA_2,
	// SafarĩubN}[N1
	BOOKMARK_SAFARI_1,
	// SafarĩubN}[N2
	BOOKMARK_SAFARI_2
};

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[X
 */
CEditSelect::CEditSelect(HWND parent, int resource) : BaseDialog(parent, resource)
{
	m_BrowserSelection = NULL;
	messageLabel = NULL;
	okButton = NULL;
	cancelButton = NULL;
	font = NULL;
}

/**
 * fXgN^
 */
CEditSelect::~CEditSelect()
{
	if (font != NULL) {
		DeleteObject(font);
	}

	if (m_BrowserSelection != NULL) {
		delete m_BrowserSelection;
	}
	if (messageLabel == NULL) {
		delete messageLabel;
	}
	if (okButton == NULL) {
		delete okButton;
	}
	if (cancelButton == NULL) {
		delete cancelButton;
	}
}

/**
 * f[^XV
 *
 * @param toObj true:Rg[IuWFNg false:IuWFNgRg[
 */
void CEditSelect::UpdateData(bool toObj)
{
	DDX_CBIndex(toObj, IDC_COMBOBOOKMARK, selection);
}

/**
 * _CAO
 *
 * @return tH[JX̐ݒ肪(FALSE:)
 */
INT_PTR CEditSelect::OnInitDialog()
{
	HWND comboBoxHandle = ::GetDlgItem(hWnd, IDC_COMBOBOOKMARK);

	m_BrowserSelection = new TwrCombobox(comboBoxHandle);
	messageLabel = GetDlgItem(IDC_LABEL_CHOICE);
	okButton = GetDlgItem(IDOK);
	cancelButton = GetDlgItem(IDCANCEL);

	for (int i = 0; i < SELECTABLE_BOOKMARKS - 1; i++){
		m_BrowserSelection->addItem(bookmark_name[menuNo[i]]);
	}

	UpdateData(false);
	if (title.length() > 0) {
		::SetWindowText(hWnd, title.c_str());
	}

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	// \ꂽEChËʒuIuWFNgɔfB
	RECT r;

	GetWindowRect(hWnd, &r);
	setPoint(r.left, r.top);

	// EChȆ傫ݒ肷B
	setClientSize(382, 94);

	messageLabel->setPoint(12, 11);
	messageLabel->setSize(360, 19);
	add(messageLabel);

	m_BrowserSelection->setPoint(12, 35);
	m_BrowserSelection->setSize(353, 21);
	add(m_BrowserSelection);

	okButton->setPoint(175, 62);
	okButton->setSize(89, 22);
	add(okButton);

	cancelButton->setPoint(282, 62);
	cancelButton->setSize(89, 22);
	add(cancelButton);

	SetFocus(m_BrowserSelection->getHwnd());

	return (INT_PTR)FALSE;
}

/**
 * \ɌĂяo܂B
 */
void CEditSelect::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
	scaleChildren();

	// _CAOe̒ɔzuB
	RECT parentRect;

	GetWindowRect(getParent(), &parentRect);

	adjustCenter(parentRect, getParent(), this->hWnd);

}


/**
 * WM_COMMANDbZ[W̏
 *
 * @param wParam WPARAM
 */
INT_PTR CEditSelect::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDOK:
			OnBnClickedOk();
			break;
	}
	return BaseDialog::OnCommand(wParam);
}

#if 0
HWND targetHwnd;
/**
* 񋓂ꂽEChEnhɑ΂AtHgݒ肷B
*
* @param hwnd 񋓂ꂽEChEnh
* @param lparam Ăьnꂽp[^(tHgnh)
* @return TRUE 񋓂pB
*/
BOOL CALLBACK showBookmarkWinSize(HWND hwnd, LPARAM lparam)
{
	//HFONT font = (HFONT)lparam;

	//SendMessage(hwnd, WM_SETFONT, (WPARAM)font, TRUE);

	// Capture control position
	char buf[256];
	RECT r;
	GetWindowRect(hwnd, &r);
	POINT p;
	p.x = r.left;
	p.y = r.top;
	ScreenToClient(targetHwnd, &p);

	sprintf(buf, "->setPoint(%d, %d);\n->setSize(%d, %d);\nadd();\n",
		p.x, p.y, r.right - r.left + 1, r.bottom - r.top + 1);
	MessageBox(NULL, buf, "", MB_OK);
	// Capture control position end

	return TRUE;
}
#endif

/**
 * OK{^̏
 */
void CEditSelect::OnBnClickedOk()
{
	UpdateData(true);

#if 0
	char buf[256];
	RECT r;
	GetClientRect(getHwnd(), &r);

	sprintf(buf, "->setClientSize(%d, %d);\n",
		r.right - r.left + 1, r.bottom - r.top + 1);
	MessageBox(NULL, buf, "", MB_OK);

	//myHwnd = getHwnd();
	targetHwnd = getHwnd();
	HWND w = getHwnd();
	EnumChildWindows(w, ::showBookmarkWinSize, (LPARAM)font);
#endif
}

/**
 * DPIωۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT CEditSelect::OnDpiChanged(void)
{
	// \p̃tHg蒼B
	if (font != NULL) {
		DeleteObject(font);
	}

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	return BaseDialog::OnDpiChanged();
}

/**
 * Iڂ̐ݒ
 *
 * @param no I鍀(ubN}[Nʔ)
 */
void CEditSelect::setSelection(int no)
{
	selection = 0;

	if (no > -1) {
		// ubN}[NʔԂR{{bNX̕\ʒuɒB
		for (int i = 0; i < SELECTABLE_BOOKMARKS; i++) {
			if (no == menuNo[i]) {
				selection = i;
				break;
			}
		}
	}
	UpdateData(false);
}

/**
 * Iڂ̎擾
 *
 * @return I鍀(ubN}[Nʔ)
 */
int CEditSelect::getSelection(void)
{
	return menuNo[selection];
}
