#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>
#include <shtypes.h>
#include <shlobj.h>
#include "NCFileDialog.h"
#include "util.h"
#include "resource.h"
#include "EdgeForm.h"
#include "IeUtil.h"

/** EgdẽubN}[NtH_ */
const char *EDGE_BOOKMARK_FOLDER = "\\Packages\\Microsoft.MicrosoftEdge_8wekyb3d8bbwe\\AC\\MicrosoftEdge\\User\\Default\\DataStore\\Data\\nouser1\\120712-0049\\DBStore\\spartan.edb";

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CEdgeForm::CEdgeForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_EdgeBM(_T(""))
	, m_chkEdgelink(FALSE)
	, m_chkEdgelinkSync(FALSE)
	, m_chkEdge1(false)
	, m_chkLinkFx3Sync(FALSE)
	, m_chkNoLinkToMenu(FALSE)
{
	editEdge = NULL;
	chkEdge = NULL;
	ignoreLink = NULL;
	useLink = NULL;
	syncFx3 = NULL;
	noLinkToMenu = NULL;
	groupEdge = NULL;
	refEdge = NULL;
	findEdge = NULL;
}

/**
 * fXgN^
 */
CEdgeForm::~CEdgeForm()
{
	if (editEdge != NULL) {
		delete editEdge;
	}
	if (chkEdge != NULL) {
		delete chkEdge;
	}
	if (ignoreLink != NULL) {
		delete ignoreLink;
	}
	if (useLink != NULL) {
		delete useLink;
	}
	if (syncFx3 != NULL) {
		delete syncFx3;
	}
	if (noLinkToMenu != NULL) {
		delete noLinkToMenu;
	}
	if (groupEdge != NULL) {
		delete groupEdge;
	}
	if (refEdge != NULL) {
		delete refEdge;
	}
	if (findEdge != NULL) {
		delete findEdge;
	}
}


/**
 * _CAO
 *
 * @param toObj true:CX^Xɉʂ̒lݒ肷B false:CX^Xʂɒlݒ肷B
 */
void CEdgeForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDIT_FAVORITE_EDGE, m_EdgeBM);
	DDX_Check(toObj, IDC_CHKLINK_EDGE, m_chkEdgelink);
	DDX_Check(toObj, IDC_USELINK_EDGE, m_chkEdgelinkSync);
	DDX_Check(toObj, IDC_CHECKEDGE1, m_chkEdge1);
	DDX_Check(toObj, IDC_CHECKLINKSYNCFX3_EDGE, m_chkLinkFx3Sync);
	DDX_Check(toObj, IDC_CHECKNOLINKTOMENU_EDGE, m_chkNoLinkToMenu);
}

/**
 * _CAO
 */
INT_PTR CEdgeForm::OnInitDialog()
{
	editEdge = GetDlgItem(IDC_EDIT_FAVORITE_EDGE);
	chkEdge = GetDlgItem(IDC_CHECKEDGE1);
	ignoreLink = GetDlgItem(IDC_CHKLINK_EDGE);
	useLink = GetDlgItem(IDC_USELINK_EDGE);
	syncFx3 = GetDlgItem(IDC_CHECKLINKSYNCFX3_EDGE);
	noLinkToMenu = GetDlgItem(IDC_CHECKNOLINKTOMENU_EDGE);
	groupEdge = GetDlgItem(IDC_GroupEDGE);
	refEdge = GetDlgItem(IDC_BUT_EDGEFav);
	findEdge = GetDlgItem(IDC_BUT_OrgEDGEFav);

	// I[gRv[gݒ肷B
	setAutoComplete(editEdge->getHwnd());

	UpdateData(false);

	groupEdge->setPoint(7, 6);
	groupEdge->setSize(526, 138);
	add(groupEdge);

	chkEdge->setPoint(23, 21);
	chkEdge->setSize(54, 19);
	add(chkEdge);

	ignoreLink->setPoint(95, 21);
	ignoreLink->setSize(166, 19);
	add(ignoreLink);

	useLink->setPoint(23, 44);
	useLink->setSize(435, 19);
	add(useLink);

	syncFx3->setPoint(23, 66);
	syncFx3->setSize(498, 19);
	add(syncFx3);

	noLinkToMenu->setPoint(23, 89);
	noLinkToMenu->setSize(442, 19);
	add(noLinkToMenu);

	editEdge->setPoint(23, 111);
	editEdge->setSize(386, 19);
	add(editEdge);

	refEdge->setPoint(424, 111);
	refEdge->setSize(43, 24);
	add(refEdge);

	findEdge->setPoint(474, 111);
	findEdge->setSize(43, 24);
	add(findEdge);

	SetEdge1Enable();

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CEdgeForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

/**
 * WM_COMMANDbZ[Wɂ鏈U蕪
 *
 * @param wParam WPARAM̒l
 * @return TRUE:R}hs FALSE:R}hsȂ
 */
INT_PTR CEdgeForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_BUT_EDGEFav:
			OnBnClickedButEdgefav();

			return (INT_PTR)TRUE;
		case IDC_BUT_OrgEDGEFav:
			OnBnClickedButOrgEdgefav();

			return (INT_PTR)TRUE;

		case IDC_USELINK_EDGE:
			OnBnClickedUselink();
			return (INT_PTR)TRUE;

		case IDC_CHKLINK_EDGE:
			OnBnClickedChklink();
			return (INT_PTR)TRUE;

		case IDC_CHECKLINKSYNCFX3_EDGE:
			OnBnClickedChecklinksyncfx3();
			return (INT_PTR)TRUE;
	}

	return BaseDialog::OnCommand(wParam);
}

/**
* EdgêCɓtH_擾B
*
* @param buf i[((MAX_PATH+1)Kv)
*/
void CEdgeForm::getEdgeFavoritesFolder(char *buf)
{
	GetLocalAppDataDir(buf);
	strcat(buf, EDGE_BOOKMARK_FOLDER);

}

/**
 * EdgêCɓtH_(tpX)擾B
 *
 * @return "":擾s ""ȊO:擾
 *
 */
tstring CEdgeForm::getEdgeFavoriteFolder(void)
{
	char szDir[MAX_PATH+1];
	tstring ret;

	getEdgeFavoritesFolder(szDir);

	ret = szDir;

	return ret;

}

/**
 * EdgêCɓfBNg̑IsB
 */
void CEdgeForm::Edge_dirsel(HWND hWnd)
{
	BROWSEINFO info;
	ITEMIDLIST *lpid;
	TCHAR buf[MAX_PATH],dir[MAX_PATH];

    HRESULT hr;
    LPMALLOC pMalloc = NULL;//IMallocւ̃|C^

	UpdateData(true);
	memset(&info, 0, sizeof(BROWSEINFO));
	info.hwndOwner = hWnd;	//eEChEnh
	info.pszDisplayName = dir;	// ʂobt@
	info.lpszTitle = _T("^[QbgfBNg̑I");
	info.ulFlags = BIF_RETURNONLYFSDIRS ;
	info.pidlRoot = NULL;	// fBNg
	info.lpfn = NULL;	// CxgN̊֐
	info.lParam = (LPARAM)0;

	lpid = SHBrowseForFolder(&info);
	if (lpid == NULL) {
		return;
	} else {
        hr = SHGetMalloc(&pMalloc);
        if (hr == E_FAIL) {
            ::MessageBox(hWnd, _T("SHGetMalloc Error"), _T("Error"), MB_OK);
            return;
        }
        SHGetPathFromIDList(lpid, buf);

		// eLXg{bNXɔfB
		m_EdgeBM = buf;
		m_chkEdge1 = TRUE;

		// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
		UpdateData(false);
		SetEdge1Enable();

		pMalloc->Free(lpid);
		pMalloc->Release();
	}

}

/**
 * Edge̎s̗Lɉă`FbN邩ǂw肷B
 */
void CEdgeForm::SetEdge1Enable()
{
	if (m_chkLinkFx3Sync) {
		noLinkToMenu->EnableWindow(TRUE);
	} else {
		noLinkToMenu->EnableWindow(FALSE);
	}
}

/**
 * EdgêCɓtH_߂{^NbNƂ̏
 *
 */
void CEdgeForm::OnBnClickedButOrgEdgefav()
{
	UpdateData(true);

	// EdgêCɓtH_擾B
	tstring favoriteFolder = getEdgeFavoriteFolder();

	m_EdgeBM = favoriteFolder;
	m_chkEdge1 = TRUE;

	UpdateData(false);
	SetEdge1Enable();
}

/**
 * EdgêCɓtH_I{^NbNƂ̏
 *
 */
void CEdgeForm::OnBnClickedButEdgefav()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE, NULL,
		_T("spartan.edb"), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file(*.edb)\0*.edb\0ׂẴt@C(*.*)\0*.*\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("EdgẽubN}[N̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL) {
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_EdgeBM = path;
	m_chkEdge1 = TRUE;

	// ʂ͍ڂIuWFNgɓ]AeLXg{bNX킹Đݒ肷B
	UpdateData(false);

	delete cDlg;
}

/**
 * NtH_Firefox 2ƓNbNƂ̏
 *
 */
void CEdgeForm::OnBnClickedUselink()
{
	UpdateData(true);

	// NtH_𔽉fꍇ̓NtH_̖͍sȂB
	if (m_chkEdgelinkSync){
		if (m_chkEdgelink){
			m_chkEdgelink = FALSE;
			UpdateData(false);
		}
	}

}

/**
 * NtH_Firefox 3ƓNbNƂ̏
 *
 */
void CEdgeForm::OnBnClickedChecklinksyncfx3()
{
	UpdateData(true);

	// NtH_𓯊ꍇ̓NtH_̖͍sȂB
	if (m_chkLinkFx3Sync){
		if (m_chkEdgelink){
			m_chkEdgelink = FALSE;
			UpdateData(false);
		}
		noLinkToMenu->EnableWindow(TRUE);
	} else {
		m_chkNoLinkToMenu = FALSE;
		noLinkToMenu->EnableWindow(FALSE);
		UpdateData(false);
	}
}

/**
 * NtH_𖳎NbNƂ̏
 *
 */
void CEdgeForm::OnBnClickedChklink()
{
	UpdateData(true);

	// NtH_𖳎ꍇ̓NtH_̔f͍sȂB
	if (m_chkEdgelink){
		m_chkEdgelinkSync = FALSE;
		m_chkLinkFx3Sync = FALSE;
		m_chkNoLinkToMenu = FALSE;
		noLinkToMenu->EnableWindow(FALSE);
		UpdateData(false);
	} else {
		if (m_chkLinkFx3Sync) {
			noLinkToMenu->EnableWindow(TRUE);
		} else {
			noLinkToMenu->EnableWindow(FALSE);
		}
	}

}

/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CEdgeForm::setSettingEnable(void)
{
	SetEdge1Enable();
}
