#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "encutil.h"
#include "encutil2.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "Edge2Form.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CEdge2Form::CEdge2Form(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_Edge2BM1(_T(""))
	, m_Edge2BM2(_T(""))
	, m_chkEdge2_1(FALSE)
	, m_chkEdge2_2(FALSE)
	, m_chkIgnoreToolbar1(FALSE)
	, m_chkIgnoreToolbar2(FALSE)
{
	editEdge2_1 = NULL;
	editEdge2_2 = NULL;
	chkEdge2_1 = NULL;
	chkEdge2_2 = NULL;
	ignoreToolbarEdge2_1 = NULL;
	ignoreToolbarEdge2_2 = NULL;
	groupEdge2_1 = NULL;
	groupEdge2_2 = NULL;
	refEdge2_1 = NULL;
	refEdge2_2 = NULL;
	findEdge2_1 = NULL;
	findEdge2_2 = NULL;
}

/**
 * fXgN^
 */
CEdge2Form::~CEdge2Form()
{
	if (editEdge2_1 != NULL) {
		delete editEdge2_1;
	}
	if (editEdge2_2 != NULL) {
		delete editEdge2_2;
	}
	if (chkEdge2_1 != NULL) {
		delete chkEdge2_1;
	}
	if (chkEdge2_2 != NULL) {
		delete chkEdge2_2;
	}
	if (ignoreToolbarEdge2_1 != NULL) {
		delete ignoreToolbarEdge2_1;
	}
	if (ignoreToolbarEdge2_2 != NULL) {
		delete ignoreToolbarEdge2_2;
	}
	if (groupEdge2_1 == NULL) {
		delete groupEdge2_1;
	}

	if (groupEdge2_2 == NULL) {
		delete groupEdge2_2;
	}

	if (refEdge2_1 == NULL) {
		delete refEdge2_1;
	}

	if (refEdge2_2 == NULL) {
		delete refEdge2_2;
	}

	if (findEdge2_1 == NULL) {
		delete findEdge2_1;
	}

	if (findEdge2_2 == NULL) {
		delete findEdge2_2;
	}
}

/**
 * _CAO̊eRg[̒lݒ菈
 *
 * @param true:Rg[̃IuWFNgɒlnB false:Rg[ɒlݒ肷B
 */
void CEdge2Form::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITEDGE2_1, m_Edge2BM1);
	DDX_Text(toObj, IDC_EDITEDGE2_2, m_Edge2BM2);
	DDX_Check(toObj, IDC_CHECKEDGE2_1, m_chkEdge2_1);
	DDX_Check(toObj, IDC_CHECKEDGE2_2, m_chkEdge2_2);
	DDX_Check(toObj, IDC_CHECK_EDGE2_TOOLBAR_IGNORE1, m_chkIgnoreToolbar1);
	DDX_Check(toObj, IDC_CHECK_EDGE2_TOOLBAR_IGNORE2, m_chkIgnoreToolbar2);
}

/**
 * _CAȌ
 *
 * @return FALSE
 */
INT_PTR CEdge2Form::OnInitDialog()
{
	editEdge2_1 = GetDlgItem(IDC_EDITEDGE2_1);
	editEdge2_2 = GetDlgItem(IDC_EDITEDGE2_2);
	chkEdge2_1 = GetDlgItem(IDC_CHECKEDGE2_1);
	chkEdge2_2 = GetDlgItem(IDC_CHECKEDGE2_2);
	ignoreToolbarEdge2_1 = GetDlgItem(IDC_CHECK_EDGE2_TOOLBAR_IGNORE1);
	ignoreToolbarEdge2_2 = GetDlgItem(IDC_CHECK_EDGE2_TOOLBAR_IGNORE2);
	groupEdge2_1 = GetDlgItem(IDC_GroupEdge2_1);
	groupEdge2_2 = GetDlgItem(IDC_GroupEdge2_2);
	refEdge2_1 = GetDlgItem(IDC_REFEDGE2_1);
	refEdge2_2 = GetDlgItem(IDC_REFEDGE2_2);
	findEdge2_1 = GetDlgItem(IDC_BUTTONSearchEdge2_1);
	findEdge2_2 = GetDlgItem(IDC_BUTTONSearchEdge2_2);

	// I[gRv[gݒ肷B
	setAutoComplete(editEdge2_1->getHwnd());
	setAutoComplete(editEdge2_2->getHwnd());

	UpdateData(false);

	groupEdge2_1->setPoint(7, 6);
	groupEdge2_1->setSize(524, 58);
	add(groupEdge2_1);

	chkEdge2_1->setPoint(23, 19);
	chkEdge2_1->setSize(54, 19);
	add(chkEdge2_1);

	ignoreToolbarEdge2_1->setPoint(81, 19);
	ignoreToolbarEdge2_1->setSize(152, 19);
	add(ignoreToolbarEdge2_1);

	editEdge2_1->setPoint(23, 39);
	editEdge2_1->setSize(386, 19);
	add(editEdge2_1);

	refEdge2_1->setPoint(424, 30);
	refEdge2_1->setSize(43, 24);
	add(refEdge2_1);

	findEdge2_1->setPoint(474, 30);
	findEdge2_1->setSize(43, 24);
	add(findEdge2_1);

	groupEdge2_2->setPoint(7, 68);
	groupEdge2_2->setSize(524, 58);
	add(groupEdge2_2);

	chkEdge2_2->setPoint(23, 83);
	chkEdge2_2->setSize(54, 19);
	add(chkEdge2_2);

	ignoreToolbarEdge2_2->setPoint(81, 83);
	ignoreToolbarEdge2_2->setSize(152, 19);
	add(ignoreToolbarEdge2_2);

	editEdge2_2->setPoint(23, 103);
	editEdge2_2->setSize(386, 19);
	add(editEdge2_2);

	refEdge2_2->setPoint(424, 95);
	refEdge2_2->setSize(43, 24);
	add(refEdge2_2);

	findEdge2_2->setPoint(474, 95);
	findEdge2_2->setSize(43, 24);
	add(findEdge2_2);

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CEdge2Form::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

/**
 * _CAO삪sꂽɌĂяo܂B
 *
 * @return  0:s 0:sȂ
 */
INT_PTR CEdge2Form::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFEDGE2_1:
			OnBnClickedRefEdge2_1();

			return (INT_PTR)0;

		case IDC_REFEDGE2_2:
			OnBnClickedRefEdge2_2();

			return (INT_PTR)0;

		case IDC_BUTTONSearchEdge2_1:
			OnBnClickedButtonsearchEdge2_1();

			return (INT_PTR)0;

		case IDC_BUTTONSearchEdge2_2:
			OnBnClickedButtonsearchEdge2_2();

			return (INT_PTR)0;
	}

	return BaseDialog::OnCommand(wParam);
}

/**
 * EdgẽubN}[N1̎Qƃ{^̓
 */
void CEdge2Form::OnBnClickedRefEdge2_1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("EdgêCɓ1̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_Edge2BM1 = path;
	m_chkEdge2_1 = TRUE;

	UpdateData(false);
	SetEdge2_1Enable();

	delete cDlg;
}

/**
 * EdgẽubN}[N2̎Qƃ{^̓
 */
void CEdge2Form::OnBnClickedRefEdge2_2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("EdgêCɓ2̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_Edge2BM2 = path;
	m_chkEdge2_2 = TRUE;

	UpdateData(false);
	SetEdge2_2Enable();

	delete cDlg;
}

/**
 * EdgẽubN}[N1̌{^̓
 */
void CEdge2Form::OnBnClickedButtonsearchEdge2_1()
{
	UpdateData(TRUE);

	searchEdge2_1( hWnd );
	UpdateData(FALSE);
}

/**
 * EdgẽubN}[N2̌{^̓
 */
void CEdge2Form::OnBnClickedButtonsearchEdge2_2()
{
	UpdateData(TRUE);

	searchEdge2_2( hWnd );
	UpdateData(FALSE);
}

/**
 * Edgen1̎s̗Lɉă`FbN邩ǂw肷B
 */
void CEdge2Form::SetEdge2_1Enable()
{
	ignoreToolbarEdge2_1->EnableWindow(m_chkEdge2_1);
	editEdge2_1->EnableWindow(m_chkEdge2_1);
}

/**
 * Edgen2̎s̗Lɉă`FbN邩ǂw肷B
 */
void CEdge2Form::SetEdge2_2Enable()
{
	ignoreToolbarEdge2_2->EnableWindow(m_chkEdge2_2);
	editEdge2_2->EnableWindow(m_chkEdge2_2);
}

/**
 * EdgẽubN}[N1̌
 *
 * @param hWnd eƂȂ_CAÕEChEnh
 */
void CEdge2Form::searchEdge2_1(HWND hWnd)
{
	tstring bookmark = GetBookmark(hWnd, 1, m_Edge2BM2);
	if (bookmark != _T("")){
		m_Edge2BM1 = bookmark;
		m_chkEdge2_1 = TRUE;
		SetEdge2_1Enable();
	}
}

/**
 * EdgẽubN}[N2̌
 *
 * @param hWnd eƂȂ_CAÕEChEnh
 */
void CEdge2Form::searchEdge2_2(HWND hWnd)
{
	tstring bookmark = GetBookmark(hWnd, 2, m_Edge2BM1);
	if (bookmark != _T("")){
		m_Edge2BM2 = bookmark;
		m_chkEdge2_2 = TRUE;
		SetEdge2_2Enable();
	}

}

/**
 * EdgẽubN}[Nt@C̈ʒu擾B
 *
 * @param pos ݒ肷ubN}[N̈ʒu
 * @return ubN}[Nt@C̃pX
 */
tstring CEdge2Form::GetBookmark(HWND hWnd, int pos, tstring exclude)
{
	tstring basePath;	// vt@CtH_̃pX
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR localAppDataDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	profiles[0] = '\0';
	memset(profiles,0x00,_MAX_PATH);
	memset(localAppDataDir, 0x00, _MAX_PATH * sizeof(TCHAR));
	GetLocalAppDataDir(localAppDataDir);

	if (localAppDataDir[0] != _T('\0')){
		// vtB[̓t@CLocal StatěEǂݍ
		_tcscpy(profiles,localAppDataDir);
		// vt@CtH_̋N_
		_tcscat(profiles,_T(EDGE2_CONFIG_BASE));
		basePath = profiles;
		// AvP[Vݒt@C
		_tcscat(profiles,_T(EDGE2_CONFIG_FILE));
		
		memset(&f,0x00,sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			// Ȃ甲B
			delete []profiles;
			return ret;
		}
		FindClose(h);

		// 
		try {
			TJson *jsonObj = new TJson();
			if (jsonObj == NULL) {
				delete []profiles;
				return ret;
			}
			tstring bookmarkFile = searchProfile(
				hWnd,
				jsonObj,
				profiles,
				pos,
				basePath,
				exclude);
			delete jsonObj;
			if (bookmarkFile != _T("")) {
				ret = bookmarkFile;
			}
		} catch(...) {
			delete []profiles;
			return ret;
		}
	}

	delete []profiles;
	return ret;
}

/**
 * vtB[ƕRÂubN}[Nt@CB
 *
 * @param hWnd ₢킹_CAO̐eEChEnh
 * @param jsonObj JSONǂݎIuWFNg
 * @param profiles vtB[񂪏ꂽLocal StatẽtpX
 * @param pos ݒΏۂ̃ubN}[N(1/2)
 * @param base vtB[̂tH_̃pX
 * @param exclude 珜OubN}[Nt@C̃tpX
 * @return vtB[ɕRÂubN}[Nt@C̃tpX(IȂꍇ͋)
 */
tstring CEdge2Form::searchProfile(
	HWND hWnd,
	TJson *jsonObj,
	TCHAR *profiles,
	int pos,
	tstring base,
	tstring exclude)
{
	tstring ret;
	ret = _T("");

	int readResult = jsonObj->readFile(profiles);
	if (readResult) {
		return ret;
	}
	TJsonValue *top = jsonObj->getTopValue();
	if (top == NULL) {
		return ret;
	}
	TJsonValue *profile = top->getObjectValue("profile");
	if (profile == NULL) {
		return ret;
	}
	TJsonValue *infoCache = profile->getObjectValue("info_cache");
	if (infoCache == NULL) {
		return ret;
	}
	int profileCount = infoCache->getObjectCount();
	if (profileCount == 0) {
		return ret;
	}
	for (int i = 0; i < profileCount; i++) {
		TJsonValue *profile = infoCache->getObjectValue(i);
		std::string folder = infoCache->getObjectKey(i);
		TJsonValue *name = profile->getObjectValue("shortcut_name");
		if (name == NULL) {
			continue;
		}
		char *profileName = name->getValue();

		tstring message = _T("[U[ ");
#ifndef UNICODE
		char *mbProfileName = UTF8tombInternal(profileName);
		message += mbProfileName;

		tstring fullPath = base;
		fullPath += _T("\\");
		fullPath += folder;
		fullPath += _T("\\Bookmarks");

#else
		wchar_t *wcProfileName = UTF8tombInternal(profileName);
		message += wcProfileName;

		tstring fullPath = base;
		fullPath += _T("\\");
		fullPath += mbtowcInternal(folder);
		fullPath += _T("\\Bookmarks");
#endif
		message += _T("\nCɓEdgêCɓ");
		if (pos == 1) {
			message += _T("1");
		} else {
			message += _T("2");
		}
		message += _T("ɐݒ肵܂H");

		if (fullPath != exclude) {
			// ̃ubN}[NƏdȂȂ̂₢킹sB
			int answer = MessageBox(
				hWnd,
				message.c_str(),
				_T("EdgêCɓ"),
				MB_YESNO | MB_ICONQUESTION);
			if (answer == IDYES) {
#ifndef UNICODE
				ret = fullPath;
#else
				ret = mbtowcInternal(folder.c_str());;
#endif
				break;
			}
		}
	}
	return ret;
}


/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CEdge2Form::setSettingEnable(void)
{
}
