#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>

#include "bslib.h"
#include "encutil.h"
#include "encutil2.h"
#include "util.h"

#include "NCFileDialog.h"

#include "resource.h"
#include "ChForm.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CChForm::CChForm(HWND parent, int resource) : ChildDialog(parent, resource)
	, m_ChBM1(_T(""))
	, m_ChBM2(_T(""))
	, m_chkCh1(FALSE)
	, m_chkCh2(FALSE)
	, m_chkIgnoreToolbar1(FALSE)
	, m_chkIgnoreToolbar2(FALSE)
{
	editCh1 = NULL;
	editCh2 = NULL;
	chkCh1 = NULL;
	chkCh2 = NULL;
	ignoreToolbarCh1 = NULL;
	ignoreToolbarCh2 = NULL;
	groupCh1 = NULL;
	groupCh2 = NULL;
	refCh1 = NULL;
	refCh2 = NULL;
	findCh1 = NULL;
	findCh2 = NULL;
}

/**
 * fXgN^
 */
CChForm::~CChForm()
{
	if (editCh1 != NULL) {
		delete editCh1;
	}
	if (editCh2 != NULL) {
		delete editCh2;
	}
	if (chkCh1 != NULL) {
		delete chkCh1;
	}
	if (chkCh2 != NULL) {
		delete chkCh2;
	}
	if (ignoreToolbarCh1 != NULL) {
		delete ignoreToolbarCh1;
	}
	if (ignoreToolbarCh2 != NULL) {
		delete ignoreToolbarCh2;
	}
	if (groupCh1 == NULL) {
		delete groupCh1;
	}

	if (groupCh2 == NULL) {
		delete groupCh2;
	}

	if (refCh1 == NULL) {
		delete refCh1;
	}

	if (refCh2 == NULL) {
		delete refCh2;
	}

	if (findCh1 == NULL) {
		delete findCh1;
	}

	if (findCh2 == NULL) {
		delete findCh2;
	}
}

/**
 * _CAO̊eRg[̒lݒ菈
 *
 * @param true:Rg[̃IuWFNgɒlnB false:Rg[ɒlݒ肷B
 */
void CChForm::UpdateData(bool toObj)
{
	DDX_Text(toObj, IDC_EDITCH1, m_ChBM1);
	DDX_Text(toObj, IDC_EDITCH2, m_ChBM2);
	DDX_Check(toObj, IDC_CHECKCH1, m_chkCh1);
	DDX_Check(toObj, IDC_CHECKCH2, m_chkCh2);
	DDX_Check(toObj, IDC_CHECK_CH_TOOLBAR_IGNORE1, m_chkIgnoreToolbar1);
	DDX_Check(toObj, IDC_CHECK_CH_TOOLBAR_IGNORE2, m_chkIgnoreToolbar2);
}

/**
 * _CAȌ
 *
 * @return FALSE
 */
INT_PTR CChForm::OnInitDialog()
{
	editCh1 = GetDlgItem(IDC_EDITCH1);
	editCh2 = GetDlgItem(IDC_EDITCH2);
	chkCh1 = GetDlgItem(IDC_CHECKCH1);
	chkCh2 = GetDlgItem(IDC_CHECKCH2);
	ignoreToolbarCh1 = GetDlgItem(IDC_CHECK_CH_TOOLBAR_IGNORE1);
	ignoreToolbarCh2 = GetDlgItem(IDC_CHECK_CH_TOOLBAR_IGNORE2);
	groupCh1 = GetDlgItem(IDC_GroupCh1);
	groupCh2 = GetDlgItem(IDC_GroupCh2);
	refCh1 = GetDlgItem(IDC_REFCH1);
	refCh2 = GetDlgItem(IDC_REFCH2);
	findCh1 = GetDlgItem(IDC_BUTTONSearchCh_1);
	findCh2 = GetDlgItem(IDC_BUTTONSearchCh_2);

	// I[gRv[gݒ肷B
	setAutoComplete(editCh1->getHwnd());
	setAutoComplete(editCh2->getHwnd());

	UpdateData(false);

	groupCh1->setPoint(7, 6);
	groupCh1->setSize(524, 58);
	add(groupCh1);

	chkCh1->setPoint(23, 19);
	chkCh1->setSize(54, 19);
	add(chkCh1);

	ignoreToolbarCh1->setPoint(81, 19);
	ignoreToolbarCh1->setSize(152, 19);
	add(ignoreToolbarCh1);

	editCh1->setPoint(23, 39);
	editCh1->setSize(386, 19);
	add(editCh1);

	refCh1->setPoint(424, 30);
	refCh1->setSize(43, 24);
	add(refCh1);

	findCh1->setPoint(474, 30);
	findCh1->setSize(43, 24);
	add(findCh1);

	groupCh2->setPoint(7, 68);
	groupCh2->setSize(524, 58);
	add(groupCh2);

	chkCh2->setPoint(23, 83);
	chkCh2->setSize(54, 19);
	add(chkCh2);

	ignoreToolbarCh2->setPoint(81, 83);
	ignoreToolbarCh2->setSize(152, 19);
	add(ignoreToolbarCh2);

	editCh2->setPoint(23, 103);
	editCh2->setSize(386, 19);
	add(editCh2);

	refCh2->setPoint(424, 95);
	refCh2->setSize(43, 24);
	add(refCh2);

	findCh2->setPoint(474, 95);
	findCh2->setSize(43, 24);
	add(findCh2);

	return (INT_PTR)FALSE;
}

/**
 * \̏
 */
void CChForm::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
}

/**
 * _CAO삪sꂽɌĂяo܂B
 *
 * @return  0:s 0:sȂ
 */
INT_PTR CChForm::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_REFCH1:
			OnBnClickedRefch1();

			return (INT_PTR)0;

		case IDC_REFCH2:
			OnBnClickedRefch2();

			return (INT_PTR)0;

		case IDC_BUTTONSearchCh_1:
			OnBnClickedButtonsearchch1();

			return (INT_PTR)0;

		case IDC_BUTTONSearchCh_2:
			OnBnClickedButtonsearchch2();

			return (INT_PTR)0;
	}

	return BaseDialog::OnCommand(wParam);
}

/**
 * ChromẽubN}[N1̎Qƃ{^̓
 */
void CChForm::OnBnClickedRefch1()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("ChromẽubN}[N1̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_ChBM1 = path;
	m_chkCh1 = TRUE;

	UpdateData(false);
	SetCh1Enable();

	delete cDlg;
}

/**
 * ChromẽubN}[N2̎Qƃ{^̓
 */
void CChForm::OnBnClickedRefch2()
{
	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	UpdateData(true);
	cDlg = new NCFileDialog(TRUE,NULL,
		_T("Bookmarks"),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Bookmark file\0*\0\0"),hWnd);
	cDlg->m_ofn.lpstrTitle = _T("ChromẽubN}[N2̑I");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽݒsB
	path = cDlg->GetPathName();
	m_ChBM2 = path;
	m_chkCh2 = TRUE;

	UpdateData(false);
	SetCh2Enable();

	delete cDlg;
}

/**
 * ChromẽubN}[N1̌{^̓
 */
void CChForm::OnBnClickedButtonsearchch1()
{
	UpdateData(TRUE);

	searchCh1( hWnd );
	UpdateData(FALSE);
}

/**
 * ChromẽubN}[N2̌{^̓
 */
void CChForm::OnBnClickedButtonsearchch2()
{
	UpdateData(TRUE);

	searchCh2( hWnd );
	UpdateData(FALSE);
}

/**
 * Chromen1̎s̗Lɉă`FbN邩ǂw肷B
 */
void CChForm::SetCh1Enable()
{
	ignoreToolbarCh1->EnableWindow(m_chkCh1);
	editCh1->EnableWindow(m_chkCh1);
}

/**
 * Chromen2̎s̗Lɉă`FbN邩ǂw肷B
 */
void CChForm::SetCh2Enable()
{
	ignoreToolbarCh2->EnableWindow(m_chkCh2);
	editCh2->EnableWindow(m_chkCh2);
}

/**
 * ChromẽubN}[N1̌
 *
 * @param hWnd eƂȂ_CAÕEChEnh
 */
void CChForm::searchCh1(HWND hWnd)
{
	tstring bookmark = GetBookmark(hWnd, 1, m_ChBM2);
	if (bookmark != _T("")){
		m_ChBM1 = bookmark;
		m_chkCh1 = TRUE;
		SetCh1Enable();
	}
}

/**
 * ChromẽubN}[N2̌
 *
 * @param hWnd eƂȂ_CAÕEChEnh
 */
void CChForm::searchCh2(HWND hWnd)
{
	tstring bookmark = GetBookmark(hWnd, 2, m_ChBM1);
	if (bookmark != _T("")){
		m_ChBM2 = bookmark;
		m_chkCh2 = TRUE;
		SetCh2Enable();
	}

}

/**
 * ChromẽubN}[Nt@C̈ʒu擾B
 *
 * @param pos ݒ肷ubN}[N̈ʒu
 * @return ubN}[Nt@C̃pX
 */
tstring CChForm::GetBookmark(HWND hWnd, int pos, tstring exclude)
{
	tstring basePath;	// vt@CtH_̃pX
	tstring ret;
	TCHAR *profiles = NULL;
	TCHAR localAppDataDir[_MAX_PATH];

	WIN32_FIND_DATA f;
	HANDLE h;
	ret = _T("");

	try{
		profiles = new TCHAR[_MAX_PATH];
		if (profiles == NULL){
			return ret;
		}
	}catch(...){
		return ret;
	}

	profiles[0] = '\0';
	memset(profiles,0x00,_MAX_PATH);
	memset(localAppDataDir, 0x00, _MAX_PATH * sizeof(TCHAR));
	GetLocalAppDataDir(localAppDataDir);

	if (localAppDataDir[0] != _T('\0')){
		// vtB[̓t@CLocal StatěEǂݍ
		_tcscpy(profiles,localAppDataDir);
		// vt@CtH_̋N_
		_tcscat(profiles,_T(CH_CONFIG_BASE));
		basePath = profiles;
		// AvP[Vݒt@C
		_tcscat(profiles,_T(CH_CONFIG_FILE));
		
		memset(&f,0x00,sizeof(WIN32_FIND_DATA));

		h = FindFirstFile(profiles,&f);
		if (h == INVALID_HANDLE_VALUE){
			// Ȃ甲B
			delete []profiles;
			return ret;
		}
		FindClose(h);

		// 
		try {
			TJson *jsonObj = new TJson();
			if (jsonObj == NULL) {
				delete []profiles;
				return ret;
			}
			tstring bookmarkFile = searchProfile(
				hWnd,
				jsonObj,
				profiles,
				pos,
				basePath,
				exclude);
			delete jsonObj;
			if (bookmarkFile != _T("")) {
				ret = bookmarkFile;
			}
		} catch(...) {
			delete []profiles;
			return ret;
		}
	}

	delete []profiles;
	return ret;
}

/**
 * vtB[ƕRÂubN}[Nt@CB
 *
 * @param hWnd ₢킹_CAO̐eEChEnh
 * @param jsonObj JSONǂݎIuWFNg
 * @param profiles vtB[񂪏ꂽLocal StatẽtpX
 * @param pos ݒΏۂ̃ubN}[N(1/2)
 * @param base vtB[̂tH_̃pX
 * @param exclude 珜OubN}[Nt@C̃tpX
 * @return vtB[ɕRÂubN}[Nt@C̃tpX(IȂꍇ͋)
 */
tstring CChForm::searchProfile(
	HWND hWnd,
	TJson *jsonObj,
	TCHAR *profiles,
	int pos,
	tstring base,
	tstring exclude)
{
	tstring ret;
	ret = _T("");

	int readResult = jsonObj->readFile(profiles);
	if (readResult) {
		return ret;
	}
	TJsonValue *top = jsonObj->getTopValue();
	if (top == NULL) {
		return ret;
	}
	TJsonValue *profile = top->getObjectValue("profile");
	if (profile == NULL) {
		return ret;
	}
	TJsonValue *infoCache = profile->getObjectValue("info_cache");
	if (infoCache == NULL) {
		return ret;
	}
	int profileCount = infoCache->getObjectCount();
	if (profileCount == 0) {
		return ret;
	}
	for (int i = 0; i < profileCount; i++) {
		TJsonValue *profile = infoCache->getObjectValue(i);
		std::string folder = infoCache->getObjectKey(i);
		TJsonValue *name = profile->getObjectValue("name");
		if (name == NULL) {
			continue;
		}
		char *profileName = name->getValue();

		tstring message = _T("[U[");
#ifndef UNICODE
		char *mbProfileName = UTF8tombInternal(profileName);
		message += mbProfileName;

		tstring fullPath = base;
		fullPath += _T("\\");
		fullPath += folder;
		fullPath += _T("\\Bookmarks");

#else
		wchar_t *wcProfileName = UTF8tombInternal(profileName);
		message += wcProfileName;

		tstring fullPath = base;
		fullPath += _T("\\");
		fullPath += mbtowcInternal(folder);
		fullPath += _T("\\Bookmarks");
#endif
		message += _T("\nubN}[NChromẽubN}[N");
		if (pos == 1) {
			message += _T("1");
		} else {
			message += _T("2");
		}
		message += _T("ɐݒ肵܂H");

		if (fullPath != exclude) {
			// ̃ubN}[NƏdȂȂ̂₢킹sB
			int answer = MessageBox(
				hWnd,
				message.c_str(),
				_T("Google ChromẽubN}[N"),
				MB_YESNO | MB_ICONQUESTION);
			if (answer == IDYES) {
#ifndef UNICODE
				ret = fullPath;
#else
				ret = mbtowcInternal(folder.c_str());;
#endif
				break;
			}
		}
	}
	return ret;
}


/**
 * Rg[gp\ǂꊇݒ肷B
 */
void CChForm::setSettingEnable(void)
{
}
