#include "stdafx.h"
#include "shellapi.h"

#include "BookSyncApp.h"
#include "GuiDefine.h"
#include "BrowserSelect.h"
#include "util.h"

/**
 * Xg\Ǝۂ̃ubN}[N̎ނ̑Ή
 * ҏWΏۃubN}[N_CAOƂ邱Ƃ͈ꏏA
 * ҏWΏۂɂȂubN}[NoɔĕʓrzpӂB
 */
static int listNo[SELECTABLE_BOOKMARKS] = {
	// Firefox 3ȍ~̃ubN}[N1
	BOOKMARK_FIREFOX_1,
	// Firefox 3ȍ~̃ubN}[N2
	BOOKMARK_FIREFOX_2,
	// IẼubN}[N
	BOOKMARK_IE,
	// ChromẽubN}[N1
	BOOKMARK_CHROME_1,
	// ChromẽubN}[N2
	BOOKMARK_CHROME_2,
#ifdef WITH_OP15
	// Opera 15`28̃Xs[h_C
	BOOKMARK_OPERA15_1,
	// Opera 15`28̃Xs[h_C
	BOOKMARK_OPERA15_2,
#endif	// WITH_OP15
	// Opera 25ȍ~̃ubN}[N1
	BOOKMARK_OPERA25_1,
	// Opera 25ȍ~̃ubN}[N2
	BOOKMARK_OPERA25_2,
	// VivaldĩubN}[N1
	BOOKMARK_VIVALDI_1,
	// VivaldĩubN}[N1
	BOOKMARK_VIVALDI_2,
	// Edge(Chromium)̃ubN}[N1
	BOOKMARK_EDGE2_1,
	// Edge(Chromium)̃ubN}[N1
	BOOKMARK_EDGE2_2,
	// MozillãubN}[N1
	BOOKMARK_MOZILLA_1,
	// MozillãubN}[N2
	BOOKMARK_MOZILLA_2,
	// XBEL`ubN}[N1
	BOOKMARK_XBEL_1,
	// XBEL`ubN}[N2
	BOOKMARK_XBEL_2,
#ifdef WITH_EDGE
	// EdgẽubN}[N
	BOOKMARK_EDGE,
#endif	// WITH_EDGE
	// Opera 12ȑÕubN}[N1
	BOOKMARK_OPERA_1,
	// Opera 12ȑÕubN}[N2
	BOOKMARK_OPERA_2,
	// SafarĩubN}[N1
	BOOKMARK_SAFARI_1,
	// SafarĩubN}[N2
	BOOKMARK_SAFARI_2
};

static int toListNo[SELECTABLE_BOOKMARKS - 1] = {
	// Firefox 3ȍ~̃ubN}[N1
	BOOKMARK_FIREFOX_1,
	// Firefox 3ȍ~̃ubN}[N2
	BOOKMARK_FIREFOX_2,
	// IẼubN}[N
	BOOKMARK_IE,
#if 0
	// EdgẽubN}[N
	BOOKMARK_EDGE,
#endif	// WITH_EDGE
	// ChromẽubN}[N1
	BOOKMARK_CHROME_1,
	// ChromẽubN}[N2
	BOOKMARK_CHROME_2,
#ifdef WITH_OP15
	// Opera 15`28̃Xs[h_C
	BOOKMARK_OPERA15_1,
	// Opera 15`28̃Xs[h_C
	BOOKMARK_OPERA15_2,
#endif	// WITH_OP15
	// Opera 25ȍ~̃ubN}[N1
	BOOKMARK_OPERA25_1,
	// Opera 25ȍ~̃ubN}[N2
	BOOKMARK_OPERA25_2,
	// VivaldĩubN}[N1
	BOOKMARK_VIVALDI_1,
	// VivaldĩubN}[N1
	BOOKMARK_VIVALDI_2,
	// Edge(Chromium)̃ubN}[N1
	BOOKMARK_EDGE2_1,
	// Edge(Chromium)̃ubN}[N1
	BOOKMARK_EDGE2_2,
	// MozillãubN}[N1
	BOOKMARK_MOZILLA_1,
	// MozillãubN}[N2
	BOOKMARK_MOZILLA_2,
	// XBEL`ubN}[N1
	BOOKMARK_XBEL_1,
	// XBEL`ubN}[N2
	BOOKMARK_XBEL_2,
	// Opera 12ȑÕubN}[N1
	BOOKMARK_OPERA_1,
	// Opera 12ȑÕubN}[N2
	BOOKMARK_OPERA_2,
	// SafarĩubN}[N1
	BOOKMARK_SAFARI_1,
	// SafarĩubN}[N2
	BOOKMARK_SAFARI_2
};

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[X
 */
CBrowserSelect::CBrowserSelect(HWND parent, int resource) : BaseDialog(parent, resource)
{
	m_fromList = NULL;
	m_toList = NULL;
	windowTitle = _T("");
	fromCheckStatus = NULL;
	sourceLabel = NULL;
	destinationLabel = NULL;
	directionLabel = NULL;
	okButton = NULL;
	cancelButton = NULL;
	font = NULL;
}

/**
 * fXgN^
 */
CBrowserSelect::~CBrowserSelect()
{
	if (font != NULL) {
		DeleteObject(font);
	}

	if (m_fromList != NULL) {
		delete m_fromList;
	}
	if (m_toList != NULL) {
		delete m_toList;
	}
	if (sourceLabel == NULL) {
		delete sourceLabel;
	}
	if (destinationLabel == NULL) {
		delete destinationLabel;
	}
	if (directionLabel == NULL) {
		delete directionLabel;
	}
	if (okButton == NULL) {
		delete okButton;
	}
	if (cancelButton == NULL) {
		delete cancelButton;
	}
}

/**
 * _CAO
 *
 * @return tH[JX̐ݒ肪(FALSE:)
 */
INT_PTR CBrowserSelect::OnInitDialog()
{
	HWND listViewHandle = ::GetDlgItem(hWnd, IDC_LISTSELECT);
	HWND toListViewHandle = ::GetDlgItem(hWnd, IDC_LIST_CONVERT_TO);
	sourceLabel = GetDlgItem(IDC_LABEL_SOURCE);
	destinationLabel = GetDlgItem(IDC_LABEL_DESTINATION);
	directionLabel = GetDlgItem(IDC_LABEL_DIRECTION);
	okButton = GetDlgItem(IDOK);
	cancelButton = GetDlgItem(IDCANCEL);

	m_fromList = new TwrListView(listViewHandle);
	m_toList = new TwrListView(toListViewHandle);

	setListviewInfo(m_fromList, fromChecked, listNo, SELECTABLE_BOOKMARKS);
	setListviewInfo(m_toList, toChecked, toListNo, SELECTABLE_BOOKMARKS - 1);

	// EChE^CgύXB
	const TCHAR *newTitle = windowTitle.c_str();
	setText(newTitle);

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	// \ꂽEChËʒuIuWFNgɔfB
	RECT r;

	GetWindowRect(hWnd, &r);
	setPoint(r.left, r.top);

	setClientSize(671, 401);

	sourceLabel->setPoint(12, 14);
	sourceLabel->setSize(197, 15);
	add(sourceLabel);

	m_fromList->setPoint(12, 32);
	m_fromList->setSize(302, 332);
	add(m_fromList);

	directionLabel->setPoint(329, 165);
	directionLabel->setSize(17, 18);
	add(directionLabel);

	destinationLabel->setPoint(355, 14);
	destinationLabel->setSize(197, 15);
	add(destinationLabel);

	m_toList->setPoint(355, 33);
	m_toList->setSize(302, 332);
	add(m_toList);

	okButton->setPoint(474, 371);
	okButton->setSize(89, 22);
	add(okButton);

	cancelButton->setPoint(569, 371);
	cancelButton->setSize(89, 22);
	add(cancelButton);

	// ŏ̃tH[JXݒ
	m_fromList->selectItem(0);
	SetFocus(m_fromList->getHwnd());

	return (INT_PTR)FALSE;
}

#if 0
HWND targetHwnd;
/**
* 񋓂ꂽEChEnhɑ΂AtHgݒ肷B
*
* @param hwnd 񋓂ꂽEChEnh
* @param lparam Ăьnꂽp[^(tHgnh)
* @return TRUE 񋓂pB
*/
BOOL CALLBACK showBookmarkWinSize(HWND hwnd, LPARAM lparam)
{
	//HFONT font = (HFONT)lparam;

	//SendMessage(hwnd, WM_SETFONT, (WPARAM)font, TRUE);

	// Capture control position
	char buf[256];
	RECT r;
	GetWindowRect(hwnd, &r);
	POINT p;
	p.x = r.left;
	p.y = r.top;
	ScreenToClient(targetHwnd, &p);

	sprintf(buf, "->setPoint(%d, %d);\n->setSize(%d, %d);\nadd();\n",
		p.x, p.y, r.right - r.left + 1, r.bottom - r.top + 1);
	MessageBox(NULL, buf, "", MB_OK);
	// Capture control position end

	return TRUE;
}
#endif

/**
 * \ɌĂяo܂B
 */
void CBrowserSelect::OnLoad(void)
{
	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
	scaleChildren();

	// _CAOe̒ɔzuB
	RECT parentRect;

	GetWindowRect(getParent(), &parentRect);

	adjustCenter(parentRect, getParent(), this->hWnd);

}

/**
 * WM_COMMANDbZ[W̏
 *
 * @param wParam WPARAM
 */
INT_PTR CBrowserSelect::OnCommand(WPARAM wParam)
{
#if 0
	char buf[256];
	RECT r;
#endif

	switch (LOWORD(wParam)) {
		case IDOK:
			// e`FbN{bNX̏ԂcheckedɔfB
			for (int i = 0;i < SELECTABLE_BOOKMARKS;i++){
				fromChecked[listNo[i]] = m_fromList->isChecked(i);
			}
			for (int i = 0; i < SELECTABLE_BOOKMARKS - 1; i++) {
				toChecked[toListNo[i]] = m_toList->isChecked(i);
			}
#if 0
			GetClientRect(getHwnd(), &r);

			sprintf(buf, "->setClientSize(%d, %d);\n",
				r.right - r.left + 1, r.bottom - r.top + 1);
			MessageBox(NULL, buf, "", MB_OK);

			targetHwnd = getHwnd();
			EnumChildWindows(getHwnd(), ::showBookmarkWinSize, (LPARAM)font);
#endif
			break;
	}
	return BaseDialog::OnCommand(wParam);
}

/**
 * DPIωۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT CBrowserSelect::OnDpiChanged(void)
{
	// \p̃tHg蒼B
	if (font != NULL) {
		DeleteObject(font);
	}

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	return BaseDialog::OnDpiChanged();
}

/**
 * Xgr[̏ݒ肷B
 *
 * @param target ݒΏۂListview
 * @param checkStatus ݒ肷`FbN
 * @param list ݒ肷鍀ږXg
 * @param itemCount ݒ肷鍀ڐ
 */
void CBrowserSelect::setListviewInfo(TwrListView *target, bool *checkStatus, int *list, int itemCount)
{
	// Listview̃X^Cݒ
	LONG style = GetWindowLong(target->getHwnd(), GWL_STYLE);
	style = style | LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT;
	if (style & LVS_SORTASCENDING) {
		style ^= LVS_SORTASCENDING;
	}
	if (style & LVS_SORTDESCENDING) {
		style ^= LVS_SORTDESCENDING;
	}

	SetWindowLong(target->getHwnd(), GWL_STYLE, style);
	target->SetExtendedStyle(LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT);

	RECT rect;
	GetClientRect(target->getHwnd(), &rect);

	target->insertColumn(0, _T("w肷ubN}[N"), LVCFMT_LEFT, rect.right - rect.left,-1);

	// \ubN}[N̖̂ݒ肷B
	for (int i = 0;i < itemCount;i++){
		target->insertItem(i, bookmark_name[list[i]]);
		if (checkStatus[list[i]]) {
			target->checkItem(i, true);
		}
	}

}

/**
 * ϊ̃`FbN󋵂ݒ肷B<br>
 * (EChE\OɌĂяoƁB)
 *
 * @param status `FbN
 */
void CBrowserSelect::setFromCheckStatus(bool *status)
{

	for (int i = 0;i < ALL_BOOKMARKS;i++){
		fromChecked[i] = status[i];
	}
}

/**
 * ϊ̃`FbN󋵂ݒ肷B<br>
 * (EChE\OɌĂяoƁB)
 *
 * @param status `FbN
 */
void CBrowserSelect::setToCheckStatus(bool *status)
{

	for (int i = 0;i < ALL_BOOKMARKS;i++){
		toChecked[i] = status[i];
	}
}
