#ifndef BOOKSYNCFORM_H
#define BOOKSYNCFORM_H

#include <tchar.h>
#include <shobjidl.h>

#include "resource.h"
#include "AppliBase/BaseForm.h"
#include "TwrButton.h"
#include "TwrGroupBox.h"
#include "TwrCheckBox.h"
#include "TwrComboBox.h"
#include "TwrTab.h"
#include "TwrText.h"
#include "TwrMenu.h"

#include "BScommon.h"
#include "IProfile.h"
#include "IniProfile.h"
#include "RegistoryProfile.h"

#include "FxForm.h"
#include "OperaForm.h"
#include "IEForm.h"
#ifdef WITH_EDGE
#include "EdgeForm.h"
#endif	// WITH_EDGE
#include "SfForm.h"
#include "ChForm.h"
#include "MozForm.h"
#include "XbForm.h"
#include "Edge2Form.h"
#ifdef WITH_OP15
#include "Op15Form.h"
#endif	// WITH_OP15
#include "Op19Form.h"
#include "ViForm.h"

#include "AboutDlg.h"
#include "PriorityDlg.h"
#include "Progress.h"

#include "Configuration.h"

// `̏W܂

// WXgEINIt@Cւ̏ݗp
#define SECTION_NAME "Settings"
#define IE_NO_LINK_TO_MENU "IE_NoLinkToMenu"
#define FIREFOX_1_IGNORE_TOOLBAR_VALUE "Fx_ignore_toolbar_1"
#define FIREFOX_2_IGNORE_TOOLBAR_VALUE "Fx_ignore_toolbar_2"
#define FIREFOX_1_OPTIMIZE_VALUE "Fx_optimize_1"
#define FIREFOX_2_OPTIMIZE_VALUE "Fx_optimize_2"
#define SAFARI_1_BOOKMARK_VALUE "Sf_bookmark_1"
#define SAFARI_2_BOOKMARK_VALUE "Sf_bookmark_2"
#define SAFARI_1_DO_VALUE "Sf_do_1"
#define SAFARI_2_DO_VALUE "Sf_do_2"
#define SAFARI_1_IGNORE_TOOLBAR_VALUE "Sf_ignore_toolbar_1"
#define SAFARI_2_IGNORE_TOOLBAR_VALUE "Sf_ignore_toolbar_2"

#define CHROME_1_BOOKMARK_VALUE "Ch_bookmark_1"
#define CHROME_2_BOOKMARK_VALUE "Ch_bookmark_2"
#define CHROME_1_DO_VALUE "Ch_do_1"
#define CHROME_2_DO_VALUE "Ch_do_2"
#define CHROME_1_IGNORE_TOOLBAR_VALUE "Ch_ignore_toolbar_1"
#define CHROME_2_IGNORE_TOOLBAR_VALUE "Ch_ignore_toolbar_2"

#define XBEL_1_BOOKMARK_VALUE "Xb_bookmark_1"
#define XBEL_2_BOOKMARK_VALUE "Xb_bookmark_2"
#define XBEL_1_DO_VALUE "Xb_do_1"
#define XBEL_2_DO_VALUE "Xb_do_2"
#define XBEL_1_LAYOUT_VALUE "Xb_layout_1"
#define XBEL_2_LAYOUT_VALUE "Xb_layout_2"
#define XBEL_1_IGNORE_TOOLBAR_VALUE "Xb_ignore_toolbar_1"
#define XBEL_2_IGNORE_TOOLBAR_VALUE "Xb_ignore_toolbar_2"

#ifdef WITH_OP15
#define OP15_1_BOOKMARK_VALUE "Op15_bookmark_1"
#define OP15_2_BOOKMARK_VALUE "Op15_bookmark_2"
#define OP15_1_DO_VALUE "Op15_do_1"
#define OP15_2_DO_VALUE "Op15_do_2"
#define OP15_1_IN_FOLDER_VALUE "Op15_ignore_toolbar_1"
#define OP15_2_IN_FOLDER_VALUE "Op15_ignore_toolbar_2"
#define OP15_1_OPTIMIZE_VALUE "Op15_optimize_1"
#define OP15_2_OPTIMIZE_VALUE "Op15_optimize_2"
#endif	// WITH_OP15

#define OP19_1_BOOKMARK_VALUE "Op19_bookmark_1"
#define OP19_2_BOOKMARK_VALUE "Op19_bookmark_2"
#define OP19_1_DO_VALUE "Op19_do_1"
#define OP19_2_DO_VALUE "Op19_do_2"
#define OP19_1_IN_FOLDER_VALUE "Op19_in_folder_1"
#define OP19_2_IN_FOLDER_VALUE "Op19_in_folder_2"
#define OP19_1_LAYOUT_VALUE "Op19_layout_1"
#define OP19_2_LAYOUT_VALUE "Op19_layout_2"
#define OP19_1_IGNORE_TOOLBAR_VALUE "Op19_ignore_toolbar_1"
#define OP19_2_IGNORE_TOOLBAR_VALUE "Op19_ignore_toolbar_2"
#define OP19_1_IGNORE_TRASH_VALUE "Op19_ignore_trash_1"
#define OP19_2_IGNORE_TRASH_VALUE "Op19_ignore_trash_2"
#define OP19_1_IGNORE_UNSORTED_VALUE "Op19_ignore_unsorted_1"
#define OP19_2_IGNORE_UNSORTED_VALUE "Op19_ignore_unsorted_2"
#define OP19_SPEEDDIAL_VALUE "Op19_speeddial"

#define EDGE_BOOKMARK_VALUE "Edge_bookmark"
#define EDGE_DO "Edge_do"
#define EDGE_NO_LINK "NoEdgelink"
#define EDGE_USE_LINK "UseEdgelink"
#define EDGE_DELETE "Edge_delete"
#define EDGE_SYNC_LINK "Edge_SyncFx3link"
#define EDGE_NO_LINK_TO_MENU "Edge_NoLinkToMenu"

#define VI_1_BOOKMARK_VALUE "Vi_bookmark_1"
#define VI_2_BOOKMARK_VALUE "Vi_bookmark_2"
#define VI_1_DO_VALUE "Vi_do_1"
#define VI_2_DO_VALUE "Vi_do_2"
#define VI_1_IGNORE_TRASH_VALUE "Vi_ignore_trash_1"
#define VI_2_IGNORE_TRASH_VALUE "Vi_ignore_trash_2"
#define VI_1_LAYOUT_VALUE "Vi_layout_1"
#define VI_2_LAYOUT_VALUE "Vi_layout_2"

#define EDGE2_1_BOOKMARK_VALUE "Edge2_bookmark_1"
#define EDGE2_2_BOOKMARK_VALUE "Edge2_bookmark_2"
#define EDGE2_1_DO_VALUE "Edge2_do_1"
#define EDGE2_2_DO_VALUE "Edge2_do_2"
#define EDGE2_1_IGNORE_TOOLBAR_VALUE "Edge2_ignore_toolbar_1"
#define EDGE2_2_IGNORE_TOOLBAR_VALUE "Edge2_ignore_toolbar_2"

#define REGVALUE_CONVERTALL "ConvertAll"
#define REGVALUE_LEAVE_DUPLICATE_NAME "LeaveDuplicateName"
#define REGVALUE_NORMALIZE "Normalize"
#define REGVALUE_NOIEFAVBAR "NoIEFavoriteBar"
#define REGVALUE_XPOS "XPos"
#define REGVALUE_YPOS "YPos"

/* eAvP[ṼEChENX */
#define NSAECLASS "NS_AE_WindowClass"
#define NS4CLASS "NetscapeSlaveClass"
#define OPERACLASS "Opera Main Window"
#define OPERA7CLASS "OpWindow"
#define SAFARICLASS "{1C03B488-D53B-4a81-97F8-754559640193}"

#define BSAPRUNNING "BookSync - ss\"
#define MOZRUNNING "Firefox/SeaMonkey/Netscape/MozillaIĂ\nsĂB"
#define OPERARUNNING "OperaIĂ\nsĂB"
#define NS4RUNNING "Netscape Communicator/Navigator 4\nIĂsĂB"
#define NSAERUNNING "Netscape 8\nIĂsĂB"
#define SAFARIRUNNING "SafariIĂ\nsĂB"
#define CHROMERUNNING "ChromeIĂ\nsĂB"
#define OPERA15RUNNING "Opera 15ȍ~IĂ\nsĂB"
#define VIRUNNING "VivaldiIĂ\nsĂB"
#define EDGE2RUNNING "EdgeIĂ\nsĂB"

#define SYNCOPTIONERROR "wG["
#define CONVERTOPTIONERROR "ϊwG["

#if (WITH_EDGE && WITH_OP15)
#define BROWSER_TYPES 12
#elif WITH_EDGE
#define BROWSER_TYPES 11
#elif WITH_OP15
#define BROWSER_TYPES 11
#else
#define BROWSER_TYPES 10
#endif

typedef DWORD (WINAPI *FWINLAYER)(HWND hwnd,DWORD crKey,BYTE bAlpha,DWORD dwFlags);
// _CAOɃe[}̃eNX`Kp邽߂API
typedef HRESULT (WINAPI *pEnableThemeDialogTexture)(HWND hwnd,DWORD dwFlags);

class BookSyncForm : public BaseForm {
private:
	// EChE{̏̕i
	TwrGroupBox *actionGroup;
	TwrGroupBox *settingGroup;
	TwrButton *syncButton;
	TwrButton *convButton;
	TwrButton *editButton;
	TwrButton *aboutButton;
	TwrButton *helpButton;
	TwrCheckbox *updateCheckbox;
	TwrCombobox *propertyCombobox;
	TwrCombobox *sortCombobox;
	TwrTab *settingTab;
	TwrText *propertyText;
	TwrText *sortText;
	TwrMenu *menu;

	// e^ũ_CAO
	CMozForm *m_MozForm;
	COperaForm *m_OperaForm;
	CIEForm *m_IEForm;
#ifdef WITH_EDGE
	CEdgeForm *m_EdgeForm;
#endif	// WITH_EDGE
	CFxForm *m_FxForm;
	CSfForm *m_SfForm;
	CChForm *m_ChForm;
	CXbForm *m_XbForm;
#ifdef WITH_OP15
	COp15Form *m_Op15Form;
#endif	// WITH_OP15
	COp19Form *m_Op19Form;
	CViForm *m_ViForm;
	CEdge2Form *m_Edge2Form;

	BaseDialog *settingDialogs[BROWSER_TYPES];
	int m_nCurPage;	// ݕ\̃y[W

	// j[̃`FbN{bNX֘A
	bool syncBeforeEdit;	// ҏWOɓ邩ǂ
	bool convertAll;		// ׂẴubN}[Nϊ邩ǂ
	bool leaveDuplicateName;	// URLقȂ閼OdubN}[NcH
	bool normalize;			// Xy[X𐳋K邩?
	bool noIEFavbar;		// IÊCɓo[o͂ȂH

	bool syncOnRun;			// Nɓ邩?
	bool convertOnRun;		// Nɕϊ邩?
	bool editOnRun;			// NɕҏW邩?

	bool autoExecOnRun;		// NɕϊEҏWs邩?
	bool noReport;			// \ȗ邩?

	// ϊEҏWݒ
	int m_editSelection;	// ȑO̕ҏW̑I

	int priority[ALL_BOOKMARKS];		// D揇
	bool sourceChecked[ALL_BOOKMARKS];	// ϊƂă`FbN
	bool destinationChecked[ALL_BOOKMARKS];	// ϊƂă`FbN

	HINSTANCE hDLL;
	Configuration m_config;

	CAboutDlg *aboutDlg;
	CPriorityDlg *priorityDlg;
	CProgress *m_progress;

	int winVer;
	FWINLAYER pfWin;
	ITaskbarList3 *m_taskbar;

	tstring m_settingFile;

	int logLevel;
	RECT posInfo;

	virtual LRESULT OnDpiChanged(void);
	void OnCommandOpen();
	void OnCommandSave();
	void OnCommandSaveAs();
	void OnCommandPrefer();
	void OnCommandDefConv();
	void OnCommandDefEdit();
	void OnCommandIEOrderReset();
#ifdef WITH_EDGE
	void OnCommandEdgeFavReset();
#endif
	void OnCommandBackup();
	void OnCommandRestore();
	void OnCommandAbout();

	void showHelp(void);
	void setupBackupList(const char *bookmarkFiles[]);
	int doBackup(tstring &path);
	void updateCurrentPage(void)
	{
		settingDialogs[m_nCurPage]->UpdateData(true);
	}
	bool checkSyncOption();
	int checkRunning(const char *pWinClass);
	int checkMozillaRunning(void);
	int checkChromeRunning(void);
	int checkOperaRunning(void);
	int checkVivaldiRunning(void);
	int checkEdge2Running(void);

	bool checkBrowserRunning(void);
	int countSyncTarget(Configuration *m_config);
	void showSuccessResult(const TCHAR *message,const TCHAR *title);
	void showErrorResult(const TCHAR *message,const TCHAR *title);
	bool checkConvertEmpty();
	bool checkFxConvert();
	void setWindowPos(void);

	int selectConvertTarget();
	int preEditSync();
	void reflectEdit();
	bool checkSelection(int no);
	void setProgressMessage(int no);

	int runThread(Configuration *config,int type,int priorBookmark,int progresses);

public:
	// 𓯊uEU̎
	int m_useAttribute;
	// \[g
	int m_sortMode;
	// XV[hŃubN}[N̓sǂw肵܂B
	bool m_Update;

	// vpeBw肵܂B
	int Property;

	// IẼNo[𑼂̃uEUɔf邩ǂH
	bool m_useIElink;
	// ϊOIÊCɓ邩ǂw肷
	bool m_IEdel;

	BookSyncForm();
	~BookSyncForm();

	// NIvVŝŁA3public

	// 
	void OnCommandSync(); 
	// ϊ
	void OnCommandConvert();
	// ҏW
	void OnCommandEdit();
	// I
	void OnCommandExit();

	// obNAbv
	void OnOptionBackup(tstring &path);

	// Eϊݒǂݍ
	void getSettings(IProfile *profile);
	// Eϊݒ菑
	int setSettings(IProfile *profile);
	// AvP[Vݒǂݍ
	void getAppliSettings(IProfile *profile);
	// AvP[Vݒǂݍ
	void setAppliSettings(IProfile *profile);

	void setMozForm(CMozForm *newForm)
	{
		m_MozForm = newForm;
	}
	void setOperaForm(COperaForm *newForm)
	{
		m_OperaForm = newForm;
	}
	void setIEForm(CIEForm *newForm)
	{
		m_IEForm = newForm;
	}
#ifdef WITH_EDGE
	void setEdgeForm(CEdgeForm *newForm)
	{
		m_EdgeForm = newForm;
	}
#endif	// WITH_EDGE
	void setFxForm(CFxForm *newForm)
	{
		m_FxForm = newForm;
	}
	void setSfForm(CSfForm *newForm)
	{
		m_SfForm = newForm;
	}
	void setChForm(CChForm *newForm)
	{
		m_ChForm = newForm;
	}
	void setXbForm(CXbForm *newForm)
	{
		m_XbForm = newForm;
	}

#ifdef WITH_OP15
	void setOp15Form(COp15Form *newForm)
	{
		m_Op15Form = newForm;
	}
#endif	// WITH_OP15

	void setOp19Form(COp19Form *newForm)
	{
		m_Op19Form = newForm;
	}
	void setViForm(CViForm *newForm)
	{
		m_ViForm = newForm;
	}
	void setEdge2Form(CEdge2Form *newForm)
	{
		m_Edge2Form = newForm;
	}
	void UpdateData(bool toObj);
	void UpdateDataAll(bool toObj);

	LRESULT OnCommand(int wmId, int wmEvent);
	LRESULT OnCreate();
	LRESULT OnNotify(LPNMHDR nmhdr);
	LRESULT OnDestroy();

	// j[̃`FbN{bNX֘A
	void setSyncBeforeEdit(bool flag) {
		syncBeforeEdit = flag;
	}
	bool getSyncBeforeEdit(void) {
		return syncBeforeEdit;
	}
	void setConvertAll(bool flag) {
		convertAll = flag;
	}
	bool getConvertAll(void) {
		return convertAll;
	}
	bool getLeaveDuplicateName(void) {
		return leaveDuplicateName;
	}
	void setLeaveDuplicateName(bool flag) {
		leaveDuplicateName = flag;
	}
	bool getNormalize(void) {
		return normalize;
	}
	void setNormalize(bool flag) {
		normalize = flag;
	}
	bool getNoIEFavbar(void) {
		return noIEFavbar;
	}
	void setNoIEFavbar(bool flag) {
		noIEFavbar = flag;
	}

	// ϊEҏWݒ
	int getEditSelection(void) {
		return m_editSelection;
	}
	void setEditSelection(int no) {
		m_editSelection = no;
	}

	int getPriority(int order) {
		return priority[order];
	}
	void setPriority(int order,int type) {
		priority[order] = type;
	}

	/**
	 * ϊ̐ݒ𓾂
	 *
	 * @param no ϊubN}[N̔ԍ
	 * @return true:ubN}[N͕ϊł false:ubN}[N͕ϊłȂ
	 */
	bool getSourceChecked(int no) {
		return sourceChecked[no];
	}
	/**
	 * ϊ̐ݒݒ肷
	 *
	 * @param no ϊubN}[N̔ԍ
	 * @param status true:ubN}[N͕ϊł false:ubN}[N͕ϊłȂ
	 */
	void setSourceChecked(int no,bool status) {
		sourceChecked[no] = status;
	}

	/**
	 * ϊ̐ݒ𓾂
	 *
	 * @param no ϊubN}[N̔ԍ
	 * @return true:ubN}[N͕ϊł false:ubN}[N͕ϊłȂ
	 */
	bool getDestinationChecked(int no) {
		return destinationChecked[no];
	}
	/**
	 * ϊ̐ݒݒ肷
	 *
	 * @param no ϊubN}[N̔ԍ
	 * @param status true:ubN}[N͕ϊł false:ubN}[N͕ϊłȂ
	 */
	void setDestinationChecked(int no,bool status) {
		destinationChecked[no] = status;
	}

	/**
	 * ݒt@Cݒ肷B
	 *
	 * @param settingFileName ݒt@C
	 */
	void setSettingFileName(tstring &settingFileName) {
		m_settingFile = settingFileName;
	}

	void setApplicationTitle(void); 

	// Nݒ

	void setLogLevel(int level) {
		logLevel = level;
	}

	void setSyncOnRun(bool flag) {
		syncOnRun = flag;
	}

	void setConvertOnRun(bool flag) {
		convertOnRun = flag;
	}

	void setEditOnRun(bool flag) {
		editOnRun = flag;
	}

	void setAutoExecOnRun(bool flag) {
		autoExecOnRun = flag;
	}

	void setNoReport(bool flag) {
		noReport = flag;
	}
};

BOOL CALLBACK setFont(HWND hwnd, LPARAM lparam);

#endif // BOOKSYNCFORM_H
