#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <tchar.h>
#include <windows.h>
#include <shellapi.h>
#include <commctrl.h>
#include <process.h>

#include "BScommon.h"
#include "bslib.h"
#include "util.h"

#include "NCFileDialog.h"

#include "AppliBase/AppliBase.h"
#include "GuiDefine.h"
#include "BookSyncForm.h"
#include "BrowserSelect.h"
#include "EditSelect.h"
#include "Progress.h"
#include "Backup.h"
#include "IProfile.h"
#include "IniProfile.h"
#include "IeOrder.h"
#ifdef WITH_EDGE
#include "EdgeDBCleaner.h"
#endif
#include "Logger.h"
#include "core.h"

#ifdef WITH_EDGE
// Edge^üʒu
#define EDGE_TAB_INDEX 8
#endif

const char *progressTitle[3] = {
	"BookSync - s...",
	"BookSync - ϊs...",
	"BookSync - ҏWs...",
};

// ǂݍ݂̐iԃeLXg
const char *progressText[ALL_BOOKMARKS * 2 + 2] = {
	"Firefox 2/Netscape/MozillãubN}[N1ǂݍݒłB",
	"Firefox 2/Netscape/MozillãubN}[N2ǂݍݒłB",
	"Opera 12ȑÕubN}[N1ǂݍݒłB",
	"Opera 12ȑÕubN}[N2ǂݍݒłB",
	"IÊCɓǂݍݒłB",
	"IÊCɓłB",
	"IÊCɓ֏ݒłB",
	"Firefox 2/Netscape/MozillãubN}[N1֏ݒłB",
	"Firefox 2/Netscape/MozillãubN}[N2֏ݒłB",
	"Opera 12ȑÕubN}[N1֏ݒłB",
	"Opera 12ȑÕubN}[N2֏ݒłB",
	"Firefox 3ȍ~̃ubN}[N1ǂݍݒłB",
	"Firefox 3ȍ~̃ubN}[N2ǂݍݒłB",
	"Firefox 3ȍ~̃ubN}[N1֏ݒłB",
	"Firefox 3ȍ~̃ubN}[N2֏ݒłB",
	"SafarĩubN}[N1ǂݍݒłB",
	"SafarĩubN}[N2ǂݍݒłB",
	"SafarĩubN}[N1֏ݒłB",
	"SafarĩubN}[N2֏ݒłB",
	"ChromẽubN}[N1ǂݍݒłB",
	"ChromẽubN}[N2ǂݍݒłB",
	"ChromẽubN}[N1֏ݒłB",
	"ChromẽubN}[N2֏ݒłB",
	"XBELt@C1ǂݍݒłB",
	"XBELt@C2ǂݍݒłB",
	"XBELt@C1֏ݒłB",
	"XBELt@C2֏ݒłB",
	"Opera 15`28̃Xs[h_C1ǂݍݒłB",
	"Opera 15`28̃Xs[h_C2ǂݍݒłB",
	"Opera 15`28̃Xs[h_C1֏ݒłB",
	"Opera 15`28̃Xs[h_C2֏ݒłB",
	"Opera 25ȍ~̃ubN}[N1ǂݍݒłB",
	"Opera 25ȍ~̃ubN}[N2ǂݍݒłB",
	"Opera 25ȍ~̃ubN}[N1֏ݒłB",
	"Opera 25ȍ~̃ubN}[N2֏ݒłB",
	"EdgêCɓǂݍݒłB",
	"EdgêCɓ֏ݒłB",
	"EdgêCɓłB",
	"VivaldĩubN}[N1ǂݍݒłB",
	"VivaldĩubN}[N2ǂݍݒłB",
	"VivaldĩubN}[N1֏ݒłB",
	"VivaldĩubN}[N2֏ݒłB",
	"EdgêCɓ1ǂݍݒłB",
	"EdgêCɓ2ǂݍݒłB",
	"EdgêCɓ1֏ݒłB",
	"EdgêCɓ2֏ݒłB",
};

// ubN}[NobNAbvʃbZ[W
const char *backupMessages[ALL_BOOKMARKS + 2] = {
	"ubN}[NECɓ̕ۑɐ܂B",
	"ubN}[NECɓ̕ۑɎs܂B",
	"IÊCɓ̕ۑɎs܂B",
	"Firefox 2/Netscape/MozillãubN}[N1̕ۑɎs܂B",
	"Firefox 2/Netscape/MozillãubN}[N2̕ۑɎs܂B",
	"Opera 12ȑÕubN}[N1̕ۑɎs܂B",
	"Opera 12ȑÕubN}[N2̕ۑɎs܂B",
	"Firefox 3ȍ~̃ubN}[N1̕ۑɎs܂B",
	"Firefox 3ȍ~̃ubN}[N2̕ۑɎs܂B",
	"SafarĩubN}[N1̕ۑɎs܂B",
	"SafarĩubN}[N2̕ۑɎs܂B",
	"ChromẽubN}[N1̕ۑɎs܂B",
	"ChromẽubN}[N2̕ۑɎs܂B",
	"XBELt@C1̕ۑɎs܂B",
	"XBELt@C2̕ۑɎs܂B",
	"Opera 15`28̃Xs[h_C1̕ۑɎs܂B",
	"Opera 15`28̃Xs[h_C2̕ۑɎs܂B",
	"Opera 25ȍ~̃ubN}[N1̕ۑɎs܂B",
	"Opera 25ȍ~̃ubN}[N2̕ۑɎs܂B",
	"EdgêCɓ̕ۑɎs܂B",
	"VivaldĩubN}[N1̕ۑɎs܂B",
	"VivaldĩubN}[N2̕ۑɎs܂B",
	"EdgêCɓ1̕ۑɎs܂B",
	"EdgêCɓ2̕ۑɎs܂B",
};

// ubN}[NXgAʃbZ[W
const char *restoreMessages[ALL_BOOKMARKS + 2] = {
	"ubN}[NECɓ̕ɐ܂B",
	"ubN}[NECɓ̕Ɏs܂B",
	"IÊCɓ̕Ɏs܂B",
	"Firefox 2/Netscape/MozillãubN}[N1̕Ɏs܂B",
	"Firefox 2/Netscape/MozillãubN}[N2̕Ɏs܂B",
	"Opera 12ȑÕubN}[N1̕Ɏs܂B",
	"Opera 12ȑÕubN}[N2̕Ɏs܂B",
	"Firefox 3ȍ~̃ubN}[N1̕Ɏs܂B",
	"Firefox 3ȍ~̃ubN}[N2̕Ɏs܂B",
	"SafarĩubN}[N1̕Ɏs܂B",
	"SafarĩubN}[N2̕Ɏs܂B",
	"ChromẽubN}[N1̕Ɏs܂B",
	"ChromẽubN}[N2̕Ɏs܂B",
	"XBELt@C1̕Ɏs܂B",
	"XBELt@C2̕Ɏs܂B",
	"Opera 15`28̃Xs[h_C1̕Ɏs܂B",
	"Opera 15`28̃Xs[h_C2̕Ɏs܂B",
	"Opera 25ȍ~̃ubN}[N1̕Ɏs܂B",
	"Opera 25ȍ~̃ubN}[N2̕Ɏs܂B",
	"EdgêCɓ̕Ɏs܂B",
	"VivaldĩubN}[N1̕Ɏs܂B",
	"VivaldĩubN}[N2̕Ɏs܂B",
	"EdgêCɓ1̕Ɏs܂B",
	"EdgêCɓ2̕Ɏs܂B",
};

/**
 * Xg\Ǝۂ̃ubN}[N̎ނ̑Ή
 * ҏWΏۃubN}[N_CAOƂ邱Ƃ͈ꏏA
 * ҏWΏۂɂȂubN}[NoɔĕʓrzpӂB
 */
static int attributeNo[HAS_COMMENT_BOOKMARKS + 1] = {
	0,	// RgDȂ
	BOOKMARK_FIREFOX_1,	// Firefox 1
	BOOKMARK_FIREFOX_2,	// Firefox 2
	BOOKMARK_CHROME_1,	// Chrome 1
	BOOKMARK_CHROME_2,	// Chrome 2
	BOOKMARK_VIVALDI_1,	// Vivaldi 1
	BOOKMARK_VIVALDI_2,	// Vivaldi 2
	BOOKMARK_XBEL_1,	// XBEL 1
	BOOKMARK_XBEL_2,	// XBEL 2
	BOOKMARK_MOZILLA_1,	// Mozilla 1
	BOOKMARK_MOZILLA_2,	// Mozilla 2
	BOOKMARK_OPERA_1,	// Opera 12-1
	BOOKMARK_OPERA_2	// Opera 12-2
};

/**
 * EChE̎NX
 */

/**
 * RXgN^
 */
BookSyncForm::BookSyncForm()
{
	actionGroup = NULL;
	settingGroup = NULL;
	syncButton = NULL;
	convButton = NULL;
	editButton = NULL;
	aboutButton = NULL;
	helpButton = NULL;
	updateCheckbox = NULL;
	propertyCombobox = NULL;
	sortCombobox = NULL;
	settingTab = NULL;
	menu = NULL;

	m_MozForm = NULL;
	m_OperaForm = NULL;
	m_IEForm = NULL;
#ifdef WITH_EDGE
	m_EdgeForm = NULL;
#endif	// WITH_EDGE
	m_FxForm = NULL;
	m_SfForm = NULL;
	m_ChForm = NULL;
	m_XbForm = NULL;
#ifdef WITH_OP15
	m_Op15Form = NULL;
#endif	// WITH_OP15
	m_Op19Form = NULL;
	m_ViForm = NULL;
	m_Edge2Form = NULL;

	propertyText = NULL;
	sortText = NULL;
	m_nCurPage = 0;

	for (int i = 0; i < BROWSER_TYPES; i++) {
		settingDialogs[i] = NULL;
	}

	hDLL = NULL;
	m_taskbar = NULL;

	syncOnRun = false;
	convertOnRun = false;
	editOnRun = false;
	autoExecOnRun = false;
	noReport = false;

	m_settingFile = _T("");

	posInfo.left = INT_MIN;
	posInfo.top = INT_MIN;

	font = NULL;
}

/**
 * fXgN^
 */
BookSyncForm::~BookSyncForm()
{
	if (hDLL != NULL) {
		FreeLibrary(hDLL);
	}

	if (menu != NULL) {
		delete menu;
	}

	if (settingTab != NULL) {
		delete settingTab;
	}

	if (sortText != NULL) {
		delete sortText;
	}

	if (propertyText != NULL) {
		delete propertyText;
	}

	if (sortCombobox != NULL) {
		delete sortCombobox;
	}

	if (propertyCombobox != NULL) {
		delete propertyCombobox;
	}

	if (updateCheckbox != NULL) {
		delete updateCheckbox;
	}

	if (helpButton != NULL) {
		delete helpButton;
	}

	if (aboutButton != NULL) {
		delete aboutButton;
	}

	if (editButton != NULL) {
		delete editButton;
	}

	if (convButton != NULL) {
		delete convButton;
	}

	if (syncButton != NULL) {
		delete syncButton;
	}

	if (settingGroup != NULL) {
		delete settingGroup;
	}

	if (actionGroup != NULL) {
		delete actionGroup;
	}
}

/**
 * ʏ̃f[^/ϐXVB
 *
 * @param toObj true:ʏ̃Rg[ɐݒ肷 false:ϐɐݒ肷
 */
void BookSyncForm::UpdateData(bool toObj)
{
	FDX_CBIndex(toObj, propertyCombobox, m_useAttribute);
	FDX_CBIndex(toObj, sortCombobox, m_sortMode);
	FDX_Check(toObj, updateCheckbox, m_Update);
}

/**
 * WM_COMMAND̏
 *
 * @param wmId R}hID
 * @param wmEvent  0:j[ 1:ANZ[^ 2ȍ~:EChEnh
 * @return (R}h0ԂB)
 */
LRESULT BookSyncForm::OnCommand(int wmId, int wmEvent)
{
	// Iꂽj[̉:
	switch (wmId)
	{
		case IDM_OPEN:
			OnCommandOpen();
			break;
		case IDM_SAVE:
			OnCommandSave();
			break;
		case IDM_SAVEAS:
			OnCommandSaveAs();
			break;
		case IDM_EXIT:
			OnCommandExit();
			break;
		case IDM_SYNC:
			OnCommandSync();
			break;
		case IDM_CONV:
			OnCommandConvert();
			break;
		case IDM_EDIT:
			OnCommandEdit();
			break;
		case IDM_SAVEBOOKMARK:
			OnCommandBackup();
			break;
		case IDM_LOADBOOKMARK:
			OnCommandRestore();
			break;
		case IDM_SETPREFER:
			OnCommandPrefer();
			break;
		case IDM_DEFCONV:
			OnCommandDefConv();
			break;
		case IDM_DEFEDIT:
			OnCommandDefEdit();
			break;
		case IDM_RESET_IEORDER:
			OnCommandIEOrderReset();
			break;
#ifdef WITH_EDGE
		case IDM_RESET_EDGE_FAVRITES:
			OnCommandEdgeFavReset();
			break;
#endif
		case IDM_SYNCBEFOREEDIT:
			if (syncBeforeEdit) {
				syncBeforeEdit = false;
			} else {
				syncBeforeEdit = true;
			}
			menu->CheckMenuItem(IDM_SYNCBEFOREEDIT, syncBeforeEdit);
			break;
		case IDM_CONVERT_ALL:
			if (convertAll) {
				convertAll = false;
			} else {
				convertAll = true;
			}
			menu->CheckMenuItem(IDM_CONVERT_ALL, convertAll);
			break;
		case IDM_LEAVE_DUPLICATE_NAME:
			if (leaveDuplicateName) {
				leaveDuplicateName = false;
			} else {
				leaveDuplicateName = true;
			}
			menu->CheckMenuItem(IDM_LEAVE_DUPLICATE_NAME, leaveDuplicateName);
			break;
		case IDM_NOMALIZE:
			if (normalize) {
				normalize = false;
			} else {
				normalize = true;
			}
			menu->CheckMenuItem(IDM_NOMALIZE, normalize);
			break;
		case IDM_NO_IEFAVBAR:
			if (noIEFavbar) {
				noIEFavbar = false;
			} else {
				noIEFavbar = true;
			}
			menu->CheckMenuItem(IDM_NO_IEFAVBAR, noIEFavbar);
			break;
		case IDM_HELP_INDEX:
			showHelp();
			break;
		case IDM_ABOUT:
			OnCommandAbout();
			break;
	}

	return BaseForm::OnCommand(wmId, wmEvent);
}

/**
 * EChẼRg[
 *
 * @return BaseForm::OnCreate()̌
 */
LRESULT BookSyncForm::OnCreate()
{
	HDC hdc;	// foCXReLXg
	PAINTSTRUCT p;


	hdc = BeginPaint(hWnd,&p);
	int fontSize = 0 - MulDiv(9, GetDeviceCaps(hdc, LOGPIXELSY), 72);
	EndPaint(hWnd, &p);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH|FF_MODERN,
		FONT_FACE);

	clientWidth = 706;
	clientHeight = 327;
	// DPIɃEChETCYݒ肵DPIɍEChȆ傫ݒ肷B
	setSize(716, 385);

	// p{^Xy[X
	actionGroup = new TwrGroupBox();
	actionGroup->create(hWnd);
	actionGroup->setText(_T(""));
	actionGroup->setPoint(9, 15);
	actionGroup->setSize(117, 305);
	actionGroup->setFont(font);

	syncButton = new TwrButton();
	syncButton->create(hWnd, (HMENU)IDM_SYNC);
	syncButton->setText(_T(""));
	syncButton->setPoint(15, 39);
	syncButton->setSize(108, 38);
	syncButton->setFont(font);

	convButton = new TwrButton();
	convButton->create(hWnd, (HMENU)IDM_CONV);
	convButton->setText(_T("ϊ"));
	convButton->setPoint(15, 93);
	convButton->setSize(108, 38);
	convButton->setFont(font);

	editButton = new TwrButton();
	editButton->create(hWnd, (HMENU)IDM_EDIT);
	editButton->setText(_T("ҏW"));
	editButton->setPoint(15, 149);
	editButton->setSize(108, 38);
	editButton->setFont(font);

	aboutButton = new TwrButton();
	aboutButton->create(hWnd, (HMENU)IDM_ABOUT);
	aboutButton->setText(_T("About"));
	aboutButton->setPoint(15, 201);
	aboutButton->setSize(108, 38);
	aboutButton->setFont(font);

	helpButton = new TwrButton();
	helpButton->create(hWnd, (HMENU)IDM_HELP_INDEX);
	helpButton->setText(_T("wv"));
	helpButton->setPoint(15, 255);
	helpButton->setSize(108, 38);
	helpButton->setFont(font);

	// uEUƂ̐ݒ^u̓e
	
	settingGroup = new TwrGroupBox();
	settingGroup->create(hWnd);
	settingGroup->setText(_T("Ώۂ̃ubN}[NECɓ̐ݒ"));
	settingGroup->setPoint(132, 15);
	settingGroup->setSize(565, 305);
	settingGroup->setFont(font);

	settingTab = new TwrTab();
	settingTab->create(hWnd);
	settingTab->setSize(548, 250);
	settingTab->setPoint(141, 35);
	settingTab->add(_T("Firefox 3ȍ~"));
	settingTab->add(_T("IE"));
	settingTab->add(_T("Edge"));
	settingTab->add(_T("Chrome"));
#ifdef WITH_OP15
	settingTab->add(_T("Opera15-28 SPD"));
#endif	// WITH_OP15
	settingTab->add(_T("Opera 25ȍ~"));
	settingTab->add(_T("Vivaldi"));
	settingTab->add(_T("HTML(Firefox 2)"));
	settingTab->add(_T("XBEL"));
#ifdef WITH_EDGE
	settingTab->add(_T("Edge(Old)"));
#endif	// WITH_EDGE
	settingTab->add(_T("Opera 12ȑO"));
	settingTab->add(_T("Safari"));
	settingTab->setFont(font);

	int dialogPos = 0;
	settingDialogs[dialogPos] = m_FxForm;
	dialogPos++;
	settingDialogs[dialogPos] = m_IEForm;
	dialogPos++;
	settingDialogs[dialogPos] = m_Edge2Form;
	dialogPos++;
	settingDialogs[dialogPos] = m_ChForm;
	dialogPos++;
#ifdef WITH_OP15
	settingDialogs[dialogPos] = m_Op15Form;
	dialogPos++;
#endif	// WITH_OP15
	settingDialogs[dialogPos] = m_Op19Form;
	dialogPos++;
	settingDialogs[dialogPos] = m_ViForm;
	dialogPos++;
	settingDialogs[dialogPos] = m_MozForm;
	dialogPos++;
	settingDialogs[dialogPos] = m_XbForm;
	dialogPos++;
#ifdef WITH_EDGE
	settingDialogs[dialogPos] = m_EdgeForm;
	dialogPos++;
#endif	// WITH_EDGE
	settingDialogs[dialogPos] = m_OperaForm;
	dialogPos++;
	settingDialogs[dialogPos] = m_SfForm;
	for (int i = 0; i < BROWSER_TYPES; i++) {
		settingDialogs[i]->setSize(538, 200);
	}

	// ̋ʐݒ{^
	propertyText = new TwrText();
	propertyText->create(hWnd);
	propertyText->setPoint(141, 294);
	propertyText->setSize(56, 18);
	propertyText->setText(_T("vpeBF"));
	propertyText->setFont(font);

	propertyCombobox = new TwrCombobox();
	propertyCombobox->create(hWnd);
	propertyCombobox->setPoint(197, 291);
	propertyCombobox->setSize(100, 200);
	propertyCombobox->setStyle(CBS_DROPDOWNLIST);
	propertyCombobox->setFont(font);

	sortText = new TwrText();
	sortText->create(hWnd);
	sortText->setPoint(310, 294);
	sortText->setSize(50, 18);
	sortText->setText(_T("\[gF"));
	sortText->setFont(font);

	sortCombobox = new TwrCombobox();
	sortCombobox->create(hWnd);
	sortCombobox->setPoint(365, 291);
	sortCombobox->setSize(150, 200);
	sortCombobox->setStyle(CBS_DROPDOWNLIST);
	sortCombobox->setFont(font);

	updateCheckbox = new TwrCheckbox();
	updateCheckbox->create(hWnd);
	updateCheckbox->setText(_T("XV"));
	updateCheckbox->setPoint(525, 294);
	updateCheckbox->setSize(58, 14);
	updateCheckbox->setFont(font);

	add(actionGroup);
	add(syncButton);
	add(convButton);
	add(editButton);
	add(aboutButton);
	add(helpButton);

	add(settingGroup);
	add(settingTab);
	add(propertyText);
	add(propertyCombobox);
	add(sortText);
	add(sortCombobox);
	add(updateCheckbox);
	add(m_FxForm);
	add(m_OperaForm);
	add(m_IEForm);
	add(m_Edge2Form);
	add(m_SfForm);
	add(m_ChForm);
	add(m_MozForm);
	add(m_XbForm);
#ifdef WITH_OP15
	add(m_Op15Form);
#endif	// WITH_OP15
	add(m_Op19Form);
	add(m_ViForm);
#ifdef WITH_EDGE
	add(m_EdgeForm);
#endif	// WITH_EDGE

	propertyCombobox->addItem(_T("D揇ʂȂ"));
	propertyCombobox->addItem(_T("Firefox1"));
	propertyCombobox->addItem(_T("Firefox2"));
	propertyCombobox->addItem(_T("Chrome1"));
	propertyCombobox->addItem(_T("Chrome2"));
	propertyCombobox->addItem(_T("Vivaldi1"));
	propertyCombobox->addItem(_T("Vivaldi2"));
	propertyCombobox->addItem(_T("XBEL1"));
	propertyCombobox->addItem(_T("XBEL2"));
	propertyCombobox->addItem(_T("Mozilla1"));
	propertyCombobox->addItem(_T("Mozilla2"));
	propertyCombobox->addItem(_T("Opera12-1"));
	propertyCombobox->addItem(_T("Opera12-2"));

	sortCombobox->addItem(_T("̃ubN}[N̏"));
	sortCombobox->addItem(_T("O(fBNgD)"));
	sortCombobox->addItem(_T("O"));
	sortCombobox->addItem(_T("URL"));
	sortCombobox->addItem(_T("Ȃ"));

	for (int i = 0; i < BROWSER_TYPES; i++) {
		settingDialogs[i]->showModeless();
		settingDialogs[i]->setPoint(145, 63);
		// ̎_ł́A_CAO͂܂łĂȂ̂ŁAUpdateData͂łȂB
	}
	UpdateData(false);

	int winVerMajor,winVerMinor;
	DWORD dwver;

	dwver = GetVersion();
	winVerMajor = LOBYTE(LOWORD(dwver));
	winVerMinor = HIBYTE(LOWORD(dwver));
	winVer = winVerMajor;

	// rWAX^Cgƃ^ȕ̔wiFȂ̂łgB
	if ((winVerMajor > 5) ||	// Windows Vista(6.0) or later
		((winVerMajor == 5) && (winVerMinor > 0))){	// Windows XP(5.1)/2003(5.2)

		pEnableThemeDialogTexture EnableThemeDialogTexture;

		hDLL = LoadLibrary("uxtheme.dll");
		EnableThemeDialogTexture = (pEnableThemeDialogTexture)GetProcAddress(hDLL,"EnableThemeDialogTexture");
		if (EnableThemeDialogTexture != NULL){
			// EnableThemeDialogTexture(GetSafeHwnd(),ETDT_ENABLETAB);Ɖ͓
			EnableThemeDialogTexture(m_MozForm->getHwnd(),6);
			EnableThemeDialogTexture(m_OperaForm->getHwnd(),6);
			EnableThemeDialogTexture(m_IEForm->getHwnd(),6);
#ifdef WITH_EDGE
			EnableThemeDialogTexture(m_EdgeForm->getHwnd(), 6);
#endif	// WITH_EDGE
			EnableThemeDialogTexture(m_FxForm->getHwnd(), 6);
			EnableThemeDialogTexture(m_SfForm->getHwnd(),6);
			EnableThemeDialogTexture(m_ChForm->getHwnd(),6);
			EnableThemeDialogTexture(m_XbForm->getHwnd(),6);
#ifdef WITH_OP15
			EnableThemeDialogTexture(m_Op15Form->getHwnd(),6);
#endif	// WITH_OP15
			EnableThemeDialogTexture(m_Op19Form->getHwnd(),6);
			EnableThemeDialogTexture(m_ViForm->getHwnd(), 6);
			EnableThemeDialogTexture(m_Edge2Form->getHwnd(), 6);
		}
		FreeLibrary(hDLL);
	}
	if (winVerMajor > 4){
		LONG info;
		info = ::GetWindowLong(hWnd,GWL_EXSTYLE);	// gX^CQbg
		::SetWindowLong(hWnd,GWL_EXSTYLE,info | WS_EX_LAYERED);
		hDLL = ::LoadLibrary("user32.dll");
		pfWin = (FWINLAYER)::GetProcAddress(hDLL,"SetLayeredWindowAttributes");
		if (pfWin != NULL) {
			pfWin(hWnd,0,255,LWA_ALPHA);
		}
	}

	HRESULT hRes = ::CoCreateInstance(CLSID_TaskbarList,NULL,CLSCTX_INPROC_SERVER,IID_ITaskbarList3,(LPVOID *)&m_taskbar);
	if (FAILED(hRes)) {
		m_taskbar = NULL;
	}

	// ݒ^u̓e\͈ԍŌ
	m_FxForm->ShowWindow(SW_SHOW);

	try {
		menu = new TwrMenu(hWnd);
		if (menu != NULL) {
			menu->CheckMenuItem(IDM_SYNCBEFOREEDIT, syncBeforeEdit);
			menu->CheckMenuItem(IDM_CONVERT_ALL, convertAll);
			menu->CheckMenuItem(IDM_LEAVE_DUPLICATE_NAME, leaveDuplicateName);
			menu->CheckMenuItem(IDM_NOMALIZE, normalize);
			menu->CheckMenuItem(IDM_NO_IEFAVBAR, noIEFavbar);
			if (winVerMajor < 10) {
				// Windows 8.1ł͋Edge͂Ȃ̂ŋEdgêCɓׂč폜
				// Is\ɂB
				menu->SetEnabled(IDM_RESET_EDGE_FAVRITES, false);
			}
		}
	}catch(...) {
	}

	setWindowPos();

	return BaseForm::OnCreate();
}

/**
 * WM_NOTIFY󂯎Ƃ̓B<br>
 * ^u̐؂ւɎgpĂB
 *
 * @param nmhdr ʒme
 * @return WM_NOTIFYɑ΂铮쌋
 */
LRESULT BookSyncForm::OnNotify(LPNMHDR nmhdr)
{
	if (nmhdr->code == TCN_SELCHANGE) {
		if (nmhdr->hwndFrom == settingTab->getHwnd()) {
			settingDialogs[m_nCurPage]->ShowWindow(SW_HIDE);
			settingDialogs[m_nCurPage]->UpdateData(true);

			// NbNꂽy[W
			int newPage = settingTab->getSelectedIndex();

#ifdef WITH_EDGE
			DWORD dwver = ::GetVersion();
			DWORD winVer = LOBYTE(dwver);
			if ((winVer < 10) && (newPage == EDGE_TAB_INDEX)) {
				// Windows 10Edge^uIꂽ猳̃^uēx\
				// Edge^u\łȂ悤ɂB
				settingTab->select(m_nCurPage);
				settingDialogs[m_nCurPage]->ShowWindow(SW_SHOW);

				return BaseForm::OnNotify(nmhdr);
			}
#endif

			settingDialogs[newPage]->ShowWindow(SW_SHOW);
			m_nCurPage = newPage;
		}

	}
	return BaseForm::OnNotify(nmhdr);
}

/**
 * EChEۂɌĂяo܂B
 *
 * @return eNX̃\bh̖߂l
 */
LRESULT BookSyncForm::OnDestroy()
{
	// ʏ̓eIuWFNgɓ]B
	UpdateData(TRUE);
	updateCurrentPage();

	if (m_taskbar != NULL) {
		m_taskbar->Release();
	}
	GetWindowRect(this->getHwnd(),&posInfo);
	return BaseForm::OnDestroy();
}

/**
 * DPIωۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT BookSyncForm::OnDpiChanged(void)
{
	// \p̃tHg蒼B
	if (font != NULL) {
		DeleteObject(font);
	}

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	m_FxForm->setFont(font);
	m_FxForm->applyScale();

	m_OperaForm->setFont(font);
	m_OperaForm->applyScale();

	m_IEForm->setFont(font);
	m_IEForm->applyScale();

#ifdef WITH_EDGE
	m_EdgeForm->setFont(font);
	m_EdgeForm->applyScale();
#endif	// WITH_EDGE

	m_SfForm->setFont(font);
	m_SfForm->applyScale();

	m_ChForm->setFont(font);
	m_ChForm->applyScale();

	m_MozForm->setFont(font);
	m_MozForm->applyScale();

	m_XbForm->setFont(font);
	m_XbForm->applyScale();

#ifdef WITH_OP15
	m_Op15Form->setFont(font);
	m_Op15Form->applyScale();
#endif	// WITH_OP15

	m_Op19Form->setFont(font);
	m_Op19Form->applyScale();

	m_ViForm->setFont(font);
	m_ViForm->applyScale();

	m_Edge2Form->setFont(font);
	m_Edge2Form->applyScale();

	return BaseForm::OnDpiChanged();
}

HWND myHwnd;

/**
 * 񋓂ꂽEChEnhɑ΂AtHgݒ肷B
 *
 * @param hwnd 񋓂ꂽEChEnh
 * @param lparam Ăьnꂽp[^(tHgnh)
 * @return TRUE 񋓂pB
 */
BOOL CALLBACK setFont(HWND hwnd, LPARAM lparam)
{
	HFONT font = (HFONT)lparam;

	SendMessage(hwnd, WM_SETFONT, (WPARAM)font, TRUE);

#if 0
	// Capture control position
	char buf[256];
	RECT r;
	GetWindowRect(hwnd, &r);
	POINT p;
	p.x = r.left;
	p.y = r.top;
	ScreenToClient(myHwnd, &p);

	sprintf(buf, "->setPoint(%d, %d);\n->setSize(%d, %d);\nadd();\n",
		p.x, p.y, r.right - r.left + 1, r.bottom - r.top + 1);
	MessageBox(NULL, buf, "", MB_OK);
	// Capture control position end
#endif

	return TRUE;
}

/**
 * ut@Cv-uIvR}h̃nh
 */
void BookSyncForm::OnCommandExit()
{
	DestroyWindow(hWnd);
}

/**
 * {^̃nh
 *
 */
void BookSyncForm::OnCommandSync() 
{
	// ʏ̓eIuWFNgɓ]B
	UpdateData(TRUE);
	updateCurrentPage();

	// ݒ̐𒲂ׂĂB
	if (!checkSyncOption()){
		return;
	}

	// Ŝ߁AuEUĂƂ͓łȂ悤ɂB
	if (checkBrowserRunning()){
		return;
	}

	if (!syncOnRun) {
		int answer;
		answer = MessageBox(hWnd,_T(
			"euEŨubN}[NACɓ𓯊܂H\n\n"
			"euEŨubN}[NACɓ̓eɂȂ܂B")
			,_T("smF"),MB_YESNO | MB_ICONQUESTION);
		if (answer == IDNO){
			return;
		}
	}

	// IuWFNg̓eϊ[`gIuWFNgɓ]B
	mozFormToConfig(&m_config,m_MozForm);
	operaFormToConfig(&m_config,m_OperaForm);
	ieFormToConfig(&m_config,m_IEForm);
#ifdef WITH_EDGE
	edgeFormToConfig(&m_config, m_EdgeForm);
#endif	// WITH_EDGE
	fxFormToConfig(&m_config, m_FxForm);
	sfFormToConfig(&m_config,m_SfForm);
	chFormToConfig(&m_config,m_ChForm);
	xbFormToConfig(&m_config,m_XbForm);
#ifdef WITH_OP15
	op15FormToConfig(&m_config,m_Op15Form);
#endif	// WITH_OP15
	op19FormToConfig(&m_config,m_Op19Form);
	viFormToConfig(&m_config, m_ViForm);
	edge2FormToConfig(&m_config, m_Edge2Form);

	m_config.setSortType(m_sortMode);
	m_config.setUpdate(m_Update ? true : false);
	m_config.setProperty(attributeNo[m_useAttribute]);
	m_config.setConvertType(Configuration::Sync);
	m_config.setLeaveDuplicateName(leaveDuplicateName);
	m_config.setNormalize(normalize);
	m_config.setNoIEFavbar(noIEFavbar);
	m_config.setConvertAll(false);

	m_config.setEditMode(false);	// ҏW[hł͂Ȃ
	m_config.setEditTarget(-1);		// ҏWΏۂł͂Ȃ̂œKɁB

	// IÊCɓ𓯊ΏۂɂƂIÊCɓݒ
	// ӖȂ̂ŊOB
	if (m_IEForm->m_chkIE1){
		m_config.setIeEraseFavorite(false);
	}
	m_config.setIeNoLinkToMenu(false);
#ifdef WITH_EDGE
	// Edgel
	if (m_EdgeForm->m_chkEdge1){
		m_config.setEdgeEraseFavorite(false);
	}
	m_config.setEdgeNoLinkToMenu(false);
#endif	// WITH_EDGE

	int targets = countSyncTarget(&m_config) * 2;

	// ϊsB
	int result = runThread(&m_config,0,-1,targets);
	if (result){
		if (result == -1){
			MessageBox(
				hWnd,
				_T("𒆒f܂B"),
				_T("BookSync - ʕ"),
				MB_OK | MB_ICONINFORMATION );
		}else{
			showErrorResult(_T("Ɏs܂B"),_T("BookSync - ʕ"));
		}
	}else{
		if (!noReport) {
			showSuccessResult(_T("܂B"),_T("BookSync - ʕ"));
			if (getNoNameFlag()) {
				MessageBox(hWnd,
					_T("ÔȂtH_ύX܂B"),
					_T("BookSync - ʕ"),
					MB_OK | MB_ICONINFORMATION );
			}
		}
	}

}


/**
 * ϊ{^̃nh
 *
 */
void BookSyncForm::OnCommandConvert()
{
	// ʏ̓eIuWFNgɓ]B
	UpdateData(true);
	updateCurrentPage();

	// IuWFNg̓eϊ[`gIuWFNgɓ]B
	mozFormToConfig(&m_config,m_MozForm);
	operaFormToConfig(&m_config,m_OperaForm);
	ieFormToConfig(&m_config,m_IEForm);
#ifdef WITH_EDGE
	edgeFormToConfig(&m_config, m_EdgeForm);
#endif	// WITH_EDGE
	fxFormToConfig(&m_config, m_FxForm);
	sfFormToConfig(&m_config,m_SfForm);
	chFormToConfig(&m_config,m_ChForm);
	xbFormToConfig(&m_config,m_XbForm);
#ifdef WITH_OP15
	op15FormToConfig(&m_config,m_Op15Form);
#endif	// WITH_OP15
	op19FormToConfig(&m_config,m_Op19Form);
	viFormToConfig(&m_config, m_ViForm);
	edge2FormToConfig(&m_config, m_Edge2Form);

	m_config.setSortType(m_sortMode);
	m_config.setUpdate(m_Update ? true : false);
	m_config.setProperty(attributeNo[m_useAttribute]);
	m_config.setConvertType(Configuration::Convert);

	m_config.setEditMode(false);	// ҏW[hł͂Ȃ
	m_config.setEditTarget(-1);		// ҏWΏۂł͂Ȃ̂œKɁB

	if (m_config.getIeIgnoreLinkFolder()) {
		m_config.setIeNoLinkToMenu(false);
	}
	if (!m_config.getIeSyncronizeFxLinkFolder()) {
		m_config.setIeNoLinkToMenu(false);
	}

	// j[擾B
	bool state = menu->isChecked(IDM_CONVERT_ALL);
	if (state){
		// uׂẴubN}[NϊΏۂɂvɃ`FbNĂꍇ
		// ϊݒɂׂẴubN}[NϊΏۂɂ悤ݒ肷B
		m_config.setConvertAll(true);
	} else {
		m_config.setConvertAll(false);
	}
	m_config.setLeaveDuplicateName(leaveDuplicateName);
	m_config.setNormalize(normalize);
	m_config.setNoIEFavbar(noIEFavbar);
	int progressMax = 0;

	// ϊΏۂ̑IsB
	if (autoExecOnRun) {
		// s̏ꍇ͑O̕ϊݒgB
		for (int i = 0; i < ALL_BOOKMARKS; i++) {
			m_config.setConvertFrom(i, sourceChecked[i]);
			m_config.setConvertTo(i, destinationChecked[i]);
		}
		autoExecOnRun = false;	// s1񂾂
	} else {
		// _CAOŕϊΏۂ̑IsB
		if (selectConvertTarget()) {
			return;
		}
	}

	//
	// ϊΏۑIẽ`FbN
	//

	// ubN}[NwL̃`FbN
	if (!checkConvertEmpty()) {
		return;
	}

	// Firefox 3ȍ~̓ubN}[Nt@CKKv
	if (!checkFxConvert()) {
		return;
	}

	// ϊݒۑB
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		sourceChecked[i] = m_config.getConvertFrom(i);
		destinationChecked[i] = m_config.getConvertTo(i);
		if (m_config.getConvertFrom(i)) {
			progressMax++;
		}
		if (m_config.getConvertTo(i)) {
			progressMax++;
		}
	}

	// ϊsB
	int result = runThread(&m_config,1,-1,progressMax);
	if (result){
		if (result == -1){
			MessageBox(hWnd,
				_T("ϊ𒆒f܂B"),
				_T("BookSync - ϊʕ"),
				MB_OK | MB_ICONINFORMATION );
		}else{
			showErrorResult("ϊɎs܂B","BookSync - ϊʕ");
		}
	}else{
		if (!noReport) {
			showSuccessResult(_T("ϊ܂B"), _T("BookSync - ϊʕ"));

			if (getNoNameFlag()) {
				MessageBox(hWnd,
					_T("ÔȂtH_ύX܂B"),
					_T("BookSync - ϊʕ"),
					MB_OK | MB_ICONINFORMATION );
			}
		}
	}

}

/**
 * ҏW{^ꂽƂ̓
 *
 */
void BookSyncForm::OnCommandEdit()
{
	// ʏ̓eIuWFNgɓ]B
	UpdateData(true);
	updateCurrentPage();

	// ݒ̐𒲂ׂĂB
	if (!checkSyncOption()){
		autoExecOnRun = false;
		return;
	}


	// Ŝ߁AuEUĂƂ͓łȂ悤ɂB
	if (checkBrowserRunning()){
		autoExecOnRun = false;
		return;
	}
	if (!editOnRun) {
		int answer;
		answer = MessageBox(hWnd,_T(
			"ubN}[NƂCɓҏW܂H\n\n"
			"ubN}[NECɓ̓ʂҏW܂B\n"
			"ʂ̎wɏ]đ삵ĂB\n")
			,_T("smF"),MB_YESNO | MB_ICONQUESTION);
		if (answer == IDNO){
			autoExecOnRun = false;
			return;
		}
	}

	// j[擾B
	bool state = menu->isChecked(IDM_SYNCBEFOREEDIT);
	if (state) {
		// ҏWO̓sɃ`FbNĂꍇ
		// ҏWOɂ񓯊B
		int result = preEditSync();
		if (result){
			autoExecOnRun = false;
			return;
		}
	}

	// ҏWʂ𔽉fB
	reflectEdit();
}

/**
 * uwvv-uBookSync̃o[WvR}h̃nh
 */
void BookSyncForm::OnCommandAbout()
{
	if (winVer > 4){
		if (pfWin != NULL)
			pfWin(hWnd,0,192,LWA_ALPHA);
	}
	
	aboutDlg = new CAboutDlg(hWnd, IDD_ABOUTBOX);
	aboutDlg->showModal();

	if (winVer > 4){
		if (pfWin != NULL)
			pfWin(hWnd,0,255,LWA_ALPHA);
	}

	delete aboutDlg;

#if 0
	//myHwnd = getHwnd();
	myHwnd = m_OperaForm->getHwnd();
	HWND w = m_OperaForm->getHwnd();
	EnumChildWindows(w, ::setFont, (LPARAM)font);
#endif
}

/**
 * j[́ut@Cv-uEϊݒJvIꂽƂ̓
 *
 */
void BookSyncForm::OnCommandOpen()
{
	// ʂ̏Ԃf[^ɔfB
	UpdateData(TRUE);
	updateCurrentPage();

	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	cDlg = new NCFileDialog(
		TRUE,
		NULL,
		_T(""),
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("ݒt@C(*.BS)\0*.BS\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("ݒt@C͂Ă");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽ瓯ݒǂݍ
	path = cDlg->GetPathName();
	delete cDlg;

	IniProfile *ini = NULL;
	try {
		ini = new IniProfile();
		ini->setIniFile(path.c_str());
	}catch(...) {
		MessageBox(
			hWnd,
			_T("ݒt@C̓ǂݍ݂Ɏs܂B"),
			_T("G["),MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	getSettings(ini);
	m_settingFile = path;
	setApplicationTitle();

	UpdateDataAll(false);

	delete ini;
}

/**
 * j[́ut@Cv-uEϊݒ̏㏑ۑvIꂽƂ̓
 *
 */
void BookSyncForm::OnCommandSave()
{
	if (!m_settingFile.compare(_T(""))) {
		// ݒt@CǂݍłȂꍇ͖Otĕۑ
		// ƓƂB
		OnCommandSaveAs();
		return;
	}

	// ʂ̏Ԃf[^ɔfB
	UpdateData(TRUE);
	updateCurrentPage();

	WIN32_FIND_DATA info;
	HANDLE findResult = FindFirstFile(m_settingFile.c_str(), &info);
	if (findResult != INVALID_HANDLE_VALUE) {
		if (info.dwFileAttributes & FILE_ATTRIBUTE_READONLY) {
			MessageBox(this->getHwnd(),
				_T("̃t@C͓ǂݎpɐݒ肳Ă܂B\nǂݎp邩Aʂ̃t@CŕۑĂB"),
				_T("Eϊݒ̏㏑ۑ"),
				MB_OK | MB_ICONWARNING);
			return;
		}
	}

	IniProfile *ini = NULL;
	try {
		ini = new IniProfile();
		ini->setIniFile(m_settingFile.c_str());
	}catch(...) {
		MessageBox(
			hWnd,
			_T("ݒt@C݂̏Ɏs܂B"),
			_T("G["),MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	GetWindowRect(this->getHwnd(),&posInfo);
	int result = setSettings(ini);
	if (result) {
		MessageBox(
			hWnd,
			_T("ݒt@C݂̏Ɏs܂B"),
			_T("G["),MB_OK | MB_ICONEXCLAMATION);
	}

	delete ini;
}

/**
 * j[́ut@Cv-uEϊݒɖOĕۑvIꂽƂ̓
 *
 */
void BookSyncForm::OnCommandSaveAs()
{
	// ʂ̏Ԃf[^ɔfB
	UpdateData(TRUE);
	updateCurrentPage();

	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	cDlg = new NCFileDialog(
		FALSE,
		NULL,
		_T(""),
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("ݒt@C(*.BS)\0*.BS\0\0"),
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("ݒt@C͂Ă");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽ瓯ݒǂݍ
	path = cDlg->GetPathName();
	delete cDlg;

	IniProfile *ini = NULL;
	try {
		ini = new IniProfile();
		ini->setIniFile(path.c_str());
	}catch(...) {
		MessageBox(
			hWnd,
			_T("ݒt@C݂̏Ɏs܂B"),
			_T("G["),MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	GetWindowRect(this->getHwnd(),&posInfo);
	result = setSettings(ini);
	if (result) {
		MessageBox(
			hWnd,
			_T("ݒt@C݂̏Ɏs܂B"),
			_T("G["),MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	m_settingFile = path;
	setApplicationTitle();

	delete ini;
}

/**
 * j[́uc[v-uD揇ʂ̐ݒvIꂽƂ̓
 */
void BookSyncForm::OnCommandPrefer()
{
	priorityDlg = new CPriorityDlg(hWnd, IDD_PRIORITY_DIALOG);
	priorityDlg->setPriority(priority);
	priorityDlg->showModal();

	delete priorityDlg;
}

/**
 * j[́uc[v-uϊΏۂݒ肷vIꂽƂ̓
 */
void BookSyncForm::OnCommandDefConv()
{
	// ʏ̓eIuWFNgɓ]B
	UpdateData(true);
	updateCurrentPage();

	CBrowserSelect select(hWnd, IDD_BROWSERSELECT);

	select.windowTitle = _T("ϊEϊ̃ubN}[N/Cɓw");
	select.setFromCheckStatus(sourceChecked);
	select.setToCheckStatus(destinationChecked);
	INT_PTR nRet = -1;
	nRet = select.showModal();
	if (nRet == IDCANCEL){
		return;
	}
	// _CAO̓eϊݒɈڂB
	int fromCount = 0;
	int toCount = 0;
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		if (select.fromChecked[i]){
			fromCount++;
		}
		if (select.toChecked[i]){
			toCount++;
		}
	}
	if (fromCount < 1){
		MessageBox(
			hWnd,
			_T("ϊ1ȏ̃ubN}[N/Cɓw肵ĂB"),
			_T("G["),
			MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	if (toCount < 1){
		MessageBox(hWnd,
			_T("ϊ1ȏ̃ubN}[N/Cɓw肵ĂB"),
			_T("G["),
			MB_OK | MB_ICONEXCLAMATION);
		return;
	}

	for (int i = 0;i < ALL_BOOKMARKS;i++){
		sourceChecked[i] = select.fromChecked[i];
		destinationChecked[i] = select.toChecked[i];
	}
	return;
}

/**
 * j[́uc[v-uҏWΏۂݒ肷vIꂽƂ̓
 */
void BookSyncForm::OnCommandDefEdit()
{
	// ʏ̓eIuWFNgɓ]B
	UpdateData(true);
	updateCurrentPage();

	// ҏWꂽubN}[N̑I
	int selection = 0;	// IꂽҏWΏۂ̃ubN}[N
	while(1){
		CEditSelect select(hWnd, IDD_DIALOGEDITBOOKMARK);

		select.setText(_T("ҏWubN}[NECɓ̑I"));
		select.setSelection(m_editSelection);
		INT_PTR nRet = -1;
		nRet = select.showModal();
		if (nRet == IDCANCEL){
			return;
		}

		// IꂽuEUҏWΏۂ̂̂ǂ
		selection = select.getSelection();
		if (checkSelection(selection)){
			// ҏWΏۂ̏ꍇ͂ҏWΏۂƂB
			break;
		}
	}
	m_editSelection = selection;
}

/**
 * j[́uc[v-uIÊCɓ̏ԂZbgvIꂽƂ̓
 */
void BookSyncForm::OnCommandIEOrderReset()
{
	int result;

	result = MessageBox(
		hWnd,
		_T("IÊCɓ̏ԂZbg܂B\n낵łH"),
		_T("mF"),
		MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2);
	if (result != IDYES) {
		return;
	}

	deleteIEFavoriteOrder();

	MessageBox(
		hWnd,
		_T("IÊCɓ̏ԂZbg܂B"),
		_T("mF"),
		MB_OK | MB_ICONINFORMATION);
}

#ifdef WITH_EDGE
/**
 * j[́uc[v-uEdgêCɓׂč폜vIꂽƂ̓
 */
void BookSyncForm::OnCommandEdgeFavReset()
{
	int result;

	result = MessageBox(
		hWnd,
		_T("EdgêCɓׂč폜܂B\n낵łH"),
		_T("mF"),
		MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2);
	if (result != IDYES) {
		return;
	}

	m_EdgeForm->UpdateData(true);
	EdgeDBCleaner *cleaner = new EdgeDBCleaner();
	
	Logger *logger = new Logger();
	switch (logLevel) {
		case 1:
			logger->setLevel(Logger::DEBUG);
			break;
		case 2:
			logger->setLevel(Logger::TRACE);
			break;
	}
	logger->start();
	cleaner->setLogger(logger);

	result = cleaner->startCleaning(m_EdgeForm->m_EdgeBM.c_str());

	delete cleaner;
	logger->stop();

	if (!result) {
		MessageBox(
			hWnd,
			_T("EdgêCɓׂč폜܂B"),
			_T("mF"),
			MB_OK | MB_ICONINFORMATION);
	} else {
		MessageBox(
			hWnd,
			_T("EdgêCɓ̍폜Ɏs܂B"),
			_T("mF"),
			MB_OK | MB_ICONEXCLAMATION);
	}
}
#endif	// WITH_EDGE

/**
 * j[́uc[v-uubN}[N̕ۑvIꂽƂ̓
 *
 */
void BookSyncForm::OnCommandBackup()
{
	// ʂ̏Ԃf[^ɔfB
	UpdateData(TRUE);
	updateCurrentPage();

	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	cDlg = new NCFileDialog(
		FALSE,
		NULL,
#ifdef _WIN64
		_T("BookSyncBackup.ZIP"),
#else
		_T("BookSyncBackup.LZH"),
#endif
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
#ifdef _WIN64
		_T("obNAbvt@C(*.ZIP)\0*.ZIP\0obNAbvt@C(*.7z)\0*.7z\0\0"),
#else
		_T("obNAbvt@C(*.LZH)\0*.LZH\0obNAbvt@C(*.ZIP)\0*.ZIP\0obNAbvt@C(*.7z)\0*.7z\0\0"),
#endif
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("ۑ̃t@C͂Ă");
	OPENFILENAME &ofn = cDlg->GetOFN();

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽobNAbvJnB
	path = cDlg->GetPathName();
	int filter = ofn.nFilterIndex;
	delete cDlg;

	enum backup_type type = getArchiveType(path.c_str());
	if (type == OTHER) {
		switch (filter) {
#ifdef _WIN64
			case 1:
				if (type != ZIP) {
					path = path + ".ZIP";
				}
				break;
			case 2:
				if (type != SEVEN_ZIP) {
					path = path + ".7z";
				}
				break;
#else
			case 1:
				if (type != LZH) {
					path = path + ".LZH";
				}
				break;
			case 2:
				if (type != ZIP) {
					path = path + ".ZIP";
				}
				break;
			case 3:
				if (type != SEVEN_ZIP) {
					path = path + ".7z";
				}
				break;
#endif
		}
	}

	result = doBackup(path);

	if (result == 0){
		MessageBox(hWnd,backupMessages[result],_T("ۑ"),MB_OK | MB_ICONINFORMATION);
	}else{
		MessageBox(hWnd,backupMessages[result],_T("ۑ"),MB_OK | MB_ICONEXCLAMATION);
	}
}

/**
 * j[́uc[v-uubN}[N̕vIꂽƂ̓
 *
 */
void BookSyncForm::OnCommandRestore()
{
	// ʂ̏Ԃf[^ɔfB
	UpdateData(true);
	updateCurrentPage();

	// t@C_CAȌ
	NCFileDialog *cDlg;
	int result;
	tstring path;

	cDlg = new NCFileDialog(
		TRUE,
		NULL,
#ifdef _WIN64
		_T("BookSyncBackup.ZIP"),
#else
		_T("BookSyncBackup.LZH"),
#endif
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
#ifdef _WIN64
		_T("obNAbvt@C(*.ZIP)\0*.ZIP\0obNAbvt@C(*.7z)\0*.7z\0\0"),
#else
		_T("obNAbvt@C(*.LZH)\0*.LZH\0obNAbvt@C(*.ZIP)\0*.ZIP\0obNAbvt@C(*.7z)\0*.7z\0\0"),
#endif
		hWnd);
	cDlg->m_ofn.lpstrTitle = _T("ubN}[NECɓۑt@C͂Ă");

	// t@C_CAO\
	result = cDlg->DoModal();
	if (result == IDCANCEL){
		delete cDlg;
		return;
	}

	// OKꂽ烊XgAJnB
	path = cDlg->GetPathName();
	delete cDlg;

	const char *ieFavorite;
	const char *edgeFavorite;
	const char *bookmarkFiles[ALL_BOOKMARKS - 1];

	// IÊCɓ̃XgA
	if (m_IEForm->m_IEBM != _T("")){
		ieFavorite = m_IEForm->m_IEBM.c_str();
	}else{
		ieFavorite = NULL;
	}

#ifdef WITH_EDGE
	// EdgêCɓ̃XgA
	if (m_EdgeForm->m_EdgeBM != _T("")) {
		edgeFavorite = m_EdgeForm->m_EdgeBM.c_str();
	} else {
		edgeFavorite = NULL;
	}
#else
	edgeFavorite = NULL;
#endif	// WITH_EDGE

	enum backup_type type = getArchiveType(path.c_str());
	if (type == OTHER) {
#ifdef _WIN64
		type = ZIP;
#else
		type = LZH;
#endif
	}
	setupBackupList(bookmarkFiles);

	result = ::restoreBookmark(
		type, path.c_str(), ieFavorite, edgeFavorite, bookmarkFiles);

	if (result == 0){
		MessageBox(hWnd,restoreMessages[result],_T(""),MB_OK | MB_ICONINFORMATION);
	}else{
		MessageBox(hWnd,restoreMessages[result],_T(""),MB_OK | MB_ICONEXCLAMATION);
	}
}

/**
 * hLgt@C\B
 *
 */
void BookSyncForm::showHelp(void)
{
	// st@C̏𓾂邽߂̃obt@Q
	TCHAR path[_MAX_PATH+1],drive[_MAX_DRIVE+1],dir[_MAX_DIR+1],helpFile[_MAX_PATH+1];

	// st@ĈƂBShelp.html̃pX𐶐B
	::GetModuleFileName(NULL,path,_MAX_PATH);
	::_tsplitpath(path,drive,dir,NULL,NULL);
	::_stprintf(helpFile,_T("%s%s%s"),drive,dir,_T("BShelp.html"));
	
	// ֘AtꂽAvŃhLgt@C\B
	ShellExecute(hWnd,_T("open"),helpFile,NULL,NULL,SW_SHOW);
}

/**
 * IvV/BackupIꂽƂ̓
 *
 */
void BookSyncForm::OnOptionBackup(tstring &path)
{
	TCHAR currentDir[MAX_PATH + 1];
	tstring fullPath;

	// ʂ̏Ԃf[^ɔfB
	UpdateData(TRUE);
	updateCurrentPage();

	if (!isFullPath(path.c_str())) {
		GetCurrentDirectory(MAX_PATH + 1, currentDir);
		fullPath = currentDir;
		fullPath = fullPath + "\\";
		fullPath = fullPath + path;
	} else {
		fullPath = path;
	}

	int result = doBackup(fullPath);

	if (result != 0){
		MessageBox(hWnd,backupMessages[result],_T("ۑ"),MB_OK | MB_ICONEXCLAMATION);
	}
}

/**
 * obNAbvst@C̃Xg쐬B
 *
 * @param bookmarkFiles ubN}[Nt@Ci[z
 */
void BookSyncForm::setupBackupList(const char *bookmarkFiles[])
{
	if (m_MozForm->m_MozBM1 != _T("")){
		bookmarkFiles[0] = m_MozForm->m_MozBM1.c_str();
	}else{
		bookmarkFiles[0] = NULL;
	}

	if (m_MozForm->m_MozBM2 != _T("")){
		bookmarkFiles[1] = m_MozForm->m_MozBM2.c_str();
	}else{
		bookmarkFiles[1] = NULL;
	}

	if (m_OperaForm->m_OperaBM1 != _T("")){
		bookmarkFiles[2] = m_OperaForm->m_OperaBM1.c_str();
	}else{
		bookmarkFiles[2] = NULL;
	}

	if (m_OperaForm->m_OperaBM2 != _T("")){
		bookmarkFiles[3] = m_OperaForm->m_OperaBM2.c_str();
	}else{
		bookmarkFiles[3] = NULL;
	}

	if (m_FxForm->m_FxBM1 != _T("")){
		bookmarkFiles[4] = m_FxForm->m_FxBM1.c_str();
	}else{
		bookmarkFiles[4] = NULL;
	}

	if (m_FxForm->m_FxBM2 != _T("")){
		bookmarkFiles[5] = m_FxForm->m_FxBM2.c_str();
	}else{
		bookmarkFiles[5] = NULL;
	}

	if (m_SfForm->m_SfBM1 != _T("")){
		bookmarkFiles[6] = m_SfForm->m_SfBM1.c_str();
	}else{
		bookmarkFiles[6] = NULL;
	}

	if (m_SfForm->m_SfBM2 != _T("")){
		bookmarkFiles[7] = m_SfForm->m_SfBM2.c_str();
	}else{
		bookmarkFiles[7] = NULL;
	}

	if (m_ChForm->m_ChBM1 != _T("")){
		bookmarkFiles[8] = m_ChForm->m_ChBM1.c_str();
	}else{
		bookmarkFiles[8] = NULL;
	}

	if (m_ChForm->m_ChBM2 != _T("")){
		bookmarkFiles[9] = m_ChForm->m_ChBM2.c_str();
	}else{
		bookmarkFiles[9] = NULL;
	}

	if (m_XbForm->m_XbBM1 != _T("")){
		bookmarkFiles[10] = m_XbForm->m_XbBM1.c_str();
	}else{
		bookmarkFiles[10] = NULL;
	}

	if (m_XbForm->m_XbBM2 != _T("")){
		bookmarkFiles[11] = m_XbForm->m_XbBM2.c_str();
	}else{
		bookmarkFiles[11] = NULL;
	}

#ifdef WITH_OP15
	if (m_Op15Form->m_Op15BM1 != _T("")){
		bookmarkFiles[12] = m_Op15Form->m_Op15BM1.c_str();
	}else{
#endif	// WITH_OP15
		bookmarkFiles[12] = NULL;
#ifdef WITH_OP15
	}
#endif	// WITH_OP15

#ifdef WITH_OP15
	if (m_Op15Form->m_Op15BM2 != _T("")){
		bookmarkFiles[13] = m_Op15Form->m_Op15BM2.c_str();
	}else{
#endif	// WITH_OP15
		bookmarkFiles[13] = NULL;
#ifdef WITH_OP15
	}
#endif	// WITH_OP15

	if (m_Op19Form->m_Op19BM1 != _T("")){
		bookmarkFiles[14] = m_Op19Form->m_Op19BM1.c_str();
	}else{
		bookmarkFiles[14] = NULL;
	}

	if (m_Op19Form->m_Op19BM2 != _T("")){
		bookmarkFiles[15] = m_Op19Form->m_Op19BM2.c_str();
	}else{
		bookmarkFiles[15] = NULL;
	}

	if (m_EdgeForm->m_EdgeBM != _T("")) {
		bookmarkFiles[16] = m_EdgeForm->m_EdgeBM.c_str();
	} else {
		bookmarkFiles[16] = NULL;
	}

	if (m_ViForm->m_ViBM1 != _T("")) {
		bookmarkFiles[17] = m_ViForm->m_ViBM1.c_str();
	} else {
		bookmarkFiles[17] = NULL;
	}

	if (m_ViForm->m_ViBM2 != _T("")) {
		bookmarkFiles[18] = m_ViForm->m_ViBM2.c_str();
	} else {
		bookmarkFiles[18] = NULL;
	}

	if (m_Edge2Form->m_Edge2BM1 != _T("")) {
		bookmarkFiles[19] = m_Edge2Form->m_Edge2BM1.c_str();
	}
	else {
		bookmarkFiles[19] = NULL;
	}

	if (m_Edge2Form->m_Edge2BM2 != _T("")) {
		bookmarkFiles[20] = m_Edge2Form->m_Edge2BM2.c_str();
	}
	else {
		bookmarkFiles[20] = NULL;
	}
}

/**
 * ubN}[NECɓ蓯̐ݒɌ肪ȂǂmFB
 *
 * @return true:͂Ȃ false:肪
 */
bool BookSyncForm::checkSyncOption()
{
	int count = 0;
#ifdef WITH_OP15
	bool hasOpera15 = false;
#endif	// WITH_OP15

	if (m_MozForm->m_chkMoz1){
		count++;
		if (m_MozForm->m_MozBM1 == ""){
			MessageBox(
				hWnd,
				_T("Firefox 2/Netscape/MozillãubN}[N1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_MozForm->m_chkMoz2){
		count++;
		if (m_MozForm->m_MozBM2 == ""){
			MessageBox(
				hWnd,
				_T("Firefox 2/Netscape/MozillãubN}[N2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_OperaForm->m_chkOpera1){
		count++;
		if (m_OperaForm->m_OperaBM1 == ""){
			MessageBox(
				hWnd,
				_T("Opera 12ȑÕubN}[N1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_OperaForm->m_chkOpera2){
		count++;
		if (m_OperaForm->m_OperaBM2 == ""){
			MessageBox(
				hWnd,
				_T("Opera 12ȑÕubN}[N2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_IEForm->m_chkIE1){
		count++;
		if (m_IEForm->m_IEBM == ""){
			MessageBox(
				hWnd,
				_T("IÊCɓtH_w肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

#ifdef WITH_EDGE
	if (m_EdgeForm->m_chkEdge1){
		count++;
		if (m_EdgeForm->m_EdgeBM == ""){
			MessageBox(
				hWnd,
				_T("EdgêCɓtH_w肵ĂB"),
				SYNCOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}
#endif	// WITH_EDGE

	if (m_FxForm->m_chkFx1){
		count++;
		if (m_FxForm->m_FxBM1 == ""){
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
		if (!isExistingFile(m_FxForm->m_FxBM1.c_str())) {
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N1̃t@C݂܂B"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_FxForm->m_chkFx2){
		count++;
		if (m_FxForm->m_FxBM2 == ""){
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
		if (!isExistingFile(m_FxForm->m_FxBM2.c_str())) {
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N2̃t@C݂܂B"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_SfForm->m_chkSf1){
		count++;
		if (m_SfForm->m_SfBM1 == ""){
			MessageBox(
				hWnd,
				_T("SafarĩubN}[N1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_SfForm->m_chkSf2){
		count++;
		if (m_SfForm->m_SfBM2 == ""){
			MessageBox(
				hWnd,
				_T("SafarĩubN}[N2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_ChForm->m_chkCh1){
		count++;
		if (m_ChForm->m_ChBM1 == ""){
			MessageBox(
				hWnd,
				_T("ChromẽubN}[N1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_ChForm->m_chkCh2){
		count++;
		if (m_ChForm->m_ChBM2 == ""){
			MessageBox(
				hWnd,
				_T("ChromẽubN}[N2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_XbForm->m_chkXb1){
		count++;
		if (m_XbForm->m_XbBM1 == ""){
			MessageBox(
				hWnd,
				_T("XBELt@C1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_XbForm->m_chkXb2){
		count++;
		if (m_XbForm->m_XbBM2 == ""){
			MessageBox(
				hWnd,
				_T("XBELt@C2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

#ifdef WITH_OP15
	if (m_Op15Form->m_chkOp15_1){
		count++;
		if (m_Op15Form->m_Op15BM1 == ""){
			MessageBox(
				hWnd,
				_T("Opera 15`28̃Xs[h_C1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		} else if (!isExistingFile(m_Op15Form->m_Op15BM1.c_str())) {
			MessageBox(
				hWnd,
				_T("Opera 15`28̃Xs[h_C1̃t@C݂܂B"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		} else {
			hasOpera15 = true;
		}
	}

	if (m_Op15Form->m_chkOp15_2){
		count++;
		if (m_Op15Form->m_Op15BM2 == ""){
			MessageBox(
				hWnd,
				_T("Opera 15`28̃Xs[h_C2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		} else if (!isExistingFile(m_Op15Form->m_Op15BM2.c_str())) {
			MessageBox(
				hWnd,
				_T("Opera 15`28̃Xs[h_C2̃t@C݂܂B"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		} else {
			hasOpera15 = true;
		}
	}
#endif	// WITH_OP15

	if (m_Op19Form->m_chkOp19_1){
		count++;
		if (m_Op19Form->m_Op19BM1 == ""){
			MessageBox(
				hWnd,
				_T("Opera 25ȍ~̃ubN}[N1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_Op19Form->m_chkOp19_2){
		count++;
		if (m_Op19Form->m_Op19BM2 == ""){
			MessageBox(
				hWnd,
				_T("Opera 25ȍ~̃ubN}[N2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_ViForm->m_chkVi_1) {
		count++;
		if (m_ViForm->m_ViBM1 == "") {
			MessageBox(
				hWnd,
				_T("VivaldĩubN}[N1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_ViForm->m_chkVi_2) {
		count++;
		if (m_ViForm->m_ViBM2 == "") {
			MessageBox(
				hWnd,
				_T("VivaldĩubN}[N2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_Edge2Form->m_chkEdge2_1) {
		count++;
		if (m_Edge2Form->m_Edge2BM1 == "") {
			MessageBox(
				hWnd,
				_T("EdgêCɓ1̃t@Cw肵ĂB"),
				SYNCOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_Edge2Form->m_chkEdge2_2) {
		count++;
		if (m_Edge2Form->m_Edge2BM2 == "") {
			MessageBox(
				hWnd,
				_T("EdgêCɓ2̃t@Cw肵ĂB"),
				SYNCOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (count < 2){
		MessageBox(
			hWnd,
			_T("ubN}[NECɓ̓ɂ2ȏ̃ubN}[NECɓ̓s悤w肵ĂB"),
			SYNCOPTIONERROR,MB_OK | MB_ICONWARNING);
		return false;
	}

#ifdef WITH_OP15
	if (hasOpera15) {
		int answer = MessageBox(
			hWnd,
			_T(
				"tH_̒ɃtH_ȂOpera 15`28̃Xs[h_C\n"
				"ΏۂɓĂ܂B\n\n"
				"EҏWʂ\ȂʂɂȂ\܂A\n"
				"낵łH"),
			SYNCOPTIONERROR,MB_YESNO | MB_ICONQUESTION);
		if (answer != IDYES) {
			return false;
		}
	}
#endif	// WITH_OP15

	return true;
}

/**
 *	EChENXŃAvP[V̋N`FbNB
 *
 * @param pWinClass EChENX
 * @return 0 NĂȂ 1 NĂ
 */
int BookSyncForm::checkRunning(const char *pWinClass)
{
	HWND hWndApp;

	hWndApp = ::FindWindow(pWinClass,NULL);
	if (hWndApp != NULL){
		return 1;
	}else{
		return 0;
	}
}

/**
 *	EChENXƃt@CMozillanAvP[V̋N`FbNB
 *
 * @return 0 NĂȂ 1 NĂ
 */
int BookSyncForm::checkMozillaRunning(void)
{
	MozillaFoundFlag = 0;
	::EnumWindows(checkMozillaWindow,NULL);
	if (MozillaFoundFlag){
		return 1;
	}
	return 0;
}

/**
 *	EChENXƃt@CChrome֘AAvP[V̋N`FbNB
 *
 * @return 0 NĂȂ 1 NĂ
 */
int BookSyncForm::checkChromeRunning(void)
{
	ChromeFoundFlag = 0;
	::EnumWindows(checkChromeWindow,NULL);
	if (ChromeFoundFlag){
		return 1;
	}
	return 0;
}

/**
 * EChENXƃt@COpera 15ȍ~̋N`FbNB
 *
 * @return 0 NĂȂ 1 NĂ
 */
int BookSyncForm::checkOperaRunning(void)
{
	OperaFoundFlag = 0;
	::EnumWindows(checkOperaWindow,NULL);
	if (OperaFoundFlag){
		return 1;
	}
	return 0;
}

/**
 * EChENXƃt@CVivaldi̋N`FbNB
 *
 * @return 0 NĂȂ 1 NĂ
 */
int BookSyncForm::checkVivaldiRunning(void)
{
	VivaldiFoundFlag = 0;
	::EnumWindows(checkVivaldiWindow, NULL);
	if (VivaldiFoundFlag) {
		return 1;
	}
	return 0;
}

/**
 * EChENXƃt@CEdge(Chromium)̋N`FbNB
 *
 * @return 0 NĂȂ 1 NĂ
 */
int BookSyncForm::checkEdge2Running(void)
{
	Edge2FoundFlag = 0;
	::EnumWindows(checkEdge2Window, NULL);
	if (Edge2FoundFlag) {
		return 1;
	}
	return 0;
}

/**
 *	euEUNĂ邩ǂmFB
 *
 * @return true ǂꂩĂB<br>
 *		false uEU͋NĂȂB
 */
bool BookSyncForm::checkBrowserRunning(void)
{
	if (m_MozForm->m_chkMoz1 || m_MozForm->m_chkMoz2 || 
		m_FxForm->m_chkFx1 || m_FxForm->m_chkFx2){
		if (checkRunning(NSAECLASS)){
			MessageBox(hWnd,NSAERUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
		if (checkRunning(NS4CLASS)){
			MessageBox(hWnd,NS4RUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
		if (checkMozillaRunning()){
			MessageBox(hWnd,MOZRUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
	}

	if (m_OperaForm->m_chkOpera1 || m_OperaForm->m_chkOpera2){
		if (checkRunning(OPERACLASS)){
			MessageBox(hWnd,OPERARUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
		if (checkRunning(OPERA7CLASS)){
			MessageBox(hWnd,OPERARUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
	}

	if (m_SfForm->m_chkSf1 || m_SfForm->m_chkSf2) {
		if (checkRunning(SAFARICLASS)){
			MessageBox(hWnd,SAFARIRUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
	}

	if (m_ChForm->m_chkCh1 ||
		m_ChForm->m_chkCh2) {

		if (checkChromeRunning()){
			MessageBox(hWnd,CHROMERUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
	}
	if (
#ifdef WITH_OP15
		m_Op15Form->m_chkOp15_1 ||
		m_Op15Form->m_chkOp15_2 ||
#endif	// WITH_OP15
		m_Op19Form->m_chkOp19_1 ||
		m_Op19Form->m_chkOp19_2
		) {
		if (checkOperaRunning()){
			MessageBox(hWnd,OPERA15RUNNING,BSAPRUNNING,MB_OK |MB_ICONWARNING);
			return true;
		}
	}

	if (m_ViForm->m_chkVi_1 ||
		m_ViForm->m_chkVi_2) {

		if (checkVivaldiRunning()) {
			MessageBox(hWnd, VIRUNNING, BSAPRUNNING, MB_OK | MB_ICONWARNING);
			return true;
		}
	}

	if (m_Edge2Form->m_chkEdge2_1 ||
		m_Edge2Form->m_chkEdge2_2) {

		if (checkEdge2Running()) {
			MessageBox(hWnd, EDGE2RUNNING, BSAPRUNNING, MB_OK | MB_ICONWARNING);
			return true;
		}
	}
	return false;
}

/**
 * subN}[NECɓ̐𐔂B
 *
 * @param m_config ݒNX
 * @return Ώۂ̐
 */
int BookSyncForm::countSyncTarget(Configuration *m_config)
{
	int targets = 0;

	for (int i = 0;i < ALL_BOOKMARKS;i++) {
		if (m_config->getConvertFrom(i)) {
			targets++;
		}
	}
	return targets;
}

/**
 * EϊEҏW̌ʁAƂ̃bZ[W\
 *
 * @param message G[bZ[W
 * @param title G[_CAO^Cg
 */
void BookSyncForm::showSuccessResult(const TCHAR *message,const TCHAR *title)
{
	if (m_taskbar != NULL) {
		m_taskbar->SetProgressValue(hWnd, 100, 100);
		m_taskbar->SetProgressState(hWnd, TBPF_NORMAL);
	}
	MessageBox(hWnd,message,title,MB_OK | MB_ICONINFORMATION );

	if (m_taskbar != NULL) {
		m_taskbar->SetProgressState(hWnd, TBPF_NOPROGRESS);
	}
}

/**
 * EϊEҏW̌ʁAG[ɂȂƂ̃bZ[W\
 *
 * @param message G[bZ[W
 * @param title G[_CAO^Cg
 */
void BookSyncForm::showErrorResult(const TCHAR *message,const TCHAR *title)
{
	if (m_taskbar != NULL) {
		m_taskbar->SetProgressValue(hWnd, 100, 100);
		m_taskbar->SetProgressState(hWnd, TBPF_ERROR);
	}
	MessageBox(hWnd,message,title,MB_OK | MB_ICONEXCLAMATION );

	if (m_taskbar != NULL) {
		m_taskbar->SetProgressState(hWnd, TBPF_NOPROGRESS);
	}
}

/**
 * ubN}[Nϊ̐ݒ̓͘RꂪȂǂmFB
 *
 * @return true:͂Ȃ false:肪
 */
bool BookSyncForm::checkConvertEmpty()
{
	// IE
	if (m_config.getConvertTo(BOOKMARK_IE)) {
		if (m_config.getIePath() == "") {
			MessageBox(
				hWnd,
				_T("IÊCɓ̃tH_͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// IE
	if (m_config.getConvertTo(BOOKMARK_EDGE)) {
		if (m_config.getEdgePath() == "") {
			MessageBox(
				hWnd,
				_T("EdgêCɓ̃tH_͂ĂB")
				, CONVERTOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// Mozilla
	if (m_config.getConvertTo(BOOKMARK_MOZILLA_1)) {
		if (m_config.getMozPath(0) == "") {
			MessageBox(
				hWnd,
				_T("Firefox 2/Netscape/MozillãubN}[N1̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	if (m_config.getConvertTo(BOOKMARK_MOZILLA_2)) {
		if (m_config.getMozPath(1) == "") {
			MessageBox(
				hWnd,
				_T("Firefox 2/Netscape/MozillãubN}[N2̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// Opera
	if (m_config.getConvertTo(BOOKMARK_OPERA_1)) {
		if (m_config.getOperaPath(0) == "") {
			MessageBox(
				hWnd,
				_T("Opera 12ȑÕubN}[N1̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	if (m_config.getConvertTo(BOOKMARK_OPERA_2)) {
		if (m_config.getOperaPath(1) == "") {
			MessageBox(
				hWnd,
				_T("Opera 12ȑÕubN}[N2̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// Firefox 3
	if (m_config.getConvertTo(BOOKMARK_FIREFOX_1)) {
		if (m_config.getFxPath(0) == "") {
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N1̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	if (m_config.getConvertTo(BOOKMARK_FIREFOX_2)) {
		if (m_config.getFxPath(1) == "") {
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N2̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// Safari
	if (m_config.getConvertTo(BOOKMARK_SAFARI_1)) {
		if (m_config.getSfPath(0) == "") {
			MessageBox(
				hWnd,
				_T("SafarĩubN}[N1̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	if (m_config.getConvertTo(BOOKMARK_SAFARI_2)) {
		if (m_config.getSfPath(1) == "") {
			MessageBox(
				hWnd,
				_T("SafarĩubN}[N2̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// Chrome
	if (m_config.getConvertTo(BOOKMARK_CHROME_1)) {
		if (m_config.getChPath(0) == "") {
			MessageBox(
				hWnd,
				_T("ChromẽubN}[N1̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	if (m_config.getConvertTo(BOOKMARK_CHROME_2)) {
		if (m_config.getChPath(1) == "") {
			MessageBox(
				hWnd,
				_T("ChromẽubN}[N2̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// XBEL
	if (m_config.getConvertTo(BOOKMARK_XBEL_1)) {
		if (m_config.getXbPath(0) == "") {
			MessageBox(
				hWnd,
				_T("XBELt@C1̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	if (m_config.getConvertTo(BOOKMARK_XBEL_2)) {
		if (m_config.getXbPath(1) == "") {
			MessageBox(
				hWnd,
				_T("XBELt@C2̃t@C͂ĂB")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	// Edge(Chromium)
	if (m_config.getConvertTo(BOOKMARK_EDGE2_1)) {
		if (m_config.getEdge2Path(0) == "") {
			MessageBox(
				hWnd,
				_T("EdgêCɓ1̃t@C͂ĂB")
				, CONVERTOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	if (m_config.getConvertTo(BOOKMARK_EDGE2_2)) {
		if (m_config.getEdge2Path(1) == "") {
			MessageBox(
				hWnd,
				_T("EdgêCɓ2̃t@C͂ĂB")
				, CONVERTOPTIONERROR, MB_OK | MB_ICONWARNING);
			return false;
		}
	}

	return true;
}

/**
 * Firefox 3̃ubN}[Nϊ̐ݒɌ肪ȂǂmFB
 *
 * @return true:͂Ȃ false:肪
 */
bool BookSyncForm::checkFxConvert()
{
	if (m_config.getConvertFrom(BOOKMARK_FIREFOX_1) || m_config.getConvertTo(BOOKMARK_FIREFOX_1)) {
		if (!isExistingFile(m_FxForm->m_FxBM1.c_str())) {
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N1̃t@C݂܂B")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	if (m_config.getConvertFrom(BOOKMARK_FIREFOX_2) || m_config.getConvertTo(BOOKMARK_FIREFOX_2)) {
		if (!isExistingFile(m_FxForm->m_FxBM2.c_str())) {
			MessageBox(
				hWnd,
				_T("Firefox 3ȍ~̃ubN}[N2̃t@C݂܂B")
				,CONVERTOPTIONERROR,MB_OK | MB_ICONWARNING);
			return false;
		}
	}
	return true;
}

/**
 * ϊΏۂ̑IsB<br>
 *
 * @return 0:I 1:LZ 2:IG[
 */
int BookSyncForm::selectConvertTarget()
{
	CBrowserSelect select(hWnd, IDD_BROWSERSELECT);

	select.windowTitle = _T("ϊEϊ̃ubN}[N/Cɓw");
	select.setFromCheckStatus(sourceChecked);
	select.setToCheckStatus(destinationChecked);
	INT_PTR nRet = -1;
	nRet = select.showModal();
	if (nRet == IDCANCEL){
		return 1;
	}
	// _CAO̓eϊݒɈڂB
	int fromCount = 0;
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		if (select.fromChecked[i]){
			fromCount++;
			m_config.setConvertFrom(i,true);
		}else{
			m_config.setConvertFrom(i,false);
		}
	}
	if (fromCount < 1){
		MessageBox(
			hWnd,
			_T("ϊ1ȏ̃ubN}[N/Cɓw肵ĂB"),
			_T("G["),
			MB_OK | MB_ICONEXCLAMATION);
		return 2;
	}

	// _CAO̓eϊݒɈڂB
	int toCount = 0;
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		if (select.toChecked[i]){
			toCount++;
			m_config.setConvertTo(i,true);
		}else{
			m_config.setConvertTo(i,false);
		}
	}
	if (toCount < 1){
		MessageBox(hWnd,
			_T("ϊ1ȏ̃ubN}[N/Cɓw肵ĂB"),
			_T("G["),
			MB_OK | MB_ICONEXCLAMATION);
		return 2;
	}
	return 0;
}

/**
 * ҏWO̓sB<br>
 * (IÊCɓݒOĂ)
 *
 * @return 0:I -1:f >0:s
 */
int BookSyncForm::preEditSync()
{
	// IuWFNg̓eϊ[`gIuWFNgɓ]B
	mozFormToConfig(&m_config,m_MozForm);
	operaFormToConfig(&m_config,m_OperaForm);
	ieFormToConfig(&m_config,m_IEForm);
#ifdef WITH_EDGE
	edgeFormToConfig(&m_config, m_EdgeForm);
#endif	// WITH_EDGE
	fxFormToConfig(&m_config, m_FxForm);
	sfFormToConfig(&m_config,m_SfForm);
	chFormToConfig(&m_config,m_ChForm);
	xbFormToConfig(&m_config,m_XbForm);
#ifdef WITH_OP15
	op15FormToConfig(&m_config,m_Op15Form);
#endif	// WITH_OP15
	op19FormToConfig(&m_config,m_Op19Form);
	viFormToConfig(&m_config, m_ViForm);
	edge2FormToConfig(&m_config, m_Edge2Form);

	m_config.setSortType(m_sortMode);
	m_config.setUpdate(m_Update ? true : false);
	m_config.setProperty(attributeNo[m_useAttribute]);
	m_config.setConvertType(Configuration::Edit);

	m_config.setEditMode(false);	// ҏW[hł͂Ȃ
	m_config.setEditTarget(-1);		// ҏWΏۂł͂Ȃ̂œKɁB
	m_config.setLeaveDuplicateName(leaveDuplicateName);
	m_config.setNormalize(normalize);
	m_config.setNoIEFavbar(false);
	m_config.setConvertAll(false);

	// IÊCɓ𓯊ΏۂɂƂIÊCɓݒ͈ӖȂ̂
	// OB
	if (m_IEForm->m_chkIE1){
		m_config.setIeEraseFavorite(false);
	}
	m_config.setIeNoLinkToMenu(false);

#ifdef WITH_EDGE
	// Edgel
	if (m_EdgeForm->m_chkEdge1){
		m_config.setEdgeEraseFavorite(false);
	}
	m_config.setEdgeNoLinkToMenu(false);
#endif	// WITH_EDGE

	int targets = countSyncTarget(&m_config) * 2;

	// ϊsB
	int result = runThread(&m_config,2,-1,targets);
	if (result){
		if (result == -1){
			MessageBox(
				hWnd,
				_T("𒆒f܂B"),
				_T("BookSync - ҏWʕ"),
				MB_OK | MB_ICONINFORMATION );
		}else{
			showErrorResult(_T("Ɏs܂B"),_T("BookSync - ҏWʕ"));
		}
	}
	return result;
}

/**
 * ҏWꂽubN}[N𔽉fB
 *
 */
void BookSyncForm::reflectEdit()
{
	// ҏWꂽubN}[N̑I
	int selection = 0;	// IꂽҏWΏۂ̃ubN}[N

	if (autoExecOnRun) {
		selection = m_editSelection;
		autoExecOnRun = false;
	} else {
		while(1){
			CEditSelect select(hWnd, IDD_DIALOGEDITBOOKMARK);

			select.setSelection(m_editSelection);
			INT_PTR nRet = -1;
			nRet = select.showModal();
			if (nRet == IDCANCEL){
				return;
			}

			// IꂽuEUҏWΏۂ̂̂ǂ
			selection = select.getSelection();
			if (checkSelection(selection) == false){
				// ҏWΏۂłȂꍇ͍ēxIB
				continue;
			}

			// IăuEUNĂȂꍇɎɈڂB
			if (!checkBrowserRunning()){
				break;
			}
		}
	}
	m_editSelection = selection;

	// IuWFNg̓eϊ[`gIuWFNgɓ]B
	mozFormToConfig(&m_config,m_MozForm);
	operaFormToConfig(&m_config,m_OperaForm);
	ieFormToConfig(&m_config,m_IEForm);
#ifdef WITH_EDGE
	edgeFormToConfig(&m_config, m_EdgeForm);
#endif	// WITH_EDGE
	fxFormToConfig(&m_config, m_FxForm);
	sfFormToConfig(&m_config,m_SfForm);
	chFormToConfig(&m_config,m_ChForm);
	xbFormToConfig(&m_config,m_XbForm);
#ifdef WITH_OP15
	op15FormToConfig(&m_config,m_Op15Form);
#endif	// WITH_OP15
	op19FormToConfig(&m_config,m_Op19Form);
	viFormToConfig(&m_config, m_ViForm);
	edge2FormToConfig(&m_config, m_Edge2Form);

	m_config.setSortType(m_sortMode);
	m_config.setUpdate(m_Update ? true : false);
	m_config.setProperty(attributeNo[m_useAttribute]);
	m_config.setConvertType(Configuration::Edit);
	m_config.setLeaveDuplicateName(false);
	m_config.setNormalize(false);
	m_config.setNoIEFavbar(false);
	m_config.setConvertAll(false);

	m_config.setEditMode(true);	// ҏW[hłB
	m_config.setEditTarget(selection);		// ҏWΏۃuEU

	// ҏWʂ̔fɂIE̊̂Cɓ폜ꍇ̂ŁA
	// ׂč폜Ă甽fsB
	if (m_IEForm->m_chkIE1){
		m_config.setIeEraseFavorite(true);
	}
	m_config.setIeNoLinkToMenu(false);

#ifdef WITH_EDGE
	// Edgel
	if (m_EdgeForm->m_chkEdge1){
		m_config.setEdgeEraseFavorite(true);
	}
	m_config.setEdgeNoLinkToMenu(false);
#endif	// WITH_EDGE

	int targets = countSyncTarget(&m_config) * 2;

	// ubN}[NҏWXbhN
	int result = runThread(&m_config,2,selection,targets);
	if (result){
		if (result == -1){
			MessageBox(
				hWnd,
				_T("ҏWʂ̔f𒆒f܂B"),
				_T("BookSync - ҏWʕ"),
				MB_OK | MB_ICONINFORMATION );
		}else{
			showErrorResult(_T("ҏWʂ̔fɎs܂B"),_T("BookSync - ҏWʕ"));
		}
		return;
	}else{
		if (!noReport) {
			showSuccessResult(
				_T("ubN}[NECɓ̕ҏW܂B"),
				_T("BookSync - ҏWʕ"));
		}
	}
}

/**
 * w肵ubN}[NΏۂǂ`FbN
 *
 * @param no ubN}[N̔ԍ
 * @return true:ubN}[N͕ҏWΏ false:ubN}[N͕ҏWΏۂł͂Ȃ
 */
bool BookSyncForm::checkSelection(int no)
{
	const TCHAR *p;

	switch(no){
		case BOOKMARK_IE:
			p = _T("IÊCɓ͕ҏWΏۂł͂܂B");
			if (m_IEForm->m_chkIE1){
				return true;
			}
			break;
		case BOOKMARK_MOZILLA_1:
			p = _T("Firefox 2/Netscape/MozillãubN}[N1͕ҏWΏۂł͂܂B");
			if (m_MozForm->m_chkMoz1){
				return true;
			}
			break;
		case BOOKMARK_MOZILLA_2:
			p = _T("Firefox 2/Netscape/MozillãubN}[N2͕ҏWΏۂł͂܂B");
			if (m_MozForm->m_chkMoz2){
				return true;
			}
			break;
		case BOOKMARK_OPERA_1:
			p = _T("Opera 12ȑÕubN}[N1͕ҏWΏۂł͂܂B");
			if (m_OperaForm->m_chkOpera1){
				return true;
			}
			break;
		case BOOKMARK_OPERA_2:
			p = _T("Opera 12ȑÕubN}[N2͕ҏWΏۂł͂܂B");
			if (m_OperaForm->m_chkOpera2){
				return true;
			}
			break;
		case BOOKMARK_FIREFOX_1:
			p = _T("Firefox 3ȍ~̃ubN}[N1͕ҏWΏۂł͂܂B");
			if (m_FxForm->m_chkFx1){
				return true;
			}
			break;
		case BOOKMARK_FIREFOX_2:
			p = _T("Firefox 3ȍ~̃ubN}[N2͕ҏWΏۂł͂܂B");
			if (m_FxForm->m_chkFx2){
				return true;
			}
			break;
		case BOOKMARK_SAFARI_1:
			p = _T("SafarĩubN}[N1͕ҏWΏۂł͂܂B");
			if (m_SfForm->m_chkSf1){
				return true;
			}
			break;
		case BOOKMARK_SAFARI_2:
			p = _T("SafarĩubN}[N2͕ҏWΏۂł͂܂B");
			if (m_SfForm->m_chkSf2){
				return true;
			}
			break;
		case BOOKMARK_CHROME_1:
			p = _T("ChromẽubN}[N1͕ҏWΏۂł͂܂B");
			if (m_ChForm->m_chkCh1){
				return true;
			}
			break;
		case BOOKMARK_CHROME_2:
			p = _T("ChromẽubN}[N2͕ҏWΏۂł͂܂B");
			if (m_ChForm->m_chkCh2){
				return true;
			}
			break;
		case BOOKMARK_XBEL_1:
			p = _T("XBELt@C1͕ҏWΏۂł͂܂B");
			if (m_XbForm->m_chkXb1){
				return true;
			}
			break;
		case BOOKMARK_XBEL_2:
			p = _T("XBELt@C2͕ҏWΏۂł͂܂B");
			if (m_XbForm->m_chkXb2){
				return true;
			}
			break;
#ifdef WITH_OP15
		case BOOKMARK_OPERA15_1:
			p = _T("Opera 15`28̃Xs[h_C1͕ҏWΏۂł͂܂B");
			if (m_Op15Form->m_chkOp15_1){
				return true;
			}
			break;
		case BOOKMARK_OPERA15_2:
			p = _T("Opera 15`28̃Xs[h_C2͕ҏWΏۂł͂܂B");
			if (m_Op15Form->m_chkOp15_2){
				return true;
			}
			break;
#endif	// WITH_OP15
		case BOOKMARK_OPERA25_1:
			p = _T("Opera 25ȍ~̃ubN}[N1͕ҏWΏۂł͂܂B");
			if (m_Op19Form->m_chkOp19_1){
				return true;
			}
			break;
		case BOOKMARK_OPERA25_2:
			p = _T("Opera 25ȍ~̃ubN}[N2͕ҏWΏۂł͂܂B");
			if (m_Op19Form->m_chkOp19_2){
				return true;
			}
			break;
#ifdef WITH_EDGE
		case BOOKMARK_EDGE:
			p = _T("EdgêCɓ͕ҏWΏۂł͂܂B");
			if (m_EdgeForm->m_chkEdge1) {
				return true;
			}
			break;
#endif	// WITH_EDGE

		case BOOKMARK_VIVALDI_1:
			p = _T("VivaldĩubN}[N1͕ҏWΏۂł͂܂B");
			if (m_ViForm->m_chkVi_1) {
				return true;
			}
			break;
		case BOOKMARK_VIVALDI_2:
			p = _T("VivaldĩubN}[N2͕ҏWΏۂł͂܂B");
			if (m_ViForm->m_chkVi_2) {
				return true;
			}
			break;
			
		case BOOKMARK_EDGE2_1:
			p = _T("EdgêCɓ1͕ҏWΏۂł͂܂B");
			if (m_Edge2Form->m_chkEdge2_1) {
				return true;
			}
			break;
		case BOOKMARK_EDGE2_2:
			p = _T("EdgêCɓ2͕ҏWΏۂł͂܂B");
			if (m_Edge2Form->m_chkEdge2_2) {
				return true;
			}
			break;
	}
	MessageBox(hWnd, p, _T("G["),MB_OK | MB_ICONEXCLAMATION);
	return false;
}

/**
 * EϊXbhN
 *
 * @param config ϊݒ
 * @param type ̎
 * @param priorBookmark D悷ubN}[N(-1:Ȃ)
 * @return ϊ
 */
int BookSyncForm::runThread(Configuration *config,int type,int priorBookmark,int progresses)
{
	HANDLE hThread;
	unsigned threadID;
	uintptr_t result;

	config->setLogLevel(logLevel);

	// ǂݍݏ͗D揇̋t
	for (int i = 0;i < ALL_BOOKMARKS;i++) {
		config->setReadOrder(i,priority[ALL_BOOKMARKS - i - 1]);
	}
	if (priorBookmark != -1) {
		// D悷ubN}[Nꍇ͓ǂݍݏԍŌɂB
		int now = 0;
		int bookmarkNo = 0;
		for (int i = 0;i < (ALL_BOOKMARKS - 1);i++) {
			bookmarkNo = config->getReadOrder(now);
			if (bookmarkNo == priorBookmark) {
				now++;
				bookmarkNo = config->getReadOrder(now);
			}
			config->setReadOrder(i,bookmarkNo);
			now++;
		}
		config->setReadOrder(ALL_BOOKMARKS - 1,priorBookmark);
	}

	// LZԐݒ
	setCancel(false);

	m_progress = new CProgress(hWnd, IDD_DIAPROG);

	m_progress->showModeless();
	SetActiveWindow(m_progress->getHwnd());
	SetForegroundWindow(m_progress->getHwnd());
	m_progress->setText(progressTitle[type]);

	// bZ[Wԍ
	int prevNo = -1;
	int nowNo = -1;

	// vOXo[
	int prevProgress = 0;
	int nowProgress = 0;
	bool messageChanged = false;
	bool progressChanged = false;
	m_progress->m_Progress->setRange(0,progresses);
	m_progress->m_Progress->setStep(1);
	m_progress->m_Progress->setPos(0);
	m_progress->m_Progress->UpdateWindow();

	// bZ[W̏
	doEvents();

	// CWaitCursor cWait;
	/*
	HCURSOR waitCursor = LoadCursor(NULL, IDC_WAIT);
	HCURSOR arrowCursor = LoadCursor(NULL, IDC_ARROW);
	if (waitCursor != NULL) {
		SetCursor(waitCursor);
	}
	*/

	// XbhŕϊJnB
	setConfigration(config);

	EnableWindow(FALSE);
	result = _beginthreadex( NULL, 0, &RunConvertThread, NULL, 0, &threadID );
	// Xbh쐬Ɏs
	if (result == 0){
		m_progress->ShowWindow(SW_HIDE);
		m_progress->destroyWindow();
		delete m_progress;
		// cWait.Restore();
		EnableWindow(TRUE);

		/*
		if (arrowCursor != NULL) {
			SetCursor(arrowCursor);
			CloseHandle(arrowCursor);
		}
		if (waitCursor != NULL) {
			CloseHandle(waitCursor);
		}
		*/
		return 1;
	}

	// Xbh(ϊ)I҂
	hThread = (HANDLE)result;
	do {
		// i󋵂ς烁bZ[W\B
		nowNo = getProgressNo();
		if (prevNo != nowNo){
			setProgressMessage(nowNo);
			prevNo = nowNo;
			if (isCancelable()){
				m_progress->GetDlgItem(IDC_CONVERT_CANCEL)->EnableWindow(TRUE);
			} else {
				m_progress->GetDlgItem(IDC_CONVERT_CANCEL)->EnableWindow(FALSE);
			}
			messageChanged = true;

			doEvents();

		} else {
			messageChanged = false;
		}

		nowProgress = getProgressCount();
		if (prevProgress != nowProgress) {
			for (int i = prevProgress;i < nowProgress;i++) {
				m_progress->m_Progress->stepIt();
				m_progress->m_Progress->UpdateWindow();

				doEvents();
			}
			if (m_taskbar != NULL) {
				m_taskbar->SetProgressValue(hWnd,nowProgress,progresses);
			}

			prevProgress = nowProgress;
			progressChanged = true;
		} else {
			progressChanged = false;
		}

		// bZ[W̏
		doEvents();

		if (messageChanged) {
			setMessageChanged(true);
			messageChanged = false;
		}
		if (progressChanged) {
			setProgressChanged(true);
			progressChanged = false;
		}

	} while(::WaitForSingleObject(hThread,100) != WAIT_OBJECT_0);

	int convertResult = getConvertResult();

	if (convertResult == 0) {
		m_progress->m_Progress->setPos(progresses);
		m_progress->UpdateWindow();
		for (int i = 0;i < 2;i++) {
			doEvents();
			Sleep(500);
		}
	}
	if (m_taskbar != NULL) {
		m_taskbar->SetProgressState(hWnd, TBPF_NOPROGRESS);
	}

	// EChEB
	m_progress->ShowWindow(SW_HIDE);
	m_progress->destroyWindow();
	delete m_progress;
	EnableWindow(TRUE);

	/*
	if (arrowCursor != NULL) {
		SetCursor(arrowCursor);
		// CloseHandle(arrowCursor);
	}
	if (waitCursor != NULL) {
		// CloseHandle(waitCursor);
	}
	*/

	CloseHandle(hThread);

	return convertResult;
}

/**
 * ibZ[W\B
 *
 * @param no bZ[Wԍ
 */
void BookSyncForm::setProgressMessage(int no)
{
	SetWindowText(m_progress->GetDlgItemRaw(IDC_STPROG), progressText[no]);
	// ĕ`
	m_progress->UpdateWindow();
}

/**
 * EϊݒWXg/t@C擾B
 *
 * @param profile ǂݍ݌IuWFNg
 */
void BookSyncForm::getSettings(IProfile *profile)
{
	// Mozilla֘A̐ݒ
	m_MozForm->m_MozBM1 = profile->GetProfileString(SECTION_NAME, "NS4_bookmark", "").c_str();
	m_MozForm->m_MozBM2 = profile->GetProfileString(SECTION_NAME, "NS6_bookmark", "").c_str();
	m_MozForm->m_chkMoz1 = profile->GetProfileInt(SECTION_NAME, "NS4_do", 0);
	m_MozForm->m_chkMoz2 = profile->GetProfileInt(SECTION_NAME, "NS6_do", 0);
	m_MozForm->m_chkIEfav1 = profile->GetProfileInt(SECTION_NAME, "NS4_IEfavorites", 0);
	m_MozForm->m_chkIEfav2 = profile->GetProfileInt(SECTION_NAME, "NS6_IEfavorites", 0);
	m_MozForm->m_chkNS4Format1 = profile->GetProfileInt(SECTION_NAME, "NS4_NS4format", 0);
	m_MozForm->m_chkNS4Format2 = profile->GetProfileInt(SECTION_NAME, "NS6_NS4format", 0);

	// Opera֘A̐ݒ
	m_OperaForm->m_OperaBM1 = profile->GetProfileString(SECTION_NAME, "Opera_bookmark", "").c_str();
	m_OperaForm->m_OperaBM2 = profile->GetProfileString(SECTION_NAME, "Opera_bookmark_2", "").c_str();
	m_OperaForm->m_chkOpera1 = profile->GetProfileInt(SECTION_NAME, "Opera_do", 0);
	m_OperaForm->m_chkOpera2 = profile->GetProfileInt(SECTION_NAME, "Opera_do_2", 0);
	// m_OperaForm->m_chkOpera7_1 = profile->GetProfileInt(SECTION_NAME,"out_Opera7",1);
	// m_OperaForm->m_chkOpera7_2 = profile->GetProfileInt(SECTION_NAME,"out_Opera7_2",1);
	m_OperaForm->m_chkOpera7_1 = TRUE;
	m_OperaForm->m_chkOpera7_2 = TRUE;
	m_OperaForm->m_Opera7Trash1 = profile->GetProfileInt(SECTION_NAME, "Opera7_trash", 1);
	m_OperaForm->m_Opera7Trash2 = profile->GetProfileInt(SECTION_NAME, "Opera7_trash_2", 1);
	m_OperaForm->m_WinMobile1 = profile->GetProfileInt(SECTION_NAME, "Opera_Win_Mobile", 0);
	m_OperaForm->m_WinMobile2 = profile->GetProfileInt(SECTION_NAME, "Opera_Win_Mobile_2", 0);
	m_OperaForm->m_SyncMobileFavorites1 = profile->GetProfileInt(SECTION_NAME, "Opera_Sync_Mobile", 0);
	m_OperaForm->m_SyncMobileFavorites2 = profile->GetProfileInt(SECTION_NAME, "Opera_Sync_Mobile_2", 0);

	// IE֘A̐ݒ
	m_IEForm->m_IEBM = profile->GetProfileString(SECTION_NAME, "IE_bookmark", "").c_str();
	m_IEForm->m_chkIE1 = profile->GetProfileInt(SECTION_NAME, "IE_do", 1);
	m_IEForm->m_chkIElink = profile->GetProfileInt(SECTION_NAME, "NoIElink", 0);
	m_IEForm->m_chkIElinkSync = profile->GetProfileInt(SECTION_NAME, "UseIElink", 0);
	m_IEForm->m_IEdel = profile->GetProfileInt(SECTION_NAME, "IE_delete", 0);
	m_IEForm->m_chkLinkFx3Sync = profile->GetProfileInt(SECTION_NAME, "IE_SyncFx3link", 0);
	m_IEForm->m_chkNoLinkToMenu = profile->GetProfileInt(SECTION_NAME, IE_NO_LINK_TO_MENU, 0);

#ifdef WITH_EDGE
	// Edge֘Aݒ
	m_EdgeForm->m_EdgeBM = profile->GetProfileString(SECTION_NAME, EDGE_BOOKMARK_VALUE, "").c_str();
	m_EdgeForm->m_chkEdge1 = profile->GetProfileInt(SECTION_NAME, EDGE_DO, 0);
	m_EdgeForm->m_chkEdgelink = profile->GetProfileInt(SECTION_NAME, EDGE_NO_LINK, 0);
	m_EdgeForm->m_chkEdgelinkSync = profile->GetProfileInt(SECTION_NAME, EDGE_USE_LINK, 0);
	m_EdgeForm->m_chkLinkFx3Sync = profile->GetProfileInt(SECTION_NAME, EDGE_SYNC_LINK, 0);
	m_EdgeForm->m_chkNoLinkToMenu = profile->GetProfileInt(SECTION_NAME, EDGE_NO_LINK_TO_MENU, 0);
#endif	// WITH_EDGE

	// Firefox֘A̐ݒ
	m_FxForm->m_FxBM1 = profile->GetProfileString(SECTION_NAME, "Fx_bookmark_1", "").c_str();
	m_FxForm->m_FxBM2 = profile->GetProfileString(SECTION_NAME, "Fx_bookmark_2", "").c_str();
	m_FxForm->m_chkFx1 = profile->GetProfileInt(SECTION_NAME, "Fx_do_1", 0);
	m_FxForm->m_chkFx2 = profile->GetProfileInt(SECTION_NAME, "Fx_do_2", 0);
	m_FxForm->m_placesPut = profile->GetProfileInt(SECTION_NAME, "Fx_put_places", 1);
	m_FxForm->m_chkIgnoreToolbar1 = profile->GetProfileInt(SECTION_NAME, FIREFOX_1_IGNORE_TOOLBAR_VALUE, 0);
	m_FxForm->m_chkIgnoreToolbar2 = profile->GetProfileInt(SECTION_NAME, FIREFOX_2_IGNORE_TOOLBAR_VALUE, 0);
	m_FxForm->m_chkOptimize1 = profile->GetProfileInt(SECTION_NAME, FIREFOX_1_OPTIMIZE_VALUE, 0);
	m_FxForm->m_chkOptimize2 = profile->GetProfileInt(SECTION_NAME, FIREFOX_2_OPTIMIZE_VALUE, 0);

	// Safari֘A̐ݒ
	m_SfForm->m_SfBM1 = profile->GetProfileString(SECTION_NAME, SAFARI_1_BOOKMARK_VALUE, "").c_str();
	m_SfForm->m_SfBM2 = profile->GetProfileString(SECTION_NAME, SAFARI_2_BOOKMARK_VALUE, "").c_str();
	m_SfForm->m_chkSf1 = profile->GetProfileInt(SECTION_NAME, SAFARI_1_DO_VALUE, 0);
	m_SfForm->m_chkSf2 = profile->GetProfileInt(SECTION_NAME, SAFARI_2_DO_VALUE, 0);
	m_SfForm->m_chkIgnoreToolbar1 = profile->GetProfileInt(SECTION_NAME, SAFARI_1_IGNORE_TOOLBAR_VALUE, 0);
	m_SfForm->m_chkIgnoreToolbar2 = profile->GetProfileInt(SECTION_NAME, SAFARI_2_IGNORE_TOOLBAR_VALUE, 0);

	// Chrome֘A̐ݒ
	m_ChForm->m_ChBM1 = profile->GetProfileString(SECTION_NAME, CHROME_1_BOOKMARK_VALUE, "").c_str();
	m_ChForm->m_ChBM2 = profile->GetProfileString(SECTION_NAME, CHROME_2_BOOKMARK_VALUE, "").c_str();
	m_ChForm->m_chkCh1 = profile->GetProfileInt(SECTION_NAME, CHROME_1_DO_VALUE, 0);
	m_ChForm->m_chkCh2 = profile->GetProfileInt(SECTION_NAME, CHROME_2_DO_VALUE, 0);
	m_ChForm->m_chkIgnoreToolbar1 = profile->GetProfileInt(SECTION_NAME, CHROME_1_IGNORE_TOOLBAR_VALUE, 0);
	m_ChForm->m_chkIgnoreToolbar2 = profile->GetProfileInt(SECTION_NAME, CHROME_2_IGNORE_TOOLBAR_VALUE, 0);

	// XBEL֘A̐ݒ
	m_XbForm->m_XbBM1 = profile->GetProfileString(SECTION_NAME, XBEL_1_BOOKMARK_VALUE, "").c_str();
	m_XbForm->m_XbBM2 = profile->GetProfileString(SECTION_NAME, XBEL_2_BOOKMARK_VALUE, "").c_str();
	m_XbForm->m_chkXb1 = profile->GetProfileInt(SECTION_NAME, XBEL_1_DO_VALUE, 0);
	m_XbForm->m_chkXb2 = profile->GetProfileInt(SECTION_NAME, XBEL_2_DO_VALUE, 0);
	m_XbForm->m_LayoutXb1 = profile->GetProfileInt(SECTION_NAME, XBEL_1_LAYOUT_VALUE, 0);
	m_XbForm->m_LayoutXb2 = profile->GetProfileInt(SECTION_NAME, XBEL_2_LAYOUT_VALUE, 0);
	m_XbForm->m_chkIgnoreToolbar1 = profile->GetProfileInt(SECTION_NAME, XBEL_1_IGNORE_TOOLBAR_VALUE, 0);
	m_XbForm->m_chkIgnoreToolbar2 = profile->GetProfileInt(SECTION_NAME, XBEL_2_IGNORE_TOOLBAR_VALUE, 0);

#ifdef WITH_OP15
	// Opera 15֘A̐ݒ
	m_Op15Form->m_Op15BM1 = profile->GetProfileString(SECTION_NAME, OP15_1_BOOKMARK_VALUE, "").c_str();
	m_Op15Form->m_Op15BM2 = profile->GetProfileString(SECTION_NAME, OP15_2_BOOKMARK_VALUE, "").c_str();
	m_Op15Form->m_chkOp15_1 = profile->GetProfileInt(SECTION_NAME, OP15_1_DO_VALUE, 0);
	m_Op15Form->m_chkOp15_2 = profile->GetProfileInt(SECTION_NAME, OP15_2_DO_VALUE, 0);
	m_Op15Form->m_chkInFolder1 = profile->GetProfileInt(SECTION_NAME, OP15_1_IN_FOLDER_VALUE, 0);
	m_Op15Form->m_chkInFolder2 = profile->GetProfileInt(SECTION_NAME, OP15_2_IN_FOLDER_VALUE, 0);
	m_Op15Form->m_chkOptimize1 = profile->GetProfileInt(SECTION_NAME, OP15_1_OPTIMIZE_VALUE, 0);
	m_Op15Form->m_chkOptimize2 = profile->GetProfileInt(SECTION_NAME, OP15_2_OPTIMIZE_VALUE, 0);
#endif	// WITH_OP15

	// Opera 19֘A̐ݒ
	m_Op19Form->m_Op19BM1 = profile->GetProfileString(SECTION_NAME, OP19_1_BOOKMARK_VALUE, "").c_str();
	m_Op19Form->m_Op19BM2 = profile->GetProfileString(SECTION_NAME, OP19_2_BOOKMARK_VALUE, "").c_str();
	m_Op19Form->m_chkOp19_1 = profile->GetProfileInt(SECTION_NAME, OP19_1_DO_VALUE, 0);
	m_Op19Form->m_chkOp19_2 = profile->GetProfileInt(SECTION_NAME, OP19_2_DO_VALUE, 0);
	m_Op19Form->m_chkIgnoreToolbar1 = profile->GetProfileInt(SECTION_NAME, OP19_1_IGNORE_TOOLBAR_VALUE, 1);
	m_Op19Form->m_chkIgnoreToolbar2 = profile->GetProfileInt(SECTION_NAME, OP19_2_IGNORE_TOOLBAR_VALUE, 1);
	m_Op19Form->m_Opera19Trash1 = profile->GetProfileInt(SECTION_NAME, OP19_1_IGNORE_TRASH_VALUE, 1);
	m_Op19Form->m_Opera19Trash2 = profile->GetProfileInt(SECTION_NAME, OP19_2_IGNORE_TRASH_VALUE, 1);
	m_Op19Form->m_chkNoUnsorted1 = profile->GetProfileInt(SECTION_NAME, OP19_1_IGNORE_UNSORTED_VALUE, 0);
	m_Op19Form->m_chkNoUnsorted2 = profile->GetProfileInt(SECTION_NAME, OP19_2_IGNORE_UNSORTED_VALUE, 0);
	m_Op19Form->m_chkOp29SpeedDial = profile->GetProfileInt(SECTION_NAME, OP19_SPEEDDIAL_VALUE, 0);
	// Opera 28ł̓tH_̒ɃtH_悤ɂȂ̂ŏɐݒ
	// TRUEɂB
	m_Op19Form->m_chkInFolder1 = TRUE;
	m_Op19Form->m_chkInFolder2 = TRUE;

	// Vivaldi
	m_ViForm->m_ViBM1 = profile->GetProfileString(SECTION_NAME, VI_1_BOOKMARK_VALUE, "").c_str();
	m_ViForm->m_ViBM2 = profile->GetProfileString(SECTION_NAME, VI_2_BOOKMARK_VALUE, "").c_str();
	m_ViForm->m_chkVi_1 = profile->GetProfileInt(SECTION_NAME, VI_1_DO_VALUE, 0);
	m_ViForm->m_chkVi_2 = profile->GetProfileInt(SECTION_NAME, VI_2_DO_VALUE, 0);
	m_ViForm->m_ViTrash1 = profile->GetProfileInt(SECTION_NAME, VI_1_IGNORE_TRASH_VALUE, 1);
	m_ViForm->m_ViTrash2 = profile->GetProfileInt(SECTION_NAME, VI_2_IGNORE_TRASH_VALUE, 1);
	m_ViForm->m_LayoutVi1 = profile->GetProfileInt(SECTION_NAME, VI_1_LAYOUT_VALUE, 1);
	m_ViForm->m_LayoutVi2 = profile->GetProfileInt(SECTION_NAME, VI_2_LAYOUT_VALUE, 1);

	// Edge(Chromium)֘A̐ݒ
	m_Edge2Form->m_Edge2BM1 = profile->GetProfileString(SECTION_NAME, EDGE2_1_BOOKMARK_VALUE, "").c_str();
	m_Edge2Form->m_Edge2BM2 = profile->GetProfileString(SECTION_NAME, EDGE2_2_BOOKMARK_VALUE, "").c_str();
	m_Edge2Form->m_chkEdge2_1 = profile->GetProfileInt(SECTION_NAME, EDGE2_1_DO_VALUE, 0);
	m_Edge2Form->m_chkEdge2_2 = profile->GetProfileInt(SECTION_NAME, EDGE2_2_DO_VALUE, 0);
	m_Edge2Form->m_chkIgnoreToolbar1 = profile->GetProfileInt(SECTION_NAME, EDGE2_1_IGNORE_TOOLBAR_VALUE, 0);
	m_Edge2Form->m_chkIgnoreToolbar2 = profile->GetProfileInt(SECTION_NAME, EDGE2_2_IGNORE_TOOLBAR_VALUE, 0);

	// AvP[VŜ̐ݒ
	// gpRg̑
	int settingAttribute = profile->GetProfileInt(SECTION_NAME, "SyncAttribute", 0);
	m_useAttribute = 0;
	for (int i = 0; i < HAS_COMMENT_BOOKMARKS + 1; i++) {
		// Version 2.82ȑÕR{{bNẌʒũ݂R{{bNẌʒuɒB
		if (attributeNo[i] == settingAttribute) {
			m_useAttribute = i;
		}
	}
	m_sortMode = profile->GetProfileInt(SECTION_NAME,"SortMode",0);
	m_Update =  (profile->GetProfileInt(SECTION_NAME,"Update",0) != 0);

	// j[֘A
	int syncBeforeEdit = profile->GetProfileInt(SECTION_NAME,"SyncBeforeEdit",1);
	setSyncBeforeEdit(syncBeforeEdit ? true : false);

	int convertAll = profile->GetProfileInt(SECTION_NAME,REGVALUE_CONVERTALL,0);
	setConvertAll(convertAll ? true : false);

	int leaveDuplicateName = profile->GetProfileInt(SECTION_NAME,REGVALUE_LEAVE_DUPLICATE_NAME,0);
	setLeaveDuplicateName(leaveDuplicateName ? true : false);

	int isNomalize = profile->GetProfileInt(SECTION_NAME,REGVALUE_NORMALIZE,0);
	setNormalize(isNomalize ? true : false);

	int isNoIEFavbar = profile->GetProfileInt(SECTION_NAME,REGVALUE_NOIEFAVBAR,0);
	setNoIEFavbar(isNoIEFavbar ? true : false);


	// ϊEҏWݒ
	int selection;
	selection = profile->GetProfileInt(SECTION_NAME, "EditSelection", 0);
	setEditSelection(selection);

	char buf[32];
	for (int i = 0;i < ALL_BOOKMARKS; i++) {

		// Dx
		sprintf(buf,"Priority%02d", i);
		int priority = profile->GetProfileInt(SECTION_NAME,buf, i);
		setPriority(i, priority);

		int status;
		// ϊ̃`FbN
		sprintf(buf,"Source%02d", i);
		status = profile->GetProfileInt(SECTION_NAME,buf,0);
		if (status) {
			setSourceChecked(i,true);
		} else {
			setSourceChecked(i,false);
		}

		// ϊ̃`FbN
		sprintf(buf,"Destination%02d", i);
		status = profile->GetProfileInt(SECTION_NAME,buf,0);
		if (status) {
			setDestinationChecked(i,true);
		} else {
			setDestinationChecked(i,false);
		}
	}

}

/**
 * AvP[V̐ݒWXg/t@C擾B
 *
 * @param profile ǂݍ݌IuWFNg
 */
void BookSyncForm::getAppliSettings(IProfile *profile)
{
	// ʏ̈ʒu̎擾
	posInfo.left = profile->GetProfileInt(SECTION_NAME,REGVALUE_XPOS, INT_MIN);
	posInfo.top = profile->GetProfileInt(SECTION_NAME,REGVALUE_YPOS, INT_MIN);
}

/**
 * EϊݒWXg/t@Cɏ߂B
 *
 * @param profile ݐIuWFNg
 * @param 0:ݐ 1:ݎs
 */
int BookSyncForm::setSettings(IProfile *profile)
{
	// ÑEBU[h2ȏ㑖Ȃ悤ɂB
	if (m_MozForm->m_MozBM1 == ""){
		m_MozForm->m_MozBM1 = " ";
	}
	if (m_MozForm->m_MozBM2 == ""){
		m_MozForm->m_MozBM2 = " ";
	}
	if (m_OperaForm->m_OperaBM1 == ""){
		m_OperaForm->m_OperaBM1 = " ";
	}
	if (m_OperaForm->m_OperaBM2 == ""){
		m_OperaForm->m_OperaBM2 = " ";
	}

	if (m_FxForm->m_FxBM1 == ""){
		m_FxForm->m_FxBM1 = " ";
	}

	if (m_FxForm->m_FxBM2 == ""){
		m_FxForm->m_FxBM2 = " ";
	}

	if (m_SfForm->m_SfBM1 == ""){
		m_SfForm->m_SfBM1 = " ";
	}

	if (m_SfForm->m_SfBM2 == ""){
		m_SfForm->m_SfBM2 = " ";
	}

	if (m_ChForm->m_ChBM1 == ""){
		m_ChForm->m_ChBM1 = " ";
	}

	if (m_ChForm->m_ChBM2 == ""){
		m_ChForm->m_ChBM2 = " ";
	}

#ifdef WITH_OP15
	if (m_Op15Form->m_Op15BM1 == ""){
		m_Op15Form->m_Op15BM1 = " ";
	}
	if (m_Op15Form->m_Op15BM2 == ""){
		m_Op15Form->m_Op15BM2 = " ";
	}
#endif	// WITH_OP15

	if (m_Op19Form->m_Op19BM1 == ""){
		m_Op19Form->m_Op19BM1 = " ";
	}
	if (m_Op19Form->m_Op19BM2 == ""){
		m_Op19Form->m_Op19BM2 = " ";
	}
	if (m_EdgeForm->m_EdgeBM == "") {
		m_EdgeForm->m_EdgeBM = " ";
	}
	if (m_ViForm->m_ViBM1 == "") {
		m_ViForm->m_ViBM1 = " ";
	}
	if (m_ViForm->m_ViBM2 == "") {
		m_ViForm->m_ViBM2 = " ";
	}
	if (m_Edge2Form->m_Edge2BM1 == "") {
		m_Edge2Form->m_Edge2BM1 = " ";
	}
	if (m_Edge2Form->m_Edge2BM2 == "") {
		m_Edge2Form->m_Edge2BM2 = " ";
	}

	try {
		// Mozilla֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,"NS4_bookmark",m_MozForm->m_MozBM1.c_str());
		profile->WriteProfileString(SECTION_NAME,"NS6_bookmark",m_MozForm->m_MozBM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,"NS4_do",m_MozForm->m_chkMoz1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"NS6_do",m_MozForm->m_chkMoz2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"NS4_IEfavorites",m_MozForm->m_chkIEfav1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"NS6_IEfavorites",m_MozForm->m_chkIEfav2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"NS4_NS4format",m_MozForm->m_chkNS4Format1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"NS6_NS4format",m_MozForm->m_chkNS4Format2 ? 1 : 0);

		// Opera֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,"Opera_bookmark",m_OperaForm->m_OperaBM1.c_str());
		profile->WriteProfileString(SECTION_NAME,"Opera_bookmark_2",m_OperaForm->m_OperaBM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,"Opera_do",m_OperaForm->m_chkOpera1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Opera_do_2",m_OperaForm->m_chkOpera2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"out_Opera7", 1);
		profile->WriteProfileInt(SECTION_NAME,"out_Opera7_2", 1);
		profile->WriteProfileInt(SECTION_NAME,"Opera7_trash",m_OperaForm->m_Opera7Trash1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Opera7_trash_2",m_OperaForm->m_Opera7Trash2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Opera_Win_Mobile",m_OperaForm->m_WinMobile1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Opera_Win_Mobile_2",m_OperaForm->m_WinMobile2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Opera_Sync_Mobile",m_OperaForm->m_SyncMobileFavorites1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Opera_Sync_Mobile_2",m_OperaForm->m_SyncMobileFavorites2 ? 1 : 0);

		// IE֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,"IE_bookmark",m_IEForm->m_IEBM.c_str());
		profile->WriteProfileInt(SECTION_NAME,"IE_do",m_IEForm->m_chkIE1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"NoIElink",m_IEForm->m_chkIElink ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"UseIeLink",m_IEForm->m_chkIElinkSync ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"IE_delete",m_IEForm->m_IEdel ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"IE_SyncFx3link",m_IEForm->m_chkLinkFx3Sync ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,IE_NO_LINK_TO_MENU,m_IEForm->m_chkNoLinkToMenu ? 1 : 0);

#ifdef WITH_EDGE
		// Edge֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME, EDGE_BOOKMARK_VALUE, m_EdgeForm->m_EdgeBM.c_str());
		profile->WriteProfileInt(SECTION_NAME, EDGE_DO, m_EdgeForm->m_chkEdge1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, EDGE_NO_LINK, m_EdgeForm->m_chkEdgelink ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, EDGE_USE_LINK, m_EdgeForm->m_chkEdgelinkSync ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, EDGE_SYNC_LINK, m_EdgeForm->m_chkLinkFx3Sync ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, EDGE_NO_LINK_TO_MENU, m_EdgeForm->m_chkNoLinkToMenu ? 1 : 0);
#endif	// WITH_EDGE

		// Firefox֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,"Fx_bookmark_1",m_FxForm->m_FxBM1.c_str());
		profile->WriteProfileString(SECTION_NAME,"Fx_bookmark_2",m_FxForm->m_FxBM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,"Fx_do_1",m_FxForm->m_chkFx1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Fx_do_2",m_FxForm->m_chkFx2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,"Fx_put_places",m_FxForm->m_placesPut ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,FIREFOX_1_IGNORE_TOOLBAR_VALUE,m_FxForm->m_chkIgnoreToolbar1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,FIREFOX_2_IGNORE_TOOLBAR_VALUE,m_FxForm->m_chkIgnoreToolbar2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,FIREFOX_1_OPTIMIZE_VALUE,m_FxForm->m_chkOptimize1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,FIREFOX_2_OPTIMIZE_VALUE,m_FxForm->m_chkOptimize2 ? 1 : 0);

		// Safari֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,SAFARI_1_BOOKMARK_VALUE,m_SfForm->m_SfBM1.c_str());
		profile->WriteProfileString(SECTION_NAME,SAFARI_2_BOOKMARK_VALUE,m_SfForm->m_SfBM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,SAFARI_1_DO_VALUE,m_SfForm->m_chkSf1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,SAFARI_2_DO_VALUE,m_SfForm->m_chkSf2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,SAFARI_1_IGNORE_TOOLBAR_VALUE,m_SfForm->m_chkIgnoreToolbar1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,SAFARI_2_IGNORE_TOOLBAR_VALUE,m_SfForm->m_chkIgnoreToolbar2 ? 1 : 0);

		// Chrome֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,CHROME_1_BOOKMARK_VALUE,m_ChForm->m_ChBM1.c_str());
		profile->WriteProfileString(SECTION_NAME,CHROME_2_BOOKMARK_VALUE,m_ChForm->m_ChBM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,CHROME_1_DO_VALUE,m_ChForm->m_chkCh1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,CHROME_2_DO_VALUE,m_ChForm->m_chkCh2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,CHROME_1_IGNORE_TOOLBAR_VALUE,m_ChForm->m_chkIgnoreToolbar1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,CHROME_2_IGNORE_TOOLBAR_VALUE,m_ChForm->m_chkIgnoreToolbar2 ? 1 : 0);

		// XBEL֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,XBEL_1_BOOKMARK_VALUE,m_XbForm->m_XbBM1.c_str());
		profile->WriteProfileString(SECTION_NAME,XBEL_2_BOOKMARK_VALUE,m_XbForm->m_XbBM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,XBEL_1_DO_VALUE,m_XbForm->m_chkXb1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,XBEL_2_DO_VALUE,m_XbForm->m_chkXb2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,XBEL_1_LAYOUT_VALUE,m_XbForm->m_LayoutXb1);
		profile->WriteProfileInt(SECTION_NAME,XBEL_2_LAYOUT_VALUE,m_XbForm->m_LayoutXb2);
		profile->WriteProfileInt(SECTION_NAME,XBEL_1_IGNORE_TOOLBAR_VALUE,m_XbForm->m_chkIgnoreToolbar1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,XBEL_2_IGNORE_TOOLBAR_VALUE,m_XbForm->m_chkIgnoreToolbar2 ? 1 : 0);

#ifdef WITH_OP15
		// Opera 15֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,OP15_1_BOOKMARK_VALUE,m_Op15Form->m_Op15BM1.c_str());
		profile->WriteProfileString(SECTION_NAME,OP15_2_BOOKMARK_VALUE,m_Op15Form->m_Op15BM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,OP15_1_DO_VALUE,m_Op15Form->m_chkOp15_1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP15_2_DO_VALUE,m_Op15Form->m_chkOp15_2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP15_1_IN_FOLDER_VALUE,m_Op15Form->m_chkInFolder1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP15_2_IN_FOLDER_VALUE,m_Op15Form->m_chkInFolder2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP15_1_OPTIMIZE_VALUE,m_Op15Form->m_chkOptimize1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP15_2_OPTIMIZE_VALUE,m_Op15Form->m_chkOptimize2 ? 1 : 0);
#endif	// WITH_OP15

		// Opera 19֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME,OP19_1_BOOKMARK_VALUE,m_Op19Form->m_Op19BM1.c_str());
		profile->WriteProfileString(SECTION_NAME,OP19_2_BOOKMARK_VALUE,m_Op19Form->m_Op19BM2.c_str());
		profile->WriteProfileInt(SECTION_NAME,OP19_1_DO_VALUE,m_Op19Form->m_chkOp19_1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP19_2_DO_VALUE,m_Op19Form->m_chkOp19_2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP19_1_IN_FOLDER_VALUE,m_Op19Form->m_chkInFolder1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP19_2_IN_FOLDER_VALUE,m_Op19Form->m_chkInFolder2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, OP19_1_IGNORE_TOOLBAR_VALUE, m_Op19Form->m_chkIgnoreToolbar1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, OP19_2_IGNORE_TOOLBAR_VALUE, m_Op19Form->m_chkIgnoreToolbar2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP19_1_IGNORE_TRASH_VALUE,m_Op19Form->m_Opera19Trash1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,OP19_2_IGNORE_TRASH_VALUE,m_Op19Form->m_Opera19Trash2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, OP19_1_IGNORE_UNSORTED_VALUE, m_Op19Form->m_chkNoUnsorted1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, OP19_2_IGNORE_UNSORTED_VALUE, m_Op19Form->m_chkNoUnsorted2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, OP19_SPEEDDIAL_VALUE, m_Op19Form->m_chkOp29SpeedDial ? 1 : 0);

		// Vivaldi֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME, VI_1_BOOKMARK_VALUE, m_ViForm->m_ViBM1.c_str());
		profile->WriteProfileString(SECTION_NAME, VI_2_BOOKMARK_VALUE, m_ViForm->m_ViBM2.c_str());
		profile->WriteProfileInt(SECTION_NAME, VI_1_DO_VALUE, m_ViForm->m_chkVi_1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, VI_2_DO_VALUE, m_ViForm->m_chkVi_2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, VI_1_IGNORE_TRASH_VALUE, m_ViForm->m_ViTrash1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, VI_2_IGNORE_TRASH_VALUE, m_ViForm->m_ViTrash2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, VI_1_LAYOUT_VALUE, m_ViForm->m_LayoutVi1);
		profile->WriteProfileInt(SECTION_NAME, VI_2_LAYOUT_VALUE, m_ViForm->m_LayoutVi2);

		// Edge(Chromium)֘A̐ݒ
		profile->WriteProfileString(SECTION_NAME, EDGE2_1_BOOKMARK_VALUE, m_Edge2Form->m_Edge2BM1.c_str());
		profile->WriteProfileString(SECTION_NAME, EDGE2_2_BOOKMARK_VALUE, m_Edge2Form->m_Edge2BM2.c_str());
		profile->WriteProfileInt(SECTION_NAME, EDGE2_1_DO_VALUE, m_Edge2Form->m_chkEdge2_1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, EDGE2_2_DO_VALUE, m_Edge2Form->m_chkEdge2_2 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, EDGE2_1_IGNORE_TOOLBAR_VALUE, m_Edge2Form->m_chkIgnoreToolbar1 ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME, EDGE2_2_IGNORE_TOOLBAR_VALUE, m_Edge2Form->m_chkIgnoreToolbar2 ? 1 : 0);

		// S
		int settingAttribute = 0;
		for (int i = 0; i < HAS_COMMENT_BOOKMARKS + 1; i++) {
			// ݂̃R{{bNẌʒuVersion 2.82ȑÕR{{bNẌʒuɒB
			if (i == m_useAttribute) {
				settingAttribute = attributeNo[i];
			}
		}
		profile->WriteProfileInt(SECTION_NAME, "SyncAttribute", settingAttribute);

		profile->WriteProfileInt(SECTION_NAME,"SortMode", m_sortMode);
		profile->WriteProfileInt(SECTION_NAME,"Update", m_Update ? 1:0);

		// j[֘A
		profile->WriteProfileInt(SECTION_NAME,"SyncBeforeEdit", getSyncBeforeEdit() ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,REGVALUE_CONVERTALL, getConvertAll() ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,REGVALUE_LEAVE_DUPLICATE_NAME, getLeaveDuplicateName() ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,REGVALUE_NORMALIZE, getNormalize() ? 1 : 0);
		profile->WriteProfileInt(SECTION_NAME,REGVALUE_NOIEFAVBAR, getNoIEFavbar() ? 1 : 0);

		// ϊEҏWݒ
		int selection;
		selection = getEditSelection();

		profile->WriteProfileInt(SECTION_NAME,"EditSelection", selection);

		char buf[32];
		for (int i = 0;i < ALL_BOOKMARKS; i++) {

			// Dx
			sprintf(buf,"Priority%02d", i);
			profile->WriteProfileInt(SECTION_NAME,buf, getPriority(i));

			int status;
			// ϊ̃`FbN
			sprintf(buf,"Source%02d", i);
			if (getSourceChecked(i)) {
				status = 1;
			} else {
				status = 0;
			}
			profile->WriteProfileInt(SECTION_NAME,buf,status);

			// ϊ̃`FbN
			sprintf(buf,"Destination%02d", i);
			if (getDestinationChecked(i)) {
				status = 1;
			} else {
				status = 0;
			}
			profile->WriteProfileInt(SECTION_NAME,buf,status);
		}
		return 0;
	} catch (io_exception &) {
		return 1;
	}
}

/**
 * AvP[V̐ݒWXg/t@Cɏ߂B
 *
 * @param profile ݐIuWFNg
 */
void BookSyncForm::setAppliSettings(IProfile *profile)
{
	// ʏ̈ʒu̕ۑ
	try {
		profile->WriteProfileInt(SECTION_NAME,REGVALUE_XPOS, posInfo.left);
		profile->WriteProfileInt(SECTION_NAME,REGVALUE_YPOS, posInfo.top);
	} catch (io_exception &) {
		// ߂Ȃꍇ͏fOB
		// ʈʒuoȂꍇAQȂ̂œɏsȂB
	}
}

/**
 * ׂẲʍڂƃIuWFNg̊Ԃ̓]sB
 *
 * @param toObj true:ʁIuWFNg false:IuWFNg
 */
void BookSyncForm::UpdateDataAll(bool toObj)
{
	// IuWFNg̐ݒeRg[ɓ]B
	UpdateData(toObj);
	m_MozForm->UpdateData(toObj);
	m_OperaForm->UpdateData(toObj);
	m_IEForm->UpdateData(toObj);
#ifdef WITH_EDGE
	m_EdgeForm->UpdateData(toObj);
#endif	// WITH_EDGE
	m_FxForm->UpdateData(toObj);
	m_SfForm->UpdateData(toObj);
	m_ChForm->UpdateData(toObj);
	m_XbForm->UpdateData(toObj);
#ifdef WITH_OP15
	m_Op15Form->UpdateData(toObj);
#endif	// WITH_OP15
	m_Op19Form->UpdateData(toObj);
	m_ViForm->UpdateData(toObj);
	m_Edge2Form->UpdateData(toObj);

	if (toObj) {
		syncBeforeEdit = menu->isChecked(IDM_SYNCBEFOREEDIT);
		convertAll = menu->isChecked(IDM_CONVERT_ALL);
		leaveDuplicateName = menu->isChecked(IDM_LEAVE_DUPLICATE_NAME);
		normalize = menu->isChecked(IDM_NOMALIZE);
		noIEFavbar = menu->isChecked(IDM_NO_IEFAVBAR);
	} else {
		menu->CheckMenuItem(IDM_SYNCBEFOREEDIT, syncBeforeEdit);
		menu->CheckMenuItem(IDM_CONVERT_ALL, convertAll);
		menu->CheckMenuItem(IDM_LEAVE_DUPLICATE_NAME, leaveDuplicateName);
		menu->CheckMenuItem(IDM_NOMALIZE, normalize);
		menu->CheckMenuItem(IDM_NO_IEFAVBAR, noIEFavbar);
	}

	// ݒɉĊeRg[̎gpۂ߂B
	if (toObj == false) {
		m_MozForm->setSettingEnable();
		m_OperaForm->setSettingEnable();
		m_IEForm->setSettingEnable();
#ifdef WITH_EDGE
		m_EdgeForm->setSettingEnable();
#endif	// WITH_EDGE
		m_FxForm->setSettingEnable();
		m_SfForm->setSettingEnable();
		m_ChForm->setSettingEnable();
		m_XbForm->setSettingEnable();
#ifdef WITH_OP15
		m_Op15Form->setSettingEnable();
#endif	// WITH_OP15
		m_Op19Form->setSettingEnable();
		m_ViForm->setSettingEnable();
		m_Edge2Form->setSettingEnable();
	}
}

/**
 * obNAbvsB
 *
 * @param path A[JCut@C̃pX
 * @return 0:obNAbv 1:obNAbvs
 */
int BookSyncForm::doBackup(tstring &path)
{
	const char *ieFavorite;
	const char *edgeFavorite;
	const char *bookmarkFiles[ALL_BOOKMARKS - 1];

	if (m_IEForm->m_IEBM != _T("")){
		ieFavorite = m_IEForm->m_IEBM.c_str();
	}else{
		ieFavorite = NULL;
	}

#ifdef WITH_EDGE
	if (m_EdgeForm->m_EdgeBM != _T("")) {
		edgeFavorite = m_EdgeForm->m_EdgeBM.c_str();
	} else {
		edgeFavorite = NULL;
	}
#else
	edgeFavorite = NULL;
#endif	// WITH_EDGE

	enum backup_type type = getArchiveType(path.c_str());
	if (type == OTHER) {
		type = LZH;
	}
	setupBackupList(bookmarkFiles);

	int result = ::backupBookmark(
		type, path.c_str(),ieFavorite, edgeFavorite, bookmarkFiles);

	return result;
}

/**
 * EChËʒuݒ肷B
 */
void BookSyncForm::setWindowPos(void)
{
	RECT rect;
	int width,height;
	int screenTop;
	int screenLeft;
	int screenBottom;
	int screenRight;

	// EChETCY擾B
	GetWindowRect(this->getHwnd(), &rect);
	width = rect.right - rect.left + 1;
	height = rect.bottom - rect.top + 1;

	if (posInfo.left != INT_MIN) {

		// ʂ̑傫擾B
		screenLeft = GetSystemMetrics(SM_XVIRTUALSCREEN);
		screenTop = GetSystemMetrics(SM_YVIRTUALSCREEN);
		screenRight = screenLeft + GetSystemMetrics(SM_CXVIRTUALSCREEN) - 1;
		screenBottom = screenTop + GetSystemMetrics(SM_CYVIRTUALSCREEN) - 1;

		// ㉺EʊOƂ̕␳
		// E
		if (screenRight < posInfo.left) {
			posInfo.left = screenRight - width - 1;
		}
		// 
		if ((posInfo.left + width) < screenLeft) {
			posInfo.left = screenLeft;
		}
		// 
		if (screenBottom < posInfo.top) {
			posInfo.top = screenBottom - height - 1;
		}
		// 
		if ((posInfo.top + height) < screenTop) {
			posInfo.top = screenTop;
		}

		// EChÊꏊɍł߂j^̃nh擾B
		HMONITOR hmonitor = MonitorFromWindow(this->getHwnd(), MONITOR_DEFAULTTONEAREST);
		MONITORINFOEX  MonitorInfoEx;

		MonitorInfoEx.cbSize = sizeof(MonitorInfoEx);
		GetMonitorInfo(hmonitor, &MonitorInfoEx);

		// EChE̍j^͂ݏoƂɃj^̍Ɋ񂹂B
		if (posInfo.left < MonitorInfoEx.rcWork.left) {
			// [͂ݏoꍇ͍[ɍ킹B
			posInfo.left = MonitorInfoEx.rcWork.left;
		}

		// EChȄオj^͂ݏoƂɃj^̏Ɋ񂹂B
		if (posInfo.top < MonitorInfoEx.rcWork.top) {
			// [͂ݏoꍇ͏[ɍ킹B
			posInfo.top = MonitorInfoEx.rcWork.top;
		}
	} else {
		int mainDisplayWidth = GetSystemMetrics(SM_CXSCREEN);
		int mainDisplayHeight = GetSystemMetrics(SM_CYSCREEN);

		posInfo.left = (mainDisplayWidth - width ) / 2;
		posInfo.top = (mainDisplayHeight - height) / 2;
	}

	MoveWindow(
		this->getHwnd(),
		posInfo.left,
		posInfo.top,
		width,
		height,
		TRUE);
}

/**
 * AvP[V^Cgݒ肷B
 */
void BookSyncForm::setApplicationTitle(void)
{
	if (m_settingFile == _T("")) {
		this->setText(_T("BookSync"));
	} else {
		this->setText((m_settingFile + _T(" - BookSync")).c_str());
	}
}
