#ifndef BOOKSYNCAPP_H
#define BOOKSYNCAPP_H

#include <vector>

#include "BaseForm.h"
#include "BookSyncForm.h"
#include "FxForm.h"
#include "OperaForm.h"
#include "IEForm.h"
#ifdef WITH_EDGE
#include "EdgeForm.h"
#endif	// WITH_EDGE
#include "SfForm.h"
#include "ChForm.h"
#include "MozForm.h"
#include "XbForm.h"
#ifdef WITH_OP15
#include "Op15Form.h"
#endif	// WITH_OP15
#include "Op19Form.h"
#include "ViForm.h"
#include "Edge2Form.h"
#include "IProfile.h"
#include "IniProfile.h"
#include "RegistoryProfile.h"

#define REGISTORY_KEY "Tatsu_syo"
#define APPLICATION_NAME "BookSync"
#define EXE_NAME "BookSync.exe"

#define PORTABLE_OPTION _T("/Portable")
#define DEBUG_OPTION    _T("/Debug")
#define TRACE_OPTION    _T("/Trace")
#define AUTOEXEC_OPTION _T("/AutoExec")
#define SYNC_OPTION     _T("/Sync")
#define CONVERT_OPTION  _T("/Convert")
#define EDIT_OPTION     _T("/Edit")
#define BACKUP_OPTION   _T("/Backup")
#define AUTOEND_OPTION  _T("/AutoEnd")
#define NOREPORT_OPTION  _T("/NoReport")
#define HELP_OPTION  _T("/Help")
#define HELP_OPTION2  _T("/?")

extern const char *bookmark_name[ALL_BOOKMARKS];
extern TCHAR basePath[_MAX_PATH];

class BookSyncApp {
private:
	BookSyncForm *baseForm;
	CMozForm *m_MozForm;
	COperaForm *m_OperaForm;
	CIEForm *m_IEForm;
#ifdef WITH_EDGE
	CEdgeForm *m_EdgeForm;
#endif	// WITH_EDGE
	CFxForm *m_FxForm;
	CSfForm *m_SfForm;
	CChForm *m_ChForm;
	CXbForm *m_XbForm;
#ifdef WITH_OP15
	COp15Form *m_Op15Form;
#endif	// WITH_OP15
	COp19Form *m_Op19Form;
	CViForm *m_ViForm;
	CEdge2Form *m_Edge2Form;

	IProfile *appliProfile;
	TCHAR *m_lpCmdLine;
	std::vector<tstring> argv;

	// IvVw
	bool portable;
	bool debugMode;
	bool traceMode;
	tstring userInifile;
	bool autoExec;
	bool sync;
	bool convert;
	bool edit;
	bool backup;
	tstring backupFile;
	bool autoEnd;
	bool noReport;
	bool noIEFavbar;
	bool showHelp;
	DWORD winVer;

	int createSettingForms();
	void destructSettingForms();
	void settingsWizard();
	void replaceDummySettings(void);
	void splitOption(void);
	void parseOption(void);

public:
	BaseForm *createBaseWindow();
	int OnAppliStart(TCHAR *lpCmdLine);
	int OnWindowShow();
	void showHelpMessage();

	int OnAppliEnd();

};

#endif