#include "stdafx.h"
#include <objbase.h>
#include <vector>

#include "tstring.h"

#include "util.h"
#include "encutil.h"
#include "encutil2.h"
#include "..\common\NTfunction.h"
#include "..\common\bslib.h"
#include "..\common\IProfile.h"
#include "..\common\IniProfile.h"
#include "..\common\RegistoryProfile.h"

#include "BookSyncApp.h"
#include "BookSyncForm.h"

RegistoryProfile *registory = NULL;
IniProfile *ini = NULL;
IProfile *profile = NULL;
// ݒt@C̊pX
TCHAR basePath[_MAX_PATH];
TCHAR iniFile[_MAX_PATH];

void getBaseDirectory(void);

/**
 * ubN}[N̖
 */
const char *bookmark_name[ALL_BOOKMARKS] = {
	"IÊCɓ",
	"HTML(Firefox 2/Netscape/MozillãubN}[N)1",
	"HTML(Firefox 2/Netscape/MozillãubN}[N)2",
	"Opera 12ȑÕubN}[N1",
	"Opera 12ȑÕubN}[N2",
	"Firefox 3ȍ~̃ubN}[N1",
	"Firefox 3ȍ~̃ubN}[N2",
	"SafarĩubN}[N1",
	"SafarĩubN}[N2",
	"ChromẽubN}[N1",
	"ChromẽubN}[N2",
	"XBELt@C1",
	"XBELt@C2",
	"Opera 15`28̃Xs[h_C1",
	"Opera 15`28̃Xs[h_C2",
	"Opera 25ȍ~̃ubN}[N1",
	"Opera 25ȍ~̃ubN}[N2",
	"Edge(Old)̂Cɓ",
	"VivaldĩubN}[N1",
	"VivaldĩubN}[N2",
	"EdgêCɓ1",
	"EdgêCɓ2",
};


/**
 * AvP[VEChENX̃CX^X𐶐܂B
 *
 * @return AvP[VEChENX̃CX^X
 */
BaseForm *BookSyncApp::createBaseWindow()
{
	::CoInitialize(NULL);		// ⊮̂߂COM̏sB

	baseForm = new BookSyncForm();
	baseForm->setSize(716, 385);
	baseForm->setStyle(WS_OVERLAPPEDWINDOW ^ WS_THICKFRAME ^ WS_MAXIMIZEBOX);

	m_MozForm = NULL;
	m_OperaForm = NULL;
	m_IEForm = NULL;
#ifdef WITH_EDGE
	m_EdgeForm = NULL;
#endif	// WITH_EDGE
	m_FxForm = NULL;
	m_SfForm = NULL;
	m_ChForm = NULL;
	m_XbForm = NULL;
#ifdef WITH_OP15
	m_Op15Form = NULL;
#endif	// WITH_OP15
	m_Op19Form = NULL;
	m_ViForm = NULL;
	m_Edge2Form = NULL;

	if (createSettingForms()) {
		destructSettingForms();
		delete baseForm;
		return NULL;
	}
	baseForm->setMozForm(m_MozForm);
	baseForm->setOperaForm(m_OperaForm);
	baseForm->setIEForm(m_IEForm);
#ifdef WITH_EDGE
	baseForm->setEdgeForm(m_EdgeForm);
#endif	// WITH_EDGE
	baseForm->setFxForm(m_FxForm);
	baseForm->setSfForm(m_SfForm);
	baseForm->setChForm(m_ChForm);
	baseForm->setXbForm(m_XbForm);
#ifdef WITH_OP15
	baseForm->setOp15Form(m_Op15Form);
#endif	// WITH_OP15
	baseForm->setOp19Form(m_Op19Form);
	baseForm->setViForm(m_ViForm);
	baseForm->setEdge2Form(m_Edge2Form);

	return baseForm;
}

/**
 * AvP[V̊Jns܂B
 *
 * @return \
 */
int BookSyncApp::OnAppliStart(TCHAR *lpCmdLine)
{
	DWORD dwver;

	portable = false;
	debugMode = false;
	traceMode = false;
	userInifile = _T("");
	autoExec = false;
	sync = false;
	convert = false;
	edit = false;
	backup = false;
	backupFile = _T("");
	autoEnd = false;
	noIEFavbar = false;
	noReport = false;
	showHelp = false;
	basePath[0] = _T('\0');

	loadNTfunction();			// Windows NTŗL̃Ch֐pDLL[hB

	// {vÕP[ݒ肵܂B
	setLocale();
	m_lpCmdLine = lpCmdLine;

	// R}hCIvV߂B
	splitOption();
	parseOption();

	// bZ[WbZ[W{bNXo͂悤ɂB
	g_messageType = 1;

	dwver = ::GetVersion();
	winVer = LOBYTE(dwver);
	if (winVer < 5){	// Windows NT 3.xx`FbN
		MessageBox(NULL,"Windows 7ȍ~Windowsł̂\n삵܂B","l",MB_OK);
		unloadNTfunction();
		::CoUninitialize();	// COMgȂȂ̂ŁAnsB
		return 1;
	}
	setupAutoComplete();

	// ݒĂяoB
	// IvV̗LŐݒ̕ۑꏊςB
	try {
		getBaseDirectory();
		if (portable){
			ini = new IniProfile();

			strcpy(iniFile,basePath);
			strcat(iniFile,"BookSync.ini");
			ini->setIniFile(iniFile);

			appliProfile = ini;
		}else{
			registory = new RegistoryProfile();
			registory->SetRegistryKey(REGISTORY_KEY);
			registory->SetApplicationName(APPLICATION_NAME);

			appliProfile = registory;
		}
	} catch (...) {
		destructSettingForms();
		delete baseForm;
		return NULL;
	}

	// O֘A
	if (debugMode){
		baseForm->setLogLevel(1);
	}

	if (traceMode){
		baseForm->setLogLevel(2);
	}

	// ݒǂݍŁAIuWFNgɐݒ肷B

	// R}hCw肪邩ǂ
	if (userInifile != _T("")) {
		try {
			TCHAR buf[MAX_PATH + 1];
			GetCurrentDirectory(MAX_PATH + 1,buf);

			tstring fullIniPath;
			// MessageBox(NULL,buf,"Attach !!", MB_OK);
			if (!isFullPath(userInifile.c_str())) {
				if (userInifile[0] != _T('\\')) {
					// ΃pX
					fullIniPath = buf;
					fullIniPath += _T("\\");
					fullIniPath += userInifile;
				} else {
					// JghCu̐΃pX
					buf[2] = _T('\0');
					fullIniPath = buf;
					fullIniPath += userInifile;
				}
				userInifile = fullIniPath;
			}
			if (!isExistingFile(userInifile.c_str())) {
				MessageBox(NULL, "ݒt@C݂܂B", "G[", MB_ICONEXCLAMATION);
				baseForm->getSettings(appliProfile);
				// ݒt@C݂Ȃꍇ͉ȂB
				autoExec = false;
				autoEnd = false;
				noReport = false;
				sync = false;
				convert = false;
				edit = false;
				backup = false;
				userInifile = _T("");
			} else {
				// R}hCw肪炻œǂݍ
				IniProfile *userIni = new IniProfile();
				userIni->setIniFile(userInifile.c_str());
				baseForm->getSettings(userIni);

				baseForm->setSettingFileName(userInifile);

				delete userIni;
				replaceDummySettings();
			}
		}catch(...){
		}
	} else {
		baseForm->getSettings(appliProfile);
	}
	baseForm->getAppliSettings(appliProfile);

	return 0;
}

/**
 * EChE\ꂽƂ̏s܂B
 *
 * @return \
 */
int BookSyncApp::OnWindowShow()
{
	// ̃^C~OŃEChÊ݂ŁAɏdނƋN̎EChEԂōsƂłB
	baseForm->setApplicationTitle();

	// ݒEBU[h
	if (userInifile == _T("")) {
		settingsWizard();
	}

	// IuWFNg̐ݒ𔽉fB
	baseForm->UpdateDataAll(false);
	// |[gsȂݒ𔽉fB
	baseForm->setNoReport(noReport);

	// R}hCŎw肳ꂽ̎s
	if (showHelp) {
		showHelpMessage();
	}

	// s邩ǂ?
	if (autoExec) {
		baseForm->setAutoExecOnRun(true);
	}

	// obNAbv
	if (backup) {
		baseForm->OnOptionBackup(backupFile);
	}

	// 
	if (sync){
		baseForm->setSyncOnRun(true);
		baseForm->OnCommandSync();
	}

	// ϊ
	if (convert){
		baseForm->setConvertOnRun(true);
		baseForm->OnCommandConvert();
	}

	// ҏW(ʂ̔f)
	if (edit){
		baseForm->setEditOnRun(true);
		baseForm->OnCommandEdit();
	}

	// I
	if (autoEnd) {
		baseForm->OnCommandExit();
	}

	return 0;
}

void BookSyncApp::showHelpMessage()
{
	MessageBox(
		baseForm->getHwnd(),
		"BookSync (IvV)... ݒt@C\n"
		"/Sync Nɓs\n"
		"/Convert Nɕϊs\n"
		"/Edit NɕҏWs\n"
		"/Backup NɃobNAbvs\n"
		"/AutoExec O̎wŎs\n"
		"/AutoEnd IɎI\n"
		"/NoReport bZ[W\Ȃ\n"
		"/Portable st@C̃tH_ɐݒۑ\n"
		"/Help,/? wvbZ[W̕\\n",
		"wv"
		,MB_OK | MB_ICONINFORMATION);
}
/**
 * AvP[V̏Is܂B
 *
 * @return \
 */
int BookSyncApp::OnAppliEnd()
{
	baseForm->setSettings(appliProfile);
	baseForm->setAppliSettings(appliProfile);

	// n
	cleanupAutoComplete();

	unloadNTfunction();
	::CoUninitialize();	// COMgȂȂ̂ŁAnsB

	delete profile;
	destructSettingForms();

	return 0;
}

/**
 * tH[IuWFNg쐬Ă܂B
 *
 * @return 0:쐬 1:쐬s
 */
int BookSyncApp::createSettingForms()
{
	try {
		m_MozForm = new CMozForm(NULL, IDD_MOZ_DIALOG);
		m_OperaForm = new COperaForm(NULL, IDD_OPERA_DIALOG);
		m_IEForm = new CIEForm(NULL, IDD_IE_DIALOG);
#ifdef WITH_EDGE
		m_EdgeForm = new CEdgeForm(NULL, IDD_EDGE_DIALOG);
#endif	// WITH_EDGE
		m_FxForm = new CFxForm(NULL, IDD_FX_DIALOG);
		m_SfForm = new CSfForm(NULL, IDD_SF_DIALOG);
		m_ChForm = new CChForm(NULL, IDD_CH_DIALOG);
		m_XbForm = new CXbForm(NULL, IDD_XB_DIALOG);
#ifdef WITH_OP15
		m_Op15Form = new COp15Form(NULL, IDD_OP15_DIALOG);
#endif	// WITH_OP15
		m_Op19Form = new COp19Form(NULL, IDD_OP19_DIALOG);
		m_ViForm = new CViForm(NULL, IDD_VI_DIALOG);
		m_Edge2Form = new CEdge2Form(NULL, IDD_EDGE2_DIALOG);
	} catch(...) {
		return 1;
	}
	return 0;

}

/**
 * tH[IuWFNgJĂ܂B
 */
void BookSyncApp::destructSettingForms()
{
	if (m_Edge2Form != NULL) {
		delete m_Edge2Form;
	}

	if (m_ViForm != NULL) {
		delete m_ViForm;
	}

	if (m_Op19Form != NULL) {
		delete m_Op19Form;
	}

#ifdef WITH_OP15
	if (m_Op15Form != NULL) {
		delete m_Op15Form;
	}
#endif	// WITH_OP15

	if (m_XbForm != NULL) {
		delete m_XbForm;
	}

	if (m_ChForm != NULL) {
		delete m_ChForm;
	}

	if (m_SfForm != NULL) {
		delete m_SfForm;
	}

	if (m_FxForm != NULL) {
		delete m_FxForm;
	}

#ifdef WITH_EDGE
	if (m_EdgeForm != NULL) {
		delete m_EdgeForm;
	}
#endif	// WITH_EDGE

	if (m_IEForm != NULL) {
		delete m_IEForm;
	}

	if (m_OperaForm != NULL) {
		delete m_OperaForm;
	}

	if (m_MozForm != NULL) {
		delete m_MozForm;
	}

}

/**
 * st@C݂fBNg܂B
 */
void getBaseDirectory(void)
{
	DWORD result;
	char pathname[MAX_PATH],drive[_MAX_DRIVE+1],cDir[_MAX_DIR+1];
	HMODULE ModHdl;

	// st@C̃fBNg𓾂B
	ModHdl = GetModuleHandle(EXE_NAME);
	if (ModHdl == NULL) {
		return;
	}

	result = GetModuleFileName(ModHdl,pathname,MAX_PATH);

	// B
	_splitpath(pathname,drive,cDir,NULL,NULL);
	sprintf(basePath,"%s%s",drive,cDir);

}

/**
 * CɓEubN}[N̏ꏊݒ肷B
 *
 */
void BookSyncApp::settingsWizard()
{
	// ݒ莞ɂ̓EBU[hĂяoB
	// Mozilla
#if 0
	if (m_MozForm->m_MozBM1 == ""){
		m_MozForm->searchFx1(baseForm->getHwnd());
	}

	if (m_MozForm->m_MozBM2 == ""){
		m_MozForm->searchFx2(baseForm->getHwnd());
	}
#endif

	// Opera
	if (m_OperaForm->m_OperaBM1 == ""){
		// ݒ̏ꍇAOperãubN}[ŇoɓB
		m_OperaForm->searchOpera(baseForm->getHwnd());
	}

	if (m_OperaForm->m_OperaBM2 == ""){
		// ݒ̏ꍇAOperãubN}[ŇoɓB
		m_OperaForm->searchOpera2(baseForm->getHwnd());
	}

	if (winVer < 10) {
		// IE
		if (m_IEForm->m_IEBM == "") {
			// IÊCɓ肪ݒ̏ꍇIÊCɓoB
			m_IEForm->m_IEBM = m_IEForm->getIeFavoriteFolder();
		}
	}

#if 0
	// Edge
	DWORD dwver = ::GetVersion();
	DWORD winVer = LOBYTE(dwver);
	if (winVer > 9){	// Windows 10ȑOEdge킯͂Ȃ̂Ŕ΂B
		if (m_EdgeForm->m_EdgeBM == ""){
			// EdgêCɓ肪ݒ̏ꍇEdgêCɓoB
			m_EdgeForm->m_EdgeBM = m_EdgeForm->getEdgeFavoriteFolder();
			m_EdgeForm->m_chkEdge1 = TRUE;
		}
	}
#endif	// WITH_EDGE

	// Firefox 3
	if (m_FxForm->m_FxBM1 == ""){
		m_FxForm->searchFx1(baseForm->getHwnd());
	}

	if (m_FxForm->m_FxBM2 == ""){
		m_FxForm->searchFx2(baseForm->getHwnd());
	}

#if 0
	// Safari
	if (m_SfForm->m_SfBM1 == ""){
		m_SfForm->searchSf1(baseForm->getHwnd());
	}

	if (m_SfForm->m_SfBM2 == ""){
		m_SfForm->searchSf2(baseForm->getHwnd());
	}
#endif

	// Chrome
	if (m_ChForm->m_ChBM1 == ""){
		m_ChForm->searchCh1(baseForm->getHwnd());
	}

	if (m_ChForm->m_ChBM2 == ""){
		m_ChForm->searchCh2(baseForm->getHwnd());
	}

#if 0
	// Opera 15
	if (m_Op15Form->m_Op15BM1 == ""){
		// ݒ̏ꍇAOpera 15̃ubN}[ŇoɓB
		m_Op15Form->searchOp15_1(baseForm->getHwnd());
	}

	if (m_Op15Form->m_Op15BM2 == ""){
		// ݒ̏ꍇAOpera 15̃ubN}[ŇoɓB
		m_Op15Form->searchOp15_2(baseForm->getHwnd());
	}
#endif

	// Opera 19
	if (m_Op19Form->m_Op19BM1 == ""){
		// ݒ̏ꍇAOpera 19̃ubN}[ŇoɓB
		m_Op19Form->searchOp19_1(baseForm->getHwnd());
	}

	if (m_Op19Form->m_Op19BM2 == ""){
		// ݒ̏ꍇAOpera 19̃ubN}[ŇoɓB
		m_Op19Form->searchOp19_2(baseForm->getHwnd());
	}

	// Vivaldi
	if (m_ViForm->m_ViBM1 == "") {
		m_ViForm->searchVi_1(baseForm->getHwnd());
	}

	if (m_ViForm->m_ViBM2 == "") {
		m_ViForm->searchVi_2(baseForm->getHwnd());
	}

	// Edge(Chromium)
	if (m_Edge2Form->m_Edge2BM1 == "") {
		m_Edge2Form->searchEdge2_1(baseForm->getHwnd());
	}

	if (m_Edge2Form->m_Edge2BM2 == "") {
		m_Edge2Form->searchEdge2_2(baseForm->getHwnd());
	}

	// ݒ肵̃_~[ݒϊB
	replaceDummySettings();
}

/**
 * settingsWizardňxݒĨ_~[ݒϊB
 */
void BookSyncApp::replaceDummySettings(void)
{
	// ݒ肵̃_~[ݒϊB
	if (m_MozForm->m_MozBM1 == " "){
		m_MozForm->m_MozBM1 = "";
	}

	if (m_MozForm->m_MozBM2 == " "){
		m_MozForm->m_MozBM2 = "";
	}

	if (m_OperaForm->m_OperaBM1 == " "){
		m_OperaForm->m_OperaBM1 = "";
	}

	if (m_OperaForm->m_OperaBM2 == " "){
		m_OperaForm->m_OperaBM2 = "";
	}

	if (m_FxForm->m_FxBM1 == " "){
		m_FxForm->m_FxBM1 = "";
	}

	if (m_FxForm->m_FxBM2 == " "){
		m_FxForm->m_FxBM2 = "";
	}

	if (m_SfForm->m_SfBM1 == " "){
		m_SfForm->m_SfBM1 = "";
	}

	if (m_SfForm->m_SfBM2 == " "){
		m_SfForm->m_SfBM2 = "";
	}

	if (m_ChForm->m_ChBM1 == " "){
		m_ChForm->m_ChBM1 = "";
	}

	if (m_ChForm->m_ChBM2 == " "){
		m_ChForm->m_ChBM2 = "";
	}

#ifdef WITH_OP15
	if (m_Op15Form->m_Op15BM1 == " "){
		m_Op15Form->m_Op15BM1 = "";
	}

	if (m_Op15Form->m_Op15BM2 == " "){
		m_Op15Form->m_Op15BM2 = "";
	}
#endif	// WITH_OP15

	if (m_Op19Form->m_Op19BM1 == " "){
		m_Op19Form->m_Op19BM1 = "";
	}

	if (m_Op19Form->m_Op19BM2 == " "){
		m_Op19Form->m_Op19BM2 = "";
	}

	if (m_EdgeForm->m_EdgeBM == " ") {
		m_EdgeForm->m_EdgeBM = "";
	}

	if (m_ViForm->m_ViBM1 == " ") {
		m_ViForm->m_ViBM1 = "";
	}

	if (m_ViForm->m_ViBM2 == " ") {
		m_ViForm->m_ViBM2 = "";
	}

	if (m_Edge2Form->m_Edge2BM1 == " ") {
		m_Edge2Form->m_Edge2BM1 = "";
	}

	if (m_Edge2Form->m_Edge2BM2 == " ") {
		m_Edge2Form->m_Edge2BM2 = "";
	}
}

/**
 * IvV𕪊Ċi[B
 */
void BookSyncApp::splitOption(void)
{
	int optionLen;
	TCHAR *optionStart;
	TCHAR *arg;
	TCHAR buf[MAX_PATH];
	int commands = 0;
	bool searchToSpace = true;	// Xy[X؂肩NH[e[V؂肩

	arg = m_lpCmdLine;

	while (*arg) {
		// ܂̓Xy[X΂
		if (isspace(*arg)) {
			arg++;
			continue;
		}

		// ̏ITB
		optionStart = arg;
		optionLen = 0;
		searchToSpace = true;
		if (*arg == '\"') {
			optionStart++;
			searchToSpace = false;
		}

		do {
			if (searchToSpace) {
				if (isspace(*arg)) {
					break;
				}
			} else {
				if (*arg == '\"') {
					break;
				}
			}
			arg++;
			optionLen++;
		}while (*arg);

		if (optionLen >= MAX_PATH) {
			optionLen = MAX_PATH - 1;
		}

		for(int i = 0;i < optionLen; i++) {
			buf[i] = optionStart[i];
		}
		buf[optionLen] = _T('\0');
		tstring arg = buf;
		argv.push_back(buf);

		commands++;
	}
}

/**
 * IvV߂sB
 */
void BookSyncApp::parseOption(void)
{
	std::vector<tstring>::size_type i;

	for (i = 0; i < argv.size(); i++) {

		if (argv[i] == PORTABLE_OPTION) {
			portable = true;
		} else if (argv[i] == DEBUG_OPTION) {
			debugMode = true;
		} else if (argv[i] == TRACE_OPTION) {
			traceMode = true;
		} else if (argv[i] == AUTOEXEC_OPTION) {
			autoExec = true;
		} else if (argv[i] == SYNC_OPTION) {
			sync = true;
		} else if (argv[i] == CONVERT_OPTION) {
			convert = true;
		} else if (argv[i] == EDIT_OPTION) {
			edit = true;
		} else if (argv[i] == BACKUP_OPTION) {
			i++;
			if (i < argv.size()) {
				backup = true;
				backupFile = argv[i];
			} else {
				backup = false;
			}
		} else if (argv[i] == AUTOEND_OPTION) {
			autoEnd = true;
		} else if (argv[i] == NOREPORT_OPTION) {
			noReport = true;
		} else if (!stricmp(argv[i].c_str(), HELP_OPTION)) {
			showHelp = true;
		} else if (argv[i] == HELP_OPTION2) {
			showHelp = true;
		} else {
			userInifile = argv[i];
		}
	}
}