#ifndef BACKUP_H
#define BACKUP_H

#include <tchar.h>

enum backup_type {
	OTHER,
	LZH,
	ZIP,
	SEVEN_ZIP
};

int restoreBookmark(
	enum backup_type type,
	const char *arcFile,
	const char *ieFavorite,
	const char *edgeFavorite,
	const char *bookmarkFiles[]
);

int backupBookmark(
	enum backup_type type,
	const char *arcFile,
	const char *ieFavorite,
	const char *edgeFavorite,
	const char *bookmarkFiles[]
);
enum backup_type getArchiveType(const char *filename);

#define UNLHA_DLL "unlha32.dll"
#define SEVENZIP_DLL "7-zip32.dll"
#define SEVENZIP64_DLL "7-zip64.dll"

#define MOZILLA_ARCHIVEENTRY_1	"Mozilla1.html"
#define MOZILLA_ARCHIVEENTRY_2	"Mozilla2.html"
#define OPERA_ARCHIVEENTRY_1	"Opera1.adr"
#define OPERA_ARCHIVEENTRY_2	"Opera2.adr"
#define FIREFOX_ARCHIVEENTRY_1	"Firefox1.sqlite"
#define FIREFOX_ARCHIVEENTRY_2	"Firefox2.sqlite"
#define SAFARI_ARCHIVEENTRY_1	"Safari1.plist"
#define SAFARI_ARCHIVEENTRY_2	"Safari2.plist"
#define CHROME_ARCHIVEENTRY_1	"Chrome1"
#define CHROME_ARCHIVEENTRY_2	"Chrome2"
#define XBEL_ARCHIVEENTRY_1	"XBEL1.xbel"
#define XBEL_ARCHIVEENTRY_2	"XBEL2.xbel"
#define OP15_ARCHIVEENTRY_1	"Opera15_1.db"
#define OP15_ARCHIVEENTRY_2	"Opera15_2.db"
#define OP19_ARCHIVEENTRY_1	"Opera19_1"
#define OP19_ARCHIVEENTRY_2	"Opera19_2"
#define VI_ARCHIVEENTRY_1	"Vivaldi_1"
#define VI_ARCHIVEENTRY_2	"Vivaldi_2"
#define EDGE2_ARCHIVEENTRY_1	"EDGE2_1"
#define EDGE2_ARCHIVEENTRY_2	"EDGE2_2"

#define IE_ARCHIVEENTRY	"IE"
#define EDGE_ARCHIVEENTRY	"Edge.edb"

#define IE_ORDERENTRY	"IEOrder"
#define EDGE_ORDERENTRY	"EdgeOrder"

#define MES_NOSEVENZIP32 "7-ZIP32.DLL܂B"
#define MES_NOSEVENZIP64 "7-ZIP64.DLL܂B"

DWORD executeProcess(char *buf, BOOL &runResult);

#endif

