#include "stdafx.h"

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	"BScommon.h"
#include	"bslib.h"
#include	"Backup.h"

typedef int (WINAPI *TFUNC)(HWND,char *,char *,unsigned int);
char tempDir[_MAX_PATH];
HINSTANCE   hInstDLL;	// DLL̃CX^Xnh
TFUNC       Unlha;		// DLLUnLha֐ւ̃|C^
static const char *backupEntrys[ALL_BOOKMARKS - 1] = {
	MOZILLA_ARCHIVEENTRY_1,
	MOZILLA_ARCHIVEENTRY_2,
	OPERA_ARCHIVEENTRY_1,
	OPERA_ARCHIVEENTRY_2,
	FIREFOX_ARCHIVEENTRY_1,
	FIREFOX_ARCHIVEENTRY_2,
	SAFARI_ARCHIVEENTRY_1,
	SAFARI_ARCHIVEENTRY_2,
	CHROME_ARCHIVEENTRY_1,
	CHROME_ARCHIVEENTRY_2,
	XBEL_ARCHIVEENTRY_1,
	XBEL_ARCHIVEENTRY_2,
	OP15_ARCHIVEENTRY_1,
	OP15_ARCHIVEENTRY_2,
	OP19_ARCHIVEENTRY_1,
	OP19_ARCHIVEENTRY_2,
	EDGE_ARCHIVEENTRY,
	VI_ARCHIVEENTRY_1,
	VI_ARCHIVEENTRY_2,
	EDGE2_ARCHIVEENTRY_1,
	EDGE2_ARCHIVEENTRY_2,
};

// IÊCɓ̏Ԃۑ郌WXg̃t\L
const char *IE_FULL_ORDER_REG =
	"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\MenuOrder\\Favorites";
// EdgêCɓ̏Ԃۑ郌WXg̃t\L
const char *EDGE_FULL_ORDER_REG = 
	"HKEY_CURRENT_USER\\SOFTWARE\\Classes\\Local Settings\\Software\\Microsoft\\Windows\\CurrentVersion\\AppContainer\\Storage\\microsoft.microsoftedge_8wekyb3d8bbwe\\MicrosoftEdge\\FavOrder";

/**
 * DLL̈kEWJp֐̃AhX擾
 *
 * @param type A[JCu̎
 * @return kEWJp֐̃AhX
 */
TFUNC getFunction(enum backup_type type)
{
	switch(type) {
		case LZH:
			return (TFUNC)GetProcAddress(hInstDLL,"Unlha");
		case ZIP:
			return (TFUNC)GetProcAddress(hInstDLL,"SevenZip");
		case SEVEN_ZIP:
			return (TFUNC)GetProcAddress(hInstDLL,"SevenZip");
	}
	return NULL;
}

/**
 * t@CA[JCu̎ނ𔻒肷
 *
 * @param filename A[JCũt@C
 * @return A[JCu̎
 */
enum backup_type getArchiveType(const char *filename)
{
	int len;

	len = strlen(filename);
	if (!stricmp(filename + (len - 4), ".LZH")) {
		return LZH;
	}

	if (!stricmp(filename + (len - 4), ".ZIP")) {
		return ZIP;
	}

	if (!stricmp(filename + (len - 3), ".7z")) {
		return SEVEN_ZIP;
	}
	return OTHER;
}

/**
 * A[JCoDLL[hB
 *
 * @param type A[JCu^Cv
 * @return NULL:A[JCoDLL̃CX^X NULL:[hs
 */
HINSTANCE loadArchiverDll(enum backup_type type)
{
	switch (type) {
		case LZH:
			return LoadLibrary(_T(UNLHA_DLL));
		case ZIP:
#ifdef _WIN64
			return LoadLibrary(_T(SEVENZIP64_DLL));
#else
			return LoadLibrary(_T(SEVENZIP_DLL));
#endif
		case SEVEN_ZIP:
#ifdef _WIN64
			return LoadLibrary(_T(SEVENZIP64_DLL));
#else
			return LoadLibrary(_T(SEVENZIP_DLL));
#endif
	}
	return NULL;
}

/**
 * Ō\ȍ~؂藣B<br>
 * pathȍ~𒼐ڏ̂ŒӁB<br>
 *
 * @param path Ώە
 * @return NULL:؂藣Ɏs NULL:؂藣ʒu
 */
char *cutLastPointer(char *path)
{
	char *find = NULL,*ptmp;
	
	if (path == NULL){
		return NULL;
	}

	if (*path == '\\'){	// ΃pX?
		path++;
		if (*path == '\\'){	// UNC\LB
			path++;
		}
	}
	while(*path){
		if (isleadbyte(*path)){
			path++;
		}else{
			if (*path == '\\'){
				ptmp = path;
				while(*path == '\\'){	// \₪Y΍
					path++;
				}
				path--;
				if (*(path+1))	// \0łȂ
					find = ptmp;
			}
		}
		path++;
	}
	if (find != NULL){
		*find = '\0';	// Ō̗vfԂ؂
		return find;
	}else{
		return NULL;
	}
}

/**
 * obNAbvEXgApꎞt@C̃pX𐶐B
 * e|tH_BStemp.(A[JCůgq)ƂOŐB
 *
 * @param type A[JCu̎
 * @param tmpPath pX̓obt@
 * @param bufLen pX̓obt@̃TCY
 */
void createTemporaryPath(enum backup_type type, char *tmpPath, int bufLen)
{
	GetTempPath(bufLen, tmpPath);
	strcat(tmpPath, "BStemp");
	switch (type) {
		case LZH:
			strcat(tmpPath, ".LZH");
			break;
		case ZIP:
			strcat(tmpPath, ".ZIP");
			break;
		case SEVEN_ZIP:
			strcat(tmpPath, ".7z");
			break;
	}
}

/**
 * vZXsB
 *
 * @param buf sR}hC
 * @param runResult (out) 0FvZXs 0FvZXss
 * @return svZX̖߂l
 */
DWORD executeProcess(char *buf, BOOL &runResult)
{
	DWORD procResult;
	PROCESS_INFORMATION procInfo;
	STARTUPINFO startInfo;

	memset(&startInfo, 0, sizeof(STARTUPINFO));
	memset(&procInfo, 0, sizeof(PROCESS_INFORMATION));

	// R}hCsB
	runResult = CreateProcess(NULL, buf, NULL, NULL, FALSE, CREATE_NO_WINDOW, NULL,
		NULL, &startInfo, &procInfo);
	if (!runResult) {
		// Ns͂ŔB
		return 0;
	}

	// sIҋ@B
	WaitForSingleObject(procInfo.hProcess, INFINITE);

	// vZX̖߂l擾B
	GetExitCodeProcess(procInfo.hProcess, &procResult);
	CloseHandle(procInfo.hProcess);
	CloseHandle(procInfo.hThread);

	return procResult;
}

// --------------------------------------------
// ȉAubN}[NECɓ̃XgA
// --------------------------------------------


/**
 * t@CWJR}h쐬B
 *
 * @param type A[JCu
 * @param arcFile A[JCut@C
 * @param buf R}hCobt@
 */
void extractFileCommand(
	enum backup_type &type,
	char const*arcFile,
	char const*memberName,
	char *buf)
{
	switch (type) {
		case LZH:
			strcpy(buf,"x -h2 \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,tempDir);
			strcat(buf,"\" ");
			strcat(buf,memberName);
			break;
		case ZIP:
			strcpy(buf,"e -aoa \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,tempDir);
			strcat(buf,"\" ");
			strcat(buf,memberName);
			break;
		case SEVEN_ZIP:
			strcpy(buf,"e -aoa \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,tempDir);
			strcat(buf,"\" ");
			strcat(buf,memberName);
			break;
	}
}

/**
 * A[JCu烊l[ēWJB
 *
 * @param type A[JCu̎
 * @param arcFile ubN}[Ni[A[JCut@C
 * @param targetFile WJ̃pX
 * @param memberName ubN}[Ni[A[JCut@C̃t@C
 * @return 0: 1:s
 */
int renameExtract(
	enum backup_type type,
	const char *arcFile,
	const char *targetFile,
	const char *memberName
)
{
	int tempLength = GetTempPath(_MAX_PATH,tempDir);
	if (tempLength == 0){
		// e|fBNg擾łȂ
		return 1;
	}

	// UNLHA32.DLLpR}h쐬
	char buf[512];

	buf[511] = '\0';
	extractFileCommand(type, arcFile, memberName, buf);
	// WJsB
	int result = Unlha(NULL,buf,NULL,0);
	if (result){
		return 1;
	}

	// e|ɐVOŃRs[B
	strcat(tempDir,memberName);

	// e|烊l[Rs[sB
	result = CopyFile(tempDir,targetFile,FALSE);
	if (result == 0){
		// WJւ̃Rs[s
		return 1;
	}

	// e|͂Ȃ̂ō폜B
	DeleteFile(tempDir);

	return 0;
}

/**
 * CɓWJR}h쐬B
 *
 * @param type A[JCu
 * @param arcFile A[JCut@C
 * @param buf R}hCobt@
 * @param favoriteBase CɓfBNĝfBNg
 * @param favoriteDir CɓfBNg
 */
void extractFavoriteCommand(
	enum backup_type type,
	char const*arcFile,
	char *buf,
	char *favoriteBase,
	char *favoriteDir)
{
	switch (type) {
		case LZH:
			strcpy(buf,"x -jf0 -d1 \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,favoriteBase);
			strcat(buf,"\\\" \"");
			strcat(buf,favoriteDir);
			strcat(buf,"\"");
			break;
		case ZIP:
			strcpy(buf,"x -aoa \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,favoriteBase);
			strcat(buf,"\\\" \"");
			strcat(buf,favoriteDir);
			strcat(buf,"\"");
			break;
		case SEVEN_ZIP:
			strcpy(buf,"x -aoa \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,favoriteBase);
			strcat(buf,"\\\" \"");
			strcat(buf,favoriteDir);
			strcat(buf,"\"");
			break;
	}
}

/**
 * Edge/IÊCɓ̏ԂXgA
 *
 * @param type A[JCu̎
 * @param arcFile A[JCut@C̃pX
 * @param isEdge true:ΏۂEdge false:ΏۂIE
 */
void restoreOrder(
	enum backup_type type,
	const char *arcFile,
	bool isEdge
	)
{
	char buf[2048];
	char tmpPath[_MAX_PATH];
	BOOL runResult;
	DWORD procResult;
	const char *regPath;
	const char *orderEntry;

	if (isEdge) {
		regPath = EDGE_FULL_ORDER_REG;
		orderEntry = EDGE_ORDERENTRY;
	} else {
		regPath = IE_FULL_ORDER_REG;
		orderEntry = IE_ORDERENTRY;
	}

	// ꎞt@C̃pX쐬B
	createTemporaryPath(type, tmpPath, _MAX_PATH);

	// я̃WXgA[JCuoB
	int extractResult = renameExtract(type, arcFile, tmpPath, orderEntry);
	if (extractResult) {
		// Ȃꍇ͉Ȃ
		return;
	}

	// regR}hłCɓ̏Ԃ𕜋AB
	sprintf(buf, "REGEDIT /S /I \"%s\" ", tmpPath);
	procResult = executeProcess(buf, runResult);

	DeleteFile(tmpPath);

}


/**
 * CɓobNAbv
 *
 * @param type A[JCu̎
 * @param arcFile A[JCũpX
 * @param ieFavorite CɓtH_̃pX
 * @param isEdge true:EdgêCɓ false:IÊCɓ
 * @return 0: 0:s
 */
int restoreFavorites(
	enum backup_type type,
	const char *arcFile,
	const char *ieFavorite,
	bool isEdge
)
{
	char favoriteBase[_MAX_PATH], favoriteDir[_MAX_PATH];
	char tmpPath[_MAX_PATH];
	char buf[512];
	int result;

	// ꎞt@C̃pX쐬B
	createTemporaryPath(type, tmpPath, _MAX_PATH);

	// ܂AA[JCuꎞt@CɓWJB
	if (isEdge) {
		result = renameExtract(type, arcFile, tmpPath, EDGE_ARCHIVEENTRY);
	} else {
		result = renameExtract(type, arcFile, tmpPath, IE_ARCHIVEENTRY);
	}
	if (result) {
		// WJɎs炻ŔB
		return 1;
	}

	// ɁAꎞt@C炨CɓtH_ɓWJB
	// Cɓ肪PȂt@CƃtH_̏WȂ̂ŃA[JCuKvɂȂ
	// KvɂȂBʓ|B

	// CɓfBNgtpX番B
	strcpy(favoriteBase, ieFavorite);
	strcpy(favoriteDir, "*");

	// UNLHA32.DLLpR}h쐬
	buf[511] = '\0';
	extractFavoriteCommand(type, tmpPath, buf, favoriteBase, favoriteDir);
	// WJs
	result = Unlha(NULL, buf, NULL, 0);

	// ꎞt@C폜B
	DeleteFile(tmpPath);

	// ԂAB
	restoreOrder(type, arcFile, isEdge);

	return result;
}

/**
 * ubN}[NECɓw肵A[JCut@CWJB
 *
 * @param type A[JCu̎
 * @param arcFile i[̃A[JCut@C(tpX)
 * @param ieFavorite WJIÊCɓtH_(\Ȃ)
 * @param edgeFavorite WJEdgêCɓtH_(\Ȃ)
 * @param bookmarkFiles WJ̃ubN}[Nt@Cւ̔z
 * @return 0:obNAbvɐ 1:s
 */
int restoreBookmark(
	enum backup_type type,
	const char *arcFile,
	const char *ieFavorite,
	const char *edgeFavorite,
	const char *bookmarkFiles[]
)
{

	int result;
	int i;

	hInstDLL = loadArchiverDll(type);
	if (hInstDLL == NULL){
#ifdef SELFTEST
		fprintf(stderr,"UNLHA32.DLL not found!!\n");
#else
		if (type == LZH) {
			MessageBox(NULL,"UNLHA32.DLL܂B","G[",MB_OK | MB_ICONWARNING);
		} else {
#ifdef _WIN64
			MessageBox(NULL, MES_NOSEVENZIP64, "G[", MB_OK | MB_ICONWARNING);
#else
			MessageBox(NULL, MES_NOSEVENZIP32,"G[",MB_OK | MB_ICONWARNING);
#endif
		}
#endif
		return 1;
	}
	Unlha = getFunction(type);

	// IEȊÕubN}[N̓WJ
	for (i = 0;i < (ALL_BOOKMARKS - 1);i++) {
		if (bookmarkFiles[i] != NULL) {
			result = renameExtract(type,arcFile,bookmarkFiles[i],backupEntrys[i]);
			if (result){
				FreeLibrary(hInstDLL);
				return BOOKMARK_MOZILLA_1 + 2 + i;
			}
		}
	}

	// IÊCɓ̓WJ
	if (ieFavorite != NULL) {
		result = restoreFavorites(type, arcFile, ieFavorite, false);
		if (result) {
			FreeLibrary(hInstDLL);
			return 2;
		}
	}

#if 0
	// EdgêCɓ̓WJ
	if (edgeFavorite != NULL) {
		result = restoreFavorites(type, arcFile, edgeFavorite, true);
		if (result) {
			FreeLibrary(hInstDLL);
			return BOOKMARK_EDGE + 2;
		}
	}
#endif

	FreeLibrary(hInstDLL);

	return 0;
}

// ------------------------------------------------
// ȉAubN}[NECɓ̃obNAbv
// ------------------------------------------------

/**
 * t@CkR}h쐬B
 *
 * @param type A[JCu
 * @param arcFile A[JCut@C
 * @param buf R}hCobt@
 */
void packFileCommand(enum backup_type &type, char const*arcFile, char *buf)
{
	switch (type) {
		case LZH:
			strcpy(buf,"a -h2 \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,tempDir);
			strcat(buf,"\"");
			break;
		case ZIP:
			strcpy(buf,"a -tzip \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,tempDir);
			strcat(buf,"\"");
			break;
		case SEVEN_ZIP:
			strcpy(buf,"a -t7z \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,tempDir);
			strcat(buf,"\" -ms=off");
			break;
	}
}
/**
 * l[ăA[JCuɊi[B
 *
 * @param arcFile i[̃A[JCut@C
 * @param targetFile i[t@C
 * @param memberName i[̃A[JCut@C̃t@C
 * @return 0: 1:s
 */
int renamePack(
	enum backup_type type,
	const char *arcFile,
	const char *targetFile,
	const char *memberName
)
{
	int tempLength = GetTempPath(_MAX_PATH,tempDir);
	if (tempLength == 0){
		// e|fBNg擾łȂ
		return 1;
	}

	if (memberName == NULL) {
		// i[̃A[JCut@C̃t@CȂꍇG[ƂB
		return 1;
	}

	// e|ɐVOŃRs[B
	strcat(tempDir,memberName);

	int result = CopyFile(targetFile,tempDir,FALSE);
	if (result == 0){
		// e|ւ̃Rs[s
		return 1;
	}

	// UNLHA32.DLLpR}h쐬
	char buf[512];

	buf[511] = '\0';
	packFileCommand(type, arcFile, buf);
	// ksB
	result = Unlha(NULL,buf,NULL,0);

	// e|͂Ȃ̂ō폜B
	DeleteFile(tempDir);

	if (result){
		return 1;
	}else{
		return 0;
	}
}

/**
 * CɓkR}h쐬B
 *
 * @param type A[JCu
 * @param arcFile A[JCut@C
 * @param buf R}hCobt@
 * @param favoriteBase CɓfBNĝfBNg
 * @param favoriteDir CɓfBNg
 */
void packFavoritesCommand(
	enum backup_type &type,
	char const*arcFile,
	char *buf,
	char *favoriteBase,
	char *favoriteDir)
{
	switch (type) {
		case LZH:
			strcpy(buf,"a -jf0 -d1 -h2 \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,favoriteBase);
			strcat(buf,"\\\" \"");
			strcat(buf,favoriteDir);
			strcat(buf,"\"");
			break;
		case ZIP:
			strcpy(buf,"a -tzip \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,favoriteBase);
			strcat(buf,"\\\" \"");
			strcat(buf,favoriteDir);
			strcat(buf,"\"");
			break;
		case SEVEN_ZIP:
			strcpy(buf,"a -t7z -ms=off \"");
			strcat(buf,arcFile);
			strcat(buf,"\" \"");
			strcat(buf,favoriteBase);
			strcat(buf,"\\\" \"");
			strcat(buf,favoriteDir);
			strcat(buf,"\"");
			break;
	}
}

/**
 * Edge/IÊCɓ̏Ԃۑ
 *
 * @param type A[JCu̎
 * @param arcFile A[JCut@C̃pX
 * @param isEdge true:ΏۂEdge false:ΏۂIE
 */
void backupOrder(
	enum backup_type type,
	const char *arcFile,
	bool isEdge
)
{
	char buf[2048];
	char tmpPath[_MAX_PATH];
	BOOL runResult;
	DWORD procResult;
	const char *regPath;
	const char *orderEntry;

	if (isEdge) {
		regPath = EDGE_FULL_ORDER_REG;
		orderEntry = EDGE_ORDERENTRY;
	} else {
		regPath = IE_FULL_ORDER_REG;
		orderEntry = IE_ORDERENTRY;
	}

	// ꎞt@C̃pX쐬B
	createTemporaryPath(type, tmpPath, _MAX_PATH);

	// regR}hłCɓ̏ԂۑB
	sprintf(buf, "REGEDIT /S /E \"%s\" \"%s\" ", tmpPath, regPath);
	procResult = executeProcess(buf, runResult);
	// vZXNɎs珈𔲂B
	if (!runResult) {
		return;
	}

	// regR}hG[ɂȂ珈𔲂B
	if (procResult) {
		return;
	}

	// я̃WXgۑłA[JCuɊi[B
	renamePack(type, arcFile, tmpPath, orderEntry);
	DeleteFile(tmpPath);

}

/**
 * CɓobNAbv
 *
 * @param type A[JCu̎
 * @param arcFile A[JCũpX
 * @param ieFavorite CɓtH_̃pX
 * @param isEdge true:EdgêCɓ false:IÊCɓ
 * @return 0: 0:s
 */
int backupFavorites(
	enum backup_type type,
	const char *arcFile,
	const char *ieFavorite,
	bool isEdge
)
{
	char buf[512];
	char favoriteBase[_MAX_PATH], favoriteDir[_MAX_PATH];
	char tmpPath[_MAX_PATH];
	int result;

	// k̐ݒ
	strcpy(favoriteBase, ieFavorite);
	strcpy(favoriteDir, "*");

	// ꎞt@C̃pX쐬B
	createTemporaryPath(type, tmpPath, _MAX_PATH);

	// UNLHA32.DLLpR}h쐬
	buf[511] = '\0';
	packFavoritesCommand(type, tmpPath, buf, favoriteBase, favoriteDir);

	// MessageBox(NULL,buf,"Test",MB_OK);
	// ks
	result = Unlha(NULL, buf, NULL, 0);

	if (result) {
		DeleteFile(tmpPath);
		return 2;
	}

	if (isEdge) {
		result = renamePack(type, arcFile, tmpPath, EDGE_ARCHIVEENTRY);
	} else {
		result = renamePack(type, arcFile, tmpPath, IE_ARCHIVEENTRY);
	}
	DeleteFile(tmpPath);

	if (isEdge) {
		backupOrder(type, arcFile, true);
	} else {
		backupOrder(type, arcFile, false);
	}

	return result;
}

/**
 * ubN}[NECɓw肵A[JCut@CɊi[B
 *
 * @param arcFile i[̃A[JCut@C(tpX)
 * @param ieFavorite i[IÊCɓtH_(\Ȃ)
 * @param edgeFavorite i[EdgêCɓtH_(\Ȃ)
 * @param bookmarkFiles ubN}[Nt@Cւ̔z
 * @return 0:obNAbvɐ 1:s
 */
int backupBookmark(
	enum backup_type type,
	const char *arcFile,
	const char *ieFavorite,
	const char *edgeFavorite,
	const char *bookmarkFiles[]
)
{
	int result;
	int i;

	hInstDLL = loadArchiverDll(type);
	if (hInstDLL == NULL){
#ifdef SELFTEST
		fprintf(stderr,"UNLHA32.DLL not found!!\n");
#else
		if (type == LZH) {
			MessageBox(NULL,"UNLHA32.DLL܂B","G[",MB_OK | MB_ICONWARNING);
		} else {
#ifdef _WIN64
			MessageBox(NULL, MES_NOSEVENZIP64, "G[", MB_OK | MB_ICONWARNING);
#else
			MessageBox(NULL, MES_NOSEVENZIP32, "G[", MB_OK | MB_ICONWARNING);
#endif
		}
#endif
		return 1;
	}
	Unlha = getFunction(type);

	// ǉł͂Ȃ̂ŁAi[̃A[JCut@C폜ĂB
	DeleteFile(arcFile);

	// obNAbṽA[JCuǂݍ݂̊֌WIEȊOŏɎĂB
	for (i = 0;i < (ALL_BOOKMARKS - 1);i++) {
		if (bookmarkFiles[i] != NULL) {
			result = renamePack(type,arcFile,bookmarkFiles[i],backupEntrys[i]);
			if (result){
				FreeLibrary(hInstDLL);
				return 3 + i;
			}
		}
	}

	if (ieFavorite != NULL){
		result = backupFavorites(type, arcFile, ieFavorite, false);
		if (result) {
			FreeLibrary(hInstDLL);
			return 2;
		}
	}

#if 0
	if (edgeFavorite != NULL) {
		result = backupFavorites(type, arcFile, edgeFavorite, true);
		if (result) {
			FreeLibrary(hInstDLL);
			return BOOKMARK_EDGE + 2;
		}
	}
#endif

	FreeLibrary(hInstDLL);
	
	return 0;
}

#ifdef SELFTEST
int main(int argc,char *argv[])
{
	setlocale(LC_ALL,"japanese");
	_setmbcp(_MB_CP_LOCALE);

	int result;
/*
	backup(
		"test.lzh",
		"C:\\Documents and Settings\\Tatsu\\Application Data\\Mozilla\\Firefox\\Profiles\\34b5ta3h.default\\bookmarks.html",
		NULL,
		"C:\\Documents and Settings\\Tatsu\\Application Data\\Opera\\Opera\\profile\\Opera6.adr",
		"C:\\Documents and Settings\\Tatsu\\Favorites"
	);
*/
	result = restore(
		"test.lzh",
		"h:\\test\\bookmarks.html",
		NULL,
		"h:\\test\\Opera6.adr",
		"h:\\test\\Favorites"
	);

	if (result){
		fprintf(stderr,"XgAɎs܂B\n");
	}

}
#endif
