#ifndef TWRWND_H
#define TWRWND_H

#include <windows.h>

#include "tstring.h"

/**
 * Tatsu's windows api WRapper<br>
 * Window base class
 */
class TwrWnd {
protected:
	HWND hWnd;
	tstring title;
	int left;
	int top;
	int width;
	int height;
	int actualLeft;
	int actualTop;
	int actualWidth;
	int actualHeight;
	static int designDpi;
	static int actualDpi;
public:
	TwrWnd();
	TwrWnd(HWND newWnd);
	virtual ~TwrWnd();

	BOOL UpdateWindow();
	BOOL ShowWindow(int nCmdShow);
	void EnableWindow(BOOL enabled);
	HWND getHwnd() {
		return hWnd;
	}
	void destroyWindow(void) {
		DestroyWindow(hWnd);
	}
	void setText(const TCHAR *text);
	virtual void setPoint(int x, int y);
	virtual void setSize(int w, int h);
	virtual void applyScale(void);
	void setFont(HFONT font);
};

#endif