#include "TwrCommon.h"
#include "TwrCore.h"
#include "TwrListbox.h"

/**
 * RXgN^
 */
TwrListbox::TwrListbox() : TwrControl()
{
}

/**
 * RXgN^
 *
 * @param IuWFNgɌѕtEChẼnh
 */
TwrListbox::TwrListbox(HWND newHwnd) : TwrControl()
{
	hWnd = newHwnd;
}


/**
 * Xg{bNX쐬܂B
 */
HWND TwrListbox::create(void)
{
	hWnd = CreateWindowEx(
		WS_EX_CLIENTEDGE,
		_T("LISTBOX"),
		NULL,
		WS_CHILD|WS_VISIBLE|LBS_NOINTEGRALHEIGHT|WS_TABSTOP,
		left,	// X
		top,	// Y
		width,	// Width
		height,	// Height
		GetDesktopWindow(),	// Parent
		NULL,
		hInst,
		NULL);

	return hWnd;
}

/**
 * Xg{bNXɗvfǉ܂B
 *
 * @param item ǉ镶
 */
void TwrListbox::addItem(const TCHAR *item)
{
	SendMessage(hWnd, LB_ADDSTRING, 0, (LPARAM)item);
}

/**
 * Iꂽvf̈ʒu擾܂B
 *
 * @return -1:IĂȂ -1ȊO:Iꂽꏊ
 */
int TwrListbox::getSelectedIndex(void)
{
	LRESULT result = SendMessage(hWnd, LB_GETCURSEL, 0, 0);
	if (result == LB_ERR) {
		return -1;
	} else {
		return (int)result;
	}
}

/**
 * Xg{bNXɗvf}܂B
 *
 * @param index }ʒu
 * @param item ǉ镶
 */
void TwrListbox::insertItem(int index, const TCHAR *item)
{
	SendMessage(hWnd, LB_INSERTSTRING , (WPARAM)index, (LPARAM)item);
}

/**
 * Xg{bNX̗vf폜܂B
 *
 * @param index 폜vf̈ʒu
 */
void TwrListbox::removeItem(int index)
{
	SendMessage(hWnd, LB_DELETESTRING , (WPARAM)index, (LPARAM)0);
}

/**
 * Xg{bNX̗vfI܂B
 *
 * @param index Ivf̈ʒu
 */
void TwrListbox::selectItem(int index)
{
	SendMessage(hWnd, LB_SETCURSEL , (WPARAM)index, (LPARAM)0);
}

