#include "TwrCommon.h"
#include "TwrControl.h"

/**
 * RXgN^
 */
TwrControl::TwrControl() : TwrWnd()
{
	actualLeft = 0;
	actualTop = 0;
}

/**
 * RXgN^
 *
 * @param newHwnd IuWFNgɌѕtEChEnh
 */
TwrControl::TwrControl(HWND newWnd) : TwrWnd(newWnd)
{
	hWnd = newWnd;

	actualLeft = 0;
	actualTop = 0;
}

/**
 * fXgN^<br>
 * <br>
 * Windows̃EChEj܂B
 */
TwrControl::~TwrControl()
{
	if (hWnd != NULL) {
		::DestroyWindow(hWnd);
	}
}


/**
 * EChËʒuύX܂B
 *
 * @param x xW(96dpi̐eEChE̍W)
 * @param y yW(96dpi̐eEChE̍W)
 */
void TwrControl::setPoint(int x, int y)
{
	left = x;
	top = y;
	actualLeft = MulDiv(x, actualDpi, designDpi);
	actualTop = MulDiv(y, actualDpi, designDpi);

	if (hWnd != NULL) {
		MoveWindow(
			hWnd,
			actualLeft,
			actualTop,
			actualWidth,
			actualHeight,true);
	}
}

/**
 * EChẼTCYύX܂B
 *
 * @param w (96dpȋ傫)
 * @param h (96dpȋ傫)
 */
void TwrControl::setSize(int w, int h)
{
	width = w;
	height = h;
	actualWidth = MulDiv(w, actualDpi, designDpi);
	actualHeight = MulDiv(h, actualDpi, designDpi);

	if (hWnd != NULL) {
		MoveWindow(
			hWnd,
			actualLeft,
			actualTop,
			actualWidth,
			actualHeight,true);
	}
}

/**
 * DPIɉĎۂ̃Rg[̑傫ύX܂B
 */
void TwrControl::applyScale(void)
{
	// Rg[̓EChȄɕ\̂ŁAʒuE傫ƂɃXP[OB
	actualLeft = MulDiv(left, actualDpi, designDpi);
	actualTop = MulDiv(top, actualDpi, designDpi);
	actualWidth = MulDiv(width, actualDpi, designDpi);
	actualHeight = MulDiv(height, actualDpi, designDpi);

	if (hWnd != NULL) {
		MoveWindow(
			hWnd,
			actualLeft,
			actualTop,
			actualWidth,
			actualHeight,true);
	}
}