#ifndef NCFileDialog_H
#define NCFileDialog_H

#include	"Shobjidl.h"

typedef UINT_PTR (CALLBACK *pOFNHookProc)(
	HWND hdlg,
	UINT uiMsg,
	WPARAM wParam,
	LPARAM lParam
);

class NCFileDialog {
private:
	TCHAR gotFileName[_MAX_PATH];
	BOOL m_OpenFileDialog;
	const char *m_defExt;
	const TCHAR *filter;

	IFileDialog *pfd;
	COMDLG_FILTERSPEC *types;
	int typesCount;

	TCHAR **filtersXP;
	int typesCountXP;

	void parseFilter();
	int ShowFileDialogVista();
protected:
public:
	OPENFILENAME m_ofn;

	NCFileDialog(
		BOOL bOpenFileDialog,
		const char *lpszDefExt = NULL,
		const TCHAR *lpszFileName = NULL,
		DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		const TCHAR *lpszFilter = NULL,
		HWND pParentWnd = NULL,
		DWORD dwSize = 0
	);

	virtual ~NCFileDialog();

	int DoModal();

	TCHAR *GetPathName() { return gotFileName;};
	OPENFILENAME &GetOFN() {
		return m_ofn;
	}
};

#endif
