//#include	<windows.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<tchar.h>
#include	<windows.h>
#include	<Shlwapi.h>
#include	"NTFunction.h"
#include	"encutil.h"
#include	"encutil2.h"
#include	"NCFileDialog.h"

//
// Windows VistaX^C̑IύX
//

class SaveFileDialogCallback : public IFileDialogEvents, public IFileDialogControlEvents {
public:
	SaveFileDialogCallback(IFileDialog * pFileDialog) {mFileDialog = pFileDialog;}
	IFileDialog * mFileDialog;
	COMDLG_FILTERSPEC *types;

	// COM̃C^tF[XB
	// IUnknown
	IFACEMETHODIMP QueryInterface(REFIID riid, void** ppv) {
		static const QITAB qit[] = {
			QITABENT(SaveFileDialogCallback, IFileDialogEvents),
			QITABENT(SaveFileDialogCallback, IFileDialogControlEvents),
			{ 0 },
		};
		return QISearch(this, qit, riid, ppv);
	}
	// This class makes special assumptions about how it is used, specifically
	// 1) This class will only reside on the stack.
	// 2) Components that consume this object have well-defined reference lifetimes.
	// In this case, this is only consumed by the file dialog advise and unadvise.
	// Unadvising will release the file dialog's only reference to this object.
	//
	// Do not do this for heap allocated objects.
	IFACEMETHODIMP_(ULONG) AddRef() { return 1; }
	IFACEMETHODIMP_(ULONG) Release() { return 0; }
	// IFileDialogEvents
	IFACEMETHODIMP OnFileOk(IFileDialog * /* pfd */) { return E_NOTIMPL; }
	IFACEMETHODIMP OnFolderChanging(IFileDialog * /* pfd */, IShellItem * /* psi */) { return E_NOTIMPL; }
	IFACEMETHODIMP OnFolderChange(IFileDialog * /* pfd */) { return E_NOTIMPL; }
	IFACEMETHODIMP OnSelectionChange(IFileDialog * /* pfd */) { return E_NOTIMPL; }
	IFACEMETHODIMP OnShareViolation(IFileDialog * /* pfd */, IShellItem * /* psi */, FDE_SHAREVIOLATION_RESPONSE * /* pResponse */) { return E_NOTIMPL; }
	IFACEMETHODIMP OnTypeChange(IFileDialog * /* pfd */);
	IFACEMETHODIMP OnOverwrite(IFileDialog * /* pfd */, IShellItem * /* psi */ , FDE_OVERWRITE_RESPONSE * /* pResponse */) { return E_NOTIMPL;}
	// IFileDialogControlEvents
	IFACEMETHODIMP OnItemSelected(IFileDialogCustomize * /* pfdc */, DWORD /* dwIDCtl */, DWORD /* dwIDItem */) { return E_NOTIMPL; }
	IFACEMETHODIMP OnButtonClicked(IFileDialogCustomize * pFileDialogCustomize, DWORD pIDControl) { return E_NOTIMPL; };
	IFACEMETHODIMP OnCheckButtonToggled(IFileDialogCustomize * /* pfdc */, DWORD /* dwIDCtl */, BOOL /* bChecked */) { return E_NOTIMPL; }
	IFACEMETHODIMP OnControlActivating(IFileDialogCustomize * /* pfdc */, DWORD /* dwIDCtl */) { return E_NOTIMPL; }
};

/**
 * t@CI_CAOŃt@C̎ނȈ
 *
 * @param pfd t@C_CAOIuWFNgւ̃|C^
 * @return S_OK ɏI S_OKȊO:G[B
 */
IFACEMETHODIMP SaveFileDialogCallback::OnTypeChange(IFileDialog *pfd)
{
	UINT fileTypeIndex;
	HRESULT result;
	wchar_t buf[MAX_PATH];
	wchar_t *filename;

	result = pfd->GetFileTypeIndex(&fileTypeIndex);
	if (FAILED(result)) {
		return result;
	}
	pfd->GetFileName((WCHAR **)&filename);
	if (FAILED(result)) {
		return result;
	}

	wcscpy(buf, filename);
	wchar_t *extPos;

	extPos = wcsrchr(buf, L'.');
	if (extPos == NULL) {
		return S_OK;
	}
	wcscpy(extPos, types[fileTypeIndex - 1].pszSpec + 1);
	return pfd->SetFileName(buf);
}

//
// Windows XPX^C̑IύX
// 
static TCHAR **dialogFiltersXP;

/**
 * Windows XP܂ł̃_CAÕtbNv[VW
 *
 * @param hdlg Ώۂ̃_CAO{bNX̎qEChEnh
 * @param uiMsg bZ[W
 * @param wParam p[^1
 * @param lParam p[^2
 * @return 0:bZ[Wɑ΂鏈sȂ 1:bZ[Wɑ΂鏈s
 */
UINT_PTR CALLBACK ncFileDialogProc(
	HWND hdlg,
	UINT uiMsg,
	WPARAM wParam,
	LPARAM lParam
) {
	OFNOTIFY *notify = (LPOFNOTIFY)lParam;
	int code;
	int index;
	TCHAR buf[MAX_PATH];
	TCHAR *filename;

	switch(uiMsg) {
		case WM_NOTIFY:
			code = notify->hdr.code;
			if (code == CDN_TYPECHANGE) {
				index = notify->lpOFN->nFilterIndex;
				filename = notify->lpOFN->lpstrFile;

				_tcscpy(buf, filename);
				TCHAR *extPos;

				extPos = _tcsrchr(buf, _T('.'));
				if (extPos == NULL) {
					return S_OK;
				}
				_tcscpy(extPos, dialogFiltersXP[index - 1] + 1);
				SendDlgItemMessage(::GetParent(hdlg),cmb13,WM_SETTEXT,0,(LPARAM)buf);
				SendDlgItemMessage(::GetParent(hdlg),edt1,WM_SETTEXT,0,(LPARAM)buf);
				return 1;
			}
			break;
	}
	// ł͏ȂB
	return 0;
}

/**
 * RXgN^
 *
 * @param bOpenFileDialog \z_CAO{bNX̎<br>
 * TRUE:[t@CJ] _CAO{bNX FALSE:[t@Cĕۑ]_CAO{bNX
 * @param lpszDefExt ̊gq
 * @param lpszFileName \t@C
 * @param dwFlags _CAO{bNX̐ݒptO
 * @param lpszFilter tB^
 * @param pParentWnd eEChẼnh
 * @param dwSize OPENFILENAME\̂̃TCY
 */
NCFileDialog::NCFileDialog(
	BOOL bOpenFileDialog,
	const char *lpszDefExt,
	const TCHAR *lpszFileName,
	DWORD dwFlags,
	const TCHAR *lpszFilter,
	HWND pParentWnd,
	DWORD dwSize
)
{
	// RXgN^m_OpenFileDialogɏݒ肷B
	// 
	m_OpenFileDialog = bOpenFileDialog;

	// \̂̃TCY
	memset(&m_ofn,0x00,sizeof(OPENFILENAME));
	if (dwSize > 0) {
		m_ofn.lStructSize = dwSize;
	}else{
		m_ofn.lStructSize = sizeof(OPENFILENAME);
	}
	// ̊gq(gp)
	m_defExt = lpszDefExt;
	// eEChE
	m_ofn.hwndOwner = pParentWnd;
	// tB^
	m_ofn.lpstrFilter = lpszFilter;
	m_ofn.nFilterIndex = 1;
	// tO
	m_ofn.Flags = dwFlags | OFN_ENABLESIZING | OFN_ENABLEHOOK | OFN_EXPLORER;
	// t@C
	memset(gotFileName,0x00,sizeof(TCHAR) * _MAX_PATH);
	if (lpszFileName != NULL) {
		_tcscpy(gotFileName,lpszFileName);
	}
	m_ofn.lpstrFile = gotFileName;
	m_ofn.nMaxFile = _MAX_PATH;
	// m_ofn.lpstrTitle = "ݒt@C̎w";
	m_ofn.lpfnHook = ncFileDialogProc;

	filter = lpszFilter;

	pfd = NULL;
	types = NULL;
	typesCount = 0;
}

/**
 * fXgN^
 */
NCFileDialog::~NCFileDialog()
{
	if (types != NULL) {
		if (typesCount > 0) {
			for (int i = 0; i < typesCount; i++){
				free((void *)types[i].pszName);
				free((void *)types[i].pszSpec);
			}
		}
		free(types);
	}
	if (filtersXP != NULL) {
		if (typesCount > 0) {
			for (int i = 0; i < typesCount; i++){
				free((void *)filtersXP[i]);
			}
		}
		free(filtersXP);
	}
}

/**
 * _CAO\܂B
 *
 * @return IDOK:OK{^ IDCANCEL:LZ{^
 */
int NCFileDialog::DoModal()
{
	int result;

	parseFilter();
	dialogFiltersXP = filtersXP;

	if (gWindowsMajorVersion > 5) {
		int lResult = ShowFileDialogVista();
		return lResult;
	} else {
		// Windows 2000/XP
		if (m_OpenFileDialog == FALSE){
			result = ::GetSaveFileName(&m_ofn);
		}else{
			result = ::GetOpenFileName(&m_ofn);
		}
	}

	if (result){
		return IDOK;
	}else{
		return IDCANCEL;
	}
}

/**
 * Windows Vistaȍ~pt@CI_CAO\
 */
int NCFileDialog::ShowFileDialogVista()
{
	HRESULT hr;
	if (m_OpenFileDialog == FALSE){
		hr = CoCreateInstance(CLSID_FileSaveDialog,
			NULL,
			CLSCTX_INPROC_SERVER,
			IID_PPV_ARGS(&pfd));
	}else{
		hr = CoCreateInstance(CLSID_FileOpenDialog,
			NULL,
			CLSCTX_INPROC_SERVER,
			IID_PPV_ARGS(&pfd));
	}
	if(!SUCCEEDED(hr)) {
		return IDCANCEL;
	}

	if (types != NULL) {
		pfd->SetFileTypes(typesCount, types);
	}
#ifndef UNICODE
	wchar_t *p = mbtowcInternal(m_ofn.lpstrFile);
	pfd->SetFileName(p);
#else
	pfd->SetFileName(m_ofn.lpstrFile);
#endif

	IFileDialogEvents *pfde = NULL;
	SaveFileDialogCallback fileDialogCallback(pfd);
	fileDialogCallback.types = types;

	// Hook up the event handler.
	DWORD dwCookie;
	if (!m_OpenFileDialog) {
		hr = pfd->Advise(&fileDialogCallback, &dwCookie);
	}
	hr = pfd->Show(NULL);

	if(SUCCEEDED(hr)) {
		IShellItem *psiResult;
		hr = pfd->GetResult(&psiResult);
		if (SUCCEEDED(hr))
		{
			// We are just going to print out the
			// name of the file for sample sake.
			PWSTR pszFilePath = NULL;
			hr = psiResult->GetDisplayName(SIGDN_FILESYSPATH,
				&pszFilePath);
			if (SUCCEEDED(hr)) {
#ifndef UNICODE
				memset(gotFileName, 0, _MAX_PATH * sizeof(char));
				wcstombsByteFileName(gotFileName, pszFilePath, _MAX_PATH);
#else
				memset(gotFileName, 0, _MAX_PATH * sizeof(wchar_t));
				wcscpy(gotFileName, pszFilePath);
#endif

				CoTaskMemFree(pszFilePath);
			}
		}
		pfd->Release();
		return IDOK;
	} else {
		pfd->Release();
		return IDCANCEL;
	}
}
/**
 * t@CDtB^w߂B
 * (Agq͈̎蔲dl)
 */
void NCFileDialog::parseFilter()
{
	TCHAR *p;
	const TCHAR *description;
	int len;
	int descLen;
	typesCount = 0;

	TCHAR *extension2;

	types = (COMDLG_FILTERSPEC *)calloc(10, sizeof(COMDLG_FILTERSPEC *));
	if (types == NULL) {
		return;
	}
	filtersXP = (TCHAR **)calloc(10, sizeof(TCHAR *));
	if (filtersXP == NULL) {
		return;
	}

	p = const_cast<TCHAR *>(filter);

	while(*p) {
		description = p;

		while(*p) {
			p++;
		}
		p++;

		//
		descLen = _tcslen(description);
		wchar_t *descWc = (wchar_t *)calloc(descLen + 1, sizeof(wchar_t));
		if (descWc == NULL) {
			return;
		}

		//
		len = _tcslen(p);
		wchar_t *extension;
		extension = (wchar_t *)calloc(len + 1, sizeof(wchar_t));
		if (extension == NULL) {
			free(descWc);
			return;
		}

		extension2 = (TCHAR *)calloc(len + 1, sizeof(TCHAR));
		if (extension2 == NULL) {
			free(descWc);
			free(extension);
		}

		_tcscpy(extension2, p);

#ifndef UNICODE
		mbstowcsByte(descWc, description, descLen);
		mbstowcsByte(extension, p, len);
#else
		_tcscpy(descWc, description);
		_tcscpy(extensioon, p);
#endif

		types[typesCount].pszName = descWc;
		types[typesCount].pszSpec = extension;
		filtersXP[typesCount] = extension2;

		typesCount++;
		if (typesCount == 10) {
			return;
		}

		while(*p) {
			p++;
		}
		p++;
	}
}
