#ifndef BASEFORM_H
#define BASEFORM_H

#include <vector>

#include "TwrWnd.h"
#include "TwrControl.h"
#include "BaseDialog.h"

/**
 * T windows api WRapper<br>
 * Window base class
 */
class BaseForm : public TwrWnd {
private:
	const TCHAR *windowClass;
	const TCHAR *title;
	bool firstShow;
protected:
	HFONT  font;
	UINT message;
	WPARAM wParam;
	LPARAM lParam;
	HINSTANCE hInstance;
	DWORD style;
	std::vector<TwrControl *> *childControls;
	bool hasMenu;
	int clientWidth;
	int clientHeight;

public:
	BaseForm();
	virtual ~BaseForm();
	void setClass(TCHAR *windowClassName) {
		windowClass = windowClassName;
	}
	void setTitle(TCHAR *newTitle) {
		title = newTitle;
	}
	HWND add(TwrWnd *obj);
	HWND add(BaseDialog *obj);
	HWND add(TwrControl *obj);

	void setStyle(DWORD newStyle);
	virtual void UpdateData(bool toObj);

	virtual HWND create(HINSTANCE hInstance);
	virtual LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	virtual LRESULT OnCommand(int wmId, int wmEvent);
	virtual LRESULT OnCreate();
	virtual LRESULT OnNotify(LPNMHDR nmhdr);
	virtual LRESULT OnDestroy();
	virtual LRESULT OnDpiChanged(void);
	virtual void applyScale(void);
	void setClientSize(int w, int h);

};

// MFCDDXǂ}N
#define FDX_Text(toObj, ctl, str, bufLen) \
	if (toObj) { \
		SendMessage(ctl->getHwnd(),WM_GETTEXT,bufLen,str); \
	} else { \
		SendMessage(ctl->getHwnd(),WM_SETTEXT,(WPARAM)0,str); \
	}

#define FDX_Check(toObj, ctl, stat) \
	if (toObj) { \
		stat = (SendMessage(ctl->getHwnd(),BM_GETCHECK,0,0) ? true : false); \
	} else { \
		SendMessage(ctl->getHwnd(),BM_SETCHECK,(WPARAM)(stat ? 1 : 0),0); \
	}

#define FDX_CBIndex(toObj, ctl, index) \
	if (toObj) { \
		index = SendMessage(ctl->getHwnd(),CB_GETCURSEL,0,0); \
	} else { \
		SendMessage(ctl->getHwnd(),CB_SETCURSEL,(WPARAM)index,0); \
	}


#endif // BASEFORM_H
