#include "TwrCommon.h"
#include "TwrCore.h"
#include "BaseForm.h"

/**
 * EChẼx[XNX
 */

/**
 * RXgN^
 */
BaseForm::BaseForm()
{
	windowClass = _T("");
	title = _T("");
	style = WS_OVERLAPPEDWINDOW;
	left = CW_USEDEFAULT;
	top = CW_USEDEFAULT;
	width = CW_USEDEFAULT;
	height = 0;
	font = NULL;
	hasMenu = true;
	clientHeight = 0;
	clientWidth = 0;
	firstShow = false;

	childControls = new std::vector<TwrControl *>();
}

/**
 * fXgN^
 */
BaseForm::~BaseForm()
{
	if (childControls != NULL) {
		delete childControls;
	}
}

/**
 * EChE쐬܂B
 *
 * @param CX^Xnh
 * @return EChEnh
 */
HWND BaseForm::create(HINSTANCE hInstance)
{
	this->hInstance = hInstance;
	hWnd = CreateWindow(
		windowClass,
		title,
		style,
		left,
		top,
		width,
		height,
		NULL,
		NULL,
		hInstance,
		NULL);

	return hWnd;
}

/**
 * EChEv[VW
 *
 * @param hDlg EChEnh
 * @param message bZ[W
 * @param wParam WPARAM
 * @param lParam LPARAM
 * @return 
 */
LRESULT CALLBACK BaseForm::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	LPNMHDR nmhdr;
	LRESULT result;
	PAINTSTRUCT p;
	UINT dpiY = 96;

	this->hWnd = hWnd;
	this->message = message;
	this->wParam = wParam;
	this->lParam = lParam;

	switch (message)
	{
		case WM_CREATE:
			/* GetDeviceCapsœꂽDPItHgTCYvZB */
			hdc = BeginPaint(hWnd,&p);
			dpiY = GetDeviceCaps(hdc, LOGPIXELSY);
			EndPaint(hWnd, &p);
			actualDpi = dpiY;

			return OnCreate();
		case WM_COMMAND:
			wmId    = LOWORD(wParam);
			wmEvent = HIWORD(wParam);

			return OnCommand(wmId, wmEvent);
		case WM_NOTIFY:
			nmhdr = (LPNMHDR)lParam;

			return OnNotify(nmhdr);
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			// TODO: `R[hɒǉĂ...
			EndPaint(hWnd, &ps);
			break;
		case WM_DESTROY:
			return OnDestroy();
		case WM_SYSCOLORCHANGE:	// VXeFύXɂȂB
			// NCAg̈(j[o[^Cgo[)XV邽߁AgB
			RedrawWindow(hWnd,NULL,NULL,RDW_ERASE | RDW_INVALIDATE | RDW_FRAME);
			return 0;
		case 0x02e0:	// WM_DPICHANGED
			DefWindowProc(hWnd, message, wParam, lParam);
			// EChEƂ݂̌DPI擾B
			dpiY = getActualDpi(hWnd);
			actualDpi = dpiY;
			// DPIύX̏
			result = OnDpiChanged();
			// NCAg̈(j[o[^Cgo[)XV邽߁AgB
			RedrawWindow(hWnd,NULL,NULL,RDW_ERASE | RDW_INVALIDATE | RDW_FRAME);
			return 0;
		case WM_SHOWWINDOW:
			if (!firstShow) {
				if (lParam != SW_PARENTCLOSING) {
					firstShow = true;
					return 0;
				} else {
					return DefWindowProc(hWnd, message, wParam, lParam);
				}
			} else {
				return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
	}

	return 0;
}

/**
 * EChEX^Cݒ肵܂B
 *
 * @param newStyle EChEX^C
 */
void BaseForm::setStyle(DWORD newStyle)
{
	style = newStyle;
	if (hWnd != NULL) {
		SetWindowLongPtr(hWnd, GWL_STYLE, newStyle);
	}
}

/**
 * EChEƃEChEIuWFNg̃f[^̓Ƃ܂B
 *
 * @param toObj true:_CAO̓eIuWFNgɊi[B
 *              false:IuWFNg̓e_CAOɊi[B
 */
void BaseForm::UpdateData(bool toObj)
{
}

/**
 * WM_COMMANDbZ[W̏s܂B
 *
 * @param wmId 
 * @param wmEvent
 * @return bZ[W
 */
LRESULT BaseForm::OnCommand(int wmId, int wmEvent)
{
	return DefWindowProc(hWnd, message, wParam, lParam);
}

/**
 * EChȄɏEChEIuWFNgǉ܂B
 *
 * @param EChEIuWFNg
 * @return eɂȂEChẼnh
 */
HWND BaseForm::add(TwrWnd *obj)
{
	return ::SetParent(obj->getHwnd(), hWnd);
}

/**
 * EChȄɏRg[ǉ܂B
 *
 * @param EChEIuWFNg
 * @return eɂȂEChẼnh
 */
HWND BaseForm::add(TwrControl *obj)
{
	childControls->push_back(obj);
	return ::SetParent(obj->getHwnd(), hWnd);
}

/**
 * EChȄɏ_CAOIuWFNgǉ܂B
 *
 * @param _CAOIuWFNg
 * @return eɂȂEChẼnh
 */
HWND BaseForm::add(BaseDialog *obj)
{
	obj->setParent(hWnd);
	return ::SetParent(obj->getHwnd(), hWnd);
}

/**
 * EChE쐬ꂽƂɌĂяo܂B
 *
 * @return 0
 */
LRESULT BaseForm::OnCreate()
{
	return 0;
}

/**
 * RRg[ŃCxgƂɌĂяo܂B
 *
 * @param nmhdr ʒmbZ[W
 * @return bZ[W
 */
LRESULT BaseForm::OnNotify(LPNMHDR nmhdr)
{
	return DefWindowProc(hWnd, message, wParam, lParam);
}

/**
 * EChEۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT BaseForm::OnDestroy()
{
	PostQuitMessage(0);

	return 0;
}

/**
 * DPIωۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT BaseForm::OnDpiChanged(void)
{
	// g̃TCY𒲐B
	applyScale();

	// qRg[̑傫𒲐B
	for (std::vector<TwrControl *>::iterator it = childControls->begin(); it != childControls->end(); it++) {
		TwrControl *control;

		control = *it;
		control->applyScale();
		if (font != NULL) {
			control->setFont(font);
		}
	}

	return 0;
}

/**
 * DPIɉĎۂ̃Rg[̑傫ύX܂B
 */
void BaseForm::applyScale(void)
{
	RECT r;
	RECT cr;

	GetWindowRect(hWnd, &r);
	left = r.left;
	top = r.top;

	GetClientRect(hWnd, &cr);

	if (clientWidth > 0) {
		// ̓̑傫w肪ꍇ(+EChEg)ɑ΂ăXP[OsB
		int nonClientWidth;
		int clientActualWidth;

		nonClientWidth = (r.right - r.left + 1) - (cr.right - cr.left + 1);

		clientActualWidth = MulDiv(clientWidth, actualDpi, designDpi);
		actualWidth = nonClientWidth + clientActualWidth;
	} else {
		// w肪Ȃꍇ́AȎ傫ɑ΂ăXP[OsB
		actualWidth = MulDiv(width, actualDpi, designDpi);
	}

	if (clientHeight > 0) {
		// c̓̑傫w肪ꍇ(+EChEg)ɑ΂ăXP[OsB
		int clientActualHeight;
		int nonClientHeight;

		// NCAg̈̓j[ƃEChEgvZB
		nonClientHeight = (r.bottom - r.top + 1) - (cr.bottom - cr.top + 1);

		// NCAg̈̓fUC̍DPIvZB
		clientActualHeight = MulDiv(clientHeight, actualDpi, designDpi);

		actualHeight = nonClientHeight + clientActualHeight;
	} else {
		// j[Ȃꍇ̓fUC̍vZB
		actualHeight = MulDiv(height, actualDpi, designDpi);
	}

	if (hWnd != NULL) {
		MoveWindow(
			hWnd,
			left,
			top,
			actualWidth,
			actualHeight, true);
	}
}
/**
 * EChẼTCYύX܂B
 *
 * @param w 
 * @param h 
 */
void BaseForm::setClientSize(int w, int h)
{
	clientWidth = w;
	clientHeight = h;

	if (hWnd != NULL) {
		applyScale();
	}
}

