#ifndef BASEDIALOG_H
#define BASEDIALOG_H

#include <vector>

#include "TwrWnd.h"
#include "TwrControl.h"
#include "TwrCombobox.h"

class BaseDialog : public TwrWnd {
private:
	HWND parentWindow;
	int dialogResource;
	bool isModeless;
	bool firstShown;
protected:
	static BaseDialog *modalCallback;
	std::vector<TwrControl *> *childControls;
	HFONT  font;
	int clientWidth;
	int clientHeight;

	virtual INT_PTR OnInitDialog();
	virtual void OnLoad(void);
	virtual INT_PTR OnCommand(WPARAM wParam);
	virtual LRESULT OnDpiChanged(void);
	TCHAR ddx_buf[512];
public:
	BaseDialog();
	BaseDialog(HWND parent, int resource);
	virtual ~BaseDialog();

	INT_PTR showModal();
	HWND showModeless();
	static INT_PTR CALLBACK modalDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	static INT_PTR CALLBACK modelessDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	INT_PTR CALLBACK dialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	void setParent(HWND parent)
	{
		parentWindow = parent;
	}

	/**
	 * eEChẼnh擾B
	 *
	 * @return eEChẼnh
	 */
	HWND getParent(void)
	{
		return parentWindow;
	}
	TwrControl *GetDlgItem(int item);
	HWND GetDlgItemRaw(int item);
	HWND add(TwrControl *obj);
	/**
	 * tHgݒ肷B
	 *
	 * @param newFont ݒ肷tHg
	 */
	void setFont(HFONT newFont) {
		font = newFont;
	}

	virtual void UpdateData(bool toObj);
	void applyScale(void);
	void scaleChildren(void);
	void setClientSize(int w, int h);

};

// MFCDDXǂForm Data eXchange}N
// UpdateData֐̈A_CAORg[IDAݒΏۂ̕ϐ

// Rg[̃eLXg
#define DDX_Text(toObj, ctl, str) \
	if (toObj) { \
		GetDlgItemText(hWnd,ctl,ddx_buf,512); \
		str = ddx_buf; \
	} else { \
		SetDlgItemText(hWnd,ctl,str.c_str()); \
	}

// `FbN{bNX̃`FbN
#define DDX_Check(toObj, ctl, stat) \
	if (toObj) { \
		stat = SendMessage(::GetDlgItem(hWnd,ctl),BM_GETCHECK,0,0); \
	} else { \
		SendMessage(::GetDlgItem(hWnd,ctl),BM_SETCHECK,(WPARAM)stat,0); \
	}

// R{{bNX̃CfbNX
#define DDX_CBIndex(toObj, ctl, index) \
	if (toObj) { \
		index = SendMessage(::GetDlgItem(hWnd,ctl),CB_GETCURSEL,0,0); \
	} else { \
		SendMessage(::GetDlgItem(hWnd,ctl),CB_SETCURSEL,(WPARAM)index,0); \
	}


#endif
