#include "TwrCommon.h"

#include "TwrCore.h"
#include "BaseDialog.h"
#include "ModelessDialog.h"

BaseDialog *BaseDialog::modalCallback;
static BaseDialog *modelessCallback[MODELESS_DIALOGS];
static int modelessCallbacks = 0;

/**
 * [hX_CAÕR[obNB
 *
 */
void initModelessCallback(void)
{
	for (int i = 0; i < MODELESS_DIALOGS; i++) {
		modelessCallback[i] = NULL;
	}
}

/**
 * RXgN^
 */
BaseDialog::BaseDialog() : TwrWnd()
{
	parentWindow = NULL;
	// dialogResource = resource;
	isModeless = false;
	firstShown = false;

	childControls = new std::vector<TwrControl *>();
	font = NULL;
	clientWidth = 0;
	clientHeight = 0;
}


/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
BaseDialog::BaseDialog(HWND parent, int resource) : TwrWnd()
{
	parentWindow = parent;
	dialogResource = resource;
	isModeless = false;
	firstShown = false;

	childControls = new std::vector<TwrControl *>();
	font = NULL;
	clientWidth = 0;
	clientHeight = 0;
}

/**
 * fXgN^
 */
BaseDialog::~BaseDialog()
{
	if (isModeless) {
		delModelessDialog(hWnd);

		for (int i = 0; i < MODELESS_DIALOGS; i++) {
			if (modelessCallback[i] == this) {
				modelessCallback[i] = NULL;
				modelessCallbacks--;
				break;
			}
		}
		if (hWnd != NULL) {
			if (IsWindow(hWnd)) {
				DestroyWindow(hWnd);
			}
		}
	}

	if (childControls != NULL) {
		delete childControls;
	}
}

/**
 * [__CAO\B
 *
 * @return _CAO̖߂l
 */
INT_PTR BaseDialog::showModal()
{
	modalCallback = this;
	return ::DialogBox(
		hInst,
		MAKEINTRESOURCE(dialogResource),
		parentWindow,
		&BaseDialog::modalDialogProc);
}

/**
 * [hX_CAO\B
 *
 * @return _CAO̖߂l
 */
HWND BaseDialog::showModeless()
{
	isModeless = true;

	hWnd = CreateDialog(
		hInst,
		MAKEINTRESOURCE(dialogResource),
		parentWindow,
		&BaseDialog::modelessDialogProc);

	if (hWnd != NULL) {
		bool found = false;
		int empty = -1;
		for (int i = 0; i < MODELESS_DIALOGS; i++) {
			if (modelessCallback[i] == this) {
				found = true;
				break;
			}
			if ((modelessCallback[i] == NULL) && (empty == -1)){
				empty = i;
			}
		}
		if (!found) {
			if (empty > -1) {
				modelessCallback[empty] = this;
				modelessCallbacks++;
			}
		}

		addModelessDialog(hWnd);
	}
	this->OnInitDialog();

	return hWnd;
}

/**
 * [__CAÕ_CAOv[VW
 *
 * @param hDlg _CAÕEChEnh
 * @param message bZ[W
 * @param wParam WPARAM
 * @param lParam LPARAM
 * @return 
 */
INT_PTR CALLBACK BaseDialog::modalDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	return modalCallback->dialogProc(hDlg, message, wParam, lParam);
}

/**
 * [hX_CAÕ_CAOv[VW
 *
 * @param hDlg _CAÕEChEnh
 * @param message bZ[W
 * @param wParam WPARAM
 * @param lParam LPARAM
 * @return 
 */
INT_PTR CALLBACK BaseDialog::modelessDialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	for (int i = 0;i < MODELESS_DIALOGS; i++) {
		if (modelessCallback[i] == NULL) {
			continue;
		}
		if (hDlg == modelessCallback[i]->getHwnd()) {
			return modelessCallback[i]->dialogProc(hDlg, message, wParam, lParam);
		}
	}
	return 0;
}

/**
 * _CAÕ_CAOv[VW
 *
 * @param hDlg _CAÕEChEnh
 * @param message bZ[W
 * @param wParam WPARAM
 * @param lParam LPARAM
 * @return  TRUE:bZ[WB FALSE:bZ[WȂ
 */
INT_PTR CALLBACK BaseDialog::dialogProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	INT_PTR result;
	UINT dpiY = 96;

	hWnd = hDlg;
	switch (message)
	{
		case WM_INITDIALOG:
			// EChEƂ݂̌DPI擾B
			dpiY = getActualDpi(hWnd);
			actualDpi = dpiY;
			
			result = OnInitDialog();
			return result;

		case WM_SHOWWINDOW:
			if (!firstShown && wParam) {
				firstShown = true;

				// EChEƂ݂̌DPI擾B
				//dpiY = getActualDpi(hWnd);
				//actualDpi = dpiY;

				OnLoad();
			}
			return DefWindowProc(hDlg, message, wParam, lParam);

		case WM_COMMAND:
			result = OnCommand(wParam);
			if (result == 0) {
				return (INT_PTR)TRUE;
			} else {
				return (INT_PTR)FALSE;
			}
			break;

		case 0x02e0:	// WM_DPICHANGED
			// EChEƂ݂̌DPI擾B
			dpiY = getActualDpi(hWnd);
			actualDpi = dpiY;
			// DPIύX̏
			result = OnDpiChanged();
			// NCAg̈(j[o[^Cgo[)XV邽߁AgB
			RedrawWindow(hWnd, NULL, NULL, RDW_ERASE | RDW_INVALIDATE | RDW_FRAME);
			return result;
	}

	return (INT_PTR)FALSE;
}

/**
 * _CAOƃ_CAOIuWFNg̃f[^̓Ƃ܂B
 *
 * @param toObj true:_CAO̓eIuWFNgɊi[B
 *              false:IuWFNg̓e_CAOɊi[B
 */
void BaseDialog::UpdateData(bool toObj)
{
}


/**
 * _CAȌɌĂяo܂B
 *
 * @return 
 */
INT_PTR BaseDialog::OnInitDialog()
{
	if (title.length() > 0) {
		::SetWindowText(hWnd, title.c_str());
	}
	return (INT_PTR)FALSE;
}

/**
 * \ɌĂяo܂B
 */
void BaseDialog::OnLoad(void)
{

}

/**
 * _CAO삪sꂽɌĂяo܂B
 *
 * @return  0:s 0:sȂ
 */
INT_PTR BaseDialog::OnCommand(WPARAM wParam)
{
	if (!isModeless) {
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hWnd, LOWORD(wParam));
			return (INT_PTR)0;
		}
	}
	return (INT_PTR)TRUE;
}

/**
 * DPIωۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT BaseDialog::OnDpiChanged(void)
{
	// g̃TCY𒲐B
	applyScale();

	// qRg[̃TCY𒲐B
	scaleChildren();

	return 0;
}

/**
 * _CAO\[X̃EChE擾܂B
 *
 * @param item \[XID
 * @return _CAÕIuWFNg
 */
TwrControl *BaseDialog::GetDlgItem(int item)
{
	HWND itemHwnd = ::GetDlgItem(hWnd, item);
	if (itemHwnd == NULL) {
		return NULL;
	}

	TwrControl *newWnd;
	try {
		newWnd = new TwrControl(itemHwnd);
		if (newWnd == NULL) {
			return NULL;
		}
		
	}catch(...) {
		return NULL;
	}
	return newWnd;
}

/**
 * _CAO\[X̃EChEnh擾܂B
 *
 * @param \[XID
 * @return _CAÕEChẼnh
 */
HWND BaseDialog::GetDlgItemRaw(int item)
{
	return ::GetDlgItem(hWnd, item);
}

/**
 * EChȄɏRg[ǉ܂B
 *
 * @param EChEIuWFNg
 * @return eɂȂEChẼnh
 */
HWND BaseDialog::add(TwrControl *obj)
{
	childControls->push_back(obj);
	return hWnd;
}

/**
 * DPIɉĎۂ̃EChȆ傫ύX܂B
 */
void BaseDialog::applyScale(void)
{
	RECT r;
	RECT cr;

	GetWindowRect(hWnd, &r);
	left = r.left;
	top = r.top;

	GetClientRect(hWnd, &cr);

	if (clientWidth > 0) {
		// ̓̑傫w肪ꍇ(+EChEg)ɑ΂ăXP[OsB
		int nonClientWidth;
		int clientActualWidth;

		nonClientWidth = (r.right - r.left + 1) - (cr.right - cr.left + 1);

		clientActualWidth = MulDiv(clientWidth, actualDpi, designDpi);
		actualWidth = nonClientWidth + clientActualWidth;
	} else {
		// w肪Ȃꍇ́AȎ傫ɑ΂ăXP[OsB
		actualWidth = MulDiv(width, actualDpi, designDpi);
	}

	if (clientHeight > 0) {
		// c̓̑傫w肪ꍇ(+EChEg)ɑ΂ăXP[OsB
		int clientActualHeight;
		int nonClientHeight;

		// NCAg̈̓j[ƃEChEgvZB
		nonClientHeight = (r.bottom - r.top + 1) - (cr.bottom - cr.top + 1);

		// NCAg̈̓fUC̍DPIvZB
		clientActualHeight = MulDiv(clientHeight, actualDpi, designDpi);

		actualHeight = nonClientHeight + clientActualHeight;
	} else {
		// j[Ȃꍇ̓fUC̍vZB
		actualHeight = MulDiv(height, actualDpi, designDpi);
	}

	if (hWnd != NULL) {
		MoveWindow(
			hWnd,
			left,
			top,
			actualWidth,
			actualHeight, true);
	}
}

/**
 * qRg[̃XP[Os܂B
 */
void BaseDialog::scaleChildren(void)
{
	// qRg[̑傫𒲐B
	for (std::vector<TwrControl *>::iterator it = childControls->begin(); it != childControls->end(); it++) {
		TwrControl *control;

		control = *it;
		control->applyScale();
		if (font != NULL) {
			control->setFont(font);
		}
	}

}

/**
 * EChẼTCYύX܂B
 *
 * @param w 
 * @param h 
 */
void BaseDialog::setClientSize(int w, int h)
{
	clientWidth = w;
	clientHeight = h;

	if (hWnd != NULL) {
		applyScale();
	}
}

