// AppliBase.cpp : AvP[ṼGg |Cg`܂B
//

#include "TwrCommon.h"
#include <commctrl.h>

#include "TwrCore.h"
#include "AppliBase.h"
#include "ModelessDialog.h"
#include "BaseForm.h"

// AvP[VŗL̃wb_t@C
#include "../BookSyncApp.h"

#define MAX_LOADSTRING 100

// O[oϐ:
TCHAR szTitle[MAX_LOADSTRING];					// ^Cg o[̃eLXg
TCHAR szWindowClass[MAX_LOADSTRING];			// C EBhE NX
BaseForm *baseForm;

// AvP[VŗL̃O[oϐ
BookSyncApp *appObj;

extern void initModelessCallback(void);

// ̃R[h W[Ɋ܂܂֐̐錾]܂:
int runApplication(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPTSTR    lpCmdLine,
	int       nCmdShow);
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
bool handleDialogMessage(LPMSG lpMsg);

/**
 * AvP[VC[`
 *
 * @param hInstance AvP[ṼCX^Xnh
 * @param hPrevInstance gp
 * @param lpCmdLine R}hC
 * @param nCmdShow \
 * @return vOIR[h
 */
int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	::CoInitialize(NULL);

	INITCOMMONCONTROLSEX iccx;
	iccx.dwSize = sizeof(INITCOMMONCONTROLSEX);
	iccx.dwICC = ICC_TAB_CLASSES;
	if (!InitCommonControlsEx(&iccx)) {
         return FALSE;
	}

	initModelessDialog();
	initModelessCallback();

	// AvP[VNX̃CX^Xݒ肵܂B
	appObj = new BookSyncApp();
	baseForm = appObj->createBaseWindow();

	// EChE\ÕAvP[V̏sB
	appObj->OnAppliStart(lpCmdLine);

	int result = runApplication(hInstance, hPrevInstance, lpCmdLine, nCmdShow);

	// AvP[V̌nsB
	appObj->OnAppliEnd();

	delete baseForm;
	delete appObj;

	::CoUninitialize();

	return result;
}

/**
 * AvP[VJn
 *
 * @param hInstance AvP[ṼCX^Xnh
 * @param hPrevInstance gp
 * @param lpCmdLine R}hC
 * @param nCmdShow \
 * @return vOIR[h
 */
int runApplication(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPTSTR    lpCmdLine,
	int       nCmdShow)
{
	MSG msg;
	HACCEL hAccelTable;

	// O[oĂ܂B
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_BOOKSYNC, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// AvP[V̏s܂:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_BOOKSYNC));
	doEvents();

	// EChE\ɍssB
	appObj->OnWindowShow();

	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		if (handleDialogMessage(&msg)) {
			// bZ[W[hX_CAÔ̂ꍇ
			// ȂB
			continue;
		}
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}

//
//  ֐: MyRegisterClass()
//
//  ړI: EBhE NXo^܂B
//
//  Rg:
//
//    ̊֐юǵA'RegisterClassEx' ֐ǉꂽ
//    Windows 95 O Win32 VXeƌ݊ꍇɂ̂ݕKvłB
//    AvP[VA֘Atꂽ
//    `̏ACR擾ł悤ɂɂ́A
//    ̊֐ĂяoĂB
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.lpszClassName	= szWindowClass;

	// AvP[VŗL̏
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_BOOKSYNC));
	// wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hCursor		= NULL;
	// wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.hbrBackground = GetSysColorBrush(COLOR_3DFACE);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_BOOKSYNC);
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_BOOKSYNC));

	return RegisterClassEx(&wcex);
}

//
//   ֐: InitInstance(HINSTANCE, int)
//
//   ړI: CX^X nhۑāAC EBhE쐬܂B
//
//   Rg:
//
//        ̊֐ŁAO[oϐŃCX^X nhۑA
//        C vO EBhE쐬ѕ\܂B
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   initCore(hInstance);

   baseForm->setClass(szWindowClass);
   baseForm->setTitle(szTitle);
   hWnd = baseForm->create(hInstance);
   if (!hWnd)
   {
      return FALSE;
   }

   baseForm->ShowWindow(nCmdShow);
   baseForm->UpdateWindow();

   return TRUE;
}

//
//  ֐: WndProc(HWND, UINT, WPARAM, LPARAM)
//
//  ړI:  C EBhẼbZ[W܂B
//
//  WM_COMMAND	- AvP[V j[̏
//  WM_PAINT	- C EBhE̕`
//  WM_DESTROY	- ~bZ[W\Ė߂
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	LRESULT lResult = baseForm->WndProc(hWnd, message, wParam, lParam);

	return lResult;
}

/**
 * Windows̃CxgB
 *
 * @return Cxg
 */
int doEvents()
{
	MSG msg;
    // bZ[W̏
    while (::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
		BOOL bRet = GetMessage(&msg, NULL, 0, 0);
		if (bRet > 0){
			if (handleDialogMessage(&msg)) {
				// bZ[W[hX_CAÔ̂ꍇ
				// ȂB
				continue;
			} else {
				::TranslateMessage(&msg);
				::DispatchMessage (&msg);
			}
		} else {
			break;
		}
    }
	return 0;
}

