#include "stdafx.h"
#include "shellapi.h"

#include "GuiDefine.h"
#include "AboutDlg.h"
#include "util.h"

/**
 * RXgN^
 *
 * @param parent eEChEnh
 * @param resource _CAO\[Xԍ
 */
CAboutDlg::CAboutDlg(HWND parent, int resource) : BaseDialog(parent, resource)
{
	font = NULL;

	appIcon = NULL;
	versionLabel = NULL;
	verTypeLabel = NULL;
	copyrightLabel = NULL;
	okButton = NULL;
	supportButton = NULL;

}

/**
 * fXgN^
 */
CAboutDlg::~CAboutDlg()
{
	if (font != NULL) {
		DeleteObject(font);
	}

	if (appIcon != NULL) {
		delete appIcon;
	}
	if (versionLabel != NULL) {
		delete versionLabel;
	}
	if (verTypeLabel == NULL) {
		delete verTypeLabel;
	}
	if (copyrightLabel != NULL) {
		delete copyrightLabel;
	}
	if (okButton != NULL) {
		delete okButton;
	}
	if (supportButton != NULL) {
		delete supportButton;
	}

}

/**
 * _CAO
 *
 * @return tH[JX̐ݒ肪(FALSE:)
 */
INT_PTR CAboutDlg::OnInitDialog()
{
	appIcon = GetDlgItem(IDC_ICON_APP);
	versionLabel = GetDlgItem(IDC_VERSION_LABEL);
	verTypeLabel = GetDlgItem(IDC_VER_TYPE_LABEL);
	copyrightLabel = GetDlgItem(IDC_COPYRIGHT_LABEL);
	okButton = GetDlgItem(IDOK);
	supportButton = GetDlgItem(IDC_BTNSUPPORT);

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	// \ꂽEChËʒuIuWFNgɔfB
	RECT r;

	GetWindowRect(hWnd, &r);
	setPoint(r.left, r.top);

	setClientSize(412, 84);

	appIcon->setPoint(19, 26);
	appIcon->setSize(33, 33);
	add(appIcon);

	versionLabel->setPoint(70, 15);
	versionLabel->setSize(139, 13);
	add(versionLabel);

	verTypeLabel->setPoint(209, 15);
	verTypeLabel->setSize(50, 13);
	add(verTypeLabel);

	copyrightLabel->setPoint(70, 38);
	copyrightLabel->setSize(209, 13);
	add(copyrightLabel);

	supportButton->setPoint(315, 23);
	supportButton->setSize(89, 24);
	add(supportButton);

	okButton->setPoint(315, 53);
	okButton->setSize(89, 22);
	add(okButton);

	return FALSE;
}

/**
 * \ɌĂяo܂B
 */
void CAboutDlg::OnLoad(void)
{
#ifdef _WIN64
	verTypeLabel->setText(_T("(64bit)"));
#endif

	// NWM_DPICHANGEDbZ[WƂ͂܂Rg[
	// łĂȂ̂ŁA\DPI𔽉fB
	applyScale();
	scaleChildren();

	// _CAOe̒ɔzuB
	RECT parentRect;

	GetWindowRect(getParent(), &parentRect);

	adjustCenter(parentRect, getParent(), this->hWnd);

}

/**
 * WM_COMMANDbZ[WM̏
 *
 * @param wParam WPARAM̒l
 * @return 
 */
INT_PTR CAboutDlg::OnCommand(WPARAM wParam)
{
	switch (LOWORD(wParam)) {
		case IDC_BTNSUPPORT:
			OnBnClickedButton1();

			return (INT_PTR)TRUE;
	}
	return BaseDialog::OnCommand(wParam);

}

/**
 * DPIωۂɌĂяo܂B
 *
 * @return 0
 */
LRESULT CAboutDlg::OnDpiChanged(void)
{
	// \p̃tHg蒼B
	if (font != NULL) {
		DeleteObject(font);
	}

	int fontSize = 0 - MulDiv(9, actualDpi, 72);
	font = CreateFont(
		fontSize,
		0,
		0,
		0,
		FW_NORMAL,
		FALSE,
		FALSE,
		FALSE,
		SHIFTJIS_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY, // CLEARTYPE_QUALITY,
		FIXED_PITCH | FF_MODERN,
		FONT_FACE);

	return BaseDialog::OnDpiChanged();
}

#if 0
HWND targetHwnd;
/**
* 񋓂ꂽEChEnhɑ΂AtHgݒ肷B
*
* @param hwnd 񋓂ꂽEChEnh
* @param lparam Ăьnꂽp[^(tHgnh)
* @return TRUE 񋓂pB
*/
BOOL CALLBACK showBookmarkWinSize(HWND hwnd, LPARAM lparam)
{
	//HFONT font = (HFONT)lparam;

	//SendMessage(hwnd, WM_SETFONT, (WPARAM)font, TRUE);

	// Capture control position
	char buf[256];
	RECT r;
	GetWindowRect(hwnd, &r);
	POINT p;
	p.x = r.left;
	p.y = r.top;
	ScreenToClient(targetHwnd, &p);

	sprintf(buf, "->setPoint(%d, %d);\n->setSize(%d, %d);\nadd();\n",
		p.x, p.y, r.right - r.left + 1, r.bottom - r.top + 1);
	MessageBox(NULL, buf, "", MB_OK);
	// Capture control position end

	return TRUE;
}
#endif


/**
 * o[W_CAOSupport{^̏
 *
 */
void CAboutDlg::OnBnClickedButton1()
{
#if 0
	char buf[256];
	RECT r;

	GetClientRect(getHwnd(), &r);

	sprintf(buf, "setClientSize(%d, %d);\n",
		r.right - r.left + 1, r.bottom - r.top + 1);
	MessageBox(NULL, buf, "", MB_OK);

	targetHwnd = getHwnd();
	EnumChildWindows(getHwnd(), ::showBookmarkWinSize, (LPARAM)font);
#endif

	::ShellExecute(hWnd,NULL,MYWEB_URL,NULL,NULL,SW_SHOW);
}
