#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<ctype.h>
#include	<io.h>
#include	<time.h>
#include	<locale.h>
#include	<direct.h>
#include	<windows.h>
#include	<winbase.h>
#include	<winnetwk.h>
#include	<shlobj.h>
#include	<mbctype.h>
#include	<string>
#include	<set>

// BookSync Library
#include	"NTfunction.h"
#include	"BScommon.h"
#include	"bslib.h"
#include	"IbookmarkTree.h"
#include	"BookmarkTree.h"
#include	"TreeWriter.h"
#include	"encutil2.h"
#include	"..\common\clearKey.h"
#include	"Logger.h"

// Platform Library

#include	"ViMetaData.h"

#include	"MozillaReader.h"
#include	"OperaReader.h"
#include	"IeReader.h"
#include	"IeFavoriteReader.h"
#include	"ieCleaner.h"
#include	"ieUtil.h"
#include	"IeOrder.h"
#ifdef WITH_EDGE
#include	"EdgeReader.h"
#endif	// WITH_EDGE
#include	"FxReader.h"
#include	"SafariReader.h"
#include	"bplistReader.h"
#include	"ChromeReader.h"
#include	"XbelReader.h"
#ifdef WITH_OP15
#include	"Op15Reader.h"
#endif	// WITH_OP15
#include	"Op25Reader.h"
#include	"ViReader.h"
#include	"Edge2Reader.h"

#include	"MozillaWriter.h"
#include	"OperaWriter.h"
#include	"IeWriter.h"
#include	"FxWriter.h"
#include	"SafariWriter.h"
#include	"ChromeWriter.h"
#include	"XbelWriter.h"
#ifdef WITH_OP15
#include	"Op15Writer.h"
#endif	// WITH_OP15
#include	"Op25Writer.h"
#include	"ViWriter.h"
#include	"Edge2Writer.h"
#include	"AttributeWriter.h"

// Header
#define CORE_CPP
#include	"core.h"
#include	"CoreUtil.h"

BookmarkTree *bookmarkTree = NULL;
TreeWriter *writer = NULL;
static Configuration *s_config;
// IÊCɓo[
char ieLinkFolder[MAX_PATH];
#ifdef WITH_EDGE
// EdgêCɓo[
char edgeLinkFolder[MAX_PATH];
#endif	// WITH_EDGE
char workPath[MAX_PATH];	// pX쐬p
std::string tempPath[ALL_BOOKMARKS];	// oꎞpX
Logger *logger = NULL;
static bool ieName = true;
static int s_convertResult;	// Ro[g
static bool volatile s_cancel = false;
static int volatile s_progressNo = 0;	// iԍ
static int volatile s_progressCount = 0;	// H
static bool s_noNameFlag = false;	// iԍ
static bool hasToolbarFolder = false;	// j[zɂȂc[o[tH_݂邩?
static bool hasNonMenuItem = false;	// Unsorted bookmark(Firefox 3)݂邩?
static bool onlyMenuFlag = true;	// ǂݍ񂾂̂j[̏ꍇtrue
static bool volatile s_cancelable = true;
static bool volatile messageChanged = false;
static bool volatile progressChanged = false;
static bool hasMobileBookmark = false;
// ܂łɏoGUIDi[setBOpera 29ȍ~̃Xs[h_Cp
std::set<std::string> *guidSet;
// ܂łɏoGUIDi[setBFirefox 48ȍ~̃CuubN}[Np
std::set<std::string> *fxGuidSet;

FxWriter *fxWriters[2];	// Firefox݃IuWFNg(gUNVp)
#ifdef WITH_OP15
Op15Writer *op15Writers[2];	// Opera 15݃IuWFNg(gUNVp)
#endif	// WITH_OP15
ViMetaData* vivaldiMetaData;


/**
 * ubN}[Nj[tH_̃_~[ǉB<br>
 * łɃubN}[Nj[݂ꍇ́A̒
 * ubN}[Ni[ΏۂɂB<br>
 * IEAEdgeAMozillaAOperap
 *
 * @param no ubN}[Nj[tH_̖O 0FIEȊO̖O 1:IE̖O
 */
int addBookmarkMenu(int type)
{
	Bookmark *dummy = NULL;
	try {
		dummy = new Bookmark();
		if (dummy == NULL){
			logger->debug("Bookmark menu memory allocate error");
			return 1;
		}
		char *p;
		switch (type) {
			case 0:
				p = wctoUTF8Internal(L"ubN}[Nj[");
				dummy->setName(p);
				dummy->setIeName("ubN}[Nj[");
				dummy->setIeNameW(L"ubN}[Nj[");
				break;
			case 1:
				p = wctoUTF8Internal(L"Cɓ");
				dummy->setName(p);
				dummy->setIeName("Cɓ");
				dummy->setIeNameW(L"Cɓ");
				break;
		}

		dummy->setItemType(Bookmark::folder);
		dummy->setFolderType(Bookmark::menuBar);
		writer->storeItem(dummy);
	} catch (...) {
		logger->debug("Bookmark menu memory allocate error");
		if (dummy != NULL){
			delete dummy;
		}
		return 1;
	}
	if (dummy != NULL){
		delete dummy;
	}
	return 0;
}

/**
 * No[̃_~[ǉB<br>
 * łɃubN}[Nj[݂ꍇ́A̒
 * ubN}[Ni[ΏۂɂB<br>
 * IEAMozillaAOperap
 *
 * @return 0:i[ 1:i[s
 */
int addLinkBar(void)
{
	Bookmark *dummy = NULL;
	try {
		dummy = new Bookmark();
		if (dummy == NULL){
			logger->debug("Link bar memory allocate error");
			return 1;
		}
		dummy->setItemType(Bookmark::folder);
		dummy->setFolderType(Bookmark::normalFolder);
		if (g_lang == 1) {
			dummy->setName(mbtoUTF8Internal(gIeLinkDisplay));
			dummy->setIeName(gIeLinkDisplay);
			dummy->setIeNameW(gIeLinkDisplayW);
		} else {
			dummy->setName(UTF8tombFileNameInternal(IE7_LINK_NAME));
			dummy->setIeName(IE7_LINK_NAME);
			dummy->setIeNameW(IE7_LINK_NAME_W);
		}
		writer->storeItem(dummy);
	} catch (...) {
		logger->debug("Link bar memory allocate error");
		if (dummy != NULL){
			delete dummy;
		}
		return 1;
	}
	if (dummy != NULL){
		delete dummy;
	}
	return 0;
}

/**
 * ubN}[Nj[tH_̃_~[ǉB<br>
 * łɃubN}[Nj[݂ꍇ́A̒
 * ubN}[Ni[ΏۂɂB<br>
 * IEAMozillaAOperap
 *
 */
int addMobileFavorites(void)
{
	Bookmark *dummy = NULL;
	try {
		dummy = new Bookmark();
		if (dummy == NULL){
			logger->debug("Mobile favorites memory allocate error");
			return 1;
		}
		dummy->setIeNameW(MOBILE_FAVORITES_JP_W);
		char *utfName = wctoUTF8Internal(MOBILE_FAVORITES_JP_W);
		dummy->setName(utfName);
		char *mbName = wctombInternal(MOBILE_FAVORITES_JP_W);
		dummy->setIeName(mbName);

		dummy->setItemType(Bookmark::folder);
		dummy->setFolderType(Bookmark::normalFolder);
		writer->storeItem(dummy);
	} catch (...) {
		logger->debug("Mobile favorites memory allocate error");
		if (dummy != NULL){
			delete dummy;
		}
		return 1;
	}
	if (dummy != NULL){
		delete dummy;
	}
	return 0;
}

/**
 * MozillañubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readMozillaBookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	MozillaReader *mozReader = NULL;

	try {
		mozReader = new MozillaReader();

		// MozillaReadeȑo͐
		mozReader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_MOZILLA);
	writer->setBrowserNo(no);
	mozReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	mozReader->setLogger(logger);

	if (s_config->getMozIgnoreIe(no)){	// IÊCɓ̖
		mozReader->setIEfavoritesImport(1);
	}else{
		mozReader->setIEfavoritesImport(0);
	}
	bookmarkTree->setBrowser(BOOKMARK_MOZILLA_1 + no);

	// j[o[ɂׂẴubN}[N݂̂
	// _~[ĊKw炷B
	if (addBookmarkMenu(0)) {
		return 1;
	}

	result = mozReader->readBookmark(s_config->getMozPath(no).c_str(),"");

	if (mozReader != NULL){
		delete mozReader;
	}

	return result;
}

/**
 * OperãubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readOperaBookmark(int no)
{
	int result = 0;
	g_verbose = 1;
	OperaReader *opeReader = NULL;
	
	try {
		opeReader = new OperaReader();

		// OperaReadeȑo͐
		opeReader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_OPERA);	// Opera
	writer->setBrowserNo(no);
	opeReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	opeReader->setLogger(logger);

	OperaBookmark::setBrowserVersion(no,0);	// l0(Opera 6)
	// ݔ̈
	if (s_config->getOperaIgnoreTrush(no)){
		opeReader->setTrashMode(false);
	}else{
		opeReader->setTrashMode(true);
	}
	// Windows MobilełǂH
	if (s_config->getOperaWinMobile(no)){
		opeReader->setMobile(true);
	}else{
		opeReader->setMobile(false);
	}
	bookmarkTree->setBrowser(BOOKMARK_OPERA_1 + no);

	// j[o[ɂׂẴubN}[N݂̂
	// _~[ĊKw炷B
	if (addBookmarkMenu(0)) {
		return 1;
	}

	// oĈCɓƓۂ̓oĈCɓtH_ɈړĂ
	if (s_config->getOperaSyncMobile(no)) {
		addMobileFavorites();
	}

	result = opeReader->readBookmark(s_config->getOperaPath(no).c_str(),"");

	if (opeReader != NULL){
		delete opeReader;
	}

	return result;
}

/**
 * IÊCɓǂݍ
 *
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readIeBookmark()
{
	int result = 0;
	wchar_t buf[MAX_PATH];
	char buf2[MAX_PATH];
	
	g_verbose = 1;
	IeFavoriteReader *favReader = NULL;
	
	try {
		favReader = new IeFavoriteReader(false);

		// IeReadeȑo͐
		favReader->setBookmarkWriter(writer);
		favReader->setLogger(logger);

		// IeReader̃ANV
		IeItemHandler = favReader;
		// IÊCɓtH_t@CVXe
		// NtH_쐬B(NtH_̂)
		getIEfavoriteFolder(buf2);
		strcat(buf2,"\\");
		strcat(buf2,ieLinkFolder);
		favReader->setLinkFolder(buf2);

		// Cɓo[𖳎邩ǂ̐ݒ
		g_noIElink = s_config->getIeIgnoreLinkFolder();

	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_IE);	// IE
	writer->setBrowserNo(0);	// ӖȂ1Ԗ
	bookmarkTree->setBrowser(BOOKMARK_IE);

	// j[o[ɂׂẴubN}[N݂̂
	// _~[ĊKw炷B
	if (addBookmarkMenu(1)) {
		return 1;
	}

	mbstowcsByte(buf,s_config->getIePath().c_str(),MAX_PATH);
	result = search_dir(
		s_config->getIePath().c_str(),
		buf);

	if (favReader != NULL){
		delete favReader;
	}

	if (result > -1){
		return 0;
	}else{
		return 1;
	}
}

#ifdef WITH_EDGE
/**
 * EdgêCɓǂݍ<br>
 *
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readEdgeBookmark()
{
	int result = 0;
	wchar_t buf[MAX_PATH];
	char buf2[MAX_PATH];

	g_verbose = 1;
	IeFavoriteReader *favReader = NULL;

	try {
		favReader = new IeFavoriteReader(true);

		// CɓEdgêCɓ
		favReader->setIsEdge(true);

		// IeReadeȑo͐
		favReader->setBookmarkWriter(writer);
		favReader->setLogger(logger);

		// IeReader̃ANV
		IeItemHandler = favReader;
		// EdgêCɓtH_t@CVXe
		// NtH_쐬B(NtH_̂)
		strcpy(buf2, s_config->getEdgePath().c_str());
		strcat(buf2, "\\");
		strcat(buf2, edgeLinkFolder);
		favReader->setLinkFolder(buf2);

		// Cɓo[𖳎邩ǂ̐ݒ
		g_noIElink = s_config->getEdgeIgnoreLinkFolder();
	}
	catch (...) {
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_EDGE);	// Edge
	writer->setBrowserNo(0);	// ӖȂ1Ԗ
	bookmarkTree->setBrowser(BOOKMARK_EDGE);

	// j[o[ɂׂẴubN}[N݂̂
	// _~[ĊKw炷B
	if (addBookmarkMenu(1)) {
		return 1;
	}

	mbstowcsByte(buf, s_config->getEdgePath().c_str(), MAX_PATH);
	result = search_dir(
		s_config->getEdgePath().c_str(),
		buf);

	if (favReader != NULL) {
		delete favReader;
	}

	if (result > -1) {
		return 0;
	}
	else {
		return 1;
	}
}

/**
 * EdgêCɓǂݍ<br>
 * 邱IEƈꏏǔÔIEƕʂɂĂB
 *
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readEdgeBookmark2()
{
	int result = 0;
	wchar_t buf[MAX_PATH];
	char buf2[MAX_PATH];

	g_verbose = 1;
	EdgeReader *favReader = NULL;

	try {
		favReader = new EdgeReader();

		// CɓEdgêCɓ
		//favReader->setIsEdge(true);

		// IeReadeȑo͐
		favReader->setBookmarkWriter(writer);
		favReader->setLogger(logger);

		// EdgêCɓtH_t@CVXe
		// NtH_쐬B(NtH_̂)
		strcpy(buf2, s_config->getEdgePath().c_str());
		strcat(buf2, "\\");
		strcat(buf2, edgeLinkFolder);
		//favReader->setLinkFolder(buf2);

		// Cɓo[𖳎邩ǂ̐ݒ
		favReader->setIgnoreLink(s_config->getEdgeIgnoreLinkFolder());
	}
	catch (...) {
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_EDGE);	// Edge
	writer->setBrowserNo(0);	// ӖȂ1Ԗ
	bookmarkTree->setBrowser(BOOKMARK_EDGE);

	// j[o[ɂׂẴubN}[N݂̂
	// _~[ĊKw炷B
	if (addBookmarkMenu(1)) {
		return 1;
	}

	mbstowcsByte(buf, s_config->getEdgePath().c_str(), MAX_PATH);
	result = favReader->search_dir(s_config->getEdgePath().c_str());

	if (favReader != NULL) {
		delete favReader;
	}

	if (result > -1) {
		return 0;
	} else {
		return 1;
	}
}
#endif	// WITH_EDGE

/**
 * Firefox 3̃ubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readFxBookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	FxReader *fxReader = NULL;

	try {
		fxReader = new FxReader();

		// FxReadeȑo͐
		fxReader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_FIREFOX);	// Firefox
	writer->setBrowserNo(no);

	fxReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	fxReader->setLogger(logger);
	fxReader->setIgnoreToolbar(s_config->getFxIgnoreToolbar(no));	// ubN}[Nc[o[𖳎邩ǂ
	fxReader->setGuidSet(fxGuidSet);

	bookmarkTree->setBrowser(BOOKMARK_FIREFOX_1 + no);

	result = fxReader->readBookmark(s_config->getFxPath(no).c_str());

	if (fxReader != NULL){
		delete fxReader;
	}

	return result;
}

/**
 * Safari 4̃oCi`vpeBXgXML`ɕϊB
 *
 * @param fileName oCi`vpeBXg̃t@C
 * @return 0:ϊ 1:ϊs
 */
int bpListToXpList(const char *fileName)
{
	// e|t@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet){
		return 1;
	}

	int result = 0;
	FILE *fpo = fopen(workPath,"w");
	if (fpo == NULL){
		return 1;
	}
	bplistReader *reader = NULL;
	try {
		reader = new bplistReader(fpo);
		if (reader == NULL) {
			logger->debug("BPLIST memory allocate error");
			result = 1;
		} else {
			result = reader->readBplist(fileName);
			if (result) {
				logger->debug("BPLIST read failed");
			}
		}
	} catch(...) {
		logger->debug("BPLIST memory allocate error");
		result = 1;
	}
	if (reader != NULL) {
		delete reader;
	}
	fclose(fpo);
	return result;
}

/**
 * SafarĩubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readSfBookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	SafariReader *sfReader = NULL;

	try {
		sfReader = new SafariReader();

		// SafariReadeȑo͐
		sfReader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}
	int type = sfReader->isBplist(s_config->getSfPath(no).c_str());
	if (type == -1) {
		delete sfReader;
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_SAFARI);	// Safari
	writer->setBrowserNo(no);

	sfReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	sfReader->setLogger(logger);
	sfReader->setIgnoreToolbar(s_config->getSfIgnoreToolbar(no));	// ubN}[No[𖳎邩ǂ

	bookmarkTree->setBrowser(BOOKMARK_SAFARI_1 + no);

	switch (type) {
		case -1:
			delete sfReader;
			return 1;
		case 0:
			// t@CXML`vpeBXgȂ̂ŉȂB
			result = sfReader->readBookmark((char *)(s_config->getSfPath(no).c_str()),"");
			break;
		case 1:
			// t@C̓oCi`vpeBXgȂ̂XML`ɕϊB
			result = bpListToXpList((char *)(s_config->getSfPath(no).c_str()));
			if (result) {
				delete sfReader;
				return 1;
			}
			char *fileName;
			fileName = workPath;
			result = sfReader->readBookmark(fileName,"");
			// ꎞIɍ쐬t@CB
			DeleteFile(fileName);
			break;
	}

	if (sfReader != NULL){
		delete sfReader;
	}

	return result;
}

/**
 * ChromẽubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readChBookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	ChromeReader *chReader = NULL;

	try {
		chReader = new ChromeReader();

		// ChromeReadeȑo͐
		chReader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_CHROME);	// Chrome
	writer->setBrowserNo(no);

	chReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	chReader->setLogger(logger);
	chReader->setIgnoreToolbar(s_config->getChIgnoreToolbar(no));	// ubN}[No[𖳎邩ǂ

	bookmarkTree->setBrowser(BOOKMARK_CHROME_1 + no);

	result = chReader->readBookmark(s_config->getChPath(no).c_str(),"");

	if (chReader != NULL){
		delete chReader;
	}

	return result;
}

/**
 * XBELt@Cǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readXbBookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	XbelReader *xbReader = NULL;

	try {
		xbReader = new XbelReader();

		// XbelReadeȑo͐
		xbReader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_XBEL);	// XBEL
	writer->setBrowserNo(no);

	xbReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	xbReader->setLogger(logger);

	// tH_CAEg
	xbReader->setLayout(s_config->getXbLayout(no));
	xbReader->setIgnoreToolbar(false);	// ubN}[No[𖳎邩ǂ

	bookmarkTree->setBrowser(BOOKMARK_XBEL_1 + no);

	switch(s_config->getXbLayout(no)) {
		case XBEL_LAYOUT_MENU:
			// j[o[ɂׂẴubN}[N݂̂
			// _~[ĊKw炷B
			if (addBookmarkMenu(0)) {
				return 1;
			}
			break;
		case XBEL_LAYOUT_MOBILE_FAVORITES:
			// j[o[ɂׂẴubN}[N݂̂
			// _~[ĊKw炷B
			if (addBookmarkMenu(0)) {
				return 1;
			}

			// oĈCɓƓۂ̓oĈCɓtH_ɈړĂ
			addMobileFavorites();
			break;
		default:
			onlyMenuFlag = false;	// j[ȊÔ݂̂B
			xbReader->setIgnoreToolbar(s_config->getXbIgnoreToolbar(no));	// ubN}[No[𖳎邩ǂ
			break;

	}

	result = xbReader->readBookmark(s_config->getXbPath(no).c_str(),"");

	if (xbReader != NULL){
		delete xbReader;
	}

	return result;
}

#ifdef WITH_OP15
/**
 * Opera 15̃ubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readOp15Bookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	Op15Reader *op15Reader = NULL;

	try {
		op15Reader = new Op15Reader();

		// Op15Readeȑo͐
		op15Reader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_OPERA15);	// Opera 15
	writer->setBrowserNo(no);

	op15Reader->setBookmarkNo(no);	// ubN}[N̔ԍ
	op15Reader->setLogger(logger);

	bookmarkTree->setBrowser(BOOKMARK_OPERA15_1 + no);

	// j[o[ɂׂẴubN}[N݂̂
	// _~[ĊKw炷B
	if (addBookmarkMenu(0)) {
		return 1;
	}

	result = op15Reader->readBookmark(s_config->getOp15Path(no).c_str());

	if (op15Reader != NULL){
		delete op15Reader;
	}

	return result;
}
#endif	// WITH_OP15

/**
 * Opera 25̃ubN}[No[ǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readOp25Bookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	Op25Reader *op25Reader = NULL;

	try {
		op25Reader = new Op25Reader();

		// Op25Readeȑo͐
		op25Reader->setBookmarkWriter(writer);
	}catch(...){
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_OPERA25);	// Opera 25
	writer->setBrowserNo(no);

	op25Reader->setBookmarkNo(no);	// ubN}[N̔ԍ
	op25Reader->setLogger(logger);
	op25Reader->setGuidSet(guidSet);
	op25Reader->setTrashMode(!s_config->getOp19IgnoreTrush(no));
	op25Reader->setIgnoreToolbar(s_config->getOp19IgnoreToolbar(no));	// ubN}[No[𖳎邩ǂ
	op25Reader->setNoUnSorted(s_config->getOp19IgnoreUnsorted(no));	// Unsorted bookmarks𖳎邩ǂ

	bookmarkTree->setBrowser(BOOKMARK_OPERA25_1 + no);

	result = op25Reader->readBookmark(s_config->getOp19Path(no).c_str(),"");

	if (op25Reader != NULL){
		delete op25Reader;
	}

	return result;
}

/**
 * VivaldĩubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readViBookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	ViReader *viReader = NULL;

	try {
		viReader = new ViReader();

		// ViReadeȑo͐
		viReader->setBookmarkWriter(writer);
	}
	catch (...) {
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_VIVALDI);	// Vivaldi
	writer->setBrowserNo(no);

	viReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	viReader->setLogger(logger);
	viReader->setTrashMode(!s_config->getViIgnoreTrush(no));
	viReader->setMetaData(vivaldiMetaData);

	bookmarkTree->setBrowser(BOOKMARK_VIVALDI_1 + no);

	result = viReader->readBookmark(s_config->getViPath(no).c_str(), "");

	if (viReader != NULL) {
		delete viReader;
	}

	return result;
}

/**
 * Edge(Chromium)̃ubN}[Nǂݍ
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int readEdge2Bookmark(int no)
{
	int result = 0;
	g_verbose = 0;
	Edge2Reader *edge2Reader = NULL;

	try {
		edge2Reader = new Edge2Reader();

		// ChromeReadeȑo͐
		edge2Reader->setBookmarkWriter(writer);
	}
	catch (...) {
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	writer->setBrowserType(BOOKMARK_TYPE_EDGE2);	// Edge(Chromium)
	writer->setBrowserNo(no);

	edge2Reader->setBookmarkNo(no);	// ubN}[N̔ԍ
	edge2Reader->setLogger(logger);
	edge2Reader->setIgnoreToolbar(s_config->getEdge2IgnoreToolbar(no));	// ubN}[No[𖳎邩ǂ

	bookmarkTree->setBrowser(BOOKMARK_EDGE2_1 + no);

	result = edge2Reader->readBookmark(s_config->getEdge2Path(no).c_str(), "");

	if (edge2Reader != NULL) {
		delete edge2Reader;
	}

	return result;
}


/**
 * SafarĩubN}[NOǂݍ
 *
 * @param targetTree ǍIuWFNg
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int preReadSfBookmark(BookmarkTree *targetTree,int no)
{
	int result = 0;
	g_verbose = 0;
	SafariReader *sfReader = NULL;

	try {
		sfReader = new SafariReader();

		// SafariReadeȑo͐
		sfReader->setBookmarkWriter(targetTree);
	}catch(...){
		return 1;
	}
	sfReader->setLogger(logger);

	int type = sfReader->isBplist(s_config->getSfPath(no).c_str());
	if (type == -1) {
		// t@CȂ̗Rœǂݍ߂Ȃꍇ͋̃c[o[B
		addLinkFolder(targetTree);

		delete sfReader;
		return 0;
	}

	sfReader->setBookmarkNo(no);	// ubN}[N̔ԍ

	targetTree->setBrowser(7 + no);
	targetTree->setMainBrowser(true);

	switch (type) {
		case -1:
			delete sfReader;
			return 1;
		case 0:
			// t@CXML`vpeBXgȂ̂ŉȂB
			result = sfReader->readBookmark((char *)(s_config->getSfPath(no).c_str()),"");
			break;
		case 1:
			// t@C̓oCi`vpeBXgȂ̂XML`ɕϊB
			result = bpListToXpList((char *)(s_config->getSfPath(no).c_str()));
			if (result) {
				delete sfReader;
				return 1;
			}
			char *fileName;
			fileName = workPath;
			result = sfReader->readBookmark(fileName,"");
			// ꎞIɍ쐬t@CB
			DeleteFile(fileName);
			break;
	}

	if (sfReader != NULL){
		delete sfReader;
	}

	return result;
}

/**
 * ChromẽubN}[NOǂݍ
 *
 * @param targetTree ǍIuWFNg
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int preReadChBookmark(BookmarkTree *targetTree,int no)
{
	int result = 0;
	g_verbose = 0;
	ChromeReader *chReader = NULL;

	try {
		chReader = new ChromeReader();

		// ChromeReadeȑo͐
		chReader->setBookmarkWriter(targetTree);
	}catch(...){
		return 1;
	}
	chReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	chReader->setLogger(logger);

	targetTree->setBrowser(BOOKMARK_CHROME_1 + no);
	targetTree->setMainBrowser(true);

	// t@CǂݍłB
	result = chReader->readBookmark((char *)(s_config->getChPath(no).c_str()),"");
	if (result) {
		// t@CȂ̗Rœǂݍ߂Ȃꍇ͋̃c[o[B
		addLinkFolder(targetTree);
		result = 0;
	}

	if (chReader != NULL){
		delete chReader;
	}

	return result;
}

/**
 * XBEL̃ubN}[NOǂݍ
 *
 * @param targetTree ǍIuWFNg
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int preReadXbBookmark(BookmarkTree *targetTree,int no)
{
	int result = 0;
	g_verbose = 0;
	XbelReader *xbReader = NULL;

	try {
		xbReader = new XbelReader();

		// XbelReadeȑo͐
		xbReader->setBookmarkWriter(targetTree);
	}catch(...){
		return 1;
	}
	xbReader->setBookmarkNo(no);	// ubN}[N̔ԍ
	xbReader->setLogger(logger);

	writer->setBrowserType(BOOKMARK_TYPE_XBEL);	// XBEL

	// tH_CAEg
	xbReader->setLayout(s_config->getXbLayout(no));
	targetTree->setBrowser(11 + no);
	targetTree->setMainBrowser(true);

	// t@CǂݍłB
	result = xbReader->readBookmark((char *)(s_config->getXbPath(no).c_str()),"");
	if (result) {
		// t@CȂ̗Rœǂݍ߂Ȃꍇ͋̃c[o[B
		addLinkFolder(targetTree);
		result = 0;
	}

	if (xbReader != NULL){
		delete xbReader;
	}

	return result;
}

/**
 * Opera 29̃ubN}[NOǂݍ
 *
 * @param targetTree ǍIuWFNg
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int preReadOp25Bookmark(BookmarkTree *targetTree, int no)
{
	int result = 0;
	g_verbose = 0;
	Op25Reader *op25Reader = NULL;

	try {
		op25Reader = new Op25Reader();

		// ChromeReadeȑo͐
		op25Reader->setBookmarkWriter(targetTree);
	}
	catch (...) {
		return 1;
	}
	op25Reader->setBookmarkNo(no);	// ubN}[N̔ԍ
	op25Reader->setLogger(logger);
	op25Reader->setGuidSet(guidSet);
	op25Reader->setIgnoreToolbar(false);

	targetTree->setBrowser(BOOKMARK_OPERA25_1 + no);
	targetTree->setMainBrowser(true);

	// t@CǂݍłB
	result = op25Reader->readBookmark((char *)(s_config->getOp19Path(no).c_str()), "");

	if (op25Reader != NULL) {
		delete op25Reader;
	}

	return result;
}

/**
 * ChromẽubN}[NOǂݍ
 *
 * @param targetTree ǍIuWFNg
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:ǂݍݐ 1:ǂݍݎs
 */
int preReadEdge2Bookmark(BookmarkTree *targetTree, int no)
{
	int result = 0;
	g_verbose = 0;
	Edge2Reader *edge2Reader = NULL;

	try {
		edge2Reader = new Edge2Reader();

		// ChromeReadeȑo͐
		edge2Reader->setBookmarkWriter(targetTree);
	}
	catch (...) {
		return 1;
	}
	edge2Reader->setBookmarkNo(no);	// ubN}[N̔ԍ
	edge2Reader->setLogger(logger);

	targetTree->setBrowser(BOOKMARK_EDGE2_1 + no);
	targetTree->setMainBrowser(true);

	// t@CǂݍłB
	result = edge2Reader->readBookmark((char *)(s_config->getEdge2Path(no).c_str()), "");
	if (result) {
		// t@CȂ̗Rœǂݍ߂Ȃꍇ͋̃c[o[B
		addLinkFolder(targetTree);
		result = 0;
	}

	if (edge2Reader != NULL) {
		delete edge2Reader;
	}

	return result;
}


/**
 * Firefox 3/Safari/ChromẽubN}[Nc[o[ȂꍇɃubN}[Nc[o[ǉB
 */
void addLinkFolder(BookmarkTree *targetTree)
{
	// ݐ̐ݒ

	targetTree->setBrowser(0);
	targetTree->upToTop();
	targetTree->setMainBrowser(true);
	Bookmark *target = targetTree->getFolderByAttribute(Bookmark::toolBar);
	if (target != NULL) {
		return;
	}
	Bookmark *bm;
	try {
		bm = new Bookmark();
		if (bm == NULL) {
			return;
		}
		bm->setItemType(Bookmark::folder);
		bm->setFolderType(Bookmark::toolBar);
		targetTree->storeItem(bm);
		delete bm;
	}catch(...){
	}
}

/**
 * łDx̍ubN}[NZoB
 *
 * @return -1:G[ 0ȏ:łDx̍ubN}[N
 */
int getPreferedBookmark()
{
	int no = -1;
	int prefered = -1;

	for (int order = 0;order < ALL_BOOKMARKS;order++) {
		no = s_config->getReadOrder(order);
		if (s_config->getConvertFrom(no)){
			prefered = no;
		}
	}
	return prefered;
}

/**
 * ȃ\[gݒKpB
 *
 * @return -1:ȃ\[gݒKpȂ -1ȊO:Kp\[gΏ
 */
int applySpecialSortMode()
{
	int mode = -1;
	int target;

	switch(s_config->getConvertType()) {
		case Configuration::Convert:
			if (s_config->getSortType() == 0) {
				// ϊŌ̏Ԃ̏ꍇAŗD̃ubN}[NECɓ̌̏ԂƂB
				target = getPreferedBookmark();
				if (target != -1) {
					mode = target;
				}
			}
			break;
		case Configuration::Edit:
			if (s_config->getEditMode()) {
				if (s_config->getSortType() == 0) {
					// ҏWŌ̏Ԃ̏ꍇAҏW{ubN}[NECɓ̌̏ԂƂB
					target = s_config->getEditTarget();
					if (target != -1) {
						mode = target;
					}
				}
			}
			break;
	}

	if (mode != -1) {
		Bookmark::setSortTarget(mode);
	}
	return mode;
}

/**
 * MozillañubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeMozillaBookmark(int no)
{
	// obNAbvt@Co
	std::string backFile = s_config->getMozPath(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getMozPath(no).c_str(),backFile.c_str(),FALSE);

	MozillaWriter *mozWriter;
	
	try {
		mozWriter = new MozillaWriter();
	}catch(...) {
		return 1;
	}
	
	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet){
		return 1;
	}
	tempPath[no] = workPath;
	
	fpo = fopen(workPath,"w");
	if (fpo == NULL){
		delete mozWriter;
		return 1;
	}

	// MozillaoIuWFNg̐ݒ
	mozWriter->setFilePointer(fpo);
	// ߂̓ǂݍ񂾃o[W
	mozWriter->setBrowserVersion(MozillaBookmark::getBrowserVersion(no));
	// o^Cv
	if (s_config->getMozNs4Format(no)){
		mozWriter->setBrowserType(0);	// o^CvNetscape 4
	}else{
		// o^CvMozillan
		mozWriter->setBrowserType(1);
	}
	// oΏۂ̃ubN}[N
	mozWriter->setTarget(no);

	// IẼNtH_ɃubN}[Nc[o[tH_킹邩ǂ
	if (s_config->getIeSyncronizeLinkFolder() || s_config->getEdgeSyncronizeLinkFolder()) {
		mozWriter->setSyncIElinkFolder(true);
	}
	// IẼNo[̃tH_̕\
	mozWriter->setIElinkFolderName(gIeLinkDisplay);
	// IẼNtH_ɃNtH_̖O킹邩ǂ(Windows Vista)
	mozWriter->setIEname(ieName);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	mozWriter->setPlacesPut(s_config->getPlacesPut());

	// c[IuWFNgMozillaoIuWFNgݒ肷B
	bookmarkTree->setWriter(mozWriter);
	bookmarkTree->setBrowser(BOOKMARK_MOZILLA_1 + no);
	Bookmark::setSortTarget(BOOKMARK_MOZILLA_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// ubN}[Nj[݂̂̂̂o߁AubN}[Nj[ֈړ
	goBookmarkMenu();

	// oJnB
	bookmarkTree->putAll();

	fclose(fpo);

	delete mozWriter;
	return 0;
}

/**
 * OperãubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeOperaBookmark(int no)
{
	// obNAbvt@Co
	std::string backFile = s_config->getOperaPath(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getOperaPath(no).c_str(),backFile.c_str(),FALSE);

	OperaWriter *opeWriter;
	
	try {
		opeWriter = new OperaWriter();
	}catch(...) {
		return 1;
	}
	
	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet){
		return 1;
	}
	tempPath[2 + no] = workPath;
	
	fpo = fopen(workPath,"w");
	if (fpo == NULL){
		delete opeWriter;
		return 1;
	}

	// OperaoIuWFNg̐ݒ
	opeWriter->setFilePointer(fpo);
	// ǂݍ񂾃o[WOpera 7+
	// opeWriter->setBrowserVersion(OperaBookmark::getBrowserVersion(no));
	// o^Cv
	//if (s_config->getOpera7Format(no)){
		opeWriter->setOperaVersion(1);	// o^CvOpera 7+
	//}else{
	//	opeWriter->setOperaVersion(0);	// o^CvOpera 6
	//}
	// oΏۂ̃ubN}[Nԍ
	opeWriter->setTarget(no);

	// IẼNtH_ɃubN}[Nc[o[tH_킹邩ǂ
	if (s_config->getIeSyncronizeLinkFolder() || s_config->getEdgeSyncronizeLinkFolder()) {
		opeWriter->setSyncIElinkFolder(true);
	}

	// IẼNo[̃tH_̕\
	opeWriter->setIElinkFolderName(gIeLinkDisplay);
	// IẼNtH_ɃNtH_̖O킹邩ǂ(Windows Vista)
	opeWriter->setIEname(ieName);
	// Windows MobilełǂH
	if (s_config->getOperaWinMobile(no)){
		opeWriter->setMobile(true);
	}else{
		opeWriter->setMobile(false);
	}
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	opeWriter->setPlacesPut(s_config->getPlacesPut());
	
	// c[IuWFNgOperaoIuWFNgݒ肷B
	bookmarkTree->setWriter(opeWriter);
	bookmarkTree->setBrowser(BOOKMARK_OPERA_1 + no);
	Bookmark::setSortTarget(BOOKMARK_OPERA_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// ubN}[Nj[݂̂̂̂o߁AubN}[Nj[ֈړ
	goBookmarkMenu();

	if (s_config->getOperaSyncMobile(no)) {
		// oĈCɓƓƂ̓oĈCɓɈړB
		Bookmark *stored;	// łɊi[ꂽubN}[NtH_
		stored = bookmarkTree->moveFolder(MOBILE_FAVORITES_JP_W,true);
		if (stored == NULL) {
			// Ȃꍇ͏osƂB
			return 1;
		}
	}

	// oJnB
	bookmarkTree->putAll();

	fclose(fpo);

	delete opeWriter;
	return 0;
}

/**
 * IẼubN}[NoB
 *
 * @return 0:o 1:os
 */
int writeIeBookmark()
{
	IeWriter *ieWriter;

	logger->trace("writeIeBookmark start");

	try {
		ieWriter = new IeWriter(false);
	}catch(...) {
		return 1;
	}

	wchar_t buf[MAX_PATH + 1];

	mbstowcsByte(buf,s_config->getIePath().c_str(),MAX_PATH);

	ieWriter->setLogger(logger);
	ieWriter->setFavoritesFolder(s_config->getIePath().c_str());
	ieWriter->setFavoritesFolderW(buf);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	ieWriter->setPlacesPut(s_config->getPlacesPut());

	// c[IuWFNgIEoIuWFNgݒ肷B
	bookmarkTree->setWriter(ieWriter);
	bookmarkTree->setBrowser(BOOKMARK_IE);
	Bookmark::setSortTarget(BOOKMARK_IE);
	// ȃ\[gݒKpB
	int appliedMode = applySpecialSortMode();

	// ubN}[Nj[݂̂̂̂o߁AubN}[Nj[ֈړ
	goBookmarkMenu();

	switch (s_config->getSortType()){
		case 0:
			// WXgȂΏԂ͕ێ̂
			// CɓBookSyncŏ܂Ȃ悤ɂB
			if (appliedMode != 0) {
				// ϊEҏWIEȊÕubN}[Nw肳ꂽƂ
				// IÊCɓ菇ɂ݂sB
				ieWriter->setManageOrder(true);
			} else {
				ieWriter->setManageOrder(false);
			}
			break;
		case 1:
			// O(fBNgD)͂Cɓ菇ݒ肵ȂƂ
			// ԂȂ̂ŁAIÊCɓ菇폜B
			deleteIEFavoriteOrder();
			// CɓBookSyncŏ܂Ȃ悤ɂB
			ieWriter->setManageOrder(false);
			break;
		default:
			// OAURLAȂ(t@CŌ)̎
			// CɓBookSyncŏށB
			ieWriter->setManageOrder(true);
			break;
	}

	// IÊCɓ̒ǂׂB
	char sysFavorites[MAX_PATH + 1];
	char userFavorites[MAX_PATH + 1];

	getIeFavoritesFolder(sysFavorites);
	if (sysFavorites[0] != '\0') {
		int sysLen = strlen(sysFavorites);
		strcpy(userFavorites, s_config->getIePath().c_str());
		userFavorites[sysLen] = '\0';
		if (_strnicmp(sysFavorites, userFavorites, sysLen)) {
			ieWriter->setManageOrder(false);
		}
	}


	// oJnB
	bookmarkTree->putAll();

	delete ieWriter;

	logger->trace("writeIeBookmark end");

	return 0;
}

#ifdef WITH_EDGE
/**
 * EdgẽubN}[NoB
 *
 * @return 0:o 1:os
 */
int writeEdgeBookmark()
{
	IeWriter *ieWriter;

	try {
		ieWriter = new IeWriter(true);
	}
	catch (...) {
		return 1;
	}

	wchar_t buf[MAX_PATH + 1];

	mbstowcsByte(buf, s_config->getEdgePath().c_str(), MAX_PATH);

	ieWriter->setFavoritesFolder(s_config->getEdgePath().c_str());
	ieWriter->setFavoritesFolderW(buf);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	ieWriter->setPlacesPut(s_config->getPlacesPut());

	// c[IuWFNgIEoIuWFNgݒ肷B
	bookmarkTree->setWriter(ieWriter);
	bookmarkTree->setBrowser(BOOKMARK_EDGE);
	Bookmark::setSortTarget(BOOKMARK_EDGE);
	// ȃ\[gݒKpB
	int appliedMode = applySpecialSortMode();

	// ubN}[Nj[݂̂̂̂o߁AubN}[Nj[ֈړ
	goBookmarkMenu();

	// Cɓ菇ɂ݂sB
	ieWriter->setManageOrder(true);

	// IÊCɓ̒ǂׂB
	char sysFavorites[MAX_PATH + 1];
	char userFavorites[MAX_PATH + 1];

	getIeFavoritesFolder(sysFavorites);
	if (sysFavorites[0] != '\0') {
		int sysLen = strlen(sysFavorites);
		strcpy(userFavorites, s_config->getIePath().c_str());
		userFavorites[sysLen] = '\0';
		if (_strnicmp(sysFavorites, userFavorites, sysLen)) {
			ieWriter->setManageOrder(false);
		}
	}


	// oJnB
	bookmarkTree->putAll();

	delete ieWriter;
	return 0;
}
#endif	// WITH_EDGE

/**
 * Firefox 3̃ubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeFxBookmark(int no)
{
	// obNAbvt@Co
	std::string backFile = s_config->getFxPath(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getFxPath(no).c_str(),backFile.c_str(),FALSE);

	FxWriter *fxWriter;
	
	try {
		fxWriter = new FxWriter();
	}catch(...) {
		return 1;
	}

	int result;

	// t@C̐ݒ+I[v
	result = fxWriter->setDBfileName(s_config->getFxPath(no).c_str());
	if (result){
		delete fxWriter;
		return 1;
	}

	// c[o[̒gǂH
	fxWriter->setToolbarDelete(hasToolbarFolder);
	// j[ȊO(Unsorted)ǂH
	fxWriter->setUnsortedDelete(hasNonMenuItem);
	// oC̃ubN}[N폜邩ǂH
	fxWriter->setMobileDelete(hasMobileBookmark);
	fxWriter->setPutWithoutToolbar(s_config->getFxIgnoreToolbar(no));
	fxWriter->setOptimize(s_config->getFxDoOptimize(no));
	fxWriter->setGuidSet(fxGuidSet);

	// oΏۂ̃ubN}[N
	fxWriter->setTarget(no);
	if (s_config->getNoIEFavbar()) {
		fxWriter->setIEToolbarPut(false);
	}

	// c[IuWFNgFirefoxoIuWFNgݒ肷B
	bookmarkTree->setWriter(fxWriter);
	bookmarkTree->setBrowser(BOOKMARK_FIREFOX_1 + no);
	Bookmark::setSortTarget(BOOKMARK_FIREFOX_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// oJnB
	bookmarkTree->putAll();

	fxWriters[no] = fxWriter;
	return 0;
}

/**
 * SafarĩubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeSafariBookmark(int no)
{
	int result = 0;
	bool ignoreToolbar = s_config->getSfIgnoreToolbar(no);

	// obNAbvt@Co
	std::string backFile = s_config->getSfPath(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getSfPath(no).c_str(),backFile.c_str(),FALSE);

	BookmarkTree *originalTree = NULL;
	if (ignoreToolbar) {
		try {
			originalTree = new BookmarkTree();
		} catch (...) {
			return 1;
		}
		result = preReadSfBookmark(originalTree,no);
		if (result) {
			delete originalTree;
			return 1;
		}
	}

	SafariWriter *sfWriter;
	
	try {
		sfWriter = new SafariWriter();
	}catch(...) {
		if (ignoreToolbar) {
			delete originalTree;
		}
		return 1;
	}
	
	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet){
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete sfWriter;
		return 1;
	}
	tempPath[4 + no] = workPath;
	
	fpo = fopen(workPath,"w");
	if (fpo == NULL){
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete sfWriter;
		return 1;
	}

	// SafarioIuWFNg̐ݒ
	sfWriter->setFilePointer(fpo);
	// oΏۂ̃ubN}[N
	sfWriter->setTarget(no);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	sfWriter->setPlacesPut(s_config->getPlacesPut());
	if (s_config->getNoIEFavbar()) {
		sfWriter->setIEToolbarPut(false);
	}

	// c[IuWFNgSafarioIuWFNgݒ肷B
	bookmarkTree->setWriter(sfWriter);
	bookmarkTree->setBrowser(BOOKMARK_SAFARI_1 + no);
	Bookmark::setSortTarget(BOOKMARK_SAFARI_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// oJnB
	if (ignoreToolbar) {
		originalTree->setWriter(sfWriter);
		originalTree->setBrowser(BOOKMARK_SAFARI_1 + no);
		bookmarkTree->putWithOriginalToolbar(originalTree);
		delete originalTree;
	} else {
		bookmarkTree->putAll();
	}

	fclose(fpo);

	delete sfWriter;
	return 0;
}

/**
 * ChromẽubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeChromeBookmark(int no)
{
	int result = 0;
	bool ignoreToolbar = s_config->getChIgnoreToolbar(no);

	// obNAbvt@Co
	std::string backFile = s_config->getChPath(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getChPath(no).c_str(),backFile.c_str(),FALSE);

	BookmarkTree *originalTree = NULL;
	if (ignoreToolbar) {
		try {
			originalTree = new BookmarkTree();
		} catch (...) {
			return 1;
		}
		result = preReadChBookmark(originalTree,no);
		if (result) {
			delete originalTree;
			return 1;
		}
	}

	ChromeWriter *chWriter;

	try {
		chWriter = new ChromeWriter();
	}catch(...) {
		if (ignoreToolbar) {
			delete originalTree;
		}
		return 1;
	}
	
	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet){
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete chWriter;
		return 1;
	}
	tempPath[6 + no] = workPath;
	
	fpo = fopen(workPath,"w");
	if (fpo == NULL){
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete chWriter;
		return 1;
	}

	// ChromeoIuWFNg̐ݒ
	chWriter->setFilePointer(fpo);
	// oΏۂ̃ubN}[N
	chWriter->setTarget(no);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	chWriter->setPlacesPut(s_config->getPlacesPut());
	if (s_config->getNoIEFavbar()) {
		chWriter->setIEToolbarPut(false);
	}

	// c[IuWFNgChromeoIuWFNgݒ肷B
	bookmarkTree->setWriter(chWriter);
	bookmarkTree->setBrowser(BOOKMARK_CHROME_1 + no);
	Bookmark::setSortTarget(BOOKMARK_CHROME_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// oJnB
	if (ignoreToolbar) {
		originalTree->setWriter(chWriter);
		originalTree->setBrowser(BOOKMARK_CHROME_1 + no);
		bookmarkTree->putWithOriginalToolbar(originalTree);
		delete originalTree;
	} else {
		bookmarkTree->putAll();
	}

	fclose(fpo);

	delete chWriter;
	return 0;
}

/**
 * XBEL̃ubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeXbelBookmark(int no)
{
	int result = 0;
	bool ignoreToolbar = false;
	if (s_config->getXbLayout(no) == 0) {
		if (s_config->getXbIgnoreToolbar(no)) {
			ignoreToolbar = true;
		}
	}

	// obNAbvt@Co
	std::string backFile = s_config->getXbPath(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getXbPath(no).c_str(),backFile.c_str(),FALSE);

	BookmarkTree *originalTree = NULL;
	if (ignoreToolbar) {
		try {
			originalTree = new BookmarkTree();
		} catch (...) {
			return 1;
		}
		result = preReadXbBookmark(originalTree,no);
		if (result) {
			delete originalTree;
			return 1;
		}
	}

	XbelWriter *xbWriter;
	
	try {
		xbWriter = new XbelWriter();
	}catch(...) {
		if (ignoreToolbar) {
			delete originalTree;
		}
		return 1;
	}
	
	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet){
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete xbWriter;
		return 1;
	}
	tempPath[8 + no] = workPath;
	
	fpo = fopen(workPath,"w");
	if (fpo == NULL){
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete xbWriter;
		return 1;
	}

	// XBELoIuWFNg̐ݒ
	xbWriter->setFilePointer(fpo);
	// oΏۂ̃ubN}[N
	xbWriter->setTarget(no);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	xbWriter->setPlacesPut(s_config->getPlacesPut());
	// tH_CAEg
	xbWriter->setLayout(s_config->getXbLayout(no));
	if (s_config->getNoIEFavbar()) {
		xbWriter->setIEToolbarPut(false);
	}

	// c[IuWFNgXBELoIuWFNgݒ肷B
	bookmarkTree->setWriter(xbWriter);
	bookmarkTree->setBrowser(BOOKMARK_XBEL_1 + no);
	Bookmark::setSortTarget(BOOKMARK_XBEL_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	switch(s_config->getXbLayout(no)) {
		case XBEL_LAYOUT_MENU:
			// ubN}[Nj[ֈړ
			goBookmarkMenu();
			break;
		case XBEL_LAYOUT_MOBILE_FAVORITES:
			// ܂AubN}[Nj[ֈړ
			goBookmarkMenu();

			// oĈCɓƓƂ̓oĈCɓɈړB
			Bookmark *stored;	// łɊi[ꂽubN}[NtH_
			stored = bookmarkTree->moveFolder(MOBILE_FAVORITES_JP_W,true);
			if (stored == NULL) {
				// Ȃꍇ͏osƂB
				return 1;
			}
			break;
	}

	// oJnB
	if (ignoreToolbar) {
		originalTree->setWriter(xbWriter);
		originalTree->setBrowser(BOOKMARK_XBEL_1 + no);
		bookmarkTree->putWithOriginalToolbar(originalTree);
		delete originalTree;
	} else {
		bookmarkTree->putAll();
	}

	fclose(fpo);

	delete xbWriter;
	return 0;
}

#ifdef WITH_OP15
/**
 * Opera 15̃ubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeOp15Bookmark(int no)
{
	// obNAbvt@Co
	std::string backFile = s_config->getOp15Path(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getOp15Path(no).c_str(),backFile.c_str(),FALSE);

	Op15Writer *op15Writer;
	
	try {
		op15Writer = new Op15Writer();
	}catch(...) {
		return 1;
	}

	int result;

	// t@C̐ݒ+I[v
	result = op15Writer->setDBfileName(s_config->getOp15Path(no).c_str());
	if (result){
		delete op15Writer;
		return 1;
	}

	// oΏۂ̃ubN}[N
	op15Writer->setTarget(no);
	if (s_config->getNoIEFavbar()) {
		op15Writer->setIEToolbarPut(false);
	}
	// tH_̒ɃtH_邩ǂ̐ݒ肾A
	// tH_̒ɃtH_Ȃ̂ŃRgAEgB
	//op15Writer->setInFolder(s_config->getOp15InFolder(no));
	// œK邩ǂ
	op15Writer->setOptimize(s_config->getOp15Optimize(no));

	// c[IuWFNgOpera 15oIuWFNgݒ肷B
	bookmarkTree->setWriter(op15Writer);
	bookmarkTree->setBrowser(BOOKMARK_OPERA15_1 + no);
	Bookmark::setSortTarget(BOOKMARK_OPERA15_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// ubN}[Nj[݂̂̂̂o߁AubN}[Nj[ֈړ
	goBookmarkMenu();

	// oJnB
	bookmarkTree->putAll();

	op15Writers[no] = op15Writer;
	return 0;
}
#endif	// WITH_OP15

/**
 * Opera 25̃ubN}[No[oB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeOp25Bookmark(int no)
{
	int result = 0;

	// obNAbvt@Co
	std::string backFile = s_config->getOp19Path(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getOp19Path(no).c_str(),backFile.c_str(),FALSE);

	// ̃uEUŃXs[h_Co͂Ȃꍇ͌̃ubN}[NǂݍłB
	BookmarkTree *originalTree = NULL;
	if ((!s_config->getOp29SpeedDialPut())
		|| s_config->getOp19IgnoreToolbar(no)
		|| s_config->getOp19IgnoreUnsorted(no) ) {
		try {
			originalTree = new BookmarkTree();
		}
		catch (...) {
			return 1;
		}
		result = preReadOp25Bookmark(originalTree, no);
		if (result) {
			delete originalTree;
			originalTree = NULL;
		}
	}

	Op25Writer *op25Writer;

	try {
		op25Writer = new Op25Writer();
	}catch(...) {
		if (originalTree != NULL) {
			delete originalTree;
		}
		return 1;
	}
	op25Writer->setGuidSet(guidSet);
	
	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet){
		if (originalTree != NULL) {
			delete originalTree;
		}
		delete op25Writer;
		return 1;
	}
	tempPath[10 + no] = workPath;
	
	fpo = fopen(workPath,"w");
	if (fpo == NULL){
		if (originalTree != NULL) {
			delete originalTree;
		}
		delete op25Writer;
		return 1;
	}

	// Opera 25oIuWFNg̐ݒ
	op25Writer->setFilePointer(fpo);
	// oΏۂ̃ubN}[N
	op25Writer->setTarget(no);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	op25Writer->setPlacesPut(s_config->getPlacesPut());

	// c[IuWFNgɏoIuWFNgݒ肷B
	bookmarkTree->setWriter(op25Writer);
	bookmarkTree->setBrowser(BOOKMARK_OPERA25_1 + no);
	Bookmark::setSortTarget(BOOKMARK_OPERA25_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// oJnB
	op25Writer->putHeader();

	// c[o[
	writer->upToTop();
	op25Writer->setInFolder(s_config->getOp19InFolder(no));
	bm_listitem *targetNode = NULL;
	op25Writer->setIgnoreLevel(2);
	if (s_config->getOp19IgnoreToolbar(no)) {
		// c[o[o͂Ȃꍇ͌̃c[o[o͂B
		if (originalTree != NULL) {
			originalTree->upToTop();
			targetNode = originalTree->getFolderNodeByAttribute(Bookmark::toolBar);
		}
	} else {
		targetNode = bookmarkTree->getFolderNodeByAttribute(Bookmark::toolBar);
	}
	if (targetNode != NULL) {
		Bookmark *toolbar = targetNode->getBookmark();
		op25Writer->putFolder(toolbar);

		if (targetNode->getChild()) {
			bookmarkTree->putList(targetNode->getChild());
		}
		op25Writer->putFolderEnd(toolbar, false);
	} else {
		Bookmark *customRoot = new Bookmark();
		char *p = mbtoUTF8Internal("ubN}[N o[");
		customRoot->setName(p);
		customRoot->setIeName("ubN}[N o[");
		customRoot->setIeNameW(L"ubN}[N o[");
		customRoot->setFolderType(Bookmark::toolBar);
		op25Writer->putFolder(customRoot);
		op25Writer->putFolderEnd(customRoot, false);
		delete customRoot;
	}

	// custom_root
	writer->upToTop();
	op25Writer->setInFolder(s_config->getOp19InFolder(no));
	targetNode = bookmarkTree->getFolderNodeByAttribute(Bookmark::menuBar);

	bm_listitem *orgTargetNode = NULL;
	if (originalTree != NULL) {
		originalTree->upToTop();
		orgTargetNode = originalTree->getFolderNodeByAttribute(Bookmark::menuBar);
	}

	bm_listitem *orgUnsortedNode = NULL;
	if (originalTree != NULL) {
		originalTree->upToTop();
		orgUnsortedNode = originalTree->getFolderNodeByAttribute(Bookmark::unFiled);
	}

	Bookmark *customRoot = new Bookmark();
	char *p = mbtoUTF8Internal("}CtH_");
	customRoot->setName(p);
	customRoot->setIeName("}CtH_");
	customRoot->setIeNameW(L"}CtH_");
	customRoot->setFolderType(Bookmark::customRoot);
	op25Writer->putFolder(customRoot);
	if (targetNode != NULL) {
		if (targetNode->getChild()) {
			op25Writer->writeOp25CustomRoot(
				no,
				bookmarkTree,
				targetNode,
				orgTargetNode,
				s_config->getOp29SpeedDialPut(),
				s_config->getOp19IgnoreUnsorted(no),
				orgUnsortedNode);
		}
	}
	op25Writer->putFolderEnd(customRoot, false);
	delete customRoot;

	// other
	writer->upToTop();
	op25Writer->setInFolder(true);
	op25Writer->setIgnoreLevel(65536);
	targetNode = bookmarkTree->getFolderNodeByAttribute(Bookmark::menuBar);
	Bookmark *other = new Bookmark();
	p = mbtoUTF8Internal("̑̃ubN}[N");
	other->setName(p);
	other->setIeName("̑̃ubN}[N");
	other->setIeNameW(L"̑̃ubN}[N");
	other->setFolderType(Bookmark::menuBar);
	other->getOp25Bookmark(no)->setFolderType(Op25Bookmark::normalFolder);
	op25Writer->putFolder(other);
	if (targetNode != NULL) {
		if (targetNode->getChild()) {
			op25Writer->writeOp25Other(no, bookmarkTree, targetNode);
		}
	}
	op25Writer->putFolderEnd(other, false);
	delete other;

	// oC̃ubN}[N(\)
#if 0
	writer->upToTop();
	op25Writer->setInFolder(s_config->getOp19InFolder(no));
	op25Writer->setIgnoreLevel(3);
	targetNode = bookmarkTree->getFolderNodeByAttribute(Bookmark::mobile);
	if (targetNode != NULL) {
		Bookmark *toolbar = targetNode->getBookmark();
		op25Writer->putFolder(toolbar);

		if (targetNode->getChild()) {
			bookmarkTree->putList(targetNode->getChild());
		}
		op25Writer->putFolderEnd(toolbar, true);
	}
#endif

	op25Writer->putFooter();

	fclose(fpo);

	if (originalTree != NULL) {
		delete originalTree;
	}
	delete op25Writer;
	return 0;
}

/**
 * VivaldĩubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeViBookmark(int no)
{
	int result = 0;

	// obNAbvt@Co
	std::string backFile = s_config->getViPath(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getViPath(no).c_str(), backFile.c_str(), FALSE);

	ViWriter *viWriter;

	try {
		viWriter = new ViWriter();
	}
	catch (...) {
		return 1;
	}
	viWriter->setMetaData(vivaldiMetaData);

	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet) {
		delete viWriter;
		return 1;
	}
	tempPath[12 + no] = workPath;

	fpo = fopen(workPath, "w");
	if (fpo == NULL) {
		delete viWriter;
		return 1;
	}

	// VivaldioIuWFNg̐ݒ
	viWriter->setFilePointer(fpo);
	// oΏۂ̃ubN}[N
	viWriter->setTarget(no);
	// S~o͂邩H
	viWriter->setTrashMode(!s_config->getViIgnoreTrush(no));
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	viWriter->setPlacesPut(s_config->getPlacesPut());
	if (s_config->getNoIEFavbar()) {
		viWriter->setIEToolbarPut(false);
	}

	// c[IuWFNgVivaldioIuWFNgݒ肷B
	bookmarkTree->setWriter(viWriter);
	bookmarkTree->setBrowser(BOOKMARK_VIVALDI_1 + no);
	Bookmark::setSortTarget(BOOKMARK_VIVALDI_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	if (s_config->getConvertAll()) {
		viWriter->setAllPut(true);
	} else {
		viWriter->setAllPut(false);
	}

	// oJnB
	bookmarkTree->putAll();

	fclose(fpo);

	delete viWriter;
	return 0;
}

/**
 * Edge(Chromium)̃ubN}[NoB
 *
 * @param no Ԗڂ̃ubN}[NH(0-1)
 * @return 0:o 1:os
 */
int writeEdge2Bookmark(int no)
{
	int result = 0;
	bool ignoreToolbar = s_config->getEdge2IgnoreToolbar(no);

	// obNAbvt@Co
	std::string backFile = s_config->getEdge2Path(no);

	backFile += ".BookSync.bak";
	CopyFile(s_config->getEdge2Path(no).c_str(), backFile.c_str(), FALSE);

	BookmarkTree *originalTree = NULL;
	if (ignoreToolbar) {
		try {
			originalTree = new BookmarkTree();
		}
		catch (...) {
			return 1;
		}
		result = preReadEdge2Bookmark(originalTree, no);
		if (result) {
			delete originalTree;
			return 1;
		}
	}

	Edge2Writer *edge2Writer;

	try {
		edge2Writer = new Edge2Writer();
	}
	catch (...) {
		if (ignoreToolbar) {
			delete originalTree;
		}
		return 1;
	}

	FILE *fpo;

	// ꎞot@C𓾂B
	int workGet = getTemporaryName(workPath);
	if (workGet) {
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete edge2Writer;
		return 1;
	}
	tempPath[14 + no] = workPath;

	fpo = fopen(workPath, "w");
	if (fpo == NULL) {
		if (ignoreToolbar) {
			delete originalTree;
		}
		delete edge2Writer;
		return 1;
	}

	// ChromeoIuWFNg̐ݒ
	edge2Writer->setFilePointer(fpo);
	// oΏۂ̃ubN}[N
	edge2Writer->setTarget(no);
	// Firefox 3̃X}[gubN}[No͂邩ǂ
	edge2Writer->setPlacesPut(s_config->getPlacesPut());
	if (s_config->getNoIEFavbar()) {
		edge2Writer->setIEToolbarPut(false);
	}

	// c[IuWFNgChromeoIuWFNgݒ肷B
	bookmarkTree->setWriter(edge2Writer);
	bookmarkTree->setBrowser(BOOKMARK_EDGE2_1 + no);
	Bookmark::setSortTarget(BOOKMARK_EDGE2_1 + no);
	// ȃ\[gݒKpB
	applySpecialSortMode();

	// oJnB
	if (ignoreToolbar) {
		originalTree->setWriter(edge2Writer);
		originalTree->setBrowser(BOOKMARK_EDGE2_1 + no);
		bookmarkTree->putWithOriginalToolbar(originalTree);
		delete originalTree;
	}
	else {
		bookmarkTree->putAll();
	}

	fclose(fpo);

	delete edge2Writer;
	return 0;
}

/**
 * IẼNtH_Firefox 3̃ubN}[Nc[o[tH_ɏoB
 *
 * @return 0:o 1:os
 */
int writeIeLinkFolder(void)
{
	BookmarkTree *ieLinkNode;
	BOOKLIST *ieLinkList;
	Bookmark *target;
	wchar_t pathBuf[260];

	if (s_config->getEditMode()) {
		// ҏW͔fsȂB
		return 0;
	}

	// ǂݍ݌̐ݒ
	wcscpy(pathBuf, L"\n");
	wcscat(pathBuf, gIeLinkDisplayW);
	ieLinkNode = bookmarkTree;
	ieLinkList = ieLinkNode->getBookmarkFolderByPath(pathBuf, Bookmark::menuBar);
	if (ieLinkList == NULL) {
		return 0;
	}

	// ݐ̐ݒ
	writer->reset();	// ԍŏɖ߂B
	writer->setBrowserType(BOOKMARK_TYPE_IE);	// IE
	writer->setBrowserNo(0);	// ӖȂ1Ԗ

	bookmarkTree->setBrowser(BOOKMARK_IE);
	bookmarkTree->upToTop();
	bookmarkTree->setMainBrowser(true);
	target = bookmarkTree->getFolderByAttribute(Bookmark::toolBar);
	if (target == NULL) {
		// Firefox 3̃ubN}[Nc[o[܂߂ĂȂꍇ
		// KvB
		addLinkFolder(bookmarkTree);
		bookmarkTree->upToTop();
		target = bookmarkTree->getFolderByAttribute(Bookmark::toolBar);
		if (target == NULL) {
			return 0;
		}
	}
	bookmarkTree->upToToolbar();
	bookmarkTree->setMainBrowser(true);
	ieLinkNode->setTree(writer);
	ieLinkNode->storeList(ieLinkList);
	return 0;
}

/**
 * Firefox 3̃ubN}[Nc[o[tH_IẼNtH_ɏoB
 *
 * @return 0:o 1:os
 */
int writeFxLinkFolder(void)
{
	BookmarkTree *fxLinkNode;
	BOOKLIST *fxLinkList;
	wchar_t bufW2[2];

	if (s_config->getEditMode()) {
		// ҏW͔fsȂB
		return 0;
	}

	// ǂݍ݌̐ݒ
	wcscpy(bufW2,L"\n");
	fxLinkNode = bookmarkTree;
	fxLinkList = fxLinkNode->getBookmarkFolderByPath(bufW2,Bookmark::toolBar);
	if (fxLinkList == NULL) {
		return 0;
	}

	// ݐ̐ݒ
	// c[Ə݃IuWFNgZbgB
	bookmarkTree->upToTop();
	bookmarkTree->setMainBrowser(true);
	bookmarkTree->setBrowser(BOOKMARK_IE);

	writer->reset();	// ԍŏɖ߂B
	writer->setBrowserType(BOOKMARK_TYPE_IE);	// IE
	writer->setBrowserNo(0);	// ӖȂ1Ԗ

	// IẼNtH_ֈړ
	// ubN}[Nj[݂Ƃ̂݃ubN}[Nj[֍sB
	Bookmark *menu = bookmarkTree->getFolderByAttribute(Bookmark::menuBar);
	if (menu != NULL){
		writer->upToBookmarkMenu();	// ubN}[Nj[ɖ߂B
	} else {
		// ubN}[Nj[݂ȂƂ͔f悪Ȃ̂
		// ̂܂ܔ悤ɂB
		return 0;
	}

	// No[ȂɔčĂB
	addLinkBar();
	bookmarkTree->setMainBrowser(true);

	fxLinkNode->setTree(writer);
	fxLinkNode->storeList(fxLinkList);
	return 0;
}

/**
 * IẼNtH_ւ̎QƂ͂
 *
 * @return 0:폜 1:폜s
 */
int unreferIeLinkFolder(void)
{
	BookmarkTree *ieLinkNode;
	wchar_t bufW[256];
	char buf[256];

	if (s_config->getEditMode()) {
		// ҏW͔fsȂB
		return 0;
	}

	// IẼNtH_
	getIeLinkbarFolder(buf,256);
	memset(bufW,0,sizeof(wchar_t) * 256);
	bufW[0] = L'\n';
	mbstowcsByte(bufW + 1,gIeLinkDisplay,strlen(gIeLinkDisplay));

	// ǂݍ݌̐ݒ
	ieLinkNode = bookmarkTree;
	ieLinkNode->unreferBookmarkFolderByPath(bufW,Bookmark::menuBar);

	return 0;
}

/**
 * IÊCɓB
 *
 * @return 0: 1:s
 */
int deleteIEbookmark(const char *path, bool ignoreLink)
{
	int result = 0;
	wchar_t buf[MAX_PATH];
	char buf2[MAX_PATH];
	
	bookmarkTree->upToTop();	// ԍŏɖ߂B
	writer->setMainBrowser(false);
	// ubN}[Nj[݂̂̂̂o߁AubN}[Nj[ֈړ
	goBookmarkMenu();

	// g_verbose = 1;
	IeCleaner *favCleaner = NULL;
	
	try {
		favCleaner = new IeCleaner();

		// IeReader̃ANV
		IeItemHandler = favCleaner;
		// BookmarkTreeZbgB
		favCleaner->setBookmarkTree(bookmarkTree);

		// IÊCɓtH_烊NtH_𐶐B
		strcpy(buf2, path);
		strcat(buf2,"\\");
		strcat(buf2,ieLinkFolder);

		favCleaner->setNoIeLink(ignoreLink);
		favCleaner->setIElinkDir(buf2);

	}catch(...){
		if (favCleaner != NULL){
			delete favCleaner;
		}
		return 1;
	}

	// ǂݍ݃IuWFNgݒ肵ǂݍ݂sB
	mbstowcsByte(buf, path, MAX_PATH);
	result = search_dir(path, buf);

	if (favCleaner != NULL){
		delete favCleaner;
	}

	if (result > -1){
		return 0;
	}else{
		return 1;
	}
}

/**
 * Windows VistãNtH_t@CVXe̖O猩ڂ̖OɕύXB<br>
 * (Ȃ񂾂AB)
 */
void renameLinkFolder()
{
	BOOKLIST *bookmarkFolder = bookmarkTree->getBookmarkFolderByPath(L"\n",Bookmark::menuBar);
	if (bookmarkFolder == NULL) {
		return;
	}

	// IE/OS̃o[WɂāAt@CVXe̖OA\
	// قȂ̂ŁAOݒ肷B
	wchar_t linkFolderName[256];
	const char *linkDisplayName;
	const wchar_t *linkDisplayNameW;

	if (gWindowsMajorVersion < 6){
		// Windows 2000/XP
		if (getIeMajorVersion() > 7) {
			wcscpy(linkFolderName,gIeLinkFolderW);
			linkDisplayName = gIeLinkDisplay;
			linkDisplayNameW = gIeLinkDisplayW;
		} else {
			// IE7܂ł̓tH_̃l[svȂ̂ŔB
			return;
		}
	} else {
		// Windows Vista,7,and later(?)
		wcscpy(linkFolderName,IE7_LINK_NAME_W);
		if (getIeMajorVersion() > 7) {
			linkDisplayName = gIeLinkDisplay;
			linkDisplayNameW = gIeLinkDisplayW;
		} else {
			linkDisplayName = IE7_LINK_NAME_JP;
			linkDisplayNameW = IE7_LINK_NAME_JP_W;
		}
	}

	// IẼNtH_/Cɓo[T
	BOOKLIST::iterator currentItem;
	Bookmark *item;
	Bookmark *linkFolder;

	currentItem = bookmarkFolder->begin();
	for	( ; currentItem != bookmarkFolder->end() ; ++currentItem ) {
		item = currentItem->getBookmark();
		if (item == NULL) {
			// ĂȂꍇ
			continue;
		}
		if (item->getItemType() != Bookmark::folder) {
			// tH_łȂꍇ
			continue;
		}
		wchar_t *folderName = item->getIeNameW();
		if (folderName == NULL) {
			continue;
		}
		if (wcscmp(folderName,linkFolderName) == 0) {
			// IẼNtH_/Cɓo[̃t@CVXe
			// ȌꍇArŔāA݂ƂB
			break;
		}
	}
	if (currentItem == bookmarkFolder->end()) {
		// NtH_Ȃꍇ͔B
		return;
	}

	// NtH_/Cɓo[̖OIE̕\ɕςB
	linkFolder = item;

	linkFolder->setIeName(linkDisplayName);
	linkFolder->setIeNameW(linkDisplayNameW);
	char *utf8Name = wctoUTF8Internal(linkDisplayNameW);
	linkFolder->setName(utf8Name);


}

/**
 * ꎞt@CɏoꂽubN}[N{̏ݐɏoB
 *
 * @return 0: 1:s
 */
int writeTargetFile(void)
{
	bool failFlag = false;

	// SQLitegpubN}[ÑR~bgsB
	for (int i = 0;i < 2;i++) {
		// Firefox 3
		if (fxWriters[i] != NULL) {
			int result = fxWriters[i]->commit();
			if (result) {
				failFlag = true;
				logger->debug("Firefox bookmark commit failed");
			}
			delete fxWriters[i];
		}

#ifdef WITH_OP15
		// Opera 15
		if (op15Writers[i] != NULL) {
			int result = op15Writers[i]->commit();
			if (result) {
				failFlag = true;
				logger->debug("Opera 15 speed dial commit failed");
			}
			delete op15Writers[i];
		}
#endif	// WITH_OP15
	}
	if (failFlag) {
		return 1;
	}

	// Mozillan
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_MOZILLA_1 + i)){
			int result = CopyFile(
				tempPath[i].c_str()
				,s_config->getMozPath(i).c_str()
				,FALSE);

			if (!result) {
				logger->debug("Mozilla bookmark commit failed");
				return 1;
			}
			DeleteFile(tempPath[i].c_str());
		}
	}

	// Opera
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_OPERA_1 + i)){
			logger->debug(s_config->getOperaPath(i).c_str());
			int result = CopyFile(
				tempPath[2 + i].c_str()
				,s_config->getOperaPath(i).c_str(),
				FALSE);

			DeleteFile(tempPath[2 + i].c_str());
			if (!result) {
				logger->debug("Opera bookmark commit failed");
				return 1;
			}
		}
	}

	// Safari
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_SAFARI_1 + i)){
			logger->debug(s_config->getSfPath(i).c_str());
			int result = CopyFile(
				tempPath[4 + i].c_str()
				,s_config->getSfPath(i).c_str()
				,FALSE);

			DeleteFile(tempPath[4 + i].c_str());
			if (!result) {
				logger->debug("Safari bookmark commit failed");
				return 1;
			}
		}
	}

	// Chrome
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_CHROME_1 + i)){
			logger->debug(s_config->getChPath(i).c_str());
			int result = CopyFile(
				tempPath[6 + i].c_str()
				,s_config->getChPath(i).c_str()
				,FALSE);

			DeleteFile(tempPath[6 + i].c_str());
			if (!result) {
				logger->debug("Chrome bookmark commit failed");
				return 1;
			}
		}
	}

	// XBEL
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_XBEL_1 + i)){
			logger->debug(s_config->getXbPath(i).c_str());
			int result = CopyFile(
				tempPath[8 + i].c_str()
				,s_config->getXbPath(i).c_str()
				,FALSE);

			DeleteFile(tempPath[8 + i].c_str());
			if (!result) {
				logger->debug("XBEL file commit failed");
				return 1;
			}
		}
	}

	// Opera 25ubN}[N
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_OPERA25_1 + i)){
			logger->debug(s_config->getOp19Path(i).c_str());
			int result = CopyFile(
				tempPath[10 + i].c_str()
				,s_config->getOp19Path(i).c_str()
				,FALSE);

			DeleteFile(tempPath[10 + i].c_str());
			if (!result) {
				logger->debug("Opera 25 bookmarks file commit failed");
				return 1;
			}
		}
	}

	// VivaldiubN}[N
	for (int i = 0; i < 2; i++) {
		if (s_config->getConvertTo(BOOKMARK_VIVALDI_1 + i)) {
			logger->debug(s_config->getViPath(i).c_str());
			int result = CopyFile(
				tempPath[12 + i].c_str()
				, s_config->getViPath(i).c_str()
				, FALSE);

			DeleteFile(tempPath[12 + i].c_str());
			if (!result) {
				logger->debug("Vivaldi bookmarks file commit failed");
				return 1;
			}
		}
	}

	// VivaldiubN}[N
	for (int i = 0; i < 2; i++) {
		if (s_config->getConvertTo(BOOKMARK_EDGE2_1 + i)) {
			logger->debug(s_config->getEdge2Path(i).c_str());
			int result = CopyFile(
				tempPath[14 + i].c_str()
				, s_config->getEdge2Path(i).c_str()
				, FALSE);

			DeleteFile(tempPath[14 + i].c_str());
			if (!result) {
				logger->debug("Edge(Chromium) bookmarks file commit failed");
				return 1;
			}
		}
	}
	return 0;
}

/**
 * c[̈ʒuubN}[Nj[ɈړB
 *
 */
void goBookmarkMenu(void)
{
	if (s_config->getConvertAll() &&
		(onlyMenuFlag == false) &&
		s_config->getConvertType() == Configuration::Convert) {
		// ϊϊŁAubN}[Nj[ȊÔ݂̂
		// ׂĂϊꍇ̓ubN}[Nj[ɈړȂB
		return;
	}

	// ubN}[Nj[݂Ƃ̂݃ubN}[Nj[֍sB
	Bookmark *menu = bookmarkTree->getFolderByAttribute(Bookmark::menuBar);
	if (menu != NULL){
		writer->upToBookmarkMenu();	// ubN}[Nj[ɖ߂B
	}
}

/**
 * ϊ̃vZXłB
 *
 * @param config ݒIuWFNg
 */
int convertAttribute(Configuration *config)
{
	AttributeWriter *attributeWriter;
	int property;

	property = config->getProperty();
	if (property < 1) {
		// D悷鑮Ȃꍇ͂ŔB
		return 0;
	}

	bookmarkTree->upToTop();	// ԍŏɖ߂B

	try {
		attributeWriter = new AttributeWriter();

		attributeWriter->setBrowserType(totalNoToType(property));
		attributeWriter->setBrowserNo(totalNoToSubNo(property));
	}catch(...) {
		return 1;
	}

	// c[IuWFNgɑoIuWFNgݒ肷B
	bookmarkTree->setWriter(attributeWriter);
	bookmarkTree->setBrowser(-1);
	Bookmark::setSortTarget(-1);

	// ϊJnB
	bookmarkTree->putAll();

	delete attributeWriter;

	return 0;
}

/**
 * ǂݍ݂̃vZXłB
 *
 * @param config ݒIuWFNg
 * @return 0:ϊE !0:ϊEs
 */
int readProcess(Configuration *config)
{
	int result = 0;

	bookmarkTree->upToTop();	// ԍŏɖ߂B

	for (int order = 0;order < ALL_BOOKMARKS;order++) {
		int no,subNo;

		if (s_cancel){
			return -1;
		}

		writer->setMainBrowser(false);
		no = config->getReadOrder(order);
		switch (no) {
			case BOOKMARK_IE:	// IE
				if (s_config->getConvertFrom(BOOKMARK_IE)){
					changeMessage(4);
					// ҏWΏۂǂ
					if ((!s_config->getEditMode()) || (s_config->getEditTarget() == BOOKMARK_IE)){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B

					result = readIeBookmark();
					if (result){
						MessageBox(NULL,"IÊCɓ̓ǂ݂݂Ɏs܂B",
							"G[",MB_OK | MB_ICONEXCLAMATION);
						logger->debug("IE favorites read failed");
						return result;
					}
					addProgressCount();
				}
				break;
#ifdef WITH_EDGE
			case BOOKMARK_EDGE:	// Edge
				if (s_config->getConvertFrom(BOOKMARK_EDGE)) {
					changeMessage(35);
					// ҏWΏۂǂ
					if ((!s_config->getEditMode()) || (s_config->getEditTarget() == BOOKMARK_EDGE)) {
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}
					else {
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B

					result = readEdgeBookmark2();
					if (result) {
						MessageBox(NULL, "EdgêCɓ̓ǂ݂݂Ɏs܂B",
							"G[", MB_OK | MB_ICONEXCLAMATION);
						logger->debug("Edge favorites read failed");
						return result;
					}
					addProgressCount();
				}
				break;
#endif	// WITH_EDGE
			case BOOKMARK_MOZILLA_1:	// Mozilla
			case BOOKMARK_MOZILLA_2:
				subNo = no - BOOKMARK_MOZILLA_1;
				if (s_config->getConvertFrom(BOOKMARK_MOZILLA_1 + subNo)){
					changeMessage(subNo);
					// ҏWΏۂǂ
					if ( (!s_config->getEditMode()) || 
						((totalNoToType(s_config->getEditTarget()) == BOOKMARK_TYPE_MOZILLA) && (totalNoToSubNo(s_config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B

					result = readMozillaBookmark(subNo);
					if (result){
						if (no == 1) {
							MessageBox(NULL,"Firefox 2/Netscape/MozillãubN}[N1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Mozilla bookmark 1 read failed");
						} else {
							MessageBox(NULL,"Firefox 2/Netscape/MozillãubN}[N2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Mozilla bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
				}
				break;
			case BOOKMARK_OPERA_1:	// Opera
			case BOOKMARK_OPERA_2:
				subNo = no - BOOKMARK_OPERA_1;
				if (s_config->getConvertFrom(BOOKMARK_OPERA_1 + subNo)){
					changeMessage(2 + subNo);
					// ҏWΏۂǂ
					if ( (!s_config->getEditMode()) || 
						((totalNoToType(s_config->getEditTarget()) == BOOKMARK_TYPE_OPERA) && (totalNoToSubNo(s_config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B

					result = readOperaBookmark(subNo);
					if (result){
						if (no == BOOKMARK_OPERA_1) {
							MessageBox(NULL,"Opera 12ȑÕubN}[N1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Opera bookmark 1 read failed");
						} else {
							MessageBox(NULL,"Opera 12ȑÕubN}[N2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Opera bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
				}
				break;
			case BOOKMARK_FIREFOX_1:	// Firefox 3
			case BOOKMARK_FIREFOX_2:
				subNo = no - BOOKMARK_FIREFOX_1;
				if (s_config->getConvertFrom(BOOKMARK_FIREFOX_1 + subNo)){
					changeMessage(11 + subNo);
					onlyMenuFlag = false;	// j[ȊÔ݂̂B
					// ҏWΏۂǂ
					if ( (!s_config->getEditMode()) || 
						((totalNoToType(s_config->getEditTarget()) == BOOKMARK_TYPE_FIREFOX) && (totalNoToSubNo(s_config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B
					int result = readFxBookmark(subNo);
					if (result){
						if (no == BOOKMARK_FIREFOX_1) {
							MessageBox(NULL,"Firefox 3̃ubN}[N1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Firefox bookmark 1 read failed");
						} else {
							MessageBox(NULL,"Firefox 3̃ubN}[N2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Firefox bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
					hasMobileBookmark = true;
				}
				break;
			case BOOKMARK_SAFARI_1:	// Safari
			case BOOKMARK_SAFARI_2:
				subNo = no - BOOKMARK_SAFARI_1;
				if (config->getConvertFrom(BOOKMARK_SAFARI_1 + subNo)){
					changeMessage(15 + subNo);
					onlyMenuFlag = false;	// j[ȊÔ݂̂B
					// ҏWΏۂǂ
					if ( (!config->getEditMode()) || 
						((totalNoToType(config->getEditTarget()) == BOOKMARK_TYPE_SAFARI) && (totalNoToSubNo(config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B
					int result = readSfBookmark(subNo);
					if (result){
						if (no == BOOKMARK_SAFARI_1) {
							MessageBox(NULL,"SafarĩubN}[N1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Safari bookmark 1 read failed");
						} else {
							MessageBox(NULL,"SafarĩubN}[N2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Safari bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
				}
				break;
			case BOOKMARK_CHROME_1:	// Chrome
			case BOOKMARK_CHROME_2:
				subNo = no - BOOKMARK_CHROME_1;
				if (config->getConvertFrom(BOOKMARK_CHROME_1 + subNo)){
					changeMessage(19 + subNo);
					onlyMenuFlag = false;	// j[ȊÔ݂̂B
					// ҏWΏۂǂ
					if ( (!config->getEditMode()) || 
						((totalNoToType(config->getEditTarget()) == BOOKMARK_TYPE_CHROME) && (totalNoToSubNo(config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B
					int result = readChBookmark(subNo);
					if (result){
						if (no == BOOKMARK_CHROME_1) {
							MessageBox(NULL,"ChromẽubN}[N1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Chrome bookmark 1 read failed");
						} else {
							MessageBox(NULL,"ChromẽubN}[N2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Chrome bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
					hasMobileBookmark = true;
				}
				break;
			case BOOKMARK_XBEL_1:	// XBEL
			case BOOKMARK_XBEL_2:
				subNo = no - BOOKMARK_XBEL_1;
				if (config->getConvertFrom(BOOKMARK_XBEL_1 + subNo)){
					changeMessage(23 + subNo);
					// ҏWΏۂǂ
					if ( (!config->getEditMode()) || 
						((totalNoToType(config->getEditTarget()) == BOOKMARK_TYPE_XBEL) && (totalNoToSubNo(config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B
					int result = readXbBookmark(subNo);
					if (result){
						if (no == BOOKMARK_XBEL_1) {
							MessageBox(NULL,"XBELt@C1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("XBEL bookmark 1 read failed");
						} else {
							MessageBox(NULL,"XBELt@C2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("XBEL bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
				}
				break;
#ifdef WITH_OP15
			case BOOKMARK_OPERA15_1:	// Opera 15Xs[h_C
			case BOOKMARK_OPERA15_2:
				subNo = no - BOOKMARK_OPERA15_1;
				if (s_config->getConvertFrom(BOOKMARK_OPERA15_1 + subNo)){
					changeMessage(27 + subNo);
					// ҏWΏۂǂ
					if ( (!s_config->getEditMode()) || 
						((totalNoToType(s_config->getEditTarget()) == BOOKMARK_TYPE_OPERA15) && (totalNoToSubNo(s_config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B

					result = readOp15Bookmark(subNo);
					if (result){
						if (no == BOOKMARK_OPERA15_1) {
							MessageBox(NULL,"Opera 15`28̃Xs[h_C1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Opera 15 bookmark 1 read failed");
						} else {
							MessageBox(NULL,"Opera 15`28̃Xs[h_C2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Opera 15 bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
				}
				break;
#endif	// WITH_OP15
			case BOOKMARK_OPERA25_1:	// Opera 25 ubN}[N
			case BOOKMARK_OPERA25_2:
				subNo = no - BOOKMARK_OPERA25_1;
				if (config->getConvertFrom(BOOKMARK_OPERA25_1 + subNo)){
					changeMessage(31 + subNo);
					onlyMenuFlag = false;	// j[ȊÔ݂̂B
					// ҏWΏۂǂ
					if ( (!config->getEditMode()) || 
						((totalNoToType(config->getEditTarget()) == BOOKMARK_TYPE_OPERA25) && (totalNoToSubNo(config->getEditTarget()) == subNo))
					){
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}else{
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B
					int result = readOp25Bookmark(subNo);
					if (result){
						if (no == BOOKMARK_OPERA25_1) {
							MessageBox(NULL,"Opera 25ȍ~̃ubN}[N1̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Opera 25 bookmarks 1 read failed");
						} else {
							MessageBox(NULL,"Opera 25ȍ~̃ubN}[N2̓ǂ݂݂Ɏs܂B",
								"G[",MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Opera 25 bookmarks 2 read failed");
						}
						return result;
					}
					addProgressCount();
					// hasMobileBookmark = true;
				}
				break;
			case BOOKMARK_VIVALDI_1:	// Vivaldi
			case BOOKMARK_VIVALDI_2:
				subNo = no - BOOKMARK_VIVALDI_1;
				if (config->getConvertFrom(BOOKMARK_VIVALDI_1 + subNo)) {
					changeMessage(38 + subNo);
					onlyMenuFlag = true;	// j[ȊÔ݂̂Ȃ
											// ҏWΏۂǂ
					if ((!config->getEditMode()) ||
						((totalNoToType(config->getEditTarget()) == BOOKMARK_TYPE_VIVALDI) &&
						(totalNoToSubNo(config->getEditTarget()) == subNo))
						) {
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					} else {
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B
					int result = readViBookmark(subNo);
					if (result) {
						if (no == BOOKMARK_VIVALDI_1) {
							MessageBox(NULL, "VivaldĩubN}[N1̓ǂ݂݂Ɏs܂B",
								"G[", MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Vivaldi bookmark 1 read failed");
						} else {
							MessageBox(NULL, "VivaldĩubN}[N2̓ǂ݂݂Ɏs܂B",
								"G[", MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Vivaldi bookmark 2 read failed");
						}
						return result;
					}
					addProgressCount();
				}
				break;
			case BOOKMARK_EDGE2_1:	// Edge(Chromium)
			case BOOKMARK_EDGE2_2:
				subNo = no - BOOKMARK_EDGE2_1;
				if (config->getConvertFrom(BOOKMARK_EDGE2_1 + subNo)) {
					changeMessage(42 + subNo);
					onlyMenuFlag = false;	// j[ȊÔ݂̂B
					// ҏWΏۂǂ
					if ((!config->getEditMode()) ||
						((totalNoToType(config->getEditTarget()) == BOOKMARK_TYPE_EDGE2) && (totalNoToSubNo(config->getEditTarget()) == subNo))
						) {
						bookmarkTree->setMainBrowser(true);
						writer->setMainBrowser(true);
					}
					else {
						bookmarkTree->setMainBrowser(false);
					}
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					writer->reset();	// ԍŏɖ߂B
					int result = readEdge2Bookmark(subNo);
					if (result) {
						if (no == BOOKMARK_CHROME_1) {
							MessageBox(NULL, "EdgêCɓ1̓ǂ݂݂Ɏs܂B",
								"G[", MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Edge favorite 1 read failed");
						}
						else {
							MessageBox(NULL, "EdgêCɓ2̓ǂ݂݂Ɏs܂B",
								"G[", MB_OK | MB_ICONEXCLAMATION);
							logger->debug("Edge favorite 2 read failed");
						}
						return result;
					}
					addProgressCount();
					hasMobileBookmark = true;
				}
				break;
		}
		if (s_cancel){
			return -1;
		}
	}
	return 0;
}

/**
 * Opera 25ȍ~ŗL̃tH_̓eQƂƂɂB
 * Opera 25ȊOŃubN}[NҏWɎgpB
 *
 * @param bookmarkTree QƂtubN}[Nc[
 */
void setOperaSpecialRefer(BookmarkTree *bookmarkTree)
{
	bookmarkTree->upToTop();	// ԍŏɖ߂B

	bm_listitem *targetNode = bookmarkTree->getFolderNodeByAttribute(Bookmark::menuBar);
	BOOKLIST *customRootList = targetNode->getChild();
	BOOKLIST::iterator iter;

	for (iter = customRootList->begin(); iter != customRootList->end(); ++iter){
		Bookmark *bm = iter->getBookmark();
		switch (bm->getOp25Bookmark(0)->getFolderType()) {
			case Op25Bookmark::shared:
			case Op25Bookmark::speedDial:
			case Op25Bookmark::imported:
				if (!iter->getRefer()) {
					iter->addRefer();
					bookmarkTree->setReferAll(iter->getChild(), true);
				}
				break;
		}
		switch (bm->getOp25Bookmark(1)->getFolderType()) {
			case Op25Bookmark::shared:
			case Op25Bookmark::speedDial:
			case Op25Bookmark::imported:
				if (!iter->getRefer()) {
					iter->addRefer();
					bookmarkTree->setReferAll(iter->getChild(), true);
				}
				break;
		}
	}
}

/**
 * ݂̃vZXłB
 *
 * @param config ݒIuWFNg
 * @return 0:ϊE !0:ϊEs
 */
int writeProcess(Configuration *config)
{
	// Firefox 3/Opera 15Xs[h_CDBւ̎QƂ̏
	for (int i = 0; i < 2; i++) {
		fxWriters[i] = NULL;
#ifdef WITH_OP15
		op15Writers[i] = NULL;
#endif	// WITH_OP15
	}

	if (s_config->getEditMode()) {
		switch (totalNoToType(s_config->getEditTarget())) {
			case BOOKMARK_TYPE_OPERA25:	// Opera 25
				break;
			default:
				// Opera 25ȊȌꍇOpera 25ŗL̍ڂɎQƂtB
				setOperaSpecialRefer(bookmarkTree);
				break;
		}
	}

	// ̃ubN}[NłOpera 29̃Xs[h_Co͂邩
	bookmarkTree->setOp29SpeedDialPut(s_config->getOp29SpeedDialPut());

	if (s_config->getEditMode()) {
		switch (totalNoToType(s_config->getEditTarget())) {
			case BOOKMARK_TYPE_VIVALDI:	// Vivaldi
				// VivaldĩubN}[No[̓Ώۂɂđ݂Ȃ
				// ɂĂ͌̃ubN}[N̂܂܂ƂB
				bookmarkTree->upToTop();	// ԍŏɖ߂B
				// ubN}[Nj[ȊOɎQƂB
				bookmarkTree->setTopRefer();
		}
	}

	//
	// ̓ubN}[Nj[ƓƗubN}[Nc[o[
	// ݂ȂO[v
	//

	// IE
	if (s_config->getConvertTo(BOOKMARK_IE)){
		bookmarkTree->upToTop();	// ԍŏɖ߂B
		changeMessage(6);
		writeIeBookmark();
		addProgressCount();
	}

#if 0
//#ifdef WITH_EDGE
	// Edge
	if (s_config->getConvertTo(BOOKMARK_EDGE)) {
		bookmarkTree->upToTop();	// ԍŏɖ߂B
		changeMessage(36);
		writeEdgeBookmark();
		addProgressCount();
	}
#endif	// WITH_EDGE

	// IE̖OgpƂ́AWindows VistaLinkstH_̖O
	// l[ĂB(SāAȂ񂾂悻B)
	//if (ieName){
	//	renameLinkFolder();
	//}

	// Mozillan
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_MOZILLA_1 + i)){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(7 + i);
			int result = writeMozillaBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"Firefox 2/Netscape/MozillãubN}[N1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Mozilla bookmark 1 write failed");
				} else {
					MessageBox(NULL,"Firefox 2/Netscape/MozillãubN}[N2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Mozilla bookmark 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	// Opera
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_OPERA_1 + i)){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(9 + i);
			int result = writeOperaBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"OperãubN}[N1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Opera bookmark 1 write failed");
				} else {
					MessageBox(NULL,"OperãubN}[N2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Opera bookmark 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	// XBEL(QtWebCAEgȊO)
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_XBEL_1 + i) &&
			(s_config->getXbLayout(i) != XBEL_LAYOUT_QTWEB)
			){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(25 + i);
			int result = writeXbelBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"XBELt@C1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("XBEL file 1 write failed");
				} else {
					MessageBox(NULL,"XBELt@C2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("XBEL file 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

#ifdef WITH_OP15
	// Opera 15
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_OPERA15_1 + i)){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(29 + i);
			int result = writeOp15Bookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"Opera 15`28̃Xs[h_C1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Opera 15 bookmark 1 write failed");
				} else {
					MessageBox(NULL,"Opera 15`28̃Xs[h_C2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Opera 15 bookmark 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}
#endif	// WITH_OP15

	// VivaldĩubN}[N(ϊłׂẴubN}[NϊΏۂɂƂ)
	for (int i = 0; i < 2; i++) {
		if (s_config->getConvertTo(BOOKMARK_VIVALDI_1 + i)) {
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(40 + i);
			int result = writeViBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL, "VivaldĩubN}[N1ւ݂̏Ɏs܂B",
						"G[", MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Vivaldi bookmarks 1 write failed");
				} else {
					MessageBox(NULL, "VivaldĩubN}[N2ւ݂̏Ɏs܂B",
						"G[", MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Vivaldi bookmarks 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	if (s_config->getEditMode()) {
		// ҏW[hFirefox 3/Safari/Chrome/Opera 25/Edge(Chromium)ȊÔ̂w肵ꍇ
		// c[o[ɎQƃtOȂ̂ŎQƃtOB
		switch (totalNoToType(s_config->getEditTarget())) {
			case BOOKMARK_TYPE_IE:	// IE
#ifdef WITH_EDGE
			case BOOKMARK_TYPE_EDGE:	// Edge
#endif
			case BOOKMARK_TYPE_MOZILLA:	// Firefox 2/SeaMonkey 2/Netscape/Mozilla
			case BOOKMARK_TYPE_OPERA:	// Opera
#ifdef WITH_OP15
			case BOOKMARK_TYPE_OPERA15:	// Opera 15
#endif	// WITH_OP15
				bookmarkTree->upToTop();	// ԍŏɖ߂B
				bookmarkTree->setTopRefer();
				break;
			case BOOKMARK_TYPE_SAFARI:	// Safari
				bookmarkTree->setTagsRefer();	// Firefox 3̃^O
				break;
			case BOOKMARK_TYPE_XBEL:	// XBEL
				if (s_config->getXbLayout(totalNoToSubNo(s_config->getEditTarget()))
					!= XBEL_LAYOUT_QTWEB) {
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					bookmarkTree->setTopRefer();
				} else {
					bookmarkTree->upToTop();	// ԍŏɖ߂B
					bookmarkTree->setUnfiledRefer();	// ̃ubN}[NɎQƃtOtB
				}
				break;
			case BOOKMARK_TYPE_CHROME:	// Chrome
				bookmarkTree->upToTop();	// ԍŏɖ߂B
				bookmarkTree->setUnfiledRefer();	// ̃ubN}[NɎQƃtOtB
				break;
			case BOOKMARK_TYPE_VIVALDI:	// Vivaldi
				bookmarkTree->upToTop();	// ԍŏɖ߂B
				bookmarkTree->setTopRefer();
				break;
			case BOOKMARK_TYPE_EDGE2:	// Edge(Chromium)
				bookmarkTree->upToTop();	// ԍŏɖ߂B
				bookmarkTree->setUnfiledRefer();	// ̃ubN}[NɎQƃtOtB
				break;
		}
	}

	//
	// ̓ubN}[Nj[ƓƗubN}[Nc[o[
	// ݂O[v
	//

	// IE/EdgeϊŁANtH_ϊΏۂɂȂꍇ
	if (((s_config->getConvertFrom(BOOKMARK_IE)) && s_config->getIeNoLinkToMenu()) ||
		((s_config->getConvertFrom(BOOKMARK_EDGE)) && s_config->getEdgeNoLinkToMenu())) {
		// NtH_ւ̎QƂ͂
		unreferIeLinkFolder();
	}

	// XBEL(QtWebCAEg)
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_XBEL_1 + i) &&
			(s_config->getXbLayout(i) == XBEL_LAYOUT_QTWEB)
			){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(25 + i);
			int result = writeXbelBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"XBELt@C1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("XBEL file 1 write failed");
				} else {
					MessageBox(NULL,"XBELt@C2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("XBEL file 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	// Firefox
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_FIREFOX_1 + i)){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(13 + i);
			int result = writeFxBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"Firefox 3̃ubN}[N1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Firefox bookmark 1 write failed");
				} else {
					MessageBox(NULL,"Firefox 3̃ubN}[N2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Firefox bookmark 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	// Safari
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_SAFARI_1 + i)){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(17 + i);
			int result = writeSafariBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"SafarĩubN}[N1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Safari bookmark 1 write failed");
				} else {
					MessageBox(NULL,"SafarĩubN}[N2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Safari bookmark 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	// Chrome
	// ChromẽubN}[Nɂ͕KubN}[Nc[o[tH_A
	// ̑̃tH_Kv
	addLinkFolder(bookmarkTree);
	// ubN}[Nc[o[tH_̒ǉ
	bookmarkTree->upToTop();
	bookmarkTree->setMainBrowser(true);
	addBookmarkMenu(0);
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_CHROME_1 + i)){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(21 + i);
			int result = writeChromeBookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"ChromẽubN}[N1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Chrome bookmark 1 write failed");
				} else {
					MessageBox(NULL,"ChromẽubN}[N2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Chrome bookmark 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	// Opera 25ȍ~̃ubN}[N
	for (int i = 0;i < 2;i++){
		if (s_config->getConvertTo(BOOKMARK_OPERA25_1 + i)){
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(33 + i);
			int result = writeOp25Bookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL,"Opera 25ȍ~̃ubN}[N1ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Opera 25 bookmarks 1 write failed");
				} else {
					MessageBox(NULL,"Opera 25ȍ~̃ubN}[N2ւ݂̏Ɏs܂B",
						"G[",MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Opera 25 bookmarks 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	// Edge(Chromium)̃ubN}[N
	for (int i = 0; i < 2; i++) {
		if (s_config->getConvertTo(BOOKMARK_EDGE2_1 + i)) {
			bookmarkTree->upToTop();	// ԍŏɖ߂B
			changeMessage(44 + i);
			int result = writeEdge2Bookmark(i);
			if (result) {
				if (i == 0) {
					MessageBox(NULL, "EdgêCɓ1ւ݂̏Ɏs܂B",
						"G[", MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Edge favorite 1 write failed");
				}
				else {
					MessageBox(NULL, "EdgêCɓ2ւ݂̏Ɏs܂B",
						"G[", MB_OK | MB_ICONEXCLAMATION);
					logger->debug("Edge favorite 2 write failed");
				}
				return result;
			}
			addProgressCount();
		}
	}

	return 0;
}



/**
 * ̃vZXłB
 *
 * @param config ݒIuWFNg
 * @return 0:ϊE !0:ϊEs
 */
int syncProcess(Configuration *config)
{
	int result = 0;

	s_cancelable = true;

	// ubN}[NECɓǂݍ
	logger->debug("Reading process start.");
	result = readProcess(config);
	if (result) {
		logger->debug("Read failed.");
		return result;
	}

	// uEUŗL̑𑼂̃ubN}[NɔfB
	result = convertAttribute(config);
	if (result) {
		return result;
	}


	// IE/EdgẽNtH_̓eFirefox 3/Safari/Chrome/Opera 25̃ubN}[Nc[o[
	// fB
	if ((s_config->getIeSyncronizeFxLinkFolder() && s_config->getConvertFrom(BOOKMARK_IE)) || 
		(s_config->getEdgeSyncronizeFxLinkFolder() && s_config->getConvertFrom(BOOKMARK_EDGE))) {
		logger->debug("Convert IE/Edge Linkbar to bookmarks bar.");
		writeIeLinkFolder();
	}

	// Firefox 3/Safari/Chrome/Opera 25/Edge(Chromium)̃ubN}[Nc[o[̓eIẼNtH_
	// fB
	if ((s_config->getIeSyncronizeFxLinkFolder() && s_config->getConvertTo(BOOKMARK_IE)) ||
		(s_config->getEdgeSyncronizeFxLinkFolder() && s_config->getConvertTo(BOOKMARK_EDGE)) ) {
		logger->debug("Convert bookmarks bar to IE Linkbar.");
		writeFxLinkFolder();
	}

	s_cancelable = false;
	// uIÊCɓvɃ`FbNĂƂ̏
	if (s_config->getConvertTo(BOOKMARK_IE)){
		if (s_config->getIeEraseFavorite()){
			logger->debug("Clear IE favorites.");
			changeMessage(5);
			result = deleteIEbookmark(s_config->getIePath().c_str(), s_config->getIeIgnoreLinkFolder());
			if (result){
				logger->debug("Clear IE favorites failed.");
				return result;
			}
		}
	}

#if 0
//#ifdef WITH_EDGE
	// uEdgêCɓvɃ`FbNĂƂ̏
	if (s_config->getConvertTo(BOOKMARK_EDGE)) {
		if (s_config->getEdgeEraseFavorite()) {
			logger->debug("Clear Edge favorites.");
			changeMessage(37);
			result = deleteIEbookmark(s_config->getEdgePath().c_str(), s_config->getEdgeIgnoreLinkFolder());
			if (result) {
				logger->debug("Clear Edge favorites failed.");
				return result;
			}
		}
	}
#endif	// WITH_EDGE

	// ubN}[NECɓ菑
	logger->debug("Writing process start.");
	int writeResult = writeProcess(config);
	if (writeResult) {
		logger->debug("Write failed.");
		// sqlite DB̃[obNsB
		for (int i = 0;i < 2;i++) {
			// Firefox 3̃ubN}[N
			if (fxWriters[i] != NULL) {
				delete fxWriters[i];
			}
#ifdef WITH_OP15
			// Opera 15`28̃Xs[h_C
			if (op15Writers[i] != NULL) {
				delete op15Writers[i];
			}
#endif	// WITH_OP15
		}
		return writeResult;
	}

	// ݂Ie|t@CϊΏۂ̃ubN}[Nɖ߂B
	logger->debug("Commit start.");
	int writeBackResult = writeTargetFile();

	return writeBackResult;
}

/**
 * EϊݒOɏo͂
 *
 * @param config Eϊݒ
 */
void putConfig(Configuration *config)
{
	if (config->getLogLevel() != Logger::DEBUG) {
		return;
	}
	// ǂݍݐݒ
	if (config->getConvertFrom(BOOKMARK_IE)) {
		logger->debug("Read IE Favorites:YES");
		if (config->getIeIgnoreLinkFolder()) {
			logger->debug("  Ignore IE's link folder:YES");
		}
		if (config->getIeSyncronizeFxLinkFolder()) {
			logger->debug("  Convert IE's link folder to Firefox 3 Bookmark tool bar:YES");
		}
		if (config->getIeNoLinkToMenu()) {
			logger->debug("  Don't Convert IE's link folder to Firefox 3 Bookmark menu:YES");
		}
	}

#ifdef WITH_EDGE
	if (config->getConvertFrom(BOOKMARK_EDGE)) {
		logger->debug("Read Edge Favorites:YES");
		if (config->getEdgeIgnoreLinkFolder()) {
			logger->debug("  Ignore Edge's link folder:YES");
		}
		if (config->getEdgeSyncronizeFxLinkFolder()) {
			logger->debug("  Convert Edge's link folder to Firefox 3 Bookmark tool bar:YES");
		}
		if (config->getEdgeNoLinkToMenu()) {
			logger->debug("  Don't Convert Edge's link folder to Firefox 3 Bookmark menu:YES");
		}
	}
#endif	// WITH_EDGE

	if (config->getConvertFrom(BOOKMARK_MOZILLA_1)) {
		logger->debug("Read Firefox 2 Bookmarks 1:YES");
	}
	if (config->getConvertFrom(BOOKMARK_MOZILLA_2)) {
		logger->debug("Read Firefox 2 Bookmarks 2:YES");
	}
	if (config->getConvertFrom(BOOKMARK_OPERA_1)) {
		logger->debug("Read Opera Bookmarks 1:YES");
		if (config->getOpera7Format(0)) {
			logger->debug("  Opera 7 format:YES");
		}
		if (config->getOperaIgnoreTrush(0)) {
			logger->debug("  Ignore Opera's trash folder:YES");
		}
		if (config->getOperaWinMobile(0)) {
			logger->debug("  Opera 9.5 for Windows Mobile format:YES");
		}
		if (config->getOperaSyncMobile(0)) {
			logger->debug("  Synchronize to Windows Mobile's favorites:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_OPERA_2)) {
		logger->debug("Read Opera Bookmarks 2:YES");
		if (config->getOpera7Format(1)) {
			logger->debug("  Opera 7 format:YES");
		}
		if (config->getOperaIgnoreTrush(1)) {
			logger->debug("  Ignore Opera's trash folder:YES");
		}
		if (config->getOperaWinMobile(1)) {
			logger->debug("  Opera 9.5 for Windows Mobile format:YES");
		}
		if (config->getOperaSyncMobile(1)) {
			logger->debug("  Synchronize to Windows Mobile's favorites:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_FIREFOX_1)) {
		logger->debug("Read Firefox 3 Bookmarks 1:YES");
		if (config->getFxIgnoreToolbar(0)) {
			logger->debug("  Ignore Firefox's Bookmark Toolbar folder:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_FIREFOX_2)) {
		logger->debug("Read Firefox 3 Bookmarks 2:YES");
		if (config->getFxIgnoreToolbar(1)) {
			logger->debug("  Ignore Firefox's Bookmark Toolbar folder:YES");
		}
	}

	if (config->getConvertFrom(BOOKMARK_SAFARI_1)) {
		logger->debug("Read Safari Bookmarks 1:YES");
		if (config->getSfIgnoreToolbar(0)) {
			logger->debug("  Ignore Safari's Bookmark Toolbar folder:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_SAFARI_2)) {
		logger->debug("Read Safari Bookmarks 2:YES");
		if (config->getSfIgnoreToolbar(1)) {
			logger->debug("  Ignore Safari's Bookmark Toolbar folder:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_CHROME_1)) {
		logger->debug("Read Chrome Bookmarks 1:YES");
		if (config->getChIgnoreToolbar(0)) {
			logger->debug("  Ignore Chrome's Bookmark Toolbar folder:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_CHROME_2)) {
		logger->debug("Read Chrome Bookmarks 2:YES");
		if (config->getChIgnoreToolbar(1)) {
			logger->debug("  Ignore Chrome's Bookmark Toolbar folder:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_XBEL_1)) {
		logger->debug("Read XBEL file 1:YES");
		if (config->getXbIgnoreToolbar(0)) {
			logger->debug("  Ignore XBEL's Bookmark Toolbar folder:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_XBEL_2)) {
		logger->debug("Read XBEL file 2:YES");
		if (config->getXbIgnoreToolbar(1)) {
			logger->debug("  Ignore XBEL's Bookmark Toolbar folder:YES");
		}
	}
#ifdef WITH_OP15
	if (config->getConvertFrom(BOOKMARK_OPERA15_1)) {
		logger->debug("Read Opera 15 Bookmarks 1:YES");
	}
	if (config->getConvertFrom(BOOKMARK_OPERA15_2)) {
		logger->debug("Read Opera 15 Bookmarks 2:YES");
	}
#endif	// WITH_OP15
	if (config->getConvertFrom(BOOKMARK_OPERA25_1)) {
		logger->debug("Read Opera 25 Bookmarks 1:YES");
	}
	if (config->getConvertFrom(BOOKMARK_OPERA25_2)) {
		logger->debug("Read Opera 25 Bookmarks 2:YES");
	}
	if (config->getConvertFrom(BOOKMARK_VIVALDI_1)) {
		logger->debug("Read Vivaldi Bookmarks 1:YES");
	}
	if (config->getConvertFrom(BOOKMARK_VIVALDI_2)) {
		logger->debug("Read Vivaldi Bookmarks 2:YES");
	}
	if (config->getConvertFrom(BOOKMARK_EDGE2_1)) {
		logger->debug("Read Edge favorites 1:YES");
		if (config->getChIgnoreToolbar(0)) {
			logger->debug("  Ignore Edge's Favorites Toolbar folder:YES");
		}
	}
	if (config->getConvertFrom(BOOKMARK_EDGE2_2)) {
		logger->debug("Read Edge favorites 2:YES");
		if (config->getChIgnoreToolbar(1)) {
			logger->debug("  Ignore Edge's Favorites Toolbar folder:YES");
		}
	}

	// ݐݒ
	if (config->getConvertTo(BOOKMARK_IE)) {
		logger->debug("Write IE Favorites:YES");
	}
#ifdef WITH_EDGE
	if (config->getConvertTo(BOOKMARK_EDGE)) {
		logger->debug("Write Edge Favorites:YES");
	}
#endif	// WITH_EDGE
	if (config->getConvertTo(BOOKMARK_MOZILLA_1)) {
		logger->debug("Write Firefox 2 Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_MOZILLA_2)) {
		logger->debug("Write Firefox 2 Bookmarks 2:YES");
	}
	if (config->getConvertTo(BOOKMARK_OPERA_1)) {
		logger->debug("Write Opera Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_OPERA_2)) {
		logger->debug("Write Opera Bookmarks 2:YES");
	}
	if (config->getConvertTo(BOOKMARK_FIREFOX_1)) {
		logger->debug("Write Firefox 3 Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_FIREFOX_2)) {
		logger->debug("Write Firefox 3 Bookmarks 2:YES");
	}
	if (config->getConvertTo(BOOKMARK_SAFARI_1)) {
		logger->debug("Write Safari Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_SAFARI_2)) {
		logger->debug("Write Safari Bookmarks 2:YES");
	}
	if (config->getConvertTo(BOOKMARK_CHROME_1)) {
		logger->debug("Write Chrome Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_CHROME_2)) {
		logger->debug("Write Chrome Bookmarks 2:YES");
	}
	if (config->getConvertTo(BOOKMARK_XBEL_1)) {
		logger->debug("Write XBEL file 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_XBEL_2)) {
		logger->debug("Write XBEL file 2:YES");
	}

#ifdef WITH_OP15
	if (config->getConvertTo(BOOKMARK_OPERA15_1)) {
		logger->debug("Write Opera 15 Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_OPERA15_2)) {
		logger->debug("Write Opera 15 Bookmarks 2:YES");
	}
#endif	// WITH_OP15
	if (config->getConvertTo(BOOKMARK_OPERA25_1)) {
		logger->debug("Write Opera 25 Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_OPERA25_2)) {
		logger->debug("Write Opera 25 Bookmarks 2:YES");
	}
	if (config->getConvertTo(BOOKMARK_VIVALDI_1)) {
		logger->debug("Write Vivaldi Bookmarks 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_OPERA25_2)) {
		logger->debug("Write Vivaldi Bookmarks 2:YES");
	}
	if (config->getConvertTo(BOOKMARK_EDGE2_1)) {
		logger->debug("Write Edge Favorites 1:YES");
	}
	if (config->getConvertTo(BOOKMARK_EDGE2_2)) {
		logger->debug("Write Edge Favorites 2:YES");
	}


	// eݒ
	switch (config->getProperty()) {
		case 0:
			logger->debug("Prefferd attribute:none");
			break;
		case 1:
			logger->debug("Prefferd attribute:Firefox 3-1");
			break;
		case 2:
			logger->debug("Prefferd attribute:Firefox 3-2");
			break;
		case 3:
			logger->debug("Prefferd attribute:Chrome 1");
			break;
		case 4:
			logger->debug("Prefferd attribute:Chrome 2");
			break;
		case 5:
			logger->debug("Prefferd attribute:XBEL 1");
			break;
		case 6:
			logger->debug("Prefferd attribute:XBEL 2");
			break;
		case 7:
			logger->debug("Prefferd attribute:Mozilla 1");
			break;
		case 8:
			logger->debug("Prefferd attribute:Mozilla 2");
			break;
		case 9:
			logger->debug("Prefferd attribute:Opera 1");
			break;
		case 10:
			logger->debug("Prefferd attribute:Opera 2");
			break;
	}

	switch (config->getSortType()) {
		case 0:
			logger->debug("Sort type:Original order");
			break;
		case 1:
			logger->debug("Sort type:By name(prefer directory)");
			break;
		case 2:
			logger->debug("Sort type:By name");
			break;
		case 3:
			logger->debug("Sort type:By URL");
			break;
		case 4:
			logger->debug("Sort type:None");
			break;
	}

	if (config->getUpdate()){
		logger->debug("Update:YES");
	} else {
		logger->debug("Update:NO");
	}
	if (config->getLeaveDuplicateName()) {
		logger->debug("Leave duplicate name:YES");
	}
	if (config->getConvertAll()) {
		logger->debug("Put all bookmarks to IE/Firefox 2/Opera:YES");
	}
	if (config->getPlacesPut()) {
		logger->debug("Put Firefox 3 Places URL:YES");
	}
	if (config->getIeEraseFavorite()) {
		logger->debug("Delete IE's favorites before convert:YES");
	}
	if (config->getIeSyncronizeLinkFolder()) {
		logger->debug("Synchronize IE's link folder to Firefox 2/Opera:YES");
	}
	if (config->getIeSyncronizeFxLinkFolder()) {
		logger->debug("Synchronize IE's link folder to Firefox 3/Safari/Chrome:YES");
	}

#ifdef WITH_EDGE
	if (config->getEdgeEraseFavorite()) {
		logger->debug("Delete Edge's favorites before convert:YES");
	}
	if (config->getEdgeSyncronizeLinkFolder()) {
		logger->debug("Synchronize Edge's link folder to Firefox 2/Opera:YES");
	}
	if (config->getEdgeSyncronizeFxLinkFolder()) {
		logger->debug("Synchronize Edge's link folder to Firefox 3/Safari/Chrome:YES");
	}
#endif
}

/**
 * ubN}[Nǂݍ݂܂B
 *
 * @param config ϊEݒIuWFNg
 * @return 0:ϊE !0:ϊEs
 */
int startConvert(Configuration *config)
{
	s_config = config;
	int result = 0;	// 
	onlyMenuFlag = true;

	try {
		logger = NULL;
		logger = new Logger();
		bookmarkTree = new BookmarkTree();
		writer = new TreeWriter();

		// TreeWriteȑo͐
		writer->setBookmarkTree(bookmarkTree);

	}catch(...){
		result = 1;
	}
	// Oxݒ肷B
	switch(config->getLogLevel()) {
		case 0:
			logger->setLevel(Logger::NONE);
			break;
		case 1:
			logger->setLevel(Logger::DEBUG);
			break;
		case 2:
			logger->setLevel(Logger::TRACE);
			break;
	}
	logger->start();

	// ݒOɏo͂B
	putConfig(config);

	// IÊCɓtH_ݒ肷B
	writer->setIElinkDir(ieLinkFolder);

	// XV[h̐ݒ
	if (config->getUpdate()){
		writer->setUpdateMode(true);
	}else{
		writer->setUpdateMode(false);
	}

	// D悵ē鑮
	if (config->getProperty() > 0){
		writer->setAttributeTarget(config->getProperty());
	}else{
		// ̗DΏۂ͂Ȃ̂Ń_~[ĂB
		writer->setAttributeTarget(-1);
	}

	// URLقȂ閼OdubN}[NcH
	writer->setLeaveDuplicateName(config->getLeaveDuplicateName());

	// Xy[X𐳋K邩H
	writer->setNormalize(config->getNormalize());

	// \[g@̐ݒ
	Bookmark::setSortMode(config->getSortType());

	// IÊCɓ肪ϊEɗ܂Ȃꍇ
	// t@C̕ϊsȂ悤ݒ肷B
	if ((config->getConvertFrom(BOOKMARK_IE) == false) && (config->getConvertTo(BOOKMARK_IE) == false) ) {
		writer->setNoIeName(true);
		writer->setVistaLinkMode(false);
		ieName = false;
	}else{
		// IÊCɓƂ̏
		if (gWindowsMajorVersion > 5){
			// CɓtH_Windows Vistaȍ~̎dlňB
			writer->setVistaLinkMode(true);
		}else{
			// CɓtH_Windows XPȑO̎dlňB
			writer->setVistaLinkMode(false);
		}
		// CɓtH_̒ݒ肷B
		writer->setBasePathLength(
			s_config->getIePath().length(),
			s_config->getIePath().length());
		ieName = true;
	}
	writer->setNoIeName(!ieName);
	writer->setAllPut(s_config->getConvertAll());

	// IE/EdgẽNtH_𖳎ݒ
	if (config->getIeIgnoreLinkFolder() || config->getEdgeIgnoreLinkFolder()){
		writer->setIElinkMode(true);
	}

	// Firefox 3̃ubN}[Nɕϊɕϊ̃ubN}[NɂȂ
	// vfĂ͂Ȃ̂ŗvf̗Lݒ肷B
	hasToolbarFolder = false;	// j[zɂȂc[o[tH_݂邩?
	hasNonMenuItem = false;	// Unsorted bookmark(Firefox 3)݂邩?
	hasMobileBookmark = false;	// oC̃ubN}[N݂邩?

	// uEU𐔂
	// 킹āAFirefox 3̃ubN}[Nō폜Ƃݒ肷B
	int bookmarksFrom = 0;
	for (int i = 0;i < ALL_BOOKMARKS;i++){
		if (config->getConvertFrom(i)){
			bookmarksFrom++;

			switch (i) {
				// Firefox 3̓ǂݍ݂ꍇ
				// j[o[Õc[o[tH_EUnsortedubN}[N
				// oC̃ubN}[N
				// ݂B
				case BOOKMARK_FIREFOX_1:
				case BOOKMARK_FIREFOX_2:
					hasToolbarFolder = true;	// j[zɂȂc[o[tH_݂邩?
					hasNonMenuItem = true;	// Unsorted bookmark(Firefox 3)݂邩?
					hasMobileBookmark = true;
					break;
				// Safari̓ǂݍ݂ꍇ
				// j[o[Õc[o[tH_݂B
				case BOOKMARK_SAFARI_1:
				case BOOKMARK_SAFARI_2:
					hasToolbarFolder = true;	// j[zɂȂc[o[tH_݂邩?
					break;
				// Chrome̓ǂݍ݂ꍇ
				// j[o[Õc[o[tH_
				// oC̃ubN}[N
				// ݂B
				case BOOKMARK_CHROME_1:
				case BOOKMARK_CHROME_2:
					hasToolbarFolder = true;	// j[zɂȂc[o[tH_݂邩?
					hasMobileBookmark = true;
					break;

				// Opera 25ȍ~̃ubN}[N̓ǂݍ݂ꍇ
				// j[o[Õc[o[tH_EUnsortedubN}[N
				// ݂B
				case BOOKMARK_OPERA25_1:	// Opera 25 ubN}[N
				case BOOKMARK_OPERA25_2:
					hasToolbarFolder = true;	// j[zɂȂc[o[tH_݂邩?
					hasNonMenuItem = true;	// Unsorted bookmark(Firefox 3)݂邩?
					break;

					// Edge(Chromium)̓ǂݍ݂ꍇ
					// j[o[Õc[o[tH_
					// oC̃ubN}[N
					// ݂B
				case BOOKMARK_EDGE2_1:
				case BOOKMARK_EDGE2_2:
					hasToolbarFolder = true;	// j[zɂȂc[o[tH_݂邩?
					hasMobileBookmark = true;
					break;
			}
		}
	}
	writer->setBookmarkFromCount(bookmarksFrom);

	// õIuWFNg̊mۂɐeubN}[NǂݍށB
	if (result == 0){
		logger->debug("Process start.");
		result = syncProcess(config);
		logger->debug("Process end.");
	}
	s_noNameFlag = writer->getNoNameFlag();
	sqlite3_shutdown();
	logger->stop();

	// Ō̓\[X̊J
	if (bookmarkTree != NULL){
		delete bookmarkTree;
	}
	if (writer != NULL){
		delete writer;
	}
	if (logger != NULL) {
		delete logger;
	}

	return result;

}

/**
 * ϊXbhp̃p[^ݒ
 *
 * @param config ϊݒ
 */
void setConfigration(Configuration *config)
{
	s_config = config;
}

/**
 * ϊXbhJnB
 *
 * @param pArguments Xbh
 * @return XbhIR[h
 */
unsigned __stdcall RunConvertThread( void* pArguments )
{
	::CoInitialize(NULL);
	setLocale();
	s_progressNo = 0;
	s_progressCount = 0;
	s_cancel = false;
	s_cancelable = true;

	guidSet = new std::set < std::string >() ;
	fxGuidSet = new std::set <std::string >();

	sqlite3_initialize();
	// t@CVXeIÊCɓtH_擾B
	getIeLinkbarFolder(ieLinkFolder,MAX_PATH);
	getIeLinkFolder();
	// \pIÊCɓtH_擾B
	getIeLinkDisplay();

	vivaldiMetaData = new ViMetaData();

	// EdgêCɓtH_
	// Windows 10ȑOɂEdge͂Ȃ̂ŁAEdge֘A̐ݒȂƂɂB
#ifdef WITH_EDGE
	DWORD dwver = ::GetVersion();
	DWORD winVer = LOBYTE(dwver);

	if (winVer < 10) {
#endif	// WITH_EDGE
		s_config->setEdgeConvert(false);
		s_config->setConvertFrom(BOOKMARK_EDGE, false);
		s_config->setConvertTo(BOOKMARK_EDGE, false);
		s_config->setEdgeEraseFavorite(false);
		s_config->setEdgeIgnoreLinkFolder(false);
		s_config->setEdgeNoLinkToMenu(false);
		s_config->setEdgeSyncronizeFxLinkFolder(false);
		s_config->setEdgeSyncronizeLinkFolder(false);
#ifdef WITH_EDGE
	}
	strcpy(edgeLinkFolder, EDGE_LINK_NAME);
	getEdgeLinkFolder();
#endif	// WITH_EDGE

	s_convertResult = startConvert(s_config);
	sqlite3_shutdown();
	delete vivaldiMetaData;
	delete fxGuidSet;
	delete guidSet;
	::CoUninitialize();
	return 0;
}

/**
 * RunConvertThread֐ŋNϊʂԂB
 * RunConvertThread֐̃XbhIɌĂяoƁB
 *
 * @return ϊ
 */
int getConvertResult(void)
{
	return s_convertResult;
}

/**
 * LZƂ`B
 *
 * @param cancel true:LZvo false:LZv͏oĂȂ
 */
volatile void setCancel(bool cancel)
{
	s_cancel = cancel;
}

/**
 * LZł邩ǂԂB
 *
 * @return true:LZ\ false:LZs\
 */
volatile bool isCancelable(void)
{
	return s_cancelable;
}

/**
 * iԍԂB
 *
 * @return ݂̐iԍ
 */
volatile int getProgressNo(void)
{
	return s_progressNo;
}

/**
 * iԂB
 *
 * @return ݂̐i
 */
volatile int getProgressCount(void)
{
	return s_progressCount;
}

/**
 * OȂtH_݂ǂ̃tOԂB
 *
 * @return true:ÔȂtH_݂ false:ÔȂtH_݂͑Ȃ
 */
bool getNoNameFlag(void)
{
	return s_noNameFlag;
}

/**
 * bZ[W̕ωԂݒ肷B
 *
 * @param flag ω
 */
volatile void setMessageChanged(bool flag)
{
	messageChanged = flag;
}

/**
 * i̕ωԂݒ肷B
 *
 * @param flag ω
 */
volatile void setProgressChanged(bool flag)
{
	progressChanged = flag;
}

/**
 * i󋵂
 */
volatile void addProgressCount()
{
	int i = 0;

	progressChanged = false;
	s_progressCount++;
	while (progressChanged == false) {
		Sleep(10);
		// 炩̃^C~ÔŃfbhbNNȂ悤
		// 1b҂ĕύXȂ甲B
		i++;
		if (i > 100) {
			break;
		}
	}
	progressChanged = false;
}

/**
 * i_CAÕbZ[WύXB
 *
 * @param type bZ[W̎
 */
volatile void changeMessage(int type)
{
	int i = 0;

	messageChanged = false;
	s_progressNo = type;
	while (messageChanged == false) {
		Sleep(10);
		// 炩̃^C~ÔŃfbhbNNȂ悤
		// 1b҂ĕύXȂ甲B
		i++;
		if (i > 100) {
			break;
		}
	}
	messageChanged = false;
}

#ifdef SELFTEST
/**
 * main
 *
 * @return 0:s !=0:ss
 */
int main(int argc,char *argv[])
{
	Configuration config;
	InitCommonControls();

	// {vÕP[ݒ肵܂B
	setLocale();

	// OSˑ֐Qݒ肵܂B
	loadNTfunction();

	// bZ[WR\[o͂悤ɂB
	g_messageType = 0;

	// Mozilla֌W̐ݒs܂B
	config.setMozPath(0,"h:\\test\\fav\\bookmarks.html");
	config.setMozPath(1,"h:\\test\\fav\\bookmarks2.html");
	config.setMozIgnoreIe(0,false);
	config.setMozNs4Format(0,false);
	config.setMozIgnoreIe(1,false);
	config.setMozNs4Format(1,false);
	config.setMozConvert(0,true);
	config.setMozConvert(1,false);
	config.setConvertFrom(1,false);
	config.setConvertFrom(2,false);
	config.setConvertTo(1,false);
	config.setConvertTo(2,true);
	
	// Opera֌W̐ݒs܂B
	config.setOperaPath(0,"h:\\test\\fav\\opera6.adr");
	config.setOperaPath(1,"h:\\test\\fav\\opera7.adr");
	config.setOpera7Format(0,true);
	config.setOperaIgnoreTrush(0,false);
	config.setOpera7Format(1,true);
	config.setOperaIgnoreTrush(1,false);
	config.setOperaConvert(0,true);
	config.setOperaConvert(1,false);
	config.setConvertFrom(3,false);
	config.setConvertFrom(4,false);
	config.setConvertTo(3,false);
	config.setConvertTo(4,false);
	
	// IE֌W̐ݒs܂B
	// config.setIePath("C:\\Documents and Settings\\Tatsu\\Favorites");
	config.setIePath("H:\\test\\fav\\IE");
	config.setIeIgnoreLinkFolder(false);
	config.setIeEraseFavorite(false);
	config.setIeSyncronizeLinkFolder(false);
	config.setIeConvert(true);
	config.setConvertFrom(0,false);
	config.setConvertTo(0,false);

	config.setFxPath(0,"h:\\test\\fav\\places.sqlite");
	config.setFxIgnoreIe(0,false);
	config.setFxConvert(0,true);
	config.setFxConvert(1,false);
	config.setConvertFrom(5,true);
	config.setConvertFrom(6,false);
	config.setConvertTo(5,false);
	config.setConvertTo(6,false);

	config.setProperty(0);	// Mozilla 1
	config.setSortType(1);	// O(fBNgD)
	
	config.setUpdate(false);

	// gȂǃLZƐiԂݒ肷B
	s_progressNo = 0;
	s_cancel = false;

	printf("BookSync Version 2.xx series test run\n");
	int result = startConvert(&config);

	// OSˑ֐Q̌ns܂B
	unloadNTfunction();

	return result;
}
#endif
