#ifndef TREEWRITER_H
#define TREEWRITER_H

#include	"BScommon.h"
#include	"bslib.h"
#include	"IbookmarkTree.h"
#include	"BookmarkTree.h"

class TreeWriter : public IbookmarkTree {

private:
	BookmarkTree *m_bmTree;
	char *mbPath;
	wchar_t *wcPath;

	int level;	// ݂̊Kwx
	int mbLevel;		// }`oCg̃pX̊Kw
	int wcLevel;		// Ch̃pX̊Kw
	bool ignore;		// ubN}[NEtH_𖳎邩ǂ
	int ignoreLevel;	// Kwx
	bool noIElink;		// IẼNǂH
	char *IElinkDir;	// IẼNtH_
	int browserType;	// i[ubN}[ÑuEU̎
						// 0:IE 1:Mozilla 2:Opera 3:Firefox 3 4:Safari
	int browserNo;		// uEU̔ԍ(0`)
	bool updateMode;	// XV[h true:XV false:㏑
	bool noIEname;		// IEΏۂƂȂꍇtrue
	bool treatAsVistaLink;	// "N"Windows VistaIE7LinkstH_Ƃ݂ȂǂH(Vista only)
	int mbFolderNameMax;	// tH_ǉƂ̍ő咷(}`oCg)
	size_t wcFolderNameMax;	// tH_ǉƂ̍ő咷(wchar_t)
	int mbBookmarkNameMax;	// ubN}[NǉƂ̍ő咷(}`oCg)
	int wcBookmarkNameMax;	// ubN}[NǉƂ̍ő咷(wchar_t)
	int attributeTarget;	// EV[gJbg̓Ώ
	int bookmarkFromCount;	// ϊ̃ubN}[N
	bool noNameFlag;		// tH_ǂ̃tO
	Bookmark::FolderType folderType;	// ݂̃tH_tH_̎
	int mbFavoriteFolderLen;	// IÊCɓtH_̒(}`oCg)
	int wcFavoriteFolderLen;	// IÊCɓtH_̒(wchar_t)
	bool mainBrowser;	// ҏWΏۂ̃uEUǂH
	bool leaveDuplicateName;	// URLقȂ閼OdubN}[NcH
	bool normalize;		// Xy[X𐳋K邩?
	bool allPut;		// ׂẴubN}[No͂邩H
	bool needSleep;

	void changeInvalidName(Bookmark *bookmark);
	void changeInvalidNameW(Bookmark *bookmark);
	INT_TIME_T updateKeyTime(Bookmark *bookmark);
	bool checkUpdate(Bookmark *prevBookmark,Bookmark *newBookmark);
	void setAddDate(Bookmark *prevBookmark,Bookmark *newBookmark);
	int store(wchar_t *wcPath,Bookmark *bookmark);
	void addFolderName(Bookmark *bookmark);
	void addBookmarkName(Bookmark *bookmark);
	bool changeFolderName(Bookmark *bookmark);
	int modifyName(Bookmark *bookmark);
	void setLinkFolder(Bookmark *bookmark,bool mode);
	void setSpecialInformation(Bookmark *bookmark);
	void setUserAttribute(Bookmark *to,Bookmark *from);
	void copyBrowserAttribute(Bookmark *to,Bookmark *from);
	void copyWithoutId(Bookmark *to, Bookmark *from);
	void copyBrowserAttributeSelf(Bookmark *to, Bookmark *from);
	void copyBookmarkIdentifier(Bookmark *to, Bookmark *from);
	int addBookmark(Bookmark *bookmark);
	void updateBookmark(Bookmark *stored,Bookmark *bookmark);
	bool noNameChange(Bookmark *bookmark);
	void convertOperaAttribute(Bookmark *target);
	void convertBrowserAttribute(Bookmark *target);
	bool isPreferedBookmark(int no);
	int storeDuplicate(Bookmark *stored,Bookmark *bookmark);
	int normalizeName(Bookmark *bookmark);
	void normalizeSpace(char *name);
	void normalizeSpace(wchar_t *name);
	void shiftString(char *str, int count);

public:
	// IbookmarkTree̎B
	TreeWriter();
	~TreeWriter();
	
	// ԂgΎwn֐
	int storeItem(Bookmark *bookmark);
	// zNX邽߂̃_~[֐
	int storeItemWithRefer(Bookmark *bookmark);

	void upToBookmarkMenu(void);
	void upToTop(void);
	void upFolder(void);	// {m_bmTree->upFolder();};
	void reset();

	void setBasePathLength(const int mbLength,const int wcLength);

	void setBookmarkTree(BookmarkTree *bmTree);
	int cutLast(char *path) {return ::cutLastEndl(path);}

	void setBrowserType(int type) {	browserType = type;	};
	int getBrowserType(void) {	return browserType;	};

	void setBrowserNo(int no) {	browserNo = no;	};
	int getBrowserNo(void) {	return browserNo;	};

	void setUpdateMode(bool mode){
		updateMode = mode;
	}

	/**
	 * IẼt@CK𗘗p邩ǂ̐ݒsB
	 *
	 * @param mode true:IẼt@CK𗘗pȂ false:IẼt@CK𗘗p
	 */
	void setNoIeName(bool mode){
		noIEname = mode;

		if (mode){
			// false:IẼt@CK𗘗pȂ
			// płt@C̒L΂
			mbFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(}`oCg)
			wcFolderNameMax = BUFLEN;	// tH_ǉƂ̍ő咷(wchar_t)
			mbBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(}`oCg)
			wcBookmarkNameMax = BUFLEN - 1;	// ubN}[NǉƂ̍ő咷(wchar_t)
		}
	}

	bool setIElinkMode(bool mode){	noIElink = mode;return mode;}

	char *setIElinkDir(char *dir){	IElinkDir = dir;return dir;}
	bool setVistaLinkMode(bool mode){	treatAsVistaLink = mode;return mode;}

	void setAttributeTarget(int target){
		attributeTarget = target;
	}

	void setBookmarkFromCount(int count){
		bookmarkFromCount = count;
	}

	bool getNoNameFlag(void) {
		return noNameFlag;
	}

	bool getMainBrowser(void) {
		return mainBrowser;
	}
	void setMainBrowser(bool mode) {
		mainBrowser = mode;
	}

	bool getLeaveDuplicateName(void) {
		return leaveDuplicateName;
	}
	void setLeaveDuplicateName(bool flag) {
		leaveDuplicateName = flag;
	}

	bool getNormalize(void) {
		return normalize;
	}
	void setNormalize(bool flag) {
		normalize = flag;
	}

	/**
	 * ׂẴubN}[No͂邩H
	 *
	 * @param true:o͂ false:o͂Ȃ
	 */
	void setAllPut(bool flag) {
		allPut = flag;
	}

};

#endif	// TREEWRITER_H
